/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"fileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFileClassInfo", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "javaFileFacadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getJavaFileFacadeFqName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/name/FqName;", "isJvmMultifileClassFile", "", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isInsideJvmMultifileClassFile", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "internalNameWithoutInnerClasses", "", "getInternalNameWithoutInnerClasses", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "frontend.common.jvm"})
public final class JvmFileClassUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull KtFile $this$fileClassInfo) {
        Intrinsics.checkNotNullParameter($this$fileClassInfo, "<this>");
        Object t2 = CachedValuesManager.getCachedValue($this$fileClassInfo, () -> JvmFileClassUtilKt._get_fileClassInfo_$lambda$0($this$fileClassInfo));
        Intrinsics.checkNotNullExpressionValue(t2, "getCachedValue(...)");
        return (JvmFileClassInfo)t2;
    }

    @NotNull
    public static final FqName getJavaFileFacadeFqName(@NotNull KtFile $this$javaFileFacadeFqName) {
        FqName facadeFqName;
        FqName fqName;
        Intrinsics.checkNotNullParameter($this$javaFileFacadeFqName, "<this>");
        if ($this$javaFileFacadeFqName.isCompiled()) {
            FqName fqName2 = $this$javaFileFacadeFqName.getPackageFqName();
            Name name2 = Name.identifier($this$javaFileFacadeFqName.getVirtualFile().getNameWithoutExtension());
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            fqName = fqName2.child(name2);
        } else {
            fqName = facadeFqName = JvmFileClassUtilKt.getFileClassInfo($this$javaFileFacadeFqName).getFacadeClassFqName();
        }
        if (!Name.isValidIdentifier(facadeFqName.shortName().getIdentifier())) {
            LOG.error("An invalid fqName `" + facadeFqName + "` with short name `" + facadeFqName.shortName() + "` is created for file `" + $this$javaFileFacadeFqName.getName() + "` (isCompiled = " + $this$javaFileFacadeFqName.isCompiled() + ')');
        }
        return facadeFqName;
    }

    public static final boolean isJvmMultifileClassFile(@NotNull KtFile $this$isJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter($this$isJvmMultifileClassFile, "<this>");
        return JvmFileClassUtil.findAnnotationEntryOnFileNoResolve($this$isJvmMultifileClassFile, JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
    }

    public static final boolean isInsideJvmMultifileClassFile(@NotNull KtDeclaration $this$isInsideJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter($this$isInsideJvmMultifileClassFile, "<this>");
        KtFile ktFile = $this$isInsideJvmMultifileClassFile.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
        return JvmFileClassUtilKt.isJvmMultifileClassFile(ktFile);
    }

    @NotNull
    public static final String getInternalNameWithoutInnerClasses(@NotNull FqName $this$internalNameWithoutInnerClasses) {
        Intrinsics.checkNotNullParameter($this$internalNameWithoutInnerClasses, "<this>");
        String string2 = JvmClassName.byFqNameWithoutInnerClasses($this$internalNameWithoutInnerClasses).getInternalName();
        Intrinsics.checkNotNullExpressionValue(string2, "getInternalName(...)");
        return string2;
    }

    private static final CachedValueProvider.Result _get_fileClassInfo_$lambda$0(KtFile $this_fileClassInfo) {
        Object[] objectArray = new Object[]{$this_fileClassInfo};
        return new CachedValueProvider.Result<JvmFileClassInfo>(JvmFileClassUtil.getFileClassInfoNoResolve($this_fileClassInfo), objectArray);
    }

    static {
        Logger logger = Logger.getInstance("JvmFileClassUtil");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

