/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2Marker;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3Marker;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.multiplatform.K1ExpectActualCompatibility;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/ClassicPositioningStrategies;", "", "<init>", "()V", "ACTUAL_DECLARATION_NAME", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "firstIncompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/K1ExpectActualCompatibility$Incompatible;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "getFirstIncompatibility", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;)Lorg/jetbrains/kotlin/resolve/multiplatform/K1ExpectActualCompatibility$Incompatible;", "INCOMPATIBLE_DECLARATION", "UNREACHABLE_CODE", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class ClassicPositioningStrategies {
    @NotNull
    public static final ClassicPositioningStrategies INSTANCE = new ClassicPositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> ACTUAL_DECLARATION_NAME = new PositioningStrategies.DeclarationHeader<KtNamedDeclaration>(){

        public List<TextRange> mark(KtNamedDeclaration element) {
            Intrinsics.checkNotNullParameter(element, "element");
            PsiElement nameIdentifier = element.getNameIdentifier();
            PsiElement psiElement = nameIdentifier;
            return psiElement != null ? PositioningStrategyKt.markElement(psiElement) : (element instanceof KtNamedFunction ? PositioningStrategies.DECLARATION_SIGNATURE_WITH_VALIDITY_CHECK.mark((KtDeclaration)((PsiElement)element)) : PositioningStrategies.DEFAULT.mark(element));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> INCOMPATIBLE_DECLARATION = new PositioningStrategies.DeclarationHeader<KtNamedDeclaration>(){

        /*
         * Enabled aggressive block sorting
         */
        public List<TextRange> markDiagnostic(DiagnosticMarker diagnostic) {
            Object object;
            PsiElement psiElement;
            UserDataHolder userDataHolder;
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkNotNull(psiElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            KtNamedDeclaration element = (KtNamedDeclaration)psiElement2;
            KtCallableDeclaration callableDeclaration = element instanceof KtCallableDeclaration ? (KtCallableDeclaration)element : null;
            K1ExpectActualCompatibility.Incompatible incompatibility = ClassicPositioningStrategies.access$getFirstIncompatibility(ClassicPositioningStrategies.INSTANCE, diagnostic);
            List<TextRange> list = incompatibility;
            if (list == null || list instanceof K1ExpectActualCompatibility.Incompatible.ClassScopes || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.EnumEntries.INSTANCE)) {
                userDataHolder = null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ClassKind.INSTANCE)) {
                UserDataHolder userDataHolder2;
                UserDataHolder userDataHolder3;
                PsiElement psiElement3;
                PsiElement psiElement4 = element.getModifierList();
                if (psiElement4 == null || (psiElement4 = psiElement4.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                    KtModifierList ktModifierList = element.getModifierList();
                    psiElement4 = psiElement3 = ktModifierList != null ? ktModifierList.getModifier(KtTokens.ANNOTATION_KEYWORD) : null;
                }
                if ((userDataHolder3 = element.getNode().findChildByType(PositioningStrategies.INSTANCE.getClassKindTokens())) == null || (userDataHolder3 = userDataHolder3.getPsi()) == null) {
                    userDataHolder3 = userDataHolder2 = element.getNameIdentifier();
                }
                if (psiElement3 != null && userDataHolder2 != null) {
                    return PositioningStrategyKt.markRange(psiElement3, (PsiElement)userDataHolder2);
                }
                userDataHolder = userDataHolder2;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.TypeParameterNames.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.FunctionTypeParameterCount.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ClassTypeParameterCount.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.FunctionTypeParameterUpperBounds.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ClassTypeParameterUpperBounds.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.TypeParameterVariance.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.TypeParameterReified.INSTANCE)) {
                KtTypeParameterListOwner ktTypeParameterListOwner = element instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)element : null;
                userDataHolder = ktTypeParameterListOwner != null ? ktTypeParameterListOwner.getTypeParameterList() : null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.CallableKind.INSTANCE)) {
                userDataHolder = callableDeclaration instanceof KtNamedFunction ? (KtNamedFunction)callableDeclaration : null;
                if (userDataHolder == null || (userDataHolder = ((KtNamedFunction)userDataHolder).getFunKeyword()) == null) {
                    KtProperty ktProperty = callableDeclaration instanceof KtProperty ? (KtProperty)callableDeclaration : null;
                    userDataHolder = ktProperty != null ? ktProperty.getValOrVarKeyword() : null;
                }
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ParameterShape.INSTANCE)) {
                KtElementImplStub ktElementImplStub;
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                if (ktCallableDeclaration != null) {
                    KtCallableDeclaration ktCallableDeclaration2 = ktCallableDeclaration;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = ktCallableDeclaration2.getReceiverTypeReference();
                    ktElementImplStub = ktTypeReference != null ? (KtElementImplStub)ktTypeReference : (KtElementImplStub)ktCallableDeclaration2.getValueParameterList();
                } else {
                    ktElementImplStub = null;
                }
                userDataHolder = ktElementImplStub;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ParameterCount.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ParameterTypes.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ParameterNames.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ValueParameterVararg.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ActualFunctionWithDefaultParameters.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ValueParameterNoinline.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ValueParameterCrossinline.INSTANCE)) {
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                userDataHolder = ktCallableDeclaration != null ? ktCallableDeclaration.getValueParameterList() : null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ReturnType.INSTANCE)) {
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                userDataHolder = ktCallableDeclaration != null ? ktCallableDeclaration.getTypeReference() : null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.FunctionModifiersDifferent.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.PropertyLateinitModifier.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.PropertyConstModifier.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.ClassModifiers.INSTANCE) || Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.FunInterfaceModifier.INSTANCE)) {
                userDataHolder = element.getModifierList();
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.PropertyKind.INSTANCE)) {
                ASTNode aSTNode = element.getNode().findChildByType(PositioningStrategies.INSTANCE.getPropertyKindTokens());
                userDataHolder = aSTNode != null ? aSTNode.getPsi() : null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.Supertypes.INSTANCE)) {
                KtClassOrObject ktClassOrObject = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
                userDataHolder = ktClassOrObject != null ? ktClassOrObject.getSuperTypeList() : null;
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.Modality.INSTANCE)) {
                userDataHolder = KtPsiUtilKt.modalityModifier(element);
            } else if (Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.Visibility.INSTANCE)) {
                userDataHolder = KtPsiUtilKt.visibilityModifier(element);
            } else {
                if (!Intrinsics.areEqual(list, K1ExpectActualCompatibility.Incompatible.PropertySetterVisibility.INSTANCE)) throw new NoWhenBranchMatchedException();
                KtDeclarationStub ktDeclarationStub = element instanceof KtProperty ? (KtProperty)element : null;
                userDataHolder = psiElement = (PsiElement)(ktDeclarationStub != null && (ktDeclarationStub = ((KtProperty)ktDeclarationStub).getSetter()) != null ? ktDeclarationStub.getModifierList() : null);
            }
            if (psiElement != null) {
                PsiElement psiElement5 = psiElement;
                boolean bl = false;
                list = PositioningStrategyKt.markElement(psiElement5);
                if (list != null) {
                    object = list;
                    return object;
                }
            }
            object = ClassicPositioningStrategies.ACTUAL_DECLARATION_NAME.mark((KtNamedDeclaration)((PsiElement)element));
            return object;
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

        public List<TextRange> markDiagnostic(DiagnosticMarker diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            DiagnosticWithParameters2Marker unreachableCode = (DiagnosticWithParameters2Marker)diagnostic;
            PsiElement psiElement = unreachableCode.getPsiElement();
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            return UnreachableCode.Companion.getUnreachableTextRanges((KtElement)psiElement, (Set)unreachableCode.getA(), (Set)unreachableCode.getB());
        }
    };

    private ClassicPositioningStrategies() {
    }

    private final K1ExpectActualCompatibility.Incompatible<MemberDescriptor> getFirstIncompatibility(DiagnosticMarker $this$firstIncompatibility) {
        Object object;
        String string2 = $this$firstIncompatibility.getFactoryName();
        if (Intrinsics.areEqual(string2, Errors.NO_ACTUAL_FOR_EXPECT.getName())) {
            Intrinsics.checkNotNull($this$firstIncompatibility, "null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3Marker<*, *, *>");
            object = ((DiagnosticWithParameters3Marker)$this$firstIncompatibility).getC();
        } else if (Intrinsics.areEqual(string2, Errors.ACTUAL_WITHOUT_EXPECT.getName())) {
            Intrinsics.checkNotNull($this$firstIncompatibility, "null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2Marker<*, *>");
            object = ((DiagnosticWithParameters2Marker)$this$firstIncompatibility).getB();
        } else {
            object = null;
        }
        Object c2 = object;
        Map map = c2 instanceof Map ? (Map)c2 : null;
        if (map == null) {
            return null;
        }
        Map map2 = map;
        return (K1ExpectActualCompatibility.Incompatible)CollectionsKt.firstOrNull(map2.keySet());
    }

    public static final /* synthetic */ K1ExpectActualCompatibility.Incompatible access$getFirstIncompatibility(ClassicPositioningStrategies $this, DiagnosticMarker $receiver) {
        return $this.getFirstIncompatibility($receiver);
    }
}

