/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedStoresProcessor;
import org.jetbrains.kotlin.codegen.inline.InplaceArgumentsMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.MethodVerifier;
import org.jetbrains.kotlin.codegen.optimization.NegatedJumpsMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckcastsBeforeAastoreMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.StackPeepholeOptimizationsTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryVariablesEliminationTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.CompositeMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor;", "Lorg/jetbrains/kotlin/codegen/TransformationMethodVisitor;", "delegate", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "mandatoryTransformationsOnly", "", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "access", "", "name", "", "desc", "signature", "exceptions", "", "<init>", "(Lorg/jetbrains/org/objectweb/asm/MethodVisitor;ZLorg/jetbrains/kotlin/codegen/state/GenerationState;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "normalizationMethodTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "getNormalizationMethodTransformer", "()Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "optimizationTransformer", "getOptimizationTransformer", "performTransformations", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Companion", "backend"})
public final class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean mandatoryTransformationsOnly;
    @NotNull
    private final GenerationState generationState;
    @NotNull
    private final CompositeMethodTransformer normalizationMethodTransformer;
    @NotNull
    private final CompositeMethodTransformer optimizationTransformer;
    public static final int MEMORY_LIMIT_BY_METHOD_MB = 50;

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate, boolean mandatoryTransformationsOnly, @NotNull GenerationState generationState, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Intrinsics.checkNotNullParameter(generationState, "generationState");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(desc, "desc");
        super(delegate, access, name2, desc, signature, exceptions, 0, 64, null);
        this.mandatoryTransformationsOnly = mandatoryTransformationsOnly;
        this.generationState = generationState;
        MethodTransformer[] methodTransformerArray = new MethodTransformer[]{new InplaceArgumentsMethodTransformer(), new FixStackWithLabelNormalizationMethodTransformer(), new MethodVerifier("AFTER mandatory stack transformations", this.generationState)};
        this.normalizationMethodTransformer = new CompositeMethodTransformer(methodTransformerArray);
        methodTransformerArray = new MethodTransformer[]{new CapturedVarsOptimizationMethodTransformer(), new RedundantNullCheckMethodTransformer(this.generationState), new RedundantCheckCastEliminationMethodTransformer(), new ConstantConditionEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(this.generationState), new TemporaryVariablesEliminationTransformer(), new StackPeepholeOptimizationsTransformer(), new PopBackwardPropagationTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer(), new NegatedJumpsMethodTransformer(), RedundantCheckcastsBeforeAastoreMethodTransformer.INSTANCE, new MethodVerifier("AFTER optimizations", this.generationState)};
        this.optimizationTransformer = new CompositeMethodTransformer(methodTransformerArray);
    }

    @NotNull
    public final CompositeMethodTransformer getNormalizationMethodTransformer() {
        return this.normalizationMethodTransformer;
    }

    @NotNull
    public final CompositeMethodTransformer getOptimizationTransformer() {
        return this.optimizationTransformer;
    }

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        this.normalizationMethodTransformer.transform("fake", methodNode);
        new UninitializedStoresProcessor(methodNode).run();
        if (!this.mandatoryTransformationsOnly && Companion.canBeOptimized(methodNode) && !this.generationState.getConfig().getDisableOptimization()) {
            this.optimizationTransformer.transform("fake", methodNode);
        }
        new DeadCodeEliminationMethodTransformer().transform("fake", methodNode);
        UtilKt.prepareForEmitting(methodNode);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\u0005*\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion;", "", "<init>", "()V", "MEMORY_LIMIT_BY_METHOD_MB", "", "TRY_CATCH_BLOCKS_SOFT_LIMIT", "canBeOptimized", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "canBeOptimizedUsingSourceInterpreter", "countInsnsWithFramesUntil", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "end", "getTotalFramesWeight", "", "size", "getTotalTcbSize", "backend"})
    @SourceDebugExtension(value={"SMAP\nOptimizationMethodVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizationMethodVisitor.kt\norg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeOptimized(@NotNull MethodNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            if (node.tryCatchBlocks.size() > 16 && this.getTotalFramesWeight(this.getTotalTcbSize(node), node) > 50L) {
                return false;
            }
            return this.getTotalFramesWeight(this.countInsnsWithFramesUntil(node.instructions.getFirst(), null), node) < 50L;
        }

        public final boolean canBeOptimizedUsingSourceInterpreter(@NotNull MethodNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            int methodSize = this.countInsnsWithFramesUntil(node.instructions.getFirst(), null);
            if (node.tryCatchBlocks.size() > 16 && this.getTotalFramesWeight(this.getTotalTcbSize(node) * methodSize, node) > 50L) {
                return false;
            }
            return this.getTotalFramesWeight(methodSize * methodSize, node) < 50L;
        }

        private final int countInsnsWithFramesUntil(AbstractInsnNode $this$countInsnsWithFramesUntil, AbstractInsnNode end) {
            int result2 = 0;
            for (AbstractInsnNode it = $this$countInsnsWithFramesUntil; !Intrinsics.areEqual(it, end) && it != null; it = it.getNext()) {
                int type2 = UtilKt.getNodeType(it);
                if (type2 == 15 || type2 == 14 || type2 == 8 || it.getOpcode() == 0) {
                    AbstractInsnNode abstractInsnNode = it.getNext();
                    boolean bl = abstractInsnNode != null ? UtilKt.getNodeType(abstractInsnNode) == 8 : false;
                    if (!bl) continue;
                }
                ++result2;
            }
            return result2;
        }

        private final long getTotalFramesWeight(int size, MethodNode node) {
            return (long)size * (long)(node.maxLocals + node.maxStack) / (long)0x100000;
        }

        /*
         * WARNING - void declaration
         */
        private final int getTotalTcbSize(MethodNode node) {
            List<TryCatchBlockNode> list = node.tryCatchBlocks;
            Intrinsics.checkNotNullExpressionValue(list, "tryCatchBlocks");
            Iterable iterable = list;
            int n2 = 0;
            for (Object t2 : iterable) {
                void it;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)t2;
                int n3 = n2;
                boolean bl = false;
                int n4 = Companion.countInsnsWithFramesUntil(it.start, it.end);
                n2 = n3 + n4;
            }
            return n2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

