/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.codegen.inline.InlineScopeInfo;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.codegen.inline.InlineScopesGeneratorKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"incrementScopeNumbersOfVariables", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "label", "Lorg/jetbrains/org/objectweb/asm/Label;", "incrementScopeNumbers", "", "name", "backend"})
public final class MethodInlinerKt {
    private static final int incrementScopeNumbersOfVariables(MethodNode node, Label label) {
        List<LocalVariableNode> list = node.localVariables;
        if (list == null) {
            return 0;
        }
        List<LocalVariableNode> localVariables = list;
        if (localVariables.isEmpty()) {
            return 0;
        }
        Map<Label, Integer> labelToIndex = InlineScopesGeneratorKt.getLabelToIndexMap(node);
        Integer n2 = labelToIndex.get(label);
        if (n2 == null) {
            return 0;
        }
        int currentIndex = n2;
        int inlineScopeNumberIncrement = 0;
        for (LocalVariableNode variable : localVariables) {
            Integer n3 = labelToIndex.get(variable.start.getLabel());
            if (n3 == null) {
                continue;
            }
            int variableStartIndex = n3;
            if (variableStartIndex < currentIndex) {
                String string2 = variable.name;
                Intrinsics.checkNotNullExpressionValue(string2, "name");
                if (JvmAbi.isFakeLocalVariableForInline(string2)) {
                    ++inlineScopeNumberIncrement;
                }
            }
            if (variableStartIndex <= currentIndex) continue;
            String string3 = variable.name;
            Intrinsics.checkNotNullExpressionValue(string3, "name");
            variable.name = MethodInlinerKt.incrementScopeNumbers(string3);
        }
        return inlineScopeNumberIncrement;
    }

    private static final String incrementScopeNumbers(String name2) {
        StringBuilder stringBuilder;
        InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo(name2);
        if (inlineScopeInfo == null) {
            return name2;
        }
        InlineScopeInfo inlineScopeInfo2 = inlineScopeInfo;
        int scopeNumber = inlineScopeInfo2.component1();
        Integer callSiteLineNumber = inlineScopeInfo2.component2();
        Integer surroundingScopeNumber = inlineScopeInfo2.component3();
        StringBuilder $this$incrementScopeNumbers_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$incrementScopeNumbers_u24lambda_u240.append(InlineScopeUtilsKt.dropInlineScopeInfo(name2));
        $this$incrementScopeNumbers_u24lambda_u240.append('\\');
        $this$incrementScopeNumbers_u24lambda_u240.append(scopeNumber + 1);
        if (callSiteLineNumber != null) {
            $this$incrementScopeNumbers_u24lambda_u240.append('\\');
            $this$incrementScopeNumbers_u24lambda_u240.append(callSiteLineNumber);
        }
        if (surroundingScopeNumber != null) {
            int resultingSurroundingScopeNumber = surroundingScopeNumber != 0 ? surroundingScopeNumber + 1 : 0;
            $this$incrementScopeNumbers_u24lambda_u240.append('\\');
            $this$incrementScopeNumbers_u24lambda_u240.append(resultingSurroundingScopeNumber);
        }
        return stringBuilder.toString();
    }

    public static final /* synthetic */ int access$incrementScopeNumbersOfVariables(MethodNode node, Label label) {
        return MethodInlinerKt.incrementScopeNumbersOfVariables(node, label);
    }
}

