/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerLoggerAdapterKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001aT\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000f0\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e\u001a&\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a&\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u001a)\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b*\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002\u001aM\u0010\"\u001a\u0004\u0018\u00010#\"\b\b\u0000\u0010$*\u00020%2\b\u0010&\u001a\u0004\u0018\u0001H$2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020#0\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0002\u0010+\u001a\f\u0010,\u001a\u00020-*\u00020\fH\u0007\u001a\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201\u00a8\u00062"}, d2={"incrementalCompilationIsEnabled", "", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "incrementalCompilationIsEnabledForJs", "checkKotlinPackageUsage", "F", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "files", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getPackage", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "getMessageLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "checkKotlinPackageUsageForPsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkKotlinPackageUsageForLightTree", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getLocationWithin", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocationWithRange;", "Lorg/jetbrains/kotlin/KtSourceElement;", "file", "getLineAndColumnStartingWithOnesAt", "Lkotlin/Pair;", "", "offset", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Integer;)Lkotlin/Pair;", "getLineAndColumnByOffsetStartingWithOnes", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "startOffset", "getLibraryFromHome", "Ljava/io/File;", "PathProvider", "", "paths", "getLibrary", "libraryName", "", "noLibraryArgument", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/String;)Ljava/io/File;", "toLogger", "Lorg/jetbrains/kotlin/util/Logger;", "disposeRootInWriteAction", "", "disposable", "Lcom/intellij/openapi/Disposable;", "cli"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/cli/common/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class UtilsKt {
    public static final boolean incrementalCompilationIsEnabled(@NotNull CommonCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Boolean bl = arguments.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJvm();
    }

    public static final boolean incrementalCompilationIsEnabledForJs(@NotNull CommonCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Boolean bl = arguments.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJs();
    }

    public static final <F> boolean checkKotlinPackageUsage(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends F> files2, @NotNull MessageCollector messageCollector, @NotNull Function1<? super F, FqName> getPackage, @NotNull Function1<? super F, ? extends CompilerMessageSourceLocation> getMessageLocation) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(getPackage, "getPackage");
        Intrinsics.checkNotNullParameter(getMessageLocation, "getMessageLocation");
        if (configuration2.getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        FqName kotlinPackage = new FqName("kotlin");
        for (F file2 : files2) {
            if (!FqNamesUtilKt.isSubpackageOf(getPackage.invoke(file2), kotlinPackage)) continue;
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", getMessageLocation.invoke(file2));
            return false;
        }
        return true;
    }

    public static final boolean checkKotlinPackageUsageForPsi(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector, UtilsKt::checkKotlinPackageUsageForPsi$lambda$0, UtilsKt::checkKotlinPackageUsageForPsi$lambda$1);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForPsi$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector, int n2, Object object) {
        if ((n2 & 4) != 0) {
            messageCollector = CommonConfigurationKeysKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForPsi(compilerConfiguration, collection, messageCollector);
    }

    public static final boolean checkKotlinPackageUsageForLightTree(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends FirFile> files2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector, UtilsKt::checkKotlinPackageUsageForLightTree$lambda$2, UtilsKt::checkKotlinPackageUsageForLightTree$lambda$3);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForLightTree$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector, int n2, Object object) {
        if ((n2 & 4) != 0) {
            messageCollector = CommonConfigurationKeysKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForLightTree(compilerConfiguration, collection, messageCollector);
    }

    private static final CompilerMessageLocationWithRange getLocationWithin(KtSourceElement $this$getLocationWithin, FirFile file2) {
        KtSourceFile ktSourceFile = file2.getSourceFile();
        if (ktSourceFile == null) {
            return null;
        }
        KtSourceFile sourceFile = ktSourceFile;
        Pair<Integer, Integer> pair = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getStartOffset());
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startLine = ((Number)pair2.component1()).intValue();
        int startColumn = ((Number)pair2.component2()).intValue();
        Pair<Integer, Integer> pair3 = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getEndOffset());
        if (pair3 == null) {
            return null;
        }
        Pair<Integer, Integer> pair4 = pair3;
        int endLine = ((Number)pair4.component1()).intValue();
        int endColumn = ((Number)pair4.component2()).intValue();
        CharSequence charSequence = KtSourceElementKt.getText($this$getLocationWithin);
        return CompilerMessageLocationWithRange.Companion.create(sourceFile.getPath(), startLine, startColumn, endLine, endColumn, charSequence != null ? ((Object)charSequence).toString() : null);
    }

    private static final Pair<Integer, Integer> getLineAndColumnStartingWithOnesAt(FirFile $this$getLineAndColumnStartingWithOnesAt, Integer offset) {
        Pair<Integer, Integer> pair;
        Integer n2 = offset;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            KtSourceFileLinesMapping ktSourceFileLinesMapping = $this$getLineAndColumnStartingWithOnesAt.getSourceFileLinesMapping();
            pair = ktSourceFileLinesMapping != null ? UtilsKt.getLineAndColumnByOffsetStartingWithOnes(ktSourceFileLinesMapping, it) : null;
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Pair<Integer, Integer> getLineAndColumnByOffsetStartingWithOnes(KtSourceFileLinesMapping $this$getLineAndColumnByOffsetStartingWithOnes, int startOffset) {
        Pair<Integer, Integer> pair = $this$getLineAndColumnByOffsetStartingWithOnes.getLineAndColumnByOffset(startOffset);
        int line = ((Number)pair.component1()).intValue();
        int column = ((Number)pair.component2()).intValue();
        return TuplesKt.to(line + 1, column + 1);
    }

    @Nullable
    public static final <PathProvider> File getLibraryFromHome(@Nullable PathProvider paths2, @NotNull Function1<? super PathProvider, ? extends File> getLibrary, @NotNull String libraryName2, @NotNull MessageCollector messageCollector, @NotNull String noLibraryArgument) {
        File stdlibJar;
        Intrinsics.checkNotNullParameter(getLibrary, "getLibrary");
        Intrinsics.checkNotNullParameter(libraryName2, "libraryName");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(noLibraryArgument, "noLibraryArgument");
        if (paths2 != null && (stdlibJar = getLibrary.invoke(paths2)).exists()) {
            return stdlibJar;
        }
        messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName2 + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @Deprecated(message="Use org.jetbrains.kotlin.cli.common.messages.toLogger() instead", replaceWith=@ReplaceWith(expression="toLogger()", imports={"org.jetbrains.kotlin.cli.common.messages.toLogger"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final Logger toLogger(@NotNull MessageCollector $this$toLogger) {
        Intrinsics.checkNotNullParameter($this$toLogger, "<this>");
        return CompilerLoggerAdapterKt.toLogger$default($this$toLogger, false, 1, null);
    }

    public static final void disposeRootInWriteAction(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(disposable, "disposable");
        if (ApplicationManager.getApplication() != null) {
            ActionsKt.runWriteAction(() -> UtilsKt.disposeRootInWriteAction$lambda$5(disposable));
        } else {
            Disposer.dispose(disposable);
        }
    }

    private static final FqName checkKotlinPackageUsageForPsi$lambda$0(KtFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPackageFqName();
    }

    private static final CompilerMessageSourceLocation checkKotlinPackageUsageForPsi$lambda$1(KtFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KtPackageDirective ktPackageDirective = it.getPackageDirective();
        Intrinsics.checkNotNull(ktPackageDirective);
        return MessageUtil.psiElementToMessageLocation(ktPackageDirective);
    }

    private static final FqName checkKotlinPackageUsageForLightTree$lambda$2(FirFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return org.jetbrains.kotlin.fir.UtilsKt.getPackageFqName(it);
    }

    private static final CompilerMessageSourceLocation checkKotlinPackageUsageForLightTree$lambda$3(FirFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KtSourceElement ktSourceElement = it.getPackageDirective().getSource();
        return ktSourceElement != null ? UtilsKt.getLocationWithin(ktSourceElement, it) : null;
    }

    private static final Unit disposeRootInWriteAction$lambda$5(Disposable $disposable) {
        Disposer.dispose($disposable);
        return Unit.INSTANCE;
    }
}

