/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@PhaseDescription(name="SharedVariables")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements BodyLoweringPass {
    @NotNull
    private final LoweringContext context;

    public SharedVariablesLowering(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        new SharedVariablesTransformer(irBody, container).lowerSharedVariables();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/expressions/IrBody;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getIrBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getIrDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "lowerSharedVariables", "", "collectSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        @NotNull
        private final IrBody irBody;
        @NotNull
        private final IrDeclaration irDeclaration;
        @NotNull
        private final HashSet<IrVariable> sharedVariables;

        public SharedVariablesTransformer(@NotNull IrBody irBody, IrDeclaration irDeclaration2) {
            Intrinsics.checkNotNullParameter(irBody, "irBody");
            Intrinsics.checkNotNullParameter(irDeclaration2, "irDeclaration");
            this.irBody = irBody;
            this.irDeclaration = irDeclaration2;
            this.sharedVariables = new HashSet();
        }

        @NotNull
        public final IrBody getIrBody() {
            return this.irBody;
        }

        @NotNull
        public final IrDeclaration getIrDeclaration() {
            return this.irDeclaration;
        }

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            Map skippedFunctionsParents = new LinkedHashMap();
            IrElementVisitor irElementVisitor = new IrVisitor<Unit, IrDeclarationParent>((Map<IrFunction, IrDeclarationParent>)skippedFunctionsParents, this){
                private final HashSet<IrVariable> relevantVars;
                private final HashSet<IrVariable> relevantVals;
                final /* synthetic */ Map<IrFunction, IrDeclarationParent> $skippedFunctionsParents;
                final /* synthetic */ SharedVariablesTransformer this$0;
                {
                    this.$skippedFunctionsParents = $skippedFunctionsParents;
                    this.this$0 = $receiver;
                    this.relevantVars = new HashSet<E>();
                    this.relevantVals = new HashSet<E>();
                }

                public final HashSet<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                public final HashSet<IrVariable> getRelevantVals() {
                    return this.relevantVals;
                }

                public void visitElement(IrElement element, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    element.acceptChildren(this, data);
                }

                public void visitCall(IrCall expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                    if (!callee.isInline()) {
                        super.visitCall(expression2, data);
                        return;
                    }
                    for (IrValueParameter param : callee.getParameters()) {
                        IrSimpleFunction toSkip;
                        IrSimpleFunction irSimpleFunction;
                        IrExpression arg;
                        if (expression2.getArguments().get(param) == null) continue;
                        boolean condition$iv = IrInlineUtilsKt.isInlineParameter(param) && !param.isCrossinline();
                        boolean $i$f$runIf = false;
                        if (condition$iv) {
                            boolean bl = false;
                            IrExpression irExpression = arg;
                            irSimpleFunction = irExpression instanceof IrFunctionExpression ? ((IrFunctionExpression)arg).getFunction() : (irExpression instanceof IrRichFunctionReference ? ((IrRichFunctionReference)arg).getInvokeFunction() : (irExpression instanceof IrRichPropertyReference ? ((IrRichPropertyReference)arg).getGetterFunction() : null));
                        } else {
                            irSimpleFunction = toSkip = null;
                        }
                        if (toSkip != null) {
                            IrDeclarationParent irDeclarationParent = data;
                            Intrinsics.checkNotNull(irDeclarationParent);
                            this.$skippedFunctionsParents.put(toSkip, irDeclarationParent);
                        }
                        arg.accept(this, data);
                        if (toSkip == null) continue;
                        this.$skippedFunctionsParents.remove(toSkip);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitDeclaration(IrDeclarationBase declaration, IrDeclarationParent data) {
                    void it;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    IrDeclarationBase irDeclarationBase = declaration;
                    Map<IrFunction, IrDeclarationParent> map = this.$skippedFunctionsParents;
                    IrDeclarationBase irDeclarationBase2 = irDeclarationBase;
                    IrDeclarationBase irDeclarationBase3 = declaration;
                    collectSharedVariables.1 var8_7 = this;
                    boolean bl = false;
                    boolean bl2 = !map.containsKey(it);
                    IrDeclarationBase irDeclarationBase4 = bl2 ? irDeclarationBase : null;
                    IrDeclarationParent irDeclarationParent = irDeclarationBase4 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)irDeclarationBase4) : null;
                    if (irDeclarationParent == null) {
                        irDeclarationParent = data;
                    }
                    super.visitDeclaration(irDeclarationBase3, irDeclarationParent);
                }

                public void visitVariable(IrVariable declaration, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    declaration.acceptChildren(this, data);
                    if (declaration.isVar()) {
                        this.relevantVars.add(declaration);
                    } else if (declaration.getInitializer() == null) {
                        this.relevantVals.add(declaration);
                    }
                }

                public void visitValueAccess(IrValueAccessExpression expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    expression2.acceptChildren(this, data);
                    IrValueDeclaration value2 = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, value2)) {
                        Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                        if (!Intrinsics.areEqual(this.getRealParent((IrVariable)value2), data)) {
                            SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value2);
                        }
                    }
                }

                public void visitSetValue(IrSetValue expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    super.visitSetValue(expression2, data);
                    IrValueDeclaration variable = expression2.getSymbol().getOwner();
                    if (variable instanceof IrVariable && ((IrVariable)variable).getInitializer() == null && !Intrinsics.areEqual(this.getRealParent((IrVariable)variable), data) && this.relevantVals.contains(variable)) {
                        SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(variable);
                    }
                }

                private final IrDeclarationParent getRealParent(IrVariable variable) {
                    IrDeclarationParent irDeclarationParent = variable.getParent();
                    Map<IrFunction, IrDeclarationParent> map = this.$skippedFunctionsParents;
                    IrDeclarationParent it = irDeclarationParent;
                    boolean bl = false;
                    IrDeclarationParent irDeclarationParent2 = map.get(it);
                    if (irDeclarationParent2 == null) {
                        irDeclarationParent2 = it;
                    }
                    return irDeclarationParent2;
                }
            };
            IrDeclaration irDeclaration2 = this.irDeclaration;
            IrDeclarationParent irDeclarationParent = irDeclaration2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)irDeclaration2) : null;
            if (irDeclarationParent == null) {
                irDeclarationParent = this.irDeclaration.getParent();
            }
            this.irBody.accept(irElementVisitor, irDeclarationParent);
        }

        private final void rewriteSharedVariables() {
            HashMap<IrValueSymbol, IrVariableSymbol> transformedSymbols = new HashMap<IrValueSymbol, IrVariableSymbol>();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(this, SharedVariablesLowering.this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ SharedVariablesLowering this$1;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$transformedSymbols = $transformedSymbols;
                }

                public IrStatement visitVariable(IrVariable declaration) {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration)) {
                        return declaration;
                    }
                    IrVariable newDeclaration = this.this$1.getContext().getSharedVariablesManager().declareSharedVariable(declaration);
                    newDeclaration.setParent(declaration.getParent());
                    ((Map)this.$transformedSymbols).put(declaration.getSymbol(), newDeclaration.getSymbol());
                    return this.this$1.getContext().getSharedVariablesManager().defineSharedValue(declaration, newDeclaration);
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(SharedVariablesLowering.this, transformedSymbols, this){
                final /* synthetic */ SharedVariablesLowering this$0;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                final /* synthetic */ SharedVariablesTransformer this$1;
                {
                    this.this$0 = $receiver;
                    this.$transformedSymbols = $transformedSymbols;
                    this.this$1 = $receiver2;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                public IrExpression visitSetValue(IrSetValue expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map = this.$transformedSymbols;
                    SharedVariablesTransformer sharedVariablesTransformer = this.this$1;
                    V v2 = map.get(oldSymbol);
                    if (v2 == null) {
                        boolean bl;
                        boolean bl2 = false;
                        boolean bl3 = bl = !CollectionsKt.contains(SharedVariablesTransformer.access$getSharedVariables$p(sharedVariablesTransformer), oldSymbol.getOwner());
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string2 = "Shared variable is not transformed: " + DumpIrTreeKt.dump$default(oldSymbol.getOwner(), null, 1, null);
                            throw new AssertionError((Object)string2);
                        }
                        v2 = null;
                    }
                    return (IrVariableSymbol)v2;
                }
            });
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

