/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.context;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/context/ValueScopeUpdater;", "Lorg/jetbrains/kotlin/backend/common/checkers/context/ContextUpdater;", "<init>", "()V", "runInNewContext", "", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "block", "Lkotlin/Function0;", "ValueScopeVisitor", "ir.backend.common"})
public final class ValueScopeUpdater
implements ContextUpdater {
    @NotNull
    public static final ValueScopeUpdater INSTANCE = new ValueScopeUpdater();

    private ValueScopeUpdater() {
    }

    @Override
    public void runInNewContext(@NotNull CheckerContext context2, @NotNull IrElement element, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(block, "block");
        IrVisitorsKt.acceptVoid(element, new ValueScopeVisitor(context2, block));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\r\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/context/ValueScopeUpdater$ValueScopeVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "block", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;Lkotlin/jvm/functions/Function0;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitCatch", "aCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "addValueParametersOfPrimaryConstructor", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nValueScopeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueScopeUpdater.kt\norg/jetbrains/kotlin/backend/common/checkers/context/ValueScopeUpdater$ValueScopeVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1634#2,3:93\n1634#2,3:96\n*S KotlinDebug\n*F\n+ 1 ValueScopeUpdater.kt\norg/jetbrains/kotlin/backend/common/checkers/context/ValueScopeUpdater$ValueScopeVisitor\n*L\n89#1:93,3\n62#1:96,3\n*E\n"})
    private static final class ValueScopeVisitor
    extends IrVisitorVoid {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final Function0<Unit> block;

        public ValueScopeVisitor(@NotNull CheckerContext context2, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(block, "block");
            this.context = context2;
            this.block = block;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            this.block.invoke();
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (declaration instanceof IrValueDeclaration) {
                this.context.getValueSymbolScopeStack().addToCurrentScope(((IrValueDeclaration)((Object)declaration)).getSymbol());
            }
            this.block.invoke();
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.context.withScopeOwner(declaration, this.block, arg_0 -> ValueScopeVisitor.visitClass$lambda$0(declaration, arg_0));
        }

        @Override
        public void visitScript(@NotNull IrScript declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.context.withScopeOwner(declaration, this.block, arg_0 -> ValueScopeVisitor.visitScript$lambda$1(declaration, arg_0));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.context.withScopeOwner(declaration, this.block, arg_0 -> ValueScopeVisitor.visitFunction$lambda$2(declaration, arg_0));
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.context.withScopeOwner(declaration, this.block, arg_0 -> ValueScopeVisitor.visitAnonymousInitializer$lambda$3(this, declaration, arg_0));
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.context.withScopeOwner(declaration, this.block, arg_0 -> ValueScopeVisitor.visitField$lambda$4(this, declaration, arg_0));
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkNotNullParameter(aCatch, "aCatch");
            CheckerContext.withScopeOwner$default(this.context, aCatch, this.block, null, 4, null);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            CheckerContext.withScopeOwner$default(this.context, expression2, this.block, null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void addValueParametersOfPrimaryConstructor(Set<IrValueSymbol> $this$addValueParametersOfPrimaryConstructor, IrDeclaration declaration) {
            block1: {
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                Object object = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (object == null || (object = IrUtilsKt.getPrimaryConstructor((IrClass)object)) == null || (object = ((IrFunction)object).getParameters()) == null) break block1;
                Iterable $this$mapTo$iv = (Iterable)object;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void p0;
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                    Collection collection = $this$addValueParametersOfPrimaryConstructor;
                    boolean bl = false;
                    collection.add(p0.getSymbol());
                }
                Set cfr_ignored_0 = (Set)((Collection)$this$addValueParametersOfPrimaryConstructor);
            }
        }

        private static final Unit visitClass$lambda$0(IrClass $declaration, Set $this$withScopeOwner) {
            Intrinsics.checkNotNullParameter($this$withScopeOwner, "$this$withScopeOwner");
            IrValueParameter irValueParameter = $declaration.getThisReceiver();
            CollectionsKt.addIfNotNull($this$withScopeOwner, irValueParameter != null ? irValueParameter.getSymbol() : null);
            return Unit.INSTANCE;
        }

        private static final Unit visitScript$lambda$1(IrScript $declaration, Set $this$withScopeOwner) {
            Intrinsics.checkNotNullParameter($this$withScopeOwner, "$this$withScopeOwner");
            IrValueParameter irValueParameter = $declaration.getThisReceiver();
            CollectionsKt.addIfNotNull($this$withScopeOwner, irValueParameter != null ? irValueParameter.getSymbol() : null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit visitFunction$lambda$2(IrFunction $declaration, Set $this$withScopeOwner) {
            Intrinsics.checkNotNullParameter($this$withScopeOwner, "$this$withScopeOwner");
            Iterable $this$mapTo$iv = $declaration.getParameters();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                Collection collection = $this$withScopeOwner;
                boolean bl = false;
                collection.add(p0.getSymbol());
            }
            return Unit.INSTANCE;
        }

        private static final Unit visitAnonymousInitializer$lambda$3(ValueScopeVisitor this$0, IrAnonymousInitializer $declaration, Set $this$withScopeOwner) {
            Intrinsics.checkNotNullParameter($this$withScopeOwner, "$this$withScopeOwner");
            this$0.addValueParametersOfPrimaryConstructor($this$withScopeOwner, $declaration);
            return Unit.INSTANCE;
        }

        private static final Unit visitField$lambda$4(ValueScopeVisitor this$0, IrField $declaration, Set $this$withScopeOwner) {
            Intrinsics.checkNotNullParameter($this$withScopeOwner, "$this$withScopeOwner");
            this$0.addValueParametersOfPrimaryConstructor($this$withScopeOwner, $declaration);
            return Unit.INSTANCE;
        }
    }
}

