/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FastUtilCaseInsensitiveStringHashingStrategy;
import com.intellij.util.containers.FastUtilCharSequenceHashingStrategy;
import com.intellij.util.containers.FastUtilHashingStrategies$SerializableHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FastUtilHashingStrategies {
    private static final Hash.Strategy<CharSequence> CASE_SENSITIVE = new FastUtilCharSequenceHashingStrategy(true);
    private static final Hash.Strategy<CharSequence> CASE_INSENSITIVE = new FastUtilCharSequenceHashingStrategy(false);
    public static final Hash.Strategy<String> FILE_PATH_HASH_STRATEGY = new Hash.Strategy<String>(){

        @Override
        public int hashCode(@Nullable String o2) {
            return FileUtilRt.pathHashCode(o2);
        }

        @Override
        public boolean equals(@Nullable String p1, @Nullable String p2) {
            return FileUtilRt.pathsEqual(p1, p2);
        }
    };
    public static final Hash.Strategy<File> FILE_HASH_STRATEGY = new FastUtilHashingStrategies$SerializableHashStrategy<File>(){

        public int hashCode(@Nullable File o2) {
            return FileUtilRt.pathHashCode(o2 == null ? null : o2.getPath());
        }

        public boolean equals(@Nullable File a2, @Nullable File b2) {
            return FileUtilRt.pathsEqual(a2 == null ? null : a2.getPath(), b2 == null ? null : b2.getPath());
        }
    };

    @NotNull
    public static Hash.Strategy<CharSequence> getCharSequenceStrategy(boolean isCaseSensitive) {
        Hash.Strategy<CharSequence> strategy = isCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(0);
        }
        return strategy;
    }

    @NotNull
    public static Hash.Strategy<String> getCaseInsensitiveStringStrategy() {
        Hash.Strategy<String> strategy = FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(2);
        }
        return strategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequenceStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseInsensitiveStringStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adaptAsNotNull";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

