/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.DynamicBundle;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001e\u0010\u0016\u001a\u00020\f*\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001c\u0010\u0019\u001a\u00020\f*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/LocalizationUtil;", "", "()V", "LOCALIZATION_FOLDER_NAME", "", "isL10nPluginInitialized", "", "()Z", "setL10nPluginInitialized", "(Z)V", "getFolderLocalizedPaths", "", "Ljava/nio/file/Path;", "path", "specialLocale", "Ljava/util/Locale;", "getLocalizedPaths", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "getResourceAsStream", "Ljava/io/InputStream;", "defaultLoader", "convertPathToLocaleSuffixUsage", "locale", "withRegion", "convertToLocalizationFolderUsage", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/util/LocalizationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class LocalizationUtil {
    @NotNull
    public static final LocalizationUtil INSTANCE = new LocalizationUtil();
    private static volatile boolean isL10nPluginInitialized;

    private LocalizationUtil() {
    }

    public final boolean isL10nPluginInitialized() {
        return isL10nPluginInitialized;
    }

    private final Path convertToLocalizationFolderUsage(Path $this$convertToLocalizationFolderUsage, Locale locale, boolean withRegion) {
        Path path = Paths.get("localization", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        Path result2 = path.resolve(locale.getLanguage());
        if (withRegion) {
            String string2 = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue(string2, "getCountry(...)");
            if (((CharSequence)string2).length() > 0) {
                result2 = result2.resolve(locale.getCountry());
            }
        }
        Path path2 = result2 = result2.resolve($this$convertToLocalizationFolderUsage);
        Intrinsics.checkNotNull(path2);
        return path2;
    }

    private final Path convertPathToLocaleSuffixUsage(Path $this$convertPathToLocaleSuffixUsage, Locale locale, boolean withRegion) {
        Path path;
        if (locale == null) {
            return $this$convertPathToLocaleSuffixUsage;
        }
        StringBuilder fileName = new StringBuilder(PathsKt.getNameWithoutExtension($this$convertPathToLocaleSuffixUsage));
        String extension = PathsKt.getExtension($this$convertPathToLocaleSuffixUsage);
        Path path2 = $this$convertPathToLocaleSuffixUsage.getParent();
        if (path2 == null) {
            Path path3 = Paths.get("", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
        } else {
            path = path2;
        }
        Path foldersPath = path;
        String language2 = locale.getLanguage();
        Intrinsics.checkNotNull(language2);
        if (!(((CharSequence)language2).length() == 0)) {
            fileName.append('_').append(language2);
            String country = locale.getCountry();
            Intrinsics.checkNotNull(country);
            if (((CharSequence)country).length() > 0 && withRegion) {
                fileName.append('_').append(country);
            }
        }
        if (((CharSequence)extension).length() > 0) {
            fileName.append(".").append(extension);
        }
        Path result2 = foldersPath.resolve(fileName.toString());
        Intrinsics.checkNotNull(result2);
        return result2;
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null) {
            Locale locale2 = DynamicBundle.getLocale();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue(locale2, "getLocale(...)");
        }
        Locale locale3 = locale;
        Path[] pathArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale3, true), this.convertPathToLocaleSuffixUsage(path, locale3, true), this.convertToLocalizationFolderUsage(path, locale3, false), this.convertPathToLocaleSuffixUsage(path, locale3, false), path};
        return CollectionsKt.listOf(pathArray);
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getFolderLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null) {
            Locale locale2 = DynamicBundle.getLocale();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue(locale2, "getLocale(...)");
        }
        Locale locale3 = locale;
        Path[] pathArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale3, true), this.convertToLocalizationFolderUsage(path, locale3, false)};
        return CollectionsKt.listOf(pathArray);
    }
}

