/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiMethodUtil {
    public static final Condition<PsiClass> MAIN_CLASS = psiClass -> {
        if (PsiUtil.isLocalOrAnonymousClass(psiClass)) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isAvailable(JavaFeature.EXTENSION_METHODS, psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(PsiClass aClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(aClass)) continue;
            return provider2.findMainInClass(aClass);
        }
        PsiMethod[] mainMethods = aClass.findMethodsByName("main", true);
        return PsiMethodUtil.findMainMethod(mainMethods, aClass);
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods, PsiClass aClass) {
        for (PsiMethod mainMethod : mainMethods) {
            PsiClass containingClass;
            if (mainMethod.hasModifierProperty("abstract") || aClass.hasModifierProperty("abstract") && !mainMethod.hasModifierProperty("static") || (containingClass = mainMethod.getContainingClass()) != null && containingClass != aClass && (containingClass.isInterface() && !PsiMethodUtil.instanceMainMethodsEnabled(containingClass) || containingClass.isInterface() && mainMethod.hasModifierProperty("static") && !PsiMethodUtil.inheritedStaticMainEnabled(containingClass)) || !PsiMethodUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    private static boolean instanceMainMethodsEnabled(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(0);
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(psiElement);
        boolean is21Preview = languageLevel.equals((Object)LanguageLevel.JDK_21_PREVIEW);
        boolean is22PreviewOrOlder = languageLevel.isAtLeast(LanguageLevel.JDK_22_PREVIEW);
        return is21Preview || is22PreviewOrOlder;
    }

    private static boolean inheritedStaticMainEnabled(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(1);
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(psiElement);
        return languageLevel.isAtLeast(LanguageLevel.JDK_22_PREVIEW);
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (!PsiTypes.voidType().equals(method.getReturnType())) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (PsiMethodUtil.instanceMainMethodsEnabled(method)) {
            if (!(method.hasModifierProperty("public") || method.hasModifierProperty("packageLocal") || method.hasModifierProperty("protected"))) {
                return false;
            }
            PsiMethod[] constructors2 = method.getContainingClass().getConstructors();
            if (!method.hasModifierProperty("static") && constructors2.length != 0 && !ContainerUtil.exists(constructors2, method1 -> method1.getParameterList().isEmpty())) {
                return false;
            }
            if (parameters.length == 1) {
                return PsiMethodUtil.isJavaLangStringArray(parameters[0]);
            }
            return parameters.length == 0;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        if (parameters.length != 1) {
            return false;
        }
        return PsiMethodUtil.isJavaLangStringArray(parameters[0]);
    }

    private static boolean isJavaLangStringArray(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(psiClass)) continue;
            return provider2.hasMainMethod(psiClass);
        }
        PsiMethod[] mainMethods = psiClass.findMethodsByName("main", true);
        return PsiMethodUtil.findMainMethod(mainMethods, psiClass) != null;
    }

    @Nullable
    public static PsiMethod findMainInClass(PsiClass aClass) {
        if (!MAIN_CLASS.value(aClass)) {
            return null;
        }
        return PsiMethodUtil.findMainMethod(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiElement";
        objectArray2[1] = "com/intellij/psi/util/PsiMethodUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceMainMethodsEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "inheritedStaticMainEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

