/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types2, @NotNull PsiManager psiManager) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(1);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types2);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            PsiType lub = this.myTypes.get(0);
            for (int i2 = 1; i2 < this.myTypes.size(); ++i2) {
                if ((lub = GenericsUtil.getLeastUpperBound(lub, this.myTypes.get(i2), this.myManager)) != null) continue;
                lub = PsiType.getJavaLangObject(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                break;
            }
            return CachedValueProvider.Result.create(lub, PsiModificationTracker.MODIFICATION_COUNT);
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types2, @NotNull PsiManager psiManager) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(2);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(3);
        }
        assert (!types2.isEmpty());
        return types2.size() == 1 ? types2.get(0) : new PsiDisjunctionType(types2, psiManager);
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        PsiType psiType = this.myLubCache.getValue();
        if (psiType == null) {
            PsiDisjunctionType.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        List<PsiType> list = this.myTypes;
        if (list == null) {
            PsiDisjunctionType.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types2) {
        return new PsiDisjunctionType(types2, this.myManager);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = StringUtil.join(this.myTypes, psiType -> psiType.getPresentableText(annotated), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = StringUtil.join(this.myTypes, psiType -> psiType.getCanonicalText(annotated), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = StringUtil.join(this.myTypes, psiType -> psiType.getInternalCanonicalText(), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.myTypes) {
            if (type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            PsiDisjunctionType.$$$reportNull$$$0(9);
        }
        return Objects.equals(text, this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(10);
        }
        return visitor2.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray = ((PsiIntersectionType)lub).getConjuncts();
            if (psiTypeArray == null) {
                PsiDisjunctionType.$$$reportNull$$$0(11);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = new PsiType[]{lub};
        if (psiTypeArray == null) {
            PsiDisjunctionType.$$$reportNull$$$0(12);
        }
        return psiTypeArray;
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o2;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myTypes.size(); ++i2) {
            if (this.myTypes.get(i2).equals(that.myTypes.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static List<PsiType> flattenAndRemoveDuplicates(@NotNull List<? extends PsiType> types2) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(13);
        }
        LinkedHashSet disjunctionSet = new LinkedHashSet();
        for (PsiType psiType : types2) {
            PsiDisjunctionType.flatten(disjunctionSet, psiType);
        }
        ArrayList<PsiType> disjunctions = new ArrayList<PsiType>(disjunctionSet);
        Iterator iterator2 = disjunctions.iterator();
        block1: while (iterator2.hasNext()) {
            PsiType d1 = (PsiType)iterator2.next();
            for (PsiType d2 : disjunctions) {
                if (d1 == d2 || !d2.isAssignableFrom(d1)) continue;
                iterator2.remove();
                continue block1;
            }
        }
        return disjunctions;
    }

    private static void flatten(Set<? super PsiType> disjunctions, PsiType type2) {
        if (type2 instanceof PsiDisjunctionType) {
            for (PsiType child : ((PsiDisjunctionType)type2).getDisjunctions()) {
                PsiDisjunctionType.flatten(disjunctions, child);
            }
        } else {
            disjunctions.add(type2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisjunctions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDisjunction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndRemoveDuplicates";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

