/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.Java11Shim;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    @NonNls
    protected final String lock;
    private Map<String, PersistentList<T>> explicitExtensions;
    private volatile @UnmodifiableView Map<String, List<T>> cache;
    private final String epName;
    private final SimpleModificationTracker tracker;
    protected final AtomicBoolean myEpListenerAdded;

    public KeyedExtensionCollector(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this(epName.getName());
    }

    public KeyedExtensionCollector(@NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        this.explicitExtensions = Java11Shim.INSTANCE.mapOf();
        this.cache = Java11Shim.INSTANCE.mapOf();
        this.tracker = new SimpleModificationTracker();
        this.myEpListenerAdded = new AtomicBoolean();
        this.epName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        String string2 = this.lock;
        synchronized (string2) {
            this.cache = Collections.emptyMap();
            this.tracker.incModificationCount();
        }
    }

    private void addExtensionPointListener(@NotNull @NotNull ExtensionPoint<@NotNull KeyedLazyInstance<T>> point) {
        if (point == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        if (this.myEpListenerAdded.compareAndSet(false, true)) {
            point.addExtensionPointListener(new MyExtensionPointListener(), false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateCacheForExtension(@NotNull String key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (!this.cache.containsKey(key)) {
            return;
        }
        String string2 = this.lock;
        synchronized (string2) {
            this.cache = UtilKt.without(this.cache, key);
            this.tracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t2) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        String stringKey = this.keyToString(key);
        String string2 = this.lock;
        synchronized (string2) {
            PersistentList<T> value2 = this.explicitExtensions.get(stringKey);
            this.explicitExtensions = UtilKt.with(this.explicitExtensions, stringKey, value2 == null ? ExtensionsKt.persistentListOf(t2) : value2.add(t2));
            this.invalidateCacheForExtension(stringKey);
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t2, @NotNull Disposable parentDisposable) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        this.addExplicitExtension(key, t2);
        Disposer.register(parentDisposable, () -> this.removeExplicitExtension(key, t2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t2) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        String stringKey = this.keyToString(key);
        String string2 = this.lock;
        synchronized (string2) {
            PersistentList<T> list = this.explicitExtensions.get(stringKey);
            if (list != null) {
                this.explicitExtensions = (list = list.remove(t2)).isEmpty() ? UtilKt.without(this.explicitExtensions, stringKey) : UtilKt.with(this.explicitExtensions, stringKey, list);
            }
            this.invalidateCacheForExtension(stringKey);
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        String string2 = key.toString();
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        List<T> cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        if ((cached = this.cache.get(stringKey = this.keyToString(key))) != null) {
            List<T> list = cached;
            if (list != null) return list;
            KeyedExtensionCollector.$$$reportNull$$$0(14);
            return list;
        }
        cached = this.buildExtensions(stringKey, key);
        String string2 = this.lock;
        // MONITORENTER : string2
        List<T> recent = this.cache.get(stringKey);
        if (recent != null) {
            List<T> list = recent;
            // MONITOREXIT : string2
            if (list != null) return list;
            KeyedExtensionCollector.$$$reportNull$$$0(15);
            return list;
        }
        this.cache = UtilKt.with(this.cache, stringKey, cached);
        List<T> list = cached;
        // MONITOREXIT : string2
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(16);
        return list;
    }

    public final T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(19);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.lock;
        // MONITORENTER : string2
        PersistentList<T> explicit = this.explicitExtensions.get(stringKey);
        List<T> result2 = this.buildExtensionsFromExtensionPoint(bean -> stringKey.equals(bean.getKey()), extensions);
        List<T> list = explicit == null ? result2 : explicit.addAll(result2);
        // MONITOREXIT : string2
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(20);
        return list;
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point == null) {
            List<KeyedLazyInstance<T>> list = Java11Shim.INSTANCE.listOf();
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(21);
            }
            return list;
        }
        this.addExtensionPointListener(point);
        List<KeyedLazyInstance<T>> list = point.getExtensionList();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    final List<T> buildExtensionsFromExtensionPoint(@NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<? extends KeyedLazyInstance<T>> extensions) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(23);
        }
        if (extensions == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(24);
        }
        ArrayList<T> result2 = null;
        Object r1 = null;
        Object r2 = null;
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance2;
            if (!isMyBean.test(bean) || (instance2 = KeyedExtensionCollector.instantiate(bean)) == null) continue;
            if (result2 != null) {
                result2.add(instance2);
                continue;
            }
            if (r1 == null) {
                r1 = instance2;
                continue;
            }
            if (r2 == null) {
                r2 = instance2;
                continue;
            }
            result2 = new ArrayList<T>();
            result2.add(r1);
            result2.add(r2);
            result2.add(instance2);
        }
        if (result2 != null) {
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        if (r2 != null) {
            List<Object> list = Java11Shim.INSTANCE.listOf(r1, r2);
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (r1 != null) {
            List<Object> list = Java11Shim.INSTANCE.listOf(r1);
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(27);
            }
            return list;
        }
        List list = Java11Shim.INSTANCE.listOf();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    public static <T> T instantiate(@NotNull KeyedLazyInstance<T> bean) {
        if (bean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(29);
        }
        try {
            return bean.getInstance();
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (ExtensionNotApplicableException ignore) {
            return null;
        }
        catch (Exception | LinkageError e3) {
            LOG.error(e3);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final PersistentList<T> buildExtensions(@NotNull Set<String> keys) {
        if (keys == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(30);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.lock;
        // MONITORENTER : string2
        PersistentList<T> explicit = this.buildExtensionsFromExplicitRegistration(keys::contains);
        List<T> result2 = this.buildExtensionsFromExtensionPoint(bean -> {
            String key;
            try {
                key = bean.getKey();
            }
            catch (IllegalStateException e2) {
                LOG.error(e2);
                return false;
            }
            return keys.contains(key);
        }, extensions);
        PersistentList<T> persistentList = explicit.addAll(result2);
        // MONITOREXIT : string2
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(31);
        return persistentList;
    }

    @NotNull
    protected final PersistentList<T> buildExtensionsFromExplicitRegistration(@NotNull Predicate<? super String> isMyBean) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(32);
        }
        PersistentList result2 = ExtensionsKt.persistentListOf();
        for (Map.Entry<String, PersistentList<T>> entry : this.explicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.test(key)) continue;
            result2 = result2.addAll(entry.getValue());
        }
        PersistentList persistentList = result2;
        if (persistentList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(33);
        }
        return persistentList;
    }

    @ApiStatus.Internal
    public final @Nullable ExtensionPoint<@NotNull KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.epName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string2 = this.lock;
        synchronized (string2) {
            if (!this.explicitExtensions.isEmpty()) {
                return true;
            }
        }
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        return point != null && point.size() != 0;
    }

    @NotNull
    public String getName() {
        String string2 = this.epName;
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(34);
        }
        return string2;
    }

    @Override
    public long getModificationCount() {
        return this.tracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance<T> bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 20: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExplicitRegistration";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCacheForExtension";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 18: 
            case 19: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExplicitRegistration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyExtensionPointListener
    implements ExtensionPointAndAreaListener<KeyedLazyInstance<T>>,
    ExtensionPointPriorityListener {
        private MyExtensionPointListener() {
        }

        @Override
        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(1);
            }
            if (bean.getKey() == null) {
                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        @Override
        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(3);
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void areaReplaced(@NotNull ExtensionsArea area) {
            if (area == null) {
                MyExtensionPointListener.$$$reportNull$$$0(4);
            }
            String string2 = KeyedExtensionCollector.this.lock;
            synchronized (string2) {
                KeyedExtensionCollector.this.cache = Java11Shim.INSTANCE.mapOf();
                KeyedExtensionCollector.this.tracker.incModificationCount();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$MyExtensionPointListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areaReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

