/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0002\u001a$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001a\"\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0007\"\u001a\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"(\u0010\u0006\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "()V", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "brokenPluginVersions", "Ljava/lang/ref/Reference;", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "", "updatedBrokenPluginFile", "Ljava/nio/file/Path;", "getUpdatedBrokenPluginFile", "()Ljava/nio/file/Path;", "getBrokenPluginVersions", "isBrokenPlugin", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "readBrokenPluginFile", "tryReadBrokenPluginsFile", "brokenPluginsStorage", "updateBrokenPlugins", "", "brokenPlugins", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nbrokenPluginFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,129:1\n31#2:130\n*S KotlinDebug\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n*L\n114#1:130\n*E\n"})
public final class BrokenPluginFileKt {
    @Nullable
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        return logger;
    }

    @NotNull
    public static final Path getUpdatedBrokenPluginFile() {
        String[] stringArray = new String[]{"updatedBrokenPlugins.db"};
        Path path = Paths.get(PathManager.getConfigPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return path;
    }

    @NotNull
    public static final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            return MapsKt.emptyMap();
        }
        Reference<Map<PluginId, Set<String>>> reference2 = brokenPluginVersions;
        Map<PluginId, Set<String>> map = result2 = reference2 != null ? reference2.get() : null;
        if (result2 == null) {
            result2 = BrokenPluginFileKt.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        return result2;
    }

    private static final Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> map;
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            BrokenPluginFileKt.getLOG().info("Using cached broken plugins file");
        }
        if (result2 == null) {
            String[] stringArray = new String[]{"brokenPlugins.db"};
            Path path = Paths.get(PathManager.getBinPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue(path, "get(...)");
            result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(path);
            if (result2 != null) {
                BrokenPluginFileKt.getLOG().info("Using broken plugins file from IDE distribution");
            }
        }
        if ((map = result2) == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try {
            Closeable closeable = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));
            Throwable throwable = null;
            try {
                DataInputStream stream = (DataInputStream)closeable;
                boolean bl = false;
                int version2 = stream.readUnsignedByte();
                if (version2 != 2) {
                    BrokenPluginFileKt.getLOG().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version2 + ", supportedVersion=2)");
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                String buildNumber = stream.readUTF();
                if (!Intrinsics.areEqual(buildNumber, PluginManagerCore.getBuildNumber().toString())) {
                    BrokenPluginFileKt.getLOG().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ')');
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                int count = stream.readInt();
                HashMap result2 = new HashMap(count);
                for (int i2 = 0; i2 < count; ++i2) {
                    PluginId pluginId;
                    Intrinsics.checkNotNullExpressionValue(PluginId.getId(stream.readUTF()), "getId(...)");
                    PersistentSet $this$mutate$iv = ExtensionsKt.persistentHashSetOf();
                    boolean $i$f$mutate = false;
                    PersistentSet.Builder builder = $this$mutate$iv.builder();
                    Set set = builder;
                    PluginId pluginId2 = pluginId;
                    HashMap hashMap = result2;
                    boolean bl2 = false;
                    int n2 = stream.readUnsignedShort();
                    int n3 = 0;
                    while (n3 < n2) {
                        void r2;
                        int it = n3++;
                        boolean bl3 = false;
                        String string2 = stream.readUTF();
                        Intrinsics.checkNotNullExpressionValue(string2, "readUTF(...)");
                        r2.add(string2);
                    }
                    Unit unit = Unit.INSTANCE;
                    hashMap.put(pluginId2, builder.build());
                }
                Map map = result2;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e2) {
            BrokenPluginFileKt.getLOG().warn("Failed to read " + brokenPluginsStorage, e2);
        }
        return null;
    }
}

