/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;

public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value2) {
        return value2 ^ Integer.MIN_VALUE;
    }

    public static int compare(int a2, int b2) {
        return Ints.compare(UnsignedInts.flip(a2), UnsignedInts.flip(b2));
    }

    public static long toLong(int value2) {
        return (long)value2 & 0xFFFFFFFFL;
    }

    public static int checkedCast(long value2) {
        Preconditions.checkArgument(value2 >> 32 == 0L, "out of range: %s", value2);
        return (int)value2;
    }

    public static int saturatedCast(long value2) {
        if (value2 <= 0L) {
            return 0;
        }
        if (value2 >= 0x100000000L) {
            return -1;
        }
        return (int)value2;
    }

    public static int min(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min = UnsignedInts.flip(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int next = UnsignedInts.flip(array[i2]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedInts.flip(min);
    }

    public static int max(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = UnsignedInts.flip(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int next = UnsignedInts.flip(array[i2]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedInts.flip(max);
    }

    public static String join(String separator, int ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedInts.toString(array[0]));
        for (int i2 = 1; i2 < array.length; ++i2) {
            builder.append(separator).append(UnsignedInts.toString(array[i2]));
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] array) {
        Preconditions.checkNotNull(array);
        UnsignedInts.sort(array, 0, array.length);
    }

    public static void sort(int[] array, int fromIndex, int toIndex) {
        int i2;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array[i2] = UnsignedInts.flip(array[i2]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array[i2] = UnsignedInts.flip(array[i2]);
        }
    }

    public static void sortDescending(int[] array) {
        Preconditions.checkNotNull(array);
        UnsignedInts.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(int[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i2 = fromIndex;
        while (i2 < toIndex) {
            int n2 = i2++;
            array[n2] = array[n2] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i2 = fromIndex;
        while (i2 < toIndex) {
            int n3 = i2++;
            array[n3] = array[n3] ^ Integer.MAX_VALUE;
        }
    }

    public static int divide(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong(divisor));
    }

    public static int remainder(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong(divisor));
    }

    @CanIgnoreReturnValue
    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e2) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e2);
            throw decodeException;
        }
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String s2) {
        return UnsignedInts.parseUnsignedInt(s2, 10);
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        long result2 = Long.parseLong(string2, radix);
        if ((result2 & 0xFFFFFFFFL) != result2) {
            throw new NumberFormatException("Input " + string2 + " in base " + radix + " is not in the range of an unsigned integer");
        }
        return (int)result2;
    }

    public static String toString(int x2) {
        return UnsignedInts.toString(x2, 10);
    }

    public static String toString(int x2, int radix) {
        long asLong = (long)x2 & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                if (left[i2] == right[i2]) continue;
                return UnsignedInts.compare(left[i2], right[i2]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

