/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.repositories;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.scripts.GenericDomainTypeUnifier;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.scripts.ScriptManager;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.impl.visitors.VisitorsManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.lang.SignatureKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HypoteticRelationsRepository {
    private final ScriptManager scriptManager;
    private final VisitorsManager visitorsManager;
    private final HypoteticRelationsRepository parent;
    private Map<String, Entry> entries;
    private Map<RmlDeclarationType, Set<RelationSignature>> allSignatures;

    public HypoteticRelationsRepository(VisitorsManager visitorsManager, ScriptManager scriptManager, HypoteticRelationsRepository parent) {
        this.visitorsManager = visitorsManager;
        this.scriptManager = scriptManager;
        this.parent = parent;
        this.entries = new HashMap<String, Entry>();
    }

    public void refresh() {
        this.entries = new HashMap<String, Entry>();
        this.refreshVisitors();
        this.refreshScripts();
    }

    private void refreshVisitors() {
        if (this.parent != null) {
            for (Map.Entry<String, Entry> pair : this.parent.entries.entrySet()) {
                if (pair.getValue().visitor == null && pair.getValue().script == null) continue;
                Entry entry = new Entry();
                entry.signature = pair.getValue().signature;
                entry.inMemory = true;
                entry.visitor = pair.getValue().visitor;
                entry.script = pair.getValue().script;
                entry.subgroup = pair.getValue().subgroup;
                this.entries.put(pair.getKey(), entry);
            }
        }
        Collection<Visitor> visitors = this.visitorsManager.getAvailableVisitors();
        for (Visitor visitor2 : visitors) {
            RelationSignature[] signatures;
            for (RelationSignature signature : signatures = visitor2.getOutputRelations()) {
                Entry entry;
                String name = signature.getName();
                if (this.entries.containsKey(name)) {
                    entry = this.entries.get(name);
                    if (entry.visitor != null) {
                        throw new DfaInternalException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-3") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-4") + entry.visitor.getName() + Messages.getString(HypoteticRelationsRepository.class.getName() + "-5") + visitor2.getName() + "\"");
                    }
                    if (!ArrayHelper.equals(entry.signature.getTypes(), signature.getTypes())) {
                        throw new DfaInternalException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-7") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-8"));
                    }
                } else {
                    entry = new Entry();
                }
                entry.signature = signature;
                entry.visitor = visitor2;
                this.entries.put(name, entry);
            }
        }
    }

    private void refreshScripts() {
        boolean changes;
        VariablesManager manager;
        Collection<Script> scripts = this.scriptManager.getAvailableScripts();
        HashSet<Script> processed = new HashSet<Script>();
        GenericDomainTypeUnifier unifier = new GenericDomainTypeUnifier(this);
        HashMap<Script, String> notUnified = new HashMap<Script, String>();
        this.allSignatures = new HashMap<RmlDeclarationType, Set<RelationSignature>>();
        for (RmlDeclarationType type2 : RmlDeclarationType.getEntries()) {
            this.allSignatures.put(type2, new HashSet());
        }
        for (Script script : scripts) {
            manager = this.scriptManager.getVariablesManager(script.getName());
            for (RmlDeclarationType type3 : RmlDeclarationType.getEntries()) {
                this.allSignatures.get(type3).addAll(Arrays.asList(manager.getRelations(type3)));
            }
        }
        do {
            changes = false;
            for (Script script : scripts) {
                manager = this.scriptManager.getVariablesManager(script.getName());
                RelationSignature[] outputRelations = ContainerUtil.flatMap((Iterable)RmlDeclarationType.Companion.getOutputTypes(), type -> Arrays.asList(manager.getRelations((RmlDeclarationType)type))).toArray(RelationSignature.EMPTY_ARRAY);
                RelationSignature[] outputAndTempRelations = ArrayHelper.mergeArrays(outputRelations, manager.getRelations(RmlDeclarationType.Temp), RelationSignature.class);
                if (processed.contains(script)) continue;
                if (this.parent != null) {
                    HashSet<RelationSignature> signatures = new HashSet<RelationSignature>(Arrays.asList(manager.getRelations(RmlDeclarationType.Input)));
                    Arrays.asList(outputRelations).forEach(signatures::remove);
                    signatures.removeIf(sig -> SignatureKt.isFakeRelation((String)sig.getName()));
                    for (RmlDeclarationType type4 : RmlDeclarationType.Companion.getSummaryTypes()) {
                        this.allSignatures.get(type4).forEach(signatures::remove);
                    }
                    String curNotUnified = unifier.unifySignatures((Set<RelationSignature>)signatures, script.getName());
                    notUnified.put(script, curNotUnified);
                    if (curNotUnified != null) continue;
                }
                for (RelationSignature relation : outputAndTempRelations) {
                    Entry entry;
                    String name = relation.getName();
                    if (this.entries.containsKey(name)) {
                        entry = this.entries.get(name);
                        if (entry.visitor != null || entry.script != null) {
                            throw new DfaInternalException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-9") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-10") + (entry.visitor != null ? entry.visitor.getName() : entry.script.getName()) + Messages.getString(HypoteticRelationsRepository.class.getName() + "-11") + script.getName() + "\"");
                        }
                    } else {
                        entry = new Entry();
                    }
                    entry.signature = relation;
                    entry.script = script;
                    entry.subgroup = manager.getRelationSubgroup(name);
                    this.entries.put(name, entry);
                }
                processed.add(script);
                changes = true;
            }
        } while (changes);
        StringBuilder message = new StringBuilder();
        for (Script script : scripts) {
            if (processed.contains(script)) continue;
            String relation = (String)notUnified.get(script);
            message.append(script.getName()).append(" -> ").append(this.findScriptByRelation(relation)).append(" (").append(relation).append(")\n");
        }
        if (!message.isEmpty()) {
            throw new DfaInternalException("RML scripts were not unified because of unsatisfied dependencies:\n" + message);
        }
        if (this.parent != null) {
            for (Script script : scripts) {
                VariablesManager manager2 = this.scriptManager.getVariablesManager(script.getName());
                for (RmlDeclarationType type5 : RmlDeclarationType.Companion.getSummaryTypes()) {
                    for (RelationSignature relation : manager2.getRelations(type5)) {
                        this.parent.entries.put(relation.getName(), this.entries.get(relation.getName()));
                    }
                }
            }
        }
    }

    private String findScriptByRelation(String outputRelation) {
        for (Script script : this.scriptManager.getAvailableScripts()) {
            VariablesManager manager = this.scriptManager.getVariablesManager(script.getName());
            if (!ContainerUtil.exists((Object[])manager.getRelations(RmlDeclarationType.Output), signature -> signature.getName().equals(outputRelation))) continue;
            return script.getName();
        }
        return "???";
    }

    public HypoteticRelationsRepository getParent() {
        return this.parent;
    }

    public List<String> getAllRelations(RmlDeclarationType type) {
        return ContainerUtil.map((Collection)this.allSignatures.get(type), RelationSignature::getName);
    }

    public DomainType[] getDomainTypes(String name) {
        return this.entries.get((Object)name).signature.getTypes();
    }

    public boolean containsRelation(String name) {
        return this.entries.containsKey(name);
    }

    public Object getRelationProducer(String name) {
        Entry entry = this.entries.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.script != null) {
            return entry.script;
        }
        if (entry.visitor != null) {
            return entry.visitor;
        }
        return null;
    }

    public String getRelationProducerName(String name) {
        Entry entry = this.entries.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.script != null) {
            return entry.script.getName();
        }
        if (entry.visitor != null) {
            return entry.visitor.getName();
        }
        return null;
    }

    public String getRelationSubgroup(String name) {
        Entry entry = this.entries.get(name);
        if (entry != null) {
            return entry.subgroup;
        }
        return null;
    }

    @NotNull
    public List<Script> getScriptsOrder() {
        String[] relations = ArrayUtil.toStringArray(this.scriptManager.getOutputRelations());
        ArrayList<Visitor> runVisitors = new ArrayList<Visitor>();
        ArrayList<Script> runScripts = new ArrayList<Script>();
        for (String name : relations) {
            this.getRelationBuildPlan(name, runVisitors, runScripts, new HashSet<String>());
        }
        ArrayList<Script> arrayList = runScripts;
        if (arrayList == null) {
            HypoteticRelationsRepository.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public boolean isBasicRelation(String name) {
        return this.entries.get(name) != null && this.entries.get((Object)name).visitor != null;
    }

    private void getRelationBuildPlan(String name, List<Visitor> runVisitors, List<Script> runScripts, Set<String> armedRelations) {
        if (armedRelations.contains(name)) {
            return;
        }
        armedRelations.add(name);
        Entry entry = this.entries.get(name);
        if (entry == null) {
            throw new DfaInternalException("Can't build the evaluation plan for relation " + name);
        }
        if (!entry.inMemory) {
            if (entry.visitor != null) {
                if (!runVisitors.contains(entry.visitor)) {
                    RelationSignature[] outputs;
                    runVisitors.add(entry.visitor);
                    for (RelationSignature output : outputs = entry.visitor.getOutputRelations()) {
                        armedRelations.add(output.getName());
                    }
                }
            } else if (entry.script != null) {
                if (!runScripts.contains(entry.script)) {
                    VariablesManager manager = this.scriptManager.getVariablesManager(entry.script.getName());
                    for (RmlDeclarationType type : RmlDeclarationType.Companion.getOutputTypes()) {
                        for (RelationSignature output : manager.getRelations(type)) {
                            armedRelations.add(output.getName());
                        }
                    }
                    for (RelationSignature input : manager.getRelations(RmlDeclarationType.Input)) {
                        if (this.allSignatures.get(RmlDeclarationType.Summary).contains(input) || SignatureKt.isFakeRelation((String)input.getName())) continue;
                        this.getRelationBuildPlan(input.getName(), runVisitors, runScripts, armedRelations);
                    }
                    runScripts.add(entry.script);
                }
            } else {
                throw new DfaInternalException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-23"));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/rml/dfa/impl/repositories/HypoteticRelationsRepository", "getScriptsOrder"));
    }

    private static class Entry {
        RelationSignature signature;
        boolean inMemory;
        Visitor visitor;
        Script script;
        String subgroup;

        private Entry() {
        }
    }
}

