/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.LastSelectedPropertiesFileStore;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeQuickFixDialog
extends DialogWrapper
implements I18nizeQuickFixModel {
    protected static final Logger LOG = Logger.getInstance(I18nizeQuickFixDialog.class);
    private static final Pattern PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private JTextField myValue;
    private JTextField myKey;
    private final TextFieldWithHistory myPropertiesFile;
    protected JPanel myPanel;
    private JCheckBox myUseResourceBundle;
    protected final Project myProject;
    protected final PsiFile myContext;
    protected final Set<Module> myContextModules;
    private JPanel myPropertiesFilePanel;
    protected JPanel myExtensibilityPanel;
    private ComboBox<IProperty> myExistingProperties;
    private JBRadioButton myCreateNewPropertyRb;
    private JPanel myNewPanel;
    private JBRadioButton myUseExistingPropertyRb;
    protected final String myDefaultPropertyValue;
    protected final DialogCustomization myCustomization;

    public I18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, @NotNull String defaultPropertyValue, DialogCustomization customization) {
        if (project == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(0);
        }
        if (context == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(1);
        }
        if (defaultPropertyValue == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(2);
        }
        this(project, context, defaultPropertyValue, customization, false);
    }

    protected I18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, @NotNull String defaultPropertyValue, DialogCustomization customization, boolean ancestorResponsible) {
        if (project == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(3);
        }
        if (context == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(4);
        }
        if (defaultPropertyValue == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(5);
        }
        super(false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myContext = FileContextUtil.getContextFile((PsiElement)context);
        this.myContextModules = ContainerUtil.createMaybeSingletonSet((Object)ModuleUtilCore.findModuleForFile((PsiFile)this.myContext));
        this.myDefaultPropertyValue = this.escapeValue(defaultPropertyValue, context);
        this.myCustomization = customization != null ? customization : new DialogCustomization();
        this.setTitle(this.myCustomization.title != null ? this.myCustomization.title : PropertiesBundle.message("i18nize.dialog.title", new Object[0]));
        this.myPropertiesFile = new TextFieldWithHistory();
        this.myPropertiesFile.setHistorySize(-1);
        this.myPropertiesFile.setEditable(false);
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)this.myPropertiesFile, p -> (String)p);
        this.myPropertiesFilePanel.add((Component)GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.myPropertiesFile, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeFileChooserFactory chooserFactory = TreeFileChooserFactory.getInstance((Project)I18nizeQuickFixDialog.this.myProject);
                PropertiesFile propertiesFile = I18nizeQuickFixDialog.this.getPropertiesFile();
                TreeFileChooser fileChooser = chooserFactory.createFileChooser(PropertiesBundle.message("i18nize.dialog.property.file.chooser.title", new Object[0]), propertiesFile != null ? propertiesFile.getContainingFile() : null, (FileType)PropertiesFileType.INSTANCE, null);
                fileChooser.showDialog();
                PsiFile selectedFile = fileChooser.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                String selectedPath = selectedFile.getVirtualFile().getPath();
                I18nizeQuickFixDialog.this.myPropertiesFile.setText(FileUtil.toSystemDependentName((String)selectedPath));
                I18nizeQuickFixDialog.this.myPropertiesFile.setSelectedItem((Object)FileUtil.toSystemDependentName((String)selectedPath));
            }
        }), "Center");
        this.myPropertiesFile.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                I18nizeQuickFixDialog.this.propertiesFileChanged();
                I18nizeQuickFixDialog.this.somethingChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/references/I18nizeQuickFixDialog$2", "textChanged"));
            }
        });
        this.getKeyTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                I18nizeQuickFixDialog.this.somethingChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/references/I18nizeQuickFixDialog$3", "textChanged"));
            }
        });
        this.myValue.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                I18nizeQuickFixDialog.this.somethingChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/references/I18nizeQuickFixDialog$4", "textChanged"));
            }
        });
        @NonNls String KEY = "I18NIZE_DIALOG_USE_RESOURCE_BUNDLE";
        boolean useBundleByDefault = !PropertiesComponent.getInstance().isValueSet("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE") || PropertiesComponent.getInstance().isTrueValue("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE");
        this.myUseResourceBundle.setSelected(useBundleByDefault);
        this.myUseResourceBundle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE", Boolean.valueOf(I18nizeQuickFixDialog.this.myUseResourceBundle.isSelected()).toString());
            }
        });
        this.myExistingProperties.setRenderer((ListCellRenderer)new ColoredListCellRenderer<IProperty>(){

            protected void customizeCellRenderer(@NotNull JList<? extends IProperty> list, IProperty value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    this.append(Objects.requireNonNull(value.getUnescapedKey()));
                    this.append(" (");
                    this.append(value.getPropertiesFile().getName());
                    this.append(")");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/properties/references/I18nizeQuickFixDialog$6", "customizeCellRenderer"));
            }
        });
        this.myExistingProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                I18nizeQuickFixDialog.this.somethingChanged();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.myCreateNewPropertyRb);
        bg.add((AbstractButton)this.myUseExistingPropertyRb);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                I18nizeQuickFixDialog.this.myExistingProperties.setEnabled(I18nizeQuickFixDialog.this.myUseExistingPropertyRb.isSelected());
                UIUtil.setEnabled((Component)I18nizeQuickFixDialog.this.myNewPanel, (boolean)I18nizeQuickFixDialog.this.myCreateNewPropertyRb.isSelected(), (boolean)true);
                I18nizeQuickFixDialog.this.somethingChanged();
            }
        };
        this.myCreateNewPropertyRb.addActionListener(listener);
        this.myUseExistingPropertyRb.addActionListener(listener);
        this.myExistingProperties.setEnabled(false);
        if (!ancestorResponsible) {
            this.init();
        }
    }

    protected String escapeValue(String value, @NotNull PsiFile context) {
        if (context == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(6);
        }
        return value;
    }

    protected void init() {
        this.populatePropertiesFiles();
        this.propertiesFileChanged();
        this.setKeyValueEditBoxes();
        super.init();
        this.somethingChanged();
    }

    private JTextField getKeyTextField() {
        return this.myKey;
    }

    @NotNull
    protected List<IProperty> getExistingProperties(String value) {
        if (!this.myCustomization.suggestExistingProperties) {
            List<IProperty> list = Collections.emptyList();
            if (list == null) {
                I18nizeQuickFixDialog.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<IProperty> result = new ArrayList<IProperty>();
        List<String> propertyFiles = this.suggestPropertiesFiles();
        if (!propertyFiles.isEmpty()) {
            String selectedPath = FileUtil.toSystemIndependentName((String)this.getPropertiesFilePath());
            propertyFiles.remove(selectedPath);
            propertyFiles.add(0, selectedPath);
            for (String path : propertyFiles) {
                PropertiesFile propertiesFile = this.getPropertyFileByPath(path);
                if (propertiesFile == null) continue;
                for (IProperty property : propertiesFile.getProperties()) {
                    if (!Comparing.strEqual((String)property.getUnescapedValue(), (String)value) || property.getUnescapedKey() == null) continue;
                    result.add(property);
                }
            }
        }
        ArrayList<IProperty> arrayList = result;
        if (arrayList == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    protected String suggestPropertyKey(String value) {
        if (this.myCustomization.suggestedName != null) {
            return this.myCustomization.suggestedName;
        }
        return I18nizeQuickFixDialog.suggestUniquePropertyKey(value, this.defaultSuggestPropertyKey(value), this.getPropertiesFile());
    }

    public static String suggestUniquePropertyKey(String value, String defaultKey, PropertiesFile propertiesFile) {
        if (defaultKey == null) {
            defaultKey = I18nizeQuickFixDialog.generateDefaultPropertyKey(value);
        }
        if (propertiesFile != null) {
            if (propertiesFile.findPropertyByKey(defaultKey) == null) {
                return defaultKey;
            }
            int suffix = 1;
            while (propertiesFile.findPropertyByKey(defaultKey + suffix) != null) {
                ++suffix;
            }
            return defaultKey + suffix;
        }
        return defaultKey;
    }

    @NotNull
    public static String generateDefaultPropertyKey(@NotNull String rawValue) {
        String defaultKey;
        if (rawValue == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(9);
        }
        String value = PATTERN.matcher(Normalizer.normalize(rawValue, Normalizer.Form.NFD)).replaceAll("");
        StringBuilder result = new StringBuilder();
        boolean insertDotBeforeNextWord = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (insertDotBeforeNextWord) {
                    result.append('.');
                }
                result.append(Character.toLowerCase(c));
                insertDotBeforeNextWord = false;
                continue;
            }
            if (c == '&') {
                if (insertDotBeforeNextWord || i == value.length() - 1 || Character.isLetter(value.charAt(i + 1))) continue;
                insertDotBeforeNextWord = true;
                continue;
            }
            if (result.isEmpty()) continue;
            insertDotBeforeNextWord = true;
        }
        String string = defaultKey = result.toString();
        if (string == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected String defaultSuggestPropertyKey(String value) {
        return null;
    }

    private void propertiesFileChanged() {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        boolean hasResourceBundle = propertiesFile != null && propertiesFile.getResourceBundle().getPropertiesFiles().size() > 1;
        this.myUseResourceBundle.setEnabled(hasResourceBundle);
    }

    private void setKeyValueEditBoxes() {
        this.getKeyTextField().setText(this.suggestPropertyKey(this.myDefaultPropertyValue));
        @NotNull List<IProperty> existingValueKeys = this.getExistingProperties(this.myDefaultPropertyValue);
        if (!existingValueKeys.isEmpty()) {
            for (IProperty key : existingValueKeys) {
                this.myExistingProperties.addItem((Object)key);
            }
            this.myExistingProperties.setSelectedItem((Object)existingValueKeys.get(0));
        }
        this.myUseExistingPropertyRb.setEnabled(!existingValueKeys.isEmpty());
        this.myValue.setText(I18nizeQuickFixDialog.escapeLineBreaks(this.myDefaultPropertyValue));
    }

    private static String escapeLineBreaks(String value) {
        return StringUtil.escapeLineBreak((String)StringUtil.escapeBackSlashes((String)value));
    }

    private static String unescapeLineBreaks(String value) {
        StringBuilder buffer = new StringBuilder(value.length());
        int length = value.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && i != last) {
                if ((ch = value.charAt(++i)) == 'n') {
                    buffer.append('\n');
                    continue;
                }
                if (ch == 'r') {
                    buffer.append('\n');
                    continue;
                }
                if (ch == '\\') {
                    buffer.append('\\');
                    continue;
                }
                buffer.append('\\');
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    protected void somethingChanged() {
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.getKey()));
    }

    private void populatePropertiesFiles() {
        String lastPath;
        List<@NlsSafe String> paths = this.suggestPropertiesFiles();
        String lastUrl = this.suggestSelectedFileUrl();
        String string = lastPath = lastUrl == null ? null : FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)lastUrl));
        if (lastPath != null) {
            paths.remove(lastPath);
            paths.add(0, lastPath);
        }
        this.myPropertiesFile.setHistory(paths);
        if (lastPath != null) {
            this.myPropertiesFile.setSelectedItem((Object)lastPath);
            this.myPropertiesFile.setText(lastPath);
        }
        if (this.myPropertiesFile.getSelectedIndex() == -1 && !paths.isEmpty()) {
            String selectedItem = paths.get(0);
            this.myPropertiesFile.setSelectedItem((Object)selectedItem);
            this.myPropertiesFile.setText(selectedItem);
        }
    }

    private String suggestSelectedFileUrl() {
        return LastSelectedPropertiesFileStore.getInstance().suggestLastSelectedPropertiesFileUrl(this.myContext);
    }

    private void saveLastSelectedFile() {
        PropertiesFile propertiesFile;
        if (this.myCreateNewPropertyRb.isSelected() && (propertiesFile = this.getPropertiesFile()) != null) {
            LastSelectedPropertiesFileStore.getInstance().saveLastSelectedPropertiesFile(this.myContext, propertiesFile);
        }
    }

    protected List<String> suggestPropertiesFiles() {
        if (this.myCustomization.propertiesFiles != null && !this.myCustomization.propertiesFiles.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (PropertiesFile propertiesFile : this.myCustomization.propertiesFiles) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                if (virtualFile == null) continue;
                list.add(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
            }
            return list;
        }
        return this.defaultSuggestPropertiesFiles();
    }

    protected List<String> defaultSuggestPropertiesFiles() {
        return I18nUtil.defaultSuggestPropertiesFiles(this.myProject, this.myContextModules);
    }

    @Nullable
    protected PropertiesFile getPropertiesFile() {
        String path = this.getPropertiesFilePath();
        if (path == null) {
            return null;
        }
        return this.getPropertyFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private String getPropertiesFilePath() {
        return (String)this.myPropertiesFile.getSelectedItem();
    }

    @Nullable
    private PropertiesFile getPropertyFileByPath(String path) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile != null ? PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) : null;
    }

    protected boolean useExistingProperty() {
        IProperty item;
        return this.myExistingProperties.isEnabled() && (item = (IProperty)this.myExistingProperties.getItem()) != null;
    }

    private boolean createPropertiesFileIfNotExists() {
        if (this.getPropertiesFile() != null) {
            return true;
        }
        final String path = this.getPropertiesFilePath();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            String message = PropertiesBundle.message("i18nize.empty.file.path", path);
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)PropertiesBundle.message("i18nize.error.creating.properties.file", new Object[0]));
            this.myPropertiesFile.requestFocusInWindow();
            return false;
        }
        final FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(FileUtil.toSystemIndependentName((String)path));
        if (fileType != PropertiesFileType.INSTANCE && fileType != XmlFileType.INSTANCE) {
            String message = PropertiesBundle.message("i18nize.cant.create.properties.file.because.its.name.is.associated", this.getPropertiesFilePath(), fileType.getDescription());
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)PropertiesBundle.message("i18nize.error.creating.properties.file", new Object[0]));
            this.myPropertiesFile.requestFocusInWindow();
            return false;
        }
        try {
            final File file = new File(path).getCanonicalFile();
            FileUtil.createParentDirs((File)file);
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<PsiFile, Exception>(){

                public PsiFile compute() throws Exception {
                    VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file.getParentFile());
                    PsiManager psiManager = PsiManager.getInstance((Project)I18nizeQuickFixDialog.this.myProject);
                    if (dir == null) {
                        throw new IOException("Error creating directory structure for file '" + path + "'");
                    }
                    if (fileType == PropertiesFileType.INSTANCE) {
                        return psiManager.findFile(dir.createChildData((Object)this, file.getName()));
                    }
                    FileTemplate template = FileTemplateManager.getInstance((Project)I18nizeQuickFixDialog.this.myProject).getInternalTemplate("XML Properties File.xml");
                    return (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)file.getName(), null, (PsiDirectory)psiManager.findDirectory(dir));
                }
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getLocalizedMessage(), (String)PropertiesBundle.message("i18nize.error.creating.properties.file", new Object[0]));
            return false;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCustomization.focusValueComponent ? this.myValue : this.myKey;
    }

    public void dispose() {
        super.dispose();
    }

    protected void doOKAction() {
        HashMap existingProperties;
        if (!this.createPropertiesFileIfNotExists()) {
            return;
        }
        this.saveLastSelectedFile();
        Collection<PropertiesFile> propertiesFiles = this.getAllPropertiesFiles();
        try {
            ThrowableComputable existingPropertiesGenerator = () -> this.findExistingProperties(propertiesFiles);
            existingProperties = (HashMap)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (HashMap)ReadAction.compute((ThrowableComputable)existingPropertiesGenerator), PropertiesBundle.message("i18nize.dialog.searching.for.already.existing.properties", new Object[0]), true, this.myProject);
        }
        catch (ProcessCanceledException e) {
            super.doOKAction();
            return;
        }
        for (PropertiesFile propertiesFile : propertiesFiles) {
            IProperty existingProperty = (IProperty)existingProperties.get(propertiesFile);
            String propValue = this.getValue();
            if (existingProperty == null || Comparing.strEqual((String)existingProperty.getUnescapedValue(), (String)propValue)) continue;
            String messageText = PropertiesBundle.message("i18nize.dialog.error.property.already.defined.message", this.getKey(), propertiesFile.getName());
            boolean code = MessageDialogBuilder.yesNo((String)PropertiesBundle.message("i18nize.dialog.error.property.already.defined.title", new Object[0]), (String)messageText).ask(this.myProject);
            if (code) continue;
            return;
        }
        super.doOKAction();
    }

    @RequiresBackgroundThread
    private HashMap<PropertiesFile, IProperty> findExistingProperties(Collection<PropertiesFile> files) {
        HashMap<PropertiesFile, IProperty> existingProperties = new HashMap<PropertiesFile, IProperty>();
        for (PropertiesFile propertiesFile : files) {
            IProperty existingProperty = propertiesFile.findPropertyByKey(this.getKey());
            existingProperties.put(propertiesFile, existingProperty);
        }
        return existingProperties;
    }

    protected String getHelpId() {
        return "editing.propertyFile.i18nInspection";
    }

    @Override
    public String getValue() {
        if (this.useExistingProperty()) {
            return ((IProperty)this.myExistingProperties.getItem()).getUnescapedValue();
        }
        return I18nizeQuickFixDialog.unescapeLineBreaks(this.myValue.getText());
    }

    @Override
    public String getKey() {
        if (this.useExistingProperty()) {
            return ((IProperty)this.myExistingProperties.getItem()).getUnescapedKey();
        }
        return this.getKeyTextField().getText();
    }

    @Override
    public boolean hasValidData() {
        assert (!ApplicationManager.getApplication().isUnitTestMode());
        this.show();
        return this.getExitCode() == 0;
    }

    private boolean isUseResourceBundle() {
        return this.myUseResourceBundle.isEnabled() && this.myUseResourceBundle.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.i18n.I18nizeQuickFixDialog";
    }

    @Override
    public Collection<PropertiesFile> getAllPropertiesFiles() {
        if (this.useExistingProperty()) {
            return Collections.singleton(((IProperty)this.myExistingProperties.getItem()).getPropertiesFile());
        }
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile == null) {
            return Collections.emptySet();
        }
        Collection<PropertiesFile> propertiesFiles = this.isUseResourceBundle() ? propertiesFile.getResourceBundle().getPropertiesFiles() : Collections.singleton(propertiesFile);
        return propertiesFiles;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JTextField jTextField2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setMinimumSize(new Dimension(-1, -1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(5, 5, 5, 5), 4, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("i18n.quickfix.property.panel.title"), (int)0, (int)0, null, null));
        this.myNewPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 4, 2, 0, 3, 3, 3, null, null, null, 2));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("i18n.quickfix.property.panel.property.key.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("i18n.quickfix.property.panel.property.value.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValue = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("i18n.quickfix.property.panel.properties.file.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertiesFilePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myUseResourceBundle = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("i18n.quickfix.property.panel.update.all.files.in.bundle.checkbox"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKey = jTextField = new JTextField();
        jTextField.setEditable(true);
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, new Dimension(100, -1), null, null));
        this.myCreateNewPropertyRb = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("radio.button.create.new.property"));
        jPanel5.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseExistingPropertyRb = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PropertiesBundle", I18nizeQuickFixDialog.class).getString("radio.button.use.existing.property"));
        jPanel5.add((Component)jBRadioButton, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExistingProperties = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(6, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myExtensibilityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPropertyValue";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/I18nizeQuickFixDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/I18nizeQuickFixDialog";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProperties";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultPropertyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escapeValue";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultPropertyKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static class DialogCustomization {
        @NlsContexts.DialogTitle
        private final String title;
        private final boolean suggestExistingProperties;
        private final boolean focusValueComponent;
        private final List<PropertiesFile> propertiesFiles;
        private final String suggestedName;

        public DialogCustomization(@NlsContexts.DialogTitle String title, boolean suggestExistingProperties, boolean focusValueComponent, List<PropertiesFile> propertiesFiles, String suggestedName) {
            this.title = title;
            this.suggestExistingProperties = suggestExistingProperties;
            this.focusValueComponent = focusValueComponent;
            this.propertiesFiles = propertiesFiles;
            this.suggestedName = suggestedName;
        }

        public DialogCustomization() {
            this(null, true, false, null, null);
        }

        public String getSuggestedName() {
            return this.suggestedName;
        }
    }
}

