/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyFileUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ConfigureClangTidyOptionsAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CreateClangTidyFileOptionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.EditClangTidyOptionsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClangTidyStatusBarWidget
extends EditorBasedStatusBarPopup {
    public static final String ID = "ClangTidyStatusBarWidget";

    ClangTidyStatusBarWidget(@NotNull Project project) {
        if (project == null) {
            ClangTidyStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project, false);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        Project project = this.getProject();
        if (project.isDisposed()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                ClangTidyStatusBarWidget.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, project);
        ClangTidyFilesState state = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        if (state == null || file == null || inspection == null || !inspection.isPreferClangTidyFilesOverIDESettings()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                ClangTidyStatusBarWidget.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        if (!OCFileTypeHelpers.isHeaderFile((String)file.getName()) && !OCFileTypeHelpers.isSourceFile((String)file.getName())) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                ClangTidyStatusBarWidget.$$$reportNull$$$0(3);
            }
            return widgetState;
        }
        return new EditorBasedStatusBarPopup.WidgetState("", ClangdBundle.message("clang.tidy.status.bar.widget.title", new Object[0]), true);
    }

    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        VirtualFile selectedFile;
        if (context == null) {
            ClangTidyStatusBarWidget.$$$reportNull$$$0(4);
        }
        if ((selectedFile = this.getSelectedFile()) == null) {
            return null;
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        File currentFile = new File(selectedFile.getPath());
        File nearestClangTidyFile = ClangTidyFileUtils.findNearestClangTidyFile(currentFile, this.getProject());
        actionGroup.add((AnAction)new EditClangTidyOptionsAction(currentFile, this.getProject(), nearestClangTidyFile));
        actionGroup.add((AnAction)new CreateClangTidyFileOptionAction(currentFile, this.getProject(), nearestClangTidyFile));
        actionGroup.add((AnAction)new ConfigureClangTidyOptionsAction(this.getProject()));
        return new PopupFactoryImpl.ActionGroupPopup(null, ClangdBundle.message("language.cpp.clang-tidy.configurable.name", new Object[0]), (ActionGroup)actionGroup, context, "popup", new PresentationFactory(), ActionPopupOptions.create((boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)15, (boolean)false, null), null);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            ClangTidyStatusBarWidget.$$$reportNull$$$0(5);
        }
        return new ClangTidyStatusBarWidget(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyStatusBarWidget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyStatusBarWidget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

