/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ClangTidyIntentionActionBase
implements IntentionAction {
    @NotNull
    @IntentionName
    private final String myMessage;
    @NotNull
    @IntentionFamilyName
    private final String myCheckName;
    @NotNull
    private final List<Replacement> myReplacements;

    public ClangTidyIntentionActionBase(@NotNull @IntentionName String message, @NotNull @IntentionFamilyName String checkName, @NotNull List<ClangTidyReplacement> replacements) {
        if (message == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(0);
        }
        if (checkName == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(1);
        }
        if (replacements == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(2);
        }
        this.myMessage = message;
        this.myCheckName = checkName;
        this.myReplacements = ClangTidyIntentionActionBase.createReplacements(replacements);
    }

    private ClangTidyIntentionActionBase(@NotNull @IntentionName String message, @NotNull @IntentionFamilyName String checkName, @NotNull List<Replacement> replacements, @NotNull PsiFile targetFile) {
        if (message == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(3);
        }
        if (checkName == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(4);
        }
        if (replacements == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(6);
        }
        this.myMessage = message;
        this.myCheckName = checkName;
        this.myReplacements = ClangTidyIntentionActionBase.copyReplacementsForTargetFile(replacements, targetFile);
    }

    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myCheckName;
        if (string == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(9);
        }
        return !this.myReplacements.isEmpty() && ContainerUtil.and(this.myReplacements, replacement -> replacement != null && replacement.isValid());
    }

    public void invoke(@NotNull Project project, Editor intentionStarterEditor, PsiFile intentionStarterFile) throws IncorrectOperationException {
        if (project == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(10);
        }
        if (!this.isAvailable(project, intentionStarterEditor, intentionStarterFile)) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Set<Document> documentsWithReplacements = this.myReplacements.stream().map(replacement -> replacement.myRangeMarker.getDocument()).collect(Collectors.toSet());
        this.processPostponedFormatIfNeed(documentsWithReplacements, project);
        for (Replacement replacement2 : this.myReplacements) {
            RangeMarker rangeMarker = replacement2.myRangeMarker;
            rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)replacement2.myReplacementText);
        }
        documentsWithReplacements.forEach(replaceHolderDocument -> documentManager.commitDocument(replaceHolderDocument));
    }

    protected abstract void processPostponedFormatIfNeed(@NotNull Collection<Document> var1, @NotNull Project var2);

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static @Unmodifiable List<Replacement> createReplacements(@NotNull List<ClangTidyReplacement> replacements) {
        if (replacements == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.map(replacements, replacement -> {
            VirtualFile filePath = VfsUtil.findFile((Path)Paths.get(replacement.getFilePath(), new String[0]), (boolean)true);
            if (filePath == null) {
                return null;
            }
            Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(filePath));
            if (document == null) {
                return null;
            }
            int beginOffset = replacement.getBeginOffset();
            int endOffset = replacement.getEndOffset();
            if (!DocumentUtil.isValidOffset((int)beginOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document)) {
                return null;
            }
            RangeMarker rangeMarker = document.createRangeMarker(beginOffset, endOffset);
            String oldText = document.getText(new TextRange(beginOffset, endOffset));
            return new Replacement(rangeMarker, oldText, replacement.getReplacementText());
        });
        if (list == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(13);
        }
        return new ClangTidyIntentionActionBase(this.myMessage, this.myCheckName, this.myReplacements, target){

            @Override
            protected void processPostponedFormatIfNeed(@NotNull Collection<Document> documents, @NotNull Project project) {
                if (documents == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "documents";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionActionBase$1";
                objectArray[2] = "processPostponedFormatIfNeed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static List<Replacement> copyReplacementsForTargetFile(@NotNull List<Replacement> replacements, @NotNull PsiFile target) {
        if (replacements == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(14);
        }
        if (target == null) {
            ClangTidyIntentionActionBase.$$$reportNull$$$0(15);
        }
        Document targetDocument = target.getViewProvider().getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)target.getProject());
        ArrayList<Replacement> cloneReplacements = new ArrayList<Replacement>();
        for (Replacement replacement : replacements) {
            RangeMarker oldRangeMarker = replacement.myRangeMarker;
            PsiFile oldFile = documentManager.getPsiFile(oldRangeMarker.getDocument());
            if (oldFile != target.getOriginalFile()) continue;
            RangeMarker newRangeMarker = targetDocument.createRangeMarker(oldRangeMarker.getStartOffset(), oldRangeMarker.getEndOffset());
            cloneReplacements.add(new Replacement(newRangeMarker, replacement.myOldText, replacement.myReplacementText));
        }
        return cloneReplacements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionActionBase";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionActionBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createReplacements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyReplacementsForTargetFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 12 -> new IllegalStateException(string);
        };
    }

    static class Replacement {
        @NotNull
        private final RangeMarker myRangeMarker;
        @NotNull
        private final String myOldText;
        @NotNull
        private final String myReplacementText;

        Replacement(@NotNull RangeMarker rangeMarker, @NotNull String oldText, @NotNull String replacementText) {
            if (rangeMarker == null) {
                Replacement.$$$reportNull$$$0(0);
            }
            if (oldText == null) {
                Replacement.$$$reportNull$$$0(1);
            }
            if (replacementText == null) {
                Replacement.$$$reportNull$$$0(2);
            }
            this.myRangeMarker = rangeMarker;
            this.myOldText = oldText;
            this.myReplacementText = replacementText;
        }

        public boolean isValid() {
            if (!this.myRangeMarker.isValid()) {
                return false;
            }
            TextRange textRange = this.myRangeMarker.getTextRange();
            String actualText = this.myRangeMarker.getDocument().getText(textRange);
            return actualText.equals(this.myOldText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacementText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionActionBase$Replacement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

