/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/listeners/ClangdDocumentsListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "provider", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "doNotify", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDocumentSaved", "", "intellij.c.clangd"})
public final class ClangdDocumentsListener
implements DocumentListener {
    @NotNull
    private final ClangLanguageServiceProvider provider;

    public ClangdDocumentsListener(@NotNull ClangLanguageServiceProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.provider = provider2;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        block2: {
            ClangdIndexerService indexer;
            ClangLanguageService service;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            boolean isDocumentSaved = !FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument());
            ClangLanguageService clangLanguageService = service = this.provider.getIfStarted();
            if (clangLanguageService != null) {
                this.doNotify(clangLanguageService, file, event, isDocumentSaved);
            }
            ClangdIndexerService clangdIndexerService = indexer = this.provider.getIfStartedIndexer();
            if (clangdIndexerService == null) break block2;
            this.doNotify(clangdIndexerService, file, event, isDocumentSaved);
        }
    }

    private final void doNotify(ClangLanguageService $this$doNotify, VirtualFile file, DocumentEvent event, boolean isDocumentSaved) {
        $this$doNotify.notifyDocumentChanged(file, event);
        if (isDocumentSaved) {
            $this$doNotify.notifyDocumentSaved(file);
        }
    }
}

