/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J$\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/listeners/ClangdBulkFilesListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "provider", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "handleMove", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "indexer", "handlePropertyChange", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "handleContentChange", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "intellij.c.clangd"})
public final class ClangdBulkFilesListener
implements BulkFileListener {
    @NotNull
    private final ClangLanguageServiceProvider provider;

    public ClangdBulkFilesListener(@NotNull ClangLanguageServiceProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.provider = provider2;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ClangLanguageService service = this.provider.getIfStarted();
        ClangLanguageService indexer = this.provider.getIfStarted();
        if (service == null && indexer == null) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileMoveEvent) {
                this.handleMove((VFileMoveEvent)vFileEvent, service, indexer);
                continue;
            }
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                this.handlePropertyChange((VFilePropertyChangeEvent)vFileEvent, service, indexer);
                continue;
            }
            if (!(vFileEvent2 instanceof VFileContentChangeEvent)) continue;
            this.handleContentChange((VFileContentChangeEvent)vFileEvent, service, indexer);
        }
    }

    private final void handleMove(VFileMoveEvent event, ClangLanguageService service, ClangLanguageService indexer) {
        block1: {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            String oldUrl = event.getOldParent().getUrl() + "/" + file.getName();
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String newUrl = string;
            ClangLanguageService clangLanguageService = service;
            if (clangLanguageService != null) {
                clangLanguageService.notifyDocumentMoved(file, oldUrl, newUrl);
            }
            ClangLanguageService clangLanguageService2 = indexer;
            if (clangLanguageService2 == null) break block1;
            clangLanguageService2.notifyDocumentMoved(file, oldUrl, newUrl);
        }
    }

    private final void handlePropertyChange(VFilePropertyChangeEvent event, ClangLanguageService service, ClangLanguageService indexer) {
        block4: {
            if (!Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
                return;
            }
            if (Objects.equals(event.getNewValue(), event.getOldValue())) {
                return;
            }
            Object object = event.getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String newName = (String)object;
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String newUrl = string;
            boolean bl = StringsKt.endsWith$default((String)newUrl, (String)newName, (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Object object2 = event.getOldValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String oldName = (String)object2;
            String string3 = newUrl.substring(0, newUrl.length() - newName.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String oldUrl = string3 + oldName;
            ClangLanguageService clangLanguageService = service;
            if (clangLanguageService != null) {
                clangLanguageService.notifyDocumentMoved(file, oldUrl, newUrl);
            }
            ClangLanguageService clangLanguageService2 = indexer;
            if (clangLanguageService2 == null) break block4;
            clangLanguageService2.notifyDocumentMoved(file, oldUrl, newUrl);
        }
    }

    private final void handleContentChange(VFileContentChangeEvent event, ClangLanguageService service, ClangLanguageService indexer) {
        block2: {
            if (!event.isFromSave()) {
                return;
            }
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            ClangLanguageService clangLanguageService = service;
            if (clangLanguageService != null) {
                clangLanguageService.notifyDocumentSaved(file);
            }
            ClangLanguageService clangLanguageService2 = indexer;
            if (clangLanguageService2 == null) break block2;
            clangLanguageService2.notifyDocumentSaved(file);
        }
    }
}

