/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.google.gson.Gson;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.util.ApplicationKt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.JSONCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.WslContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangInternalCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdStartupActivityKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdStartupScopeHolder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdStartupUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdActivationListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdBulkFilesListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdDocumentsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdEditorFactoryListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdTrustedListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners.ClangdWorkspaceListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyStatusBarWidgetFactory;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationUtil;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangdStartupUtil;", "", "<init>", "()V", "notifySetCDB", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "projectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "runStartupActivity", "project", "Lcom/intellij/openapi/project/Project;", "installApplicationListeners", "coroutineScope", "provider", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;", "installProjectListeners", "initLanguageServices", "openAtService", "stopLanguageServices", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdStartupActivity.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangdStartupUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,278:1\n31#2,2:279\n31#2,2:281\n*S KotlinDebug\n*F\n+ 1 ClangdStartupActivity.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangdStartupUtil\n*L\n88#1:279,2\n172#1:281,2\n*E\n"})
public final class ClangdStartupUtil {
    @NotNull
    public static final ClangdStartupUtil INSTANCE = new ClangdStartupUtil();

    private ClangdStartupUtil() {
    }

    public final void notifySetCDB(@NotNull CoroutineScope cs, @Nullable ClangLanguageService service, @NotNull Set<? extends VirtualFile> projectRoots) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        if (service == null) {
            return;
        }
        Job job = BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(service, projectRoots, null){
            int label;
            final /* synthetic */ ClangLanguageService $service;
            final /* synthetic */ Set<VirtualFile> $projectRoots;
            {
                this.$service = $service;
                this.$projectRoots = $projectRoots;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$service.notifySetCDB((Collection<VirtualFile>)this.$projectRoots);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Disposable disposable = service.getAssociatedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getAssociatedDisposable(...)");
        CoroutineScopeKt.cancelOnDispose$default((Job)job, (Disposable)disposable, (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final void runStartupActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClangdStartupActivityKt.access$getLogger$p().trace("runStartupActivity called");
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ClangdStartupScopeHolder> serviceClass$iv = ClangdStartupScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClangdStartupScopeHolder coroutineScopeHolder = (ClangdStartupScopeHolder)object;
        BuildersKt.launch$default((CoroutineScope)coroutineScopeHolder.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, coroutineScopeHolder, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangdStartupScopeHolder $coroutineScopeHolder;
            {
                this.$project = $project;
                this.$coroutineScopeHolder = $coroutineScopeHolder;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CoroutinesKt.readAction(() -> runStartupActivity.1.invokeSuspend$lambda$0(this.$project, this.$coroutineScopeHolder), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Project $project, ClangdStartupScopeHolder $coroutineScopeHolder) {
                ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider($project);
                if (provider2 == null) {
                    ClangdStartupActivityKt.access$getLogger$p().trace("runStartupActivity: no clang language service provider, exiting");
                    return Unit.INSTANCE;
                }
                ClangdStartupActivityKt.access$getLogger$p().trace("runStartupActivity: initializing clang language service provider");
                ClangdStartupUtil.access$installApplicationListeners(ClangdStartupUtil.INSTANCE, $coroutineScopeHolder.getCoroutineScope(), provider2);
                ClangdStartupUtil.access$installProjectListeners(ClangdStartupUtil.INSTANCE, $project, provider2);
                String crashesDir = System.getProperty("clangd.report.crashes.to.directory");
                if (crashesDir != null) {
                    try {
                        Path path = Paths.get(crashesDir, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        Path crashesDirPath = path;
                        PathKt.createDirectories((Path)crashesDirPath);
                        $project.putUserData(ClangCrashHandler.CRASH_REPORTER_KEY, (Object)new ClangInternalCrashReporter(crashesDirPath));
                    }
                    catch (IOException ex) {
                        ClangdStartupActivityKt.access$getLogger$p().warn((Throwable)ex);
                    }
                }
                ClangdStartupUtil.INSTANCE.initLanguageServices(provider2, $project);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private final void installApplicationListeners(CoroutineScope coroutineScope, ClangLanguageServiceProvider provider2) {
        ApplicationKt.getApplication().getMessageBus().connect(coroutineScope).subscribe(TrustedProjectsListener.TOPIC, (Object)new ClangdTrustedListener(provider2));
    }

    private final void installProjectListeners(Project project, ClangLanguageServiceProvider provider2) {
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProfileChangeAdapter(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void profileChanged(InspectionProfile profile) {
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                StatusBarWidgetsManager manager = (StatusBarWidgetsManager)object;
                manager.updateWidget(ClangTidyStatusBarWidgetFactory.class);
            }
        });
        Topic topic2 = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new ClangdWorkspaceListener(project, provider2));
        Topic<ClangdSettingsListener> topic3 = ClangdSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        connection.subscribe(topic3, (Object)new ClangdActivationListener(project, provider2));
        Topic topic4 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic4, (String)"VFS_CHANGES");
        connection.subscribe(topic4, (Object)new ClangdBulkFilesListener(provider2));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new ClangdDocumentsListener(provider2), (Disposable)provider2);
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new ClangdEditorFactoryListener(provider2), (Disposable)provider2);
        ClangToolsWslService.Companion.getInstance(project).attachListener((Function1<? super WslContext, Unit>)((Function1)arg_0 -> ClangdStartupUtil.installProjectListeners$lambda$1(provider2, project, arg_0)));
    }

    public final void initLanguageServices(@NotNull ClangLanguageServiceProvider provider2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClangLanguageService service = provider2.getOrStart();
        ClangdIndexerService indexer = provider2.getOrStartIndexer();
        ClangdIndexerService statelessIndexer = provider2.getOrStartStatelessIndexer();
        if (service == null && indexer == null && statelessIndexer == null) {
            ClangdStartupActivityKt.access$getLogger$p().warn("Neither service, nor indexerService are found");
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<ClangdStartupScopeHolder> serviceClass$iv = ClangdStartupScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClangdStartupScopeHolder coroutineScopeHolder = (ClangdStartupScopeHolder)object;
        BuildersKt.launch$default((CoroutineScope)coroutineScopeHolder.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, provider2, service, indexer, coroutineScopeHolder, statelessIndexer, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangLanguageServiceProvider $provider;
            final /* synthetic */ ClangLanguageService $service;
            final /* synthetic */ ClangdIndexerService $indexer;
            final /* synthetic */ ClangdStartupScopeHolder $coroutineScopeHolder;
            final /* synthetic */ ClangdIndexerService $statelessIndexer;
            {
                this.$project = $project;
                this.$provider = $provider;
                this.$service = $service;
                this.$indexer = $indexer;
                this.$coroutineScopeHolder = $coroutineScopeHolder;
                this.$statelessIndexer = $statelessIndexer;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService ), ()Lkotlin/Unit;)((Project)this.$project, (ClangLanguageService)this.$service, (ClangdIndexerService)this.$indexer), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        OCWorkspaceInitializationUtil.runWhenOrIfOCWorkspaceIsLoaded((Project)this.$project, (Disposable)this.$provider, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdStartupScopeHolder com.intellij.openapi.project.Project com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService ), ()Lkotlin/Unit;)((ClangdStartupScopeHolder)this.$coroutineScopeHolder, (Project)this.$project, (ClangLanguageService)this.$service, (ClangdIndexerService)this.$indexer, (ClangdIndexerService)this.$statelessIndexer));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Project $project, ClangLanguageService $service, ClangdIndexerService $indexer) {
                ClangdStartupUtil.access$openAtService(ClangdStartupUtil.INSTANCE, $project, $service);
                ClangdStartupUtil.access$openAtService(ClangdStartupUtil.INSTANCE, $project, $indexer);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(ClangdStartupScopeHolder $coroutineScopeHolder, Project $project, ClangLanguageService $service, ClangdIndexerService $indexer, ClangdIndexerService $statelessIndexer) {
                BuildersKt.launch$default((CoroutineScope)$coroutineScopeHolder.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, $service, $indexer, $statelessIndexer, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ClangLanguageService $service;
                    final /* synthetic */ ClangdIndexerService $indexer;
                    final /* synthetic */ ClangdIndexerService $statelessIndexer;
                    {
                        this.$project = $project;
                        this.$service = $service;
                        this.$indexer = $indexer;
                        this.$statelessIndexer = $statelessIndexer;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                Set<VirtualFile> projectRoots = ClangLanguageServiceUtils.getProjectRoots(this.$project);
                                if (projectRoots.isEmpty()) {
                                    return Unit.INSTANCE;
                                }
                                ClangLanguageService clangLanguageService = this.$service;
                                boolean bl = clangLanguageService != null ? clangLanguageService.isActive() : false;
                                if (bl && (ClangdBridge.isClangdOnlyMode() || Registry.Companion.is("cidr.disable.symbols", false))) {
                                    Intrinsics.checkNotNull(projectRoots);
                                    ClangdStartupUtil.INSTANCE.notifySetCDB($this$launch, this.$service, projectRoots);
                                }
                                ClangdIndexerService clangdIndexerService = this.$indexer;
                                boolean bl2 = clangdIndexerService != null ? clangdIndexerService.isActive() : false;
                                if (bl2) {
                                    ClangLanguageService clangLanguageService2 = this.$indexer;
                                    Intrinsics.checkNotNull(projectRoots);
                                    ClangdStartupUtil.INSTANCE.notifySetCDB($this$launch, clangLanguageService2, projectRoots);
                                }
                                ClangdIndexerService clangdIndexerService2 = this.$statelessIndexer;
                                boolean bl3 = clangdIndexerService2 != null ? clangdIndexerService2.isActive() : false;
                                if (bl3) {
                                    ClangLanguageService clangLanguageService3 = this.$statelessIndexer;
                                    Intrinsics.checkNotNull(projectRoots);
                                    ClangdStartupUtil.INSTANCE.notifySetCDB($this$launch, clangLanguageService3, projectRoots);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                String basePath = $project.getBasePath();
                if (ApplicationKt.getApplication().isInternal() && basePath != null) {
                    String[] stringArray = new String[]{"clion_compile_commands.json"};
                    Path path = Paths.get(basePath, Arrays.copyOf(stringArray, stringArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path clangdCmdPath = path;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(clangdCmdPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        try {
                            Object object = new Gson().fromJson(FileUtilRt.loadFile((File)clangdCmdPath.toFile()), JSONCommand.LIST_TYPE_TOKEN.getType());
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                            List commands = (List)object;
                            for (JSONCommand cmd : commands) {
                                List<String> asArgs;
                                Intrinsics.checkNotNullExpressionValue(cmd.getCommandAsArgs(), (String)"getCommandAsArgs(...)");
                                ClangUtils.putCustomCommand($project, cmd.file, asArgs);
                                ClangUtils.putCustomCommand($project, "UseThisCommandToParseHeaders", asArgs);
                            }
                        }
                        catch (IOException ex) {
                            ClangdStartupActivityKt.access$getLogger$p().error((Throwable)ex);
                        }
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        if (service == null || indexer == null) {
            return;
        }
        String string = service.getClangdModulesPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClangdModulesPath(...)");
        String $i$f$service22 = string;
        Object object2 = new String[]{"compilation_graph.txt"};
        Path path = Paths.get($i$f$service22, Arrays.copyOf(object2, ((String[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path includeGraphFile = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(includeGraphFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            service.notifyLoadGraph(((Object)includeGraphFile).toString());
        }
        object2 = new String[]{"symbols"};
        Path symbolsDir = Paths.get(service.getClangdModulesPath(), (String[])object2);
        object2 = symbolsDir;
        Intrinsics.checkNotNull((Object)object2);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists((Path)object2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            List list = CollectionsKt.emptyList();
            object2 = symbolsDir;
            Intrinsics.checkNotNull((Object)object2);
            service.notifyLoadIndex(list, object2.toString());
        }
        MessageBusConnection messageBusConnection = indexer.getMessageBus().connect();
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangServerListener(service){
            final /* synthetic */ ClangLanguageService $service;
            {
                this.$service = $service;
            }

            public void onIndexingFinished(List<String> deletedSymbolsPaths, String symbolsDirPath) {
                Intrinsics.checkNotNullParameter(deletedSymbolsPaths, (String)"deletedSymbolsPaths");
                Intrinsics.checkNotNullParameter((Object)symbolsDirPath, (String)"symbolsDirPath");
                this.$service.notifyLoadIndex(deletedSymbolsPaths, symbolsDirPath);
            }

            public void onGraphFinished(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.$service.notifyLoadGraph(path);
            }

            public void onIndexPartFinished(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.$service.notifyIndexPartFinished(path);
            }
        });
    }

    private final void openAtService(Project project, ClangLanguageService service) {
        if (project.isDisposed()) {
            return;
        }
        ClangLanguageService clangLanguageService = service;
        if (!(clangLanguageService != null ? clangLanguageService.isActive() : false)) {
            return;
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)project) || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
        }
    }

    public final void stopLanguageServices(@NotNull ClangLanguageServiceProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        provider2.stop();
        provider2.stopIndexer();
        provider2.stopStatelessIndexer();
    }

    private static final void installProjectListeners$lambda$1$lambda$0() {
        ClangdSettings.rehighlight();
    }

    private static final Unit installProjectListeners$lambda$1(ClangLanguageServiceProvider $provider, Project $project, WslContext newCtx) {
        ClangLanguageService langService = $provider.getIfStarted();
        if (langService != null) {
            String newWslId;
            WslContext wslContext = newCtx;
            String string = wslContext != null ? wslContext.getId() : null;
            if (string == null) {
                string = newWslId = "";
            }
            if (!Intrinsics.areEqual((Object)langService.getWslMsId(), (Object)newWslId)) {
                INSTANCE.stopLanguageServices($provider);
                INSTANCE.initLanguageServices($provider, $project);
            }
        }
        ApplicationKt.getApplication().invokeLater(ClangdStartupUtil::installProjectListeners$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$installApplicationListeners(ClangdStartupUtil $this, CoroutineScope coroutineScope, ClangLanguageServiceProvider provider2) {
        $this.installApplicationListeners(coroutineScope, provider2);
    }

    public static final /* synthetic */ void access$installProjectListeners(ClangdStartupUtil $this, Project project, ClangLanguageServiceProvider provider2) {
        $this.installProjectListeners(project, provider2);
    }

    public static final /* synthetic */ void access$openAtService(ClangdStartupUtil $this, Project project, ClangLanguageService service) {
        $this.openAtService(project, service);
    }
}

