/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionIndexerStateParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangIndexDiag;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangIndexNote;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyCancelledParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCodeAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDFAInputCancelledParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGraphFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexDiagsUpdatedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexPartFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingMessageParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputTables;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputTuples;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.problems.ClangIndexProblem;
import com.jetbrains.cidr.lang.problems.ClangIndexProblemReporter;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientImpl
implements ClangClient {
    private static final Logger LOG = Logger.getInstance((String)ClangClient.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private volatile Map<String, List<ClionPublishHighlightingsParams>> myHighlightingsParts;
    @NotNull
    private volatile AggregatedDfaInput myAggregatedDFAInput;

    public ClangClientImpl(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangClientImpl.$$$reportNull$$$0(0);
        }
        this.myHighlightingsParts = new HashMap<String, List<ClionPublishHighlightingsParams>>();
        this.myAggregatedDFAInput = new AggregatedDfaInput();
        this.myContext = context;
        context.getMessageBus().connect((Disposable)context).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            @Override
            public void onServerFailure() {
                ClangClientImpl.this.myHighlightingsParts = new HashMap<String, List<ClionPublishHighlightingsParams>>();
                ClangClientImpl.this.myAggregatedDFAInput = new AggregatedDfaInput();
            }
        });
    }

    private List<ClionDiagnostic> convertPathsIfRequired(List<ClionDiagnostic> diagnostics) {
        if (!this.myContext.getUrlConverter().isWslMode()) {
            return diagnostics;
        }
        diagnostics.forEach(d -> {
            String path = this.myContext.getUrlConverter().fromWslPath(d.getClionFilePath());
            d.setClionFilePath(path);
        });
        return diagnostics;
    }

    @Override
    public void clionPublishDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(this.convertPathsIfRequired(diagnostics.getDiagnostics())));
        }
    }

    @Override
    public void clionPublishClazyDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getClazyDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(this.convertPathsIfRequired(diagnostics.getDiagnostics())));
        }
    }

    @NotNull
    private Supplier<List<ClangDiagnostic>> clionDiags2ClangDiagsSupplier(@NotNull List<ClionDiagnostic> regularDiags) {
        if (regularDiags == null) {
            ClangClientImpl.$$$reportNull$$$0(1);
        }
        return new CachingSupplier<List<ClangDiagnostic>>(() -> {
            HashSet<ClangDiagnostic> antiDuplicatesGuard = new HashSet<ClangDiagnostic>();
            ArrayList<ClangDiagnostic> clangDiagnostics = new ArrayList<ClangDiagnostic>();
            ListIterator<ClionDiagnostic> lspDiagsIter = regularDiags.listIterator();
            while (lspDiagsIter.hasNext()) {
                ClangDiagnostic diag;
                ClionDiagnostic lspDiag = (ClionDiagnostic)((Object)((Object)lspDiagsIter.next()));
                if (ClangClientImpl.isForMainFile(lspDiag)) {
                    diag = this.createClangDiag(lspDiag);
                    if (!antiDuplicatesGuard.add(diag)) continue;
                    clangDiagnostics.add(diag);
                    continue;
                }
                if (lspDiag.getSeverity() != DiagnosticSeverity.Error || (diag = this.createOtherFileDiag(lspDiag, lspDiagsIter)) == null || !antiDuplicatesGuard.add(diag)) continue;
                clangDiagnostics.add(diag);
            }
            return clangDiagnostics;
        });
    }

    @NotNull
    private ClangDiagnostic createClangDiag(@NotNull ClionDiagnostic lspDiag) {
        List allFixits;
        if (lspDiag == null) {
            ClangClientImpl.$$$reportNull$$$0(2);
        }
        Range clionRange = lspDiag.getRange();
        List<String> messageAndNotes = ClangClientImpl.splitMessage(lspDiag.getMessage());
        List list = allFixits = lspDiag.getCodeActions() != null ? ContainerUtil.filter(lspDiag.getCodeActions(), ca -> ca != null) : null;
        if (allFixits != null) {
            ClangUrlConverter converter = this.myContext.getUrlConverter();
            for (ClionCodeAction fixit : allFixits) {
                if (fixit.getEdit() == null) continue;
                Map changes = fixit.getEdit().getChanges();
                for (String uri : changes.keySet()) {
                    List textEdits = (List)changes.remove(uri);
                    changes.put(converter.fromUriToUrl(uri), textEdits);
                }
            }
        }
        String diagCode = null;
        if (lspDiag.getCode() != null) {
            diagCode = lspDiag.getCode().isLeft() ? (String)lspDiag.getCode().getLeft() : ((Integer)lspDiag.getCode().getRight()).toString();
        }
        return new ClangDiagnostic(diagCode, lspDiag.getSource(), ClangClientImpl.makeFirstLetterUpperCase(ClangClientImpl.constructMessage(messageAndNotes)), ClangClientImpl.constructNotes(messageAndNotes), allFixits != null ? ContainerUtil.filter((Collection)allFixits, f -> f.getEdit() != null) : Collections.emptyList(), allFixits != null ? ContainerUtil.filter((Collection)ContainerUtil.map((Collection)allFixits, f -> f.getClionFix()), f -> f != null) : Collections.emptyList(), ClangClientImpl.getHighlightSeverity(lspDiag.getSeverity()), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
    }

    @Nullable
    private ClangDiagnostic createOtherFileDiag(@NotNull ClionDiagnostic errorLspDiag, @NotNull ListIterator<ClionDiagnostic> iter) {
        if (errorLspDiag == null) {
            ClangClientImpl.$$$reportNull$$$0(3);
        }
        if (iter == null) {
            ClangClientImpl.$$$reportNull$$$0(4);
        }
        assert (errorLspDiag.getSeverity() == DiagnosticSeverity.Error);
        assert (!ClangClientImpl.isForMainFile(errorLspDiag));
        ClangDiagnostic candidate = null;
        int errorLine = errorLspDiag.getClionRange().getStart().getLine();
        int errorCharacter = errorLspDiag.getClionRange().getStart().getCharacter();
        while (iter.hasNext()) {
            ClionDiagnostic nextLspDiag = iter.next();
            if (ClangClientImpl.isForMainFile(nextLspDiag) && nextLspDiag.getSeverity() == DiagnosticSeverity.Information) {
                ClangLanguageServiceUtils.ClangNote note;
                List<String> messageAndNotes = ClangClientImpl.splitMessage(nextLspDiag.getMessage());
                assert (!messageAndNotes.isEmpty());
                String rawNote = messageAndNotes.get(messageAndNotes.size() - 1);
                if (rawNote.contains("error: ") && (note = ClangLanguageServiceUtils.parseNote(rawNote, this.myContext.getUrlConverter())) != null && note.line - 1 == errorLine && note.character - 1 == errorCharacter && note.path.contentEquals(errorLspDiag.getClionFilePath())) {
                    if (candidate != null) continue;
                    ClangDiagnostic mainDiag = this.createClangDiag(errorLspDiag);
                    ClangDiagnostic noteDiag = this.createClangDiag(nextLspDiag);
                    candidate = new ClangDiagnostic(noteDiag.getCode(), noteDiag.getSource(), noteDiag.getMessage(), noteDiag.getNotes(), mainDiag.getClangdFixits(), mainDiag.getClionFixits(), HighlightSeverity.ERROR, noteDiag.getStartLine(), noteDiag.getStartColumn(), noteDiag.getEndLine(), noteDiag.getEndColumn());
                    continue;
                }
            }
            iter.previous();
            return candidate;
        }
        return candidate;
    }

    private static boolean isForMainFile(@NotNull ClionDiagnostic diag) {
        if (diag == null) {
            ClangClientImpl.$$$reportNull$$$0(5);
        }
        return StringUtil.isEmpty((String)diag.getClionFilePath());
    }

    @Override
    public void clionPublishHighlightingsPart(ClionPublishHighlightingsParams highlightings) {
        List current = this.myHighlightingsParts.computeIfAbsent(highlightings.getUri(), key -> new ArrayList());
        if (!current.isEmpty() && ((ClionPublishHighlightingsParams)current.get(0)).getVersion() != highlightings.getVersion()) {
            current.clear();
        }
        current.add(highlightings);
    }

    @Override
    public void clionPublishHighlightings(ClionPublishHighlightingsParams highlightings) {
        ClangParseResponse openedFile = this.findFile(highlightings.getUri(), highlightings.getVersion());
        if (openedFile != null) {
            List<ClionHighlighting> allHighlightings;
            assert (openedFile.getVersion() == highlightings.getVersion());
            List<ClionPublishHighlightingsParams> parts = this.myHighlightingsParts.get(highlightings.getUri());
            if (parts == null || parts.isEmpty()) {
                allHighlightings = highlightings.getHighlightings();
            } else {
                parts.add(highlightings);
                allHighlightings = new ArrayList<ClionHighlighting>(highlightings.getHighlightings().size() * parts.size());
                for (int i = 0; i < parts.size(); ++i) {
                    allHighlightings.addAll(parts.get(i).getHighlightings());
                    parts.set(i, null);
                }
                parts.clear();
            }
            openedFile.getHighlightings().complete(new CachingSupplier<List>(() -> ContainerUtil.map((Collection)allHighlightings, d -> {
                Range clionRange = d.getRange();
                return new ClangHighlighting(d.getType(), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
            })));
        }
    }

    @Override
    public void clionPublishTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, true);
    }

    @Override
    public void clionPublishOurTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, false);
    }

    private static String convertAttribute(List<Integer> attribute, @NotNull ClionPublishDFAInputTables tables) {
        String string;
        if (tables == null) {
            ClangClientImpl.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(tables.getStrings() != null);
        LOG.assertTrue(tables.getFiles() != null);
        int stringIdx = attribute.get(0);
        String string2 = string = stringIdx >= 0 ? tables.getStrings().get(stringIdx) : null;
        if (attribute.size() == 1) {
            return string;
        }
        int file = attribute.get(1);
        int line1 = attribute.get(2);
        int line2 = attribute.get(3);
        int col1 = attribute.get(4);
        int col2 = attribute.get(5);
        if (file != -1) {
            return "<" + tables.getFiles().get(file) + ":" + line1 + ":" + col1 + ", line:" + line2 + ":" + col2 + ">" + (String)(string != null ? "$" + string : "");
        }
        return string;
    }

    @Override
    public void clionPublishDFAInputTables(ClionPublishDFAInputTables input2) {
        this.myAggregatedDFAInput.addFileInputTables(input2);
    }

    @Override
    public void clionPublishDFAInputTuplesPart(ClionPublishDFAInputTuples input2) {
        this.myAggregatedDFAInput.addFileTuplesPart(input2);
    }

    @Override
    public void clionDFAInputCancelled(ClionDFAInputCancelledParams params) {
        assert (this.myContext.isStatelessIndexer()) : "regular indexer is not expected here for now";
        this.myAggregatedDFAInput.finishFileInput(params.getUri());
        if (this.myContext.isAnyIndexer()) {
            CompletableFuture<Object> response = this.myContext.getCustomRequests().takeResponse(params.getVersion());
            if (response != null) {
                response.complete(null);
            } else {
                LOG.warn("clionDFAInputCancelled: no corresponding dfa response for file " + params.getUri());
            }
        }
    }

    @Override
    public void clionClangTidyCancelled(ClionClangTidyCancelledParams params) {
        assert (this.myContext.isStatelessIndexer()) : "regular indexer is not expected here for now";
        CompletableFuture<Object> response = this.myContext.getCustomRequests().takeResponse(params.getId());
        if (response != null) {
            response.complete(null);
        }
    }

    @Override
    public void clionPublishDFAInputTuples(ClionPublishDFAInputTuples input2) {
        this.myAggregatedDFAInput.addFileTuplesPart(input2);
        if (this.myContext.isAnyIndexer()) {
            CompletableFuture response;
            Stream<DFARawTuple> clangTuples = this.myAggregatedDFAInput.finishFileInput(input2.getUri());
            if (clangTuples == null) {
                LOG.warn("Can't build aggregated DFA input tuples, something is going wrong");
            }
            if ((response = this.myContext.getCustomRequests().takeResponse(input2.getVersion())) == null) {
                LOG.warn("clionPublishDFAInputTuples: no corresponding dfa response for file " + input2.getUri());
                return;
            }
            DFASupplier compressingSupplier = new DFASupplier(clangTuples != null ? clangTuples : Stream.empty());
            Stream compressedTuples = Stream.of(compressingSupplier).flatMap(s -> s.get().stream());
            if (LOG.isTraceEnabled()) {
                LOG.trace("clionPublishDFAInputTuples[" + this.myContext.getDescriptor() + "]: compressed / original (bytes) = " + String.format("%d / %d", compressingSupplier.getCompressedSize(), compressingSupplier.getOriginalSize()));
            }
            response.complete(compressedTuples);
        } else {
            ClangParseResponse openedFile = this.findFile(input2.getUri(), input2.getVersion());
            if (openedFile != null) {
                assert (openedFile.getVersion() == input2.getVersion());
                Stream<DFARawTuple> clangTuples = this.myAggregatedDFAInput.finishFileInput(input2.getUri());
                openedFile.getDFAInput().complete(new DFASupplier(clangTuples != null ? clangTuples : Stream.empty()));
            }
        }
    }

    private void clionPublishTidyDiagnosticsImpl(ClionPublishTidyDiagnosticsParams diagnostics, boolean completeDefaultTidyDiags) {
        if (this.myContext.isAnyIndexer()) {
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = this.myContext.getCustomRequests().takeResponse(diagnostics.getVersion());
            if (responseFuture == null) {
                LOG.warn("clionPublishTidyDiagnosticsImpl: no corresponding response for file " + diagnostics.getUri() + " with id = " + diagnostics.getVersion());
                return;
            }
            responseFuture.complete(this.createTidyDiagnosticsSupplier(diagnostics, Collections.emptySet()));
            return;
        }
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = completeDefaultTidyDiags ? openedFile.getTidyDiagnostics() : openedFile.getOurTidyDiagnostics();
            HashSet<String> unsavedFileUrls = (HashSet<String>)openedFile.getUserData(ClangParseResponse.UNSAVED_FILES);
            unsavedFileUrls = unsavedFileUrls != null ? new HashSet<String>(unsavedFileUrls) : new HashSet();
            unsavedFileUrls.add(openedFile.getUrl());
            responseFuture.complete(this.createTidyDiagnosticsSupplier(diagnostics, unsavedFileUrls));
        }
    }

    @NotNull
    private Supplier<List<ClangTidyDiagnostic>> createTidyDiagnosticsSupplier(@NotNull ClionPublishTidyDiagnosticsParams diagnostics, @NotNull Set<String> unsavedFileUrls) {
        if (diagnostics == null) {
            ClangClientImpl.$$$reportNull$$$0(7);
        }
        if (unsavedFileUrls == null) {
            ClangClientImpl.$$$reportNull$$$0(8);
        }
        return new CachingSupplier<List<ClangTidyDiagnostic>>(() -> {
            String openedPath = this.myContext.getUrlConverter().fromUri(diagnostics.getUri());
            ClangUtils.traceClangd(LOG, "Got " + diagnostics.getClangTidyErrors().size() + " clang-tidy errors before filtering");
            List<ClionClangTidyError> clangTidyErrors = diagnostics.getClangTidyErrors().stream().filter(ClangClientImpl::isValid).filter(d -> {
                String path = this.myContext.getUrlConverter().fromWslPath(d.getFilePath());
                if (this.myContext.getUrlConverter().isWslMode()) {
                    d.setFilePath(path);
                    for (ClangTidyRange range : d.getRanges()) {
                        range.setFilePath(this.myContext.getUrlConverter().fromWslPath(range.getFilePath()));
                    }
                    for (ClionClangTidyReplacement replacement : d.getReplacements()) {
                        replacement.setFilePath(this.myContext.getUrlConverter().fromWslPath(replacement.getFilePath()));
                    }
                }
                int res = FileUtil.comparePaths((String)FileUtil.toCanonicalPath((String)path), (String)openedPath);
                ClangUtils.traceClangd(LOG, "Comparing " + d.getFilePath() + " vs " + openedPath + " = " + res);
                return res == 0;
            }).collect(Collectors.toList());
            ClangUtils.traceClangd(LOG, "Got " + clangTidyErrors.size() + " clang-tidy errors after filtering");
            Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangClientImpl.createByteToCharOffset(clangTidyErrors, unsavedFileUrls);
            return ContainerUtil.map(clangTidyErrors, tidyError -> ClangClientImpl.createClangTidyDiagnostic(tidyError, byteToCharOffsetMap));
        });
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        LOG.warn(ClangdBundle.message("clangd.standard.version.not.supported", new Object[0]));
    }

    @Override
    public void clionIndexingCanceled() {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingCanceled();
        }
    }

    @Override
    public void clionIndexingMessage(ClionIndexingMessageParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingMessage(params.getMessage());
        }
    }

    @Override
    public void clionIndexingStarted() {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingStarted();
        }
    }

    @Override
    public void clionIndexingFinished(ClionIndexingFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingFinished(params.getDeletedModuleFiles(), params.getSymbolsDir());
            ((ClangIndexProblemReporter)this.myContext.getProject().getService(ClangIndexProblemReporter.class)).cleanupStaleProblems();
        }
    }

    @Override
    public void clionIndexerStateChanged(CLionIndexerStateParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingStateChanged(params.getState());
        }
    }

    @NotNull
    private ClangIndexProblem buildProblem(ClangIndexDiag D, VirtualFile VF) {
        HtmlBuilder Desc = new HtmlBuilder();
        Desc.append(D.getDescription());
        for (ClangIndexNote Note2 : D.getNotes()) {
            Desc.br();
            Desc.appendLink("#navigation/" + Note2.getPath() + ":" + Note2.getLine() + ":" + Note2.getCol(), Note2.getDescription());
        }
        return new ClangIndexProblem(this.myContext.getProject(), D.getSeverity(), VF.getModificationStamp(), D.getLine() - 1, D.getCol() - 1, VF, D.getMainFile() ? "clangd.indexer.main" : "clangd.indexer.modules", D.getDescription(), Desc.wrapWithHtmlBody().toString());
    }

    @Override
    public void clionIndexDiagsUpdated(ClionIndexDiagsUpdatedParams params) {
        String path = params.getPath();
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        if (vFile == null) {
            return;
        }
        Project proj = this.myContext.getProject();
        List problems = ContainerUtil.map(params.getDiags(), it -> this.buildProblem((ClangIndexDiag)it, vFile));
        ClangIndexProblemReporter service = (ClangIndexProblemReporter)proj.getService(ClangIndexProblemReporter.class);
        service.updateIndexProblems(vFile, problems);
    }

    @Override
    public void clionGraphFinished(ClionGraphFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onGraphFinished(params.getPath());
        }
    }

    @Override
    public void clionIndexPartFinished(ClionIndexPartFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexPartFinished(params.getPath());
        }
    }

    public void telemetryEvent(Object object) {
        this.myContext.getTelemetry().onServerTelemetryEvent(object);
    }

    public void showMessage(MessageParams messageParams) {
        if (messageParams.getType() == MessageType.Info && ClangDebugLevel.isWarnOrMore()) {
            Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("language.cpp.clangd.message", new Object[0]), NotificationType.INFORMATION));
        }
        switch (messageParams.getType()) {
            case Error: {
                LOG.error(messageParams.getMessage());
                break;
            }
            case Warning: {
                LOG.warn(messageParams.getMessage());
                break;
            }
            case Info: 
            case Log: {
                LOG.info(messageParams.getMessage());
            }
        }
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        CompletableFuture<MessageActionItem> response = new CompletableFuture<MessageActionItem>();
        response.complete(null);
        return response;
    }

    public void logMessage(MessageParams message) {
        LOG.info("From server: " + message.getMessage());
    }

    @Nullable
    private ClangParseResponse findFile(@NotNull String uri, int version) {
        if (uri == null) {
            ClangClientImpl.$$$reportNull$$$0(9);
        }
        String vfsUrl = this.myContext.getUrlConverter().fromUriToUrl(uri);
        ClangParseResponse file = this.myContext.getLocalWorkspace().apply(vfsUrl, wf -> wf.getPendingParseResponse(version));
        if (file == null) {
            ClangUtils.traceClangd(LOG, "Failed to find file to report diagnostics: " + uri);
        }
        return file;
    }

    @NotNull
    private static Map<String, Map<Integer, Integer>> createByteToCharOffset(@NotNull List<ClionClangTidyError> errors, @NotNull Set<String> unsavedFileUrls) {
        if (errors == null) {
            ClangClientImpl.$$$reportNull$$$0(10);
        }
        if (unsavedFileUrls == null) {
            ClangClientImpl.$$$reportNull$$$0(11);
        }
        Set<String> unsavedFilePaths = unsavedFileUrls.stream().map(url -> VirtualFileManager.extractPath((String)url)).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        Map<String, Map<Integer, Integer>> map = builder.createFor(errors, unsavedFilePaths);
        if (map == null) {
            ClangClientImpl.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            ClangClientImpl.$$$reportNull$$$0(13);
        }
        HighlightSeverity highlightSeverity = switch (lspSeverity) {
            default -> throw new IncompatibleClassChangeError();
            case DiagnosticSeverity.Error -> HighlightSeverity.ERROR;
            case DiagnosticSeverity.Warning -> HighlightSeverity.WARNING;
            case DiagnosticSeverity.Information -> HighlightSeverity.WEAK_WARNING;
            case DiagnosticSeverity.Hint -> HighlightSeverity.INFORMATION;
        };
        if (highlightSeverity == null) {
            ClangClientImpl.$$$reportNull$$$0(14);
        }
        return highlightSeverity;
    }

    @NotNull
    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull ClionClangTidyError diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (diagnostic == null) {
            ClangClientImpl.$$$reportNull$$$0(15);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(16);
        }
        List replacements = Collections.emptyList();
        if (diagnostic.getReplacements() != null && !diagnostic.getReplacements().isEmpty()) {
            replacements = ContainerUtil.map(diagnostic.getReplacements(), replacement -> ClangClientImpl.createClangTidyReplacement(replacement, byteToCharOffsetMap));
        }
        int offset = ClangClientImpl.getCharOffset(diagnostic.getFilePath(), diagnostic.getFileOffset(), byteToCharOffsetMap);
        List ranges = Collections.emptyList();
        if (diagnostic.getRanges() != null && !diagnostic.getRanges().isEmpty()) {
            ranges = ContainerUtil.map((Collection)ContainerUtil.filter(diagnostic.getRanges(), ClangClientImpl::isValid), it -> ClangClientImpl.createClangTidyRange(it, byteToCharOffsetMap));
        }
        return new ClangTidyDiagnostic(diagnostic.getMessage(), diagnostic.getName(), diagnostic.getFilePath(), offset, ranges, replacements, diagnostic.getClionFix());
    }

    @NotNull
    private static ClangTidyRange createClangTidyRange(@NotNull ClangTidyRange range, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (range == null) {
            ClangClientImpl.$$$reportNull$$$0(17);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(18);
        }
        int beginOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset() + range.getLength(), byteToCharOffsetMap);
        return new ClangTidyRange(range.getFilePath(), beginOffset, endOffset - beginOffset);
    }

    @NotNull
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull ClionClangTidyReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (replacement == null) {
            ClangClientImpl.$$$reportNull$$$0(19);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(20);
        }
        int beginOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), byteToCharOffsetMap);
        return new ClangTidyReplacement(replacement.getFilePath(), replacement.getReplacementText(), beginOffset, endOffset);
    }

    private static boolean isValid(@NotNull ClionClangTidyError diagnostic) {
        if (diagnostic == null) {
            ClangClientImpl.$$$reportNull$$$0(21);
        }
        return StringUtil.isNotEmpty((String)diagnostic.getName()) && StringUtil.isNotEmpty((String)diagnostic.getFilePath()) && StringUtil.isNotEmpty((String)diagnostic.getMessage()) && diagnostic.getFileOffset() >= 0 && (diagnostic.getReplacements() == null || diagnostic.getReplacements().isEmpty() || ContainerUtil.all(diagnostic.getReplacements(), ClangClientImpl::isValid));
    }

    private static boolean isValid(@NotNull ClionClangTidyReplacement replacement) {
        if (replacement == null) {
            ClangClientImpl.$$$reportNull$$$0(22);
        }
        return StringUtil.isNotEmpty((String)replacement.getFilePath()) && replacement.getLength() >= 0 && replacement.getOffset() >= 0;
    }

    private static boolean isValid(@NotNull ClangTidyRange range) {
        if (range == null) {
            ClangClientImpl.$$$reportNull$$$0(23);
        }
        return StringUtil.isNotEmpty((String)range.getFilePath());
    }

    private static int getCharOffset(@NotNull String filePath, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (filePath == null) {
            ClangClientImpl.$$$reportNull$$$0(24);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(25);
        }
        return byteToCharOffsetMap.getOrDefault(filePath, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    @NotNull
    private static String makeFirstLetterUpperCase(@NotNull String message) {
        if (message == null) {
            ClangClientImpl.$$$reportNull$$$0(26);
        }
        if (message.isEmpty()) {
            String string = message;
            if (string == null) {
                ClangClientImpl.$$$reportNull$$$0(27);
            }
            return string;
        }
        char upperCaseLetter = Character.toUpperCase(message.charAt(0));
        String string = upperCaseLetter + message.substring(1);
        if (string == null) {
            ClangClientImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static List<String> splitMessage(@NotNull String message) {
        if (message == null) {
            ClangClientImpl.$$$reportNull$$$0(29);
        }
        List<String> list = Arrays.asList(message.split("\n\n"));
        if (list == null) {
            ClangClientImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private static String constructMessage(@NotNull List<String> messagesAndNotes) {
        String message;
        if (messagesAndNotes == null) {
            ClangClientImpl.$$$reportNull$$$0(31);
        }
        if ((message = messagesAndNotes.get(0)).endsWith(" requested here")) {
            String string = message.substring(0, message.length() - " requested here".length());
            if (string == null) {
                ClangClientImpl.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            ClangClientImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    private static List<String> constructNotes(@NotNull List<String> messagesAndNotes) {
        if (messagesAndNotes == null) {
            ClangClientImpl.$$$reportNull$$$0(34);
        }
        return messagesAndNotes.size() > 1 ? messagesAndNotes.subList(1, messagesAndNotes.size()) : null;
    }

    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public void notifyProgress(ProgressParams params) {
        if (!this.myContext.isStopped() && params.getValue().isLeft()) {
            ClangServerListener publisher = (ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC);
            WorkDoneProgressNotification progNotif = (WorkDoneProgressNotification)params.getValue().getLeft();
            if (progNotif instanceof WorkDoneProgressBegin) {
                WorkDoneProgressBegin progBegin = (WorkDoneProgressBegin)progNotif;
                ClangdIndexingTaskId id = progBegin.getTitle().equals("indexing") ? ClangdIndexingTaskId.indexing : ClangdIndexingTaskId.preprocessing;
                publisher.onIndexingStarted(id);
            } else if (progNotif instanceof WorkDoneProgressReport) {
                WorkDoneProgressReport progReport = (WorkDoneProgressReport)progNotif;
                publisher.onIndexingProgress(progReport.getPercentage(), progReport.getMessage());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 27, 28, 30, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularDiags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lspDiag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLspDiag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsavedFileUrls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 12: 
            case 14: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lspSeverity";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteToCharOffsetMap";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesAndNotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createByteToCharOffset";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFirstLetterUpperCase";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMessage";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "constructMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clionDiags2ClangDiagsSupplier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClangDiag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOtherFileDiag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isForMainFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertAttribute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTidyDiagnosticsSupplier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createByteToCharOffset";
                break;
            }
            case 12: 
            case 14: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightSeverity";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyDiagnostic";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyReplacement";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCharOffset";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeFirstLetterUpperCase";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "splitMessage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "constructMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "constructNotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 27, 28, 30, 32, 33 -> new IllegalStateException(string);
        };
    }

    private static class AggregatedDfaInput {
        Map<String, AggregatedDfaFileInput> myAggregatedDFAInputs = new HashMap<String, AggregatedDfaFileInput>();

        private AggregatedDfaInput() {
        }

        public void addFileInputTables(ClionPublishDFAInputTables input2) {
            this.myAggregatedDFAInputs.put(input2.getUri(), new AggregatedDfaFileInput(input2));
        }

        public void addFileTuplesPart(ClionPublishDFAInputTuples input2) {
            AggregatedDfaFileInput aggregated = this.myAggregatedDFAInputs.get(input2.getUri());
            if (aggregated != null) {
                aggregated.addTuples(input2);
            }
        }

        @Nullable
        public Stream<DFARawTuple> finishFileInput(String uri) {
            AggregatedDfaFileInput aggregated = this.myAggregatedDFAInputs.get(uri);
            this.myAggregatedDFAInputs.remove(uri);
            if (aggregated == null) {
                return null;
            }
            AggregatedDfaFileInput finalAggregated = aggregated;
            List<String> relationNames = aggregated.tables.getRelationNames();
            LOG.assertTrue(relationNames != null);
            return aggregated.tuples.stream().flatMap(part -> Objects.requireNonNull(part.getTuples()).stream().map(d -> new DFARawTuple((String)relationNames.get(d.getR()), ClangClientImpl.convertAttribute(d.getF(), finalAggregated.tables), ContainerUtil.map(d.getA(), attr -> ClangClientImpl.convertAttribute(attr, finalAggregated.tables)))));
        }
    }

    public static class DFASupplier
    implements Supplier<List<DFARawTuple>> {
        private static final int CHUNK_SIZE = 10000;
        private final long myCompressionTimeMs;
        private final int myOriginalSize;
        private final List<byte @NotNull []> myCompressedJSonTuples;

        private DFASupplier(@NotNull Stream<DFARawTuple> clangTuples) {
            if (clangTuples == null) {
                DFASupplier.$$$reportNull$$$0(0);
            }
            this.myCompressedJSonTuples = new ArrayList<byte[]>();
            long startTime = System.currentTimeMillis();
            Iterator iter = clangTuples.iterator();
            int originalSize = 0;
            while (iter.hasNext()) {
                ArrayList<DFARawTuple> chunk = new ArrayList<DFARawTuple>();
                for (int i = 0; i < 10000 && iter.hasNext(); ++i) {
                    chunk.add((DFARawTuple)iter.next());
                }
                String serializedChunk = new Gson().toJson(chunk);
                originalSize += serializedChunk.length();
                this.myCompressedJSonTuples.add(ClangLanguageServiceUtils.compress(serializedChunk));
            }
            this.myCompressionTimeMs = System.currentTimeMillis() - startTime;
            this.myOriginalSize = originalSize;
        }

        public int getOriginalSize() {
            return this.myOriginalSize;
        }

        public int getCompressedSize() {
            return this.myCompressedJSonTuples.stream().reduce(0, (acc, arr) -> acc + ((byte[])arr).length, (lhs, rhs) -> lhs + rhs);
        }

        public long getCompressionTimeMs() {
            return this.myCompressionTimeMs;
        }

        @Override
        public List<DFARawTuple> get() {
            if (this.myCompressedJSonTuples.isEmpty()) {
                return Collections.emptyList();
            }
            return new ChunkedList(ContainerUtil.map(this.myCompressedJSonTuples, compressed -> ClangLanguageServiceUtils.extract(compressed, TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{DFARawTuple.class}), Collections.emptyList())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clangTuples", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl$DFASupplier", "<init>"));
        }

        private static class ChunkedList
        extends AbstractList<DFARawTuple> {
            @NotNull
            private final @NotNull List<@NotNull List<DFARawTuple>> myChunks;

            private ChunkedList(@NotNull @NotNull List<@NotNull List<DFARawTuple>> chunks) {
                if (chunks == null) {
                    ChunkedList.$$$reportNull$$$0(0);
                }
                this.myChunks = chunks;
            }

            @Override
            public DFARawTuple get(int index) {
                int chunkStartIndex = 0;
                for (List<DFARawTuple> chunk : this.myChunks) {
                    if (index < chunkStartIndex + chunk.size()) {
                        return chunk.get(index - chunkStartIndex);
                    }
                    chunkStartIndex += chunk.size();
                }
                throw new IndexOutOfBoundsException(index);
            }

            @Override
            public int size() {
                int totalSize = 0;
                for (List<DFARawTuple> chunk : this.myChunks) {
                    totalSize += chunk.size();
                }
                return totalSize;
            }

            @Override
            public Iterator<DFARawTuple> iterator() {
                return new ChunksIterator(this.myChunks.iterator());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl$DFASupplier$ChunkedList", "<init>"));
            }

            private static class ChunksIterator
            implements Iterator<DFARawTuple> {
                @NotNull
                private final Iterator<List<DFARawTuple>> myChunksIter;
                @Nullable
                private Iterator<DFARawTuple> myChunkIter;
                @Nullable
                private DFARawTuple myNextTuple;

                private ChunksIterator(@NotNull Iterator<List<DFARawTuple>> chunksIter) {
                    if (chunksIter == null) {
                        ChunksIterator.$$$reportNull$$$0(0);
                    }
                    this.myChunkIter = null;
                    this.myNextTuple = null;
                    this.myChunksIter = chunksIter;
                    this.calculateNext();
                }

                @Override
                public boolean hasNext() {
                    return this.myNextTuple != null;
                }

                @Override
                public DFARawTuple next() {
                    DFARawTuple res = this.myNextTuple;
                    this.calculateNext();
                    return res;
                }

                private void calculateNext() {
                    if (this.myChunkIter != null && this.myChunkIter.hasNext()) {
                        this.myNextTuple = this.myChunkIter.next();
                    } else if (this.myChunksIter.hasNext()) {
                        this.myChunkIter = this.myChunksIter.next().iterator();
                        this.calculateNext();
                    } else {
                        this.myNextTuple = null;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunksIter", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl$DFASupplier$ChunkedList$ChunksIterator", "<init>"));
                }
            }
        }
    }

    private static class AggregatedDfaFileInput {
        @NotNull
        final ClionPublishDFAInputTables tables;
        @NotNull
        final List<ClionPublishDFAInputTuples> tuples;

        private AggregatedDfaFileInput(@NotNull ClionPublishDFAInputTables tables) {
            if (tables == null) {
                AggregatedDfaFileInput.$$$reportNull$$$0(0);
            }
            this.tuples = new ArrayList<ClionPublishDFAInputTuples>();
            this.tables = tables;
        }

        private void addTuples(@NotNull ClionPublishDFAInputTuples tuplesPart) {
            if (tuplesPart == null) {
                AggregatedDfaFileInput.$$$reportNull$$$0(1);
            }
            if (this.tables.getVersion() != tuplesPart.getVersion()) {
                LOG.error("Shouldn't happen as we have clionPublishDFAInputTables notification:\n - Tables = " + this.tables.getUri() + " of version " + this.tables.getVersion() + "\n - Tuples = " + tuplesPart.getUri() + " of version " + tuplesPart.getVersion());
            }
            this.tuples.add(tuplesPart);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tuplesPart";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl$AggregatedDfaFileInput";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTuples";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

