/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasksBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"showTuplesInEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "tuples", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/DFARawTuple;", "fileName", "", "tuplesToString", "fileTuples", "getDfaInputFromClangd", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDfaInputFromIndexer", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdDumpDfaTuples.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdDumpDfaTuples.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpDfaTuplesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,74:1\n1485#2:75\n1510#2,3:76\n1513#2,3:86\n1485#2:89\n1510#2,3:90\n1513#2,3:100\n1557#2:103\n1628#2,3:104\n1863#2,2:107\n381#3,7:79\n381#3,7:93\n*S KotlinDebug\n*F\n+ 1 ClangdDumpDfaTuples.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpDfaTuplesKt\n*L\n43#1:75\n43#1:76,3\n43#1:86,3\n46#1:89\n46#1:90,3\n46#1:100,3\n48#1:103\n48#1:104,3\n48#1:107,2\n43#1:79,7\n46#1:93,7\n*E\n"})
public final class ClangdDumpDfaTuplesKt {
    private static final void showTuplesInEditor(Project project, List<DFARawTuple> tuples, String fileName) {
        String content = ClangdDumpDfaTuplesKt.tuplesToString(tuples);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(fileName, (CharSequence)content), true);
    }

    /*
     * WARNING - void declaration
     */
    private static final String tuplesToString(List<DFARawTuple> fileTuples) {
        Iterable list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$tuplesToString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$tuplesToString_u24lambda_u244.append("Count: " + CollectionsKt.toSet((Iterable)fileTuples).size()).append('\n');
        Iterable $this$groupBy$iv = CollectionsKt.toSet((Iterable)fileTuples);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DFARawTuple it = (DFARawTuple)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = it.getFunction();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap functionToTuples = MapsKt.toSortedMap((Map)destination$iv$iv);
        for (Map.Entry entry : ((Map)functionToTuples).entrySet()) {
            Object $this$getOrPut$iv$iv$iv2;
            void $this$groupByTo$iv$iv2;
            String function = (String)entry.getKey();
            List functionTuples = (List)entry.getValue();
            $this$tuplesToString_u24lambda_u244.append("Function: " + function).append('\n');
            Intrinsics.checkNotNull((Object)functionTuples);
            Iterable iterable2 = functionTuples;
            boolean $i$f$groupBy2 = false;
            list$iv$iv = iterable2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                DFARawTuple it = (DFARawTuple)element$iv$iv;
                boolean bl4 = false;
                String key$iv$iv = it.getRelation();
                $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object;
                list$iv$iv2.add(element$iv$iv);
            }
            for (Map.Entry entry2 : destination$iv$iv2.entrySet()) {
                void $this$mapTo$iv$iv;
                String rel = (String)entry2.getKey();
                List tuples = (List)entry2.getValue();
                $this$tuplesToString_u24lambda_u244.append("\t" + rel + ":").append('\n');
                Iterable $this$map$iv = tuples;
                boolean $i$f$map = false;
                $this$getOrPut$iv$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    $this$getOrPut$iv$iv$iv2 = (DFARawTuple)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.toString());
                }
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl7 = false;
                    $this$tuplesToString_u24lambda_u244.append("\t\t" + it).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    private static final List<DFARawTuple> getDfaInputFromClangd(Project project, VirtualFile file) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        ClangLanguageService clangLanguageService = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        Intrinsics.checkNotNull((Object)clangLanguageService);
        ClangLanguageService service = clangLanguageService;
        List dfaInput = service.computeWithOpenedAndParsed(file, ClangdDumpDfaTuplesKt::getDfaInputFromClangd$lambda$5);
        return dfaInput;
    }

    private static final List<DFARawTuple> getDfaInputFromIndexer(Project project, VirtualFile file) {
        List list;
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        ClangdIndexerService clangdIndexerService = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getOrStartStatelessIndexer() : null;
        Intrinsics.checkNotNull((Object)clangdIndexerService);
        ClangdIndexerService service = clangdIndexerService;
        ClionClangDFAConfigParams config = service.getClangIdeFacade().getDFAOptions(project, file);
        ClangdIndexerCustomTasksBuilder tasksBuilder = new ClangdIndexerCustomTasksBuilder(service);
        Intrinsics.checkNotNull((Object)config);
        CompletableFuture<Stream<DFARawTuple>> answer = tasksBuilder.addDfaInput(config, CollectionsKt.listOf((Object)file)).get(file);
        service.runCustomTasks(tasksBuilder.create(), ClangdDumpDfaTuplesKt::getDfaInputFromIndexer$lambda$6);
        CompletableFuture<Stream<DFARawTuple>> completableFuture = answer;
        if ((completableFuture != null && (completableFuture = completableFuture.get()) != null ? completableFuture.toList() : (list = null)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List getDfaInputFromClangd$lambda$5(ClangParseResponse resp) {
        CompletableFuture<Supplier<List<DFARawTuple>>> completableFuture = resp.getDFAInput();
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getDFAInput(...)");
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)completableFuture, (long)Long.MAX_VALUE, (String)"dfaInput");
        return supplier != null ? (List)supplier.get() : null;
    }

    private static final void getDfaInputFromIndexer$lambda$6(ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.waitForResult();
    }

    public static final /* synthetic */ List access$getDfaInputFromClangd(Project project, VirtualFile file) {
        return ClangdDumpDfaTuplesKt.getDfaInputFromClangd(project, file);
    }

    public static final /* synthetic */ void access$showTuplesInEditor(Project project, List tuples, String fileName) {
        ClangdDumpDfaTuplesKt.showTuplesInEditor(project, tuples, fileName);
    }

    public static final /* synthetic */ List access$getDfaInputFromIndexer(Project project, VirtualFile file) {
        return ClangdDumpDfaTuplesKt.getDfaInputFromIndexer(project, file);
    }
}

