/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ClangdRequestsPlanner {
    static final int DEFAULT_PATIENT_SEND_DELAY_SEC = 10;
    private static final Logger LOG = Logger.getInstance(ClangdRequestsPlanner.class);
    @NotNull
    private final ClangServerAccessor myServerAccessor;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final AtomicBoolean myIsStopped;
    @NotNull
    private final LinkedList<ClangRequestTask> myQueue;
    @NotNull
    private final AtomicBoolean myExecutorMonitor;
    @Nullable
    private final ScheduledFuture<?> myTimerFuture;
    @Nullable
    private Consumer<ClangInteractionPromise> myInteractionListener;

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor) {
        if (descriptor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(0);
        }
        if (serverAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(1);
        }
        this(descriptor, serverAccessor, 10);
    }

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor, int patientSendDelaySeconds) {
        if (descriptor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(2);
        }
        if (serverAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(3);
        }
        this.myIsStopped = new AtomicBoolean(false);
        this.myQueue = new LinkedList();
        this.myExecutorMonitor = new AtomicBoolean(false);
        this.myServerAccessor = serverAccessor;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdRequestsPlanner [" + descriptor + "]"));
        this.myExecutorService.execute(new ExecutorRunnable());
        this.myTimerFuture = patientSendDelaySeconds > 0 ? AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::notifyExecutor, patientSendDelaySeconds, patientSendDelaySeconds, TimeUnit.SECONDS) : null;
    }

    @TestOnly
    public void setInteractionListener(@Nullable Consumer<ClangInteractionPromise> interactionListener) {
        this.myInteractionListener = interactionListener;
    }

    @NotNull
    ClangServerAccessor getServerAccessor() {
        ClangServerAccessor clangServerAccessor = this.myServerAccessor;
        if (clangServerAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(4);
        }
        return clangServerAccessor;
    }

    @NotNull
    Future<Boolean> send(@Nullable ClangInteractionPromise promise) {
        if (this.myInteractionListener != null) {
            this.myInteractionListener.accept(promise);
        }
        if (promise != null) {
            ClangRequestTask requestTask = ClangdRequestsPlanner.createTask(promise);
            this.addTask(requestTask);
            if (requestTask.isImmediateTask()) {
                this.notifyExecutor();
            }
            CompletableFuture<Boolean> completableFuture = requestTask.getTaskFuture();
            if (completableFuture == null) {
                ClangdRequestsPlanner.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
        if (completableFuture == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @NotNull
    Future<Boolean> send(@Nullable ClangPlannedInteraction interaction) {
        Future<Boolean> future = interaction != null ? this.send(new CompletedInteractionPromise(interaction)) : CompletableFuture.completedFuture(false);
        if (future == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(7);
        }
        return future;
    }

    @NotNull
    Future<Boolean> sendImmediately(@NotNull ClangInteraction request) {
        CompletableFuture<Boolean> postFuture;
        if (request == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(8);
        }
        CompletableFuture<Boolean> completableFuture = (postFuture = this.myServerAccessor.post(request)) != null ? postFuture : CompletableFuture.completedFuture(false);
        if (completableFuture == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    void waitUntilTasksFinished() {
        assert (this.myServerAccessor.isRunningSynchronously() || !ApplicationManager.getApplication().isWriteAccessAllowed()) : "Holding write lock here can result in a deadlock, because there could be pending tasks requiring read lock!";
        CompletableFuture waitFuture = new CompletableFuture();
        ClangInteraction waitRequest = ClangInteraction.newInteraction("Wait").action(server -> waitFuture.complete(null)).onSkipped(() -> waitFuture.complete(null)).create();
        ClangInteractionPromise waitPromise = new ClangInteractionPromiseImpl.Builder<ClangInteraction>(waitRequest).setRearrangeable(false).create();
        this.addTask(new ClangRequestTask(waitPromise));
        this.notifyExecutor();
        try {
            waitFuture.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    ClangStopData stop() {
        this.myIsStopped.set(true);
        if (this.myTimerFuture != null) {
            this.myTimerFuture.cancel(true);
        }
        this.notifyExecutor();
        this.myExecutorService.shutdown();
        ClangStopData clangStopData = this.myServerAccessor.stop();
        if (clangStopData == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(10);
        }
        return clangStopData;
    }

    @NotNull
    private static ClangRequestTask createTask(@NotNull ClangInteractionPromise clangRequestPromise) {
        if (clangRequestPromise == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(11);
        }
        if (clangRequestPromise.getInteractionClass().equals(ClangChangeNotification.class)) {
            return new ClangChangeFileTask(clangRequestPromise);
        }
        return new ClangRequestTask(clangRequestPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(@NotNull ClangRequestTask task) {
        if (task == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(12);
        }
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        synchronized (linkedList) {
            ClangRequestTask queued;
            ListIterator<ClangRequestTask> iterator = this.myQueue.listIterator(this.myQueue.size());
            while (iterator.hasPrevious() && task.canEat(queued = iterator.previous())) {
                queued.onRejected();
                iterator.remove();
            }
            this.myQueue.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<ClangRequestTask> takeTasks() {
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        // MONITORENTER : linkedList
        ArrayList<ClangRequestTask> toProcess = new ArrayList<ClangRequestTask>(this.myQueue);
        this.myQueue.clear();
        ArrayList<ClangRequestTask> arrayList = toProcess;
        // MONITOREXIT : linkedList
        if (arrayList != null) return arrayList;
        ClangdRequestsPlanner.$$$reportNull$$$0(13);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            while (!this.myExecutorMonitor.get()) {
                try {
                    this.myExecutorMonitor.wait();
                }
                catch (InterruptedException ex) {
                    LOG.warn((Throwable)ex);
                    break;
                }
            }
            this.myExecutorMonitor.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutor() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            this.myExecutorMonitor.set(true);
            this.myExecutorMonitor.notifyAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverAccessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangRequestPromise";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerAccessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "send";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sendImmediately";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "takeTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sendImmediately";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 10, 13 -> new IllegalStateException(string);
        };
    }

    private class ExecutorRunnable
    implements Runnable {
        @NotNull
        private final Set<ClangRequestTask> myKnownStuckTasks = Collections.newSetFromMap(new IdentityHashMap());

        private ExecutorRunnable() {
        }

        @Override
        public void run() {
            try {
                LinkedList<ClangRequestTask> executorQueue = new LinkedList<ClangRequestTask>();
                while (true) {
                    List<ClangRequestTask> stuckTasks;
                    ClangdRequestsPlanner.this.waitForEvent();
                    if (ClangdRequestsPlanner.this.myIsStopped.get()) break;
                    List<ClangRequestTask> newTasks = ClangdRequestsPlanner.this.takeTasks();
                    executorQueue.addAll(newTasks);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Taken " + newTasks.size() + " new tasks to execute" + ExecutorRunnable.attachTasksListToMessage(newTasks) + "Total tasks pool is " + executorQueue.size() + ExecutorRunnable.attachTasksListToMessage(executorQueue));
                    }
                    if ((stuckTasks = this.sendPending(executorQueue.iterator())) != null) {
                        assert (!executorQueue.isEmpty());
                        for (ClangRequestTask stuckTask : stuckTasks) {
                            if (this.myKnownStuckTasks.contains(stuckTask)) continue;
                            this.myKnownStuckTasks.add(stuckTask);
                            stuckTask.getRequestPromise().getInteraction().whenComplete((res, resEx) -> ClangdRequestsPlanner.this.notifyExecutor());
                        }
                    }
                    this.myKnownStuckTasks.removeIf(ClangRequestTask::isReady);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Currently there are " + this.myKnownStuckTasks.size() + " known stuck tasks" + ExecutorRunnable.attachTasksListToMessage(this.myKnownStuckTasks));
                }
                for (ClangRequestTask task : executorQueue) {
                    task.onRejected();
                }
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }

        @NotNull
        private static String attachTasksListToMessage(@NotNull Collection<ClangRequestTask> tasks) {
            if (tasks == null) {
                ExecutorRunnable.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder(tasks.isEmpty() ? "." : ":\n");
            for (ClangRequestTask task : tasks) {
                sb.append(" - ").append(task.toString()).append("\n");
            }
            String string = sb.toString();
            if (string == null) {
                ExecutorRunnable.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private List<ClangRequestTask> sendPending(@NotNull Iterator<ClangRequestTask> iterator) {
            if (iterator == null) {
                ExecutorRunnable.$$$reportNull$$$0(2);
            }
            ArrayList<ClangRequestTask> stuckRequests = null;
            DependenciesManager dependencies = new DependenciesManager();
            while (iterator.hasNext()) {
                ClangRequestTask task = iterator.next();
                if (dependencies.isDependent(task.getRequestPromise())) {
                    dependencies.mergeNext(task.getRequestPromise());
                    continue;
                }
                if (!this.trySendOne(task)) {
                    dependencies.mergeNext(task.getRequestPromise());
                    if (stuckRequests == null) {
                        stuckRequests = new ArrayList<ClangRequestTask>();
                    }
                    stuckRequests.add(task);
                    continue;
                }
                iterator.remove();
            }
            return stuckRequests;
        }

        private boolean trySendOne(@NotNull ClangRequestTask task) {
            if (task == null) {
                ExecutorRunnable.$$$reportNull$$$0(3);
            }
            CompletableFuture<? extends ClangInteraction> futureRequest = task.getRequestPromise().getInteraction();
            try {
                ClangInteraction request = futureRequest.get(100L, TimeUnit.MILLISECONDS);
                if (request != null && !task.getTaskFuture().isCancelled()) {
                    CompletableFuture<Boolean> post = ClangdRequestsPlanner.this.myServerAccessor.post(request);
                    if (post == null) {
                        task.onRejected();
                    } else {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Sent " + task);
                        }
                        ClangUtils.tie(task.getTaskFuture(), post);
                    }
                } else {
                    task.onRejected();
                }
                return true;
            }
            catch (TimeoutException ex) {
                return false;
            }
            catch (CancellationException ex) {
                task.onRejected();
                return true;
            }
            catch (ExecutionException ex) {
                if (!(ex.getCause() instanceof ControlFlowException)) {
                    LOG.warn((Throwable)ex);
                }
                task.onRejected();
                return true;
            }
            catch (Throwable thr) {
                LOG.warn(thr);
                task.onRejected();
                return true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ExecutorRunnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ExecutorRunnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "attachTasksListToMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "attachTasksListToMessage";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "sendPending";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "trySendOne";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ClangRequestTask {
        @NotNull
        private final CompletableFuture<Boolean> myTaskFuture;
        @NotNull
        protected final ClangInteractionPromise myRequestPromise;

        ClangRequestTask(@NotNull ClangInteractionPromise requestPromise) {
            if (requestPromise == null) {
                ClangRequestTask.$$$reportNull$$$0(0);
            }
            this.myTaskFuture = new CompletableFuture();
            this.myRequestPromise = requestPromise;
        }

        @NotNull
        private ClangInteractionPromise getRequestPromise() {
            ClangInteractionPromise clangInteractionPromise = this.myRequestPromise;
            if (clangInteractionPromise == null) {
                ClangRequestTask.$$$reportNull$$$0(1);
            }
            return clangInteractionPromise;
        }

        @NotNull
        private CompletableFuture<Boolean> getTaskFuture() {
            CompletableFuture<Boolean> completableFuture = this.myTaskFuture;
            if (completableFuture == null) {
                ClangRequestTask.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }

        protected boolean isImmediateTask() {
            return this.myRequestPromise.isImmediate();
        }

        protected final boolean isReady() {
            return this.myRequestPromise.getInteraction().isDone();
        }

        protected boolean canEat(@NotNull ClangRequestTask other) {
            if (other == null) {
                ClangRequestTask.$$$reportNull$$$0(3);
            }
            return false;
        }

        protected void onRejected() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rejected " + this);
            }
            this.myTaskFuture.complete(false);
            ClangInteraction request = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            if (request != null) {
                request.onRejected();
            } else {
                Runnable rejectedHandler = this.myRequestPromise.getRejectedHandler();
                if (rejectedHandler != null) {
                    rejectedHandler.run();
                }
            }
        }

        public String toString() {
            ClangInteraction interaction = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            String simpleName = this.myRequestPromise.getInteractionClass().getSimpleName();
            String description = interaction != null ? interaction.getName() : (!simpleName.isBlank() ? simpleName : "unknown");
            return "task for " + description;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestPromise";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangRequestTask";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangRequestTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestPromise";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canEat";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CompletedInteractionPromise
    implements ClangInteractionPromise {
        @NotNull
        private final ClangPlannedInteraction myPlannedInteraction;

        private CompletedInteractionPromise(@NotNull ClangPlannedInteraction plannedInteraction) {
            if (plannedInteraction == null) {
                CompletedInteractionPromise.$$$reportNull$$$0(0);
            }
            this.myPlannedInteraction = plannedInteraction;
        }

        @Override
        @NotNull
        public Class<? extends ClangInteraction> getInteractionClass() {
            Class<?> clazz = this.myPlannedInteraction.getClass();
            if (clazz == null) {
                CompletedInteractionPromise.$$$reportNull$$$0(1);
            }
            return clazz;
        }

        @Override
        @NotNull
        public CompletableFuture<? extends ClangInteraction> getInteraction() {
            CompletableFuture<ClangPlannedInteraction> completableFuture = CompletableFuture.completedFuture(this.myPlannedInteraction);
            if (completableFuture == null) {
                CompletedInteractionPromise.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }

        @Override
        @Nullable
        public Runnable getRejectedHandler() {
            return null;
        }

        @Override
        @Nullable
        public List<Pair<String, ClangProperty>> getWrittenProperties() {
            return this.myPlannedInteraction.getWrittenProperties();
        }

        @Override
        @Nullable
        public List<Pair<String, ClangProperty>> getReadProperties() {
            return this.myPlannedInteraction.getReadProperties();
        }

        @Override
        public boolean isRearrangeable() {
            return this.myPlannedInteraction.isRearrangeable();
        }

        @Override
        public boolean isImmediate() {
            return this.myPlannedInteraction.isImmediate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plannedInteraction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$CompletedInteractionPromise";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$CompletedInteractionPromise";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInteractionClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInteraction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ClangChangeFileTask
    extends ClangRequestTask {
        ClangChangeFileTask(@NotNull ClangInteractionPromise requestPromise) {
            if (requestPromise == null) {
                ClangChangeFileTask.$$$reportNull$$$0(0);
            }
            super(requestPromise);
        }

        @Override
        protected boolean canEat(@NotNull ClangRequestTask other) {
            if (other == null) {
                ClangChangeFileTask.$$$reportNull$$$0(1);
            }
            if (!(other instanceof ClangChangeFileTask)) {
                return false;
            }
            if (!this.myRequestPromise.getInteraction().isDone() || !other.myRequestPromise.getInteraction().isDone()) {
                return false;
            }
            ClangInteraction request = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            ClangInteraction otherRequest = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(other.myRequestPromise.getInteraction());
            assert (request instanceof ClangChangeNotification && otherRequest instanceof ClangChangeNotification);
            ClangChangeNotification change = (ClangChangeNotification)request;
            ClangChangeNotification otherChange = (ClangChangeNotification)otherRequest;
            return change.getUrl().contentEquals(otherChange.getUrl()) && change.getVersion() >= otherChange.getVersion();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestPromise";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangChangeFileTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canEat";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DependenciesManager {
        private static final Function<String, Set<ClangProperty>> EMPTY_PROPERTY_SET = u -> EnumSet.noneOf(ClangProperty.class);
        private boolean hasRequests = false;
        private boolean hasNotRearrangeable = false;
        @NotNull
        private final Map<String, Set<ClangProperty>> myReadAccessedProperties = new HashMap<String, Set<ClangProperty>>();
        @NotNull
        private final Map<String, Set<ClangProperty>> myWriteAccessedProperties = new HashMap<String, Set<ClangProperty>>();

        private DependenciesManager() {
        }

        void mergeNext(@NotNull ClangInteractionPromise promise) {
            List<Pair<String, ClangProperty>> writeProperties;
            List<Pair<String, ClangProperty>> readProperties;
            if (promise == null) {
                DependenciesManager.$$$reportNull$$$0(0);
            }
            if (!promise.isRearrangeable()) {
                this.hasNotRearrangeable = true;
            }
            if ((readProperties = promise.getReadProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : readProperties) {
                    Set<ClangProperty> properties = this.myReadAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            if ((writeProperties = promise.getWrittenProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : writeProperties) {
                    Set<ClangProperty> properties = this.myWriteAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            this.hasRequests = true;
        }

        boolean isDependent(@NotNull ClangInteractionPromise promise) {
            if (promise == null) {
                DependenciesManager.$$$reportNull$$$0(1);
            }
            if (this.hasRequests && !promise.isRearrangeable()) {
                return true;
            }
            if (this.hasNotRearrangeable) {
                return true;
            }
            if (promise.getReadProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getReadProperties()) {
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            if (promise.getWrittenProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getWrittenProperties()) {
                    Set<ClangProperty> readProperties = this.myReadAccessedProperties.get(urlAndProperty.first);
                    if (readProperties != null && readProperties.contains(urlAndProperty.second)) {
                        return true;
                    }
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "promise";
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$DependenciesManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeNext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDependent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

