/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "", "command", "", "argument", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "getArgument", "isPause", "", "isResume", "ActionState", "Companion", "intellij.c.clangd"})
public final class ClangIndexerCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String command;
    @NotNull
    private final String argument;
    @NotNull
    private static final ClangIndexerCommand PAUSE = new ClangIndexerCommand("pause", "");
    @NotNull
    private static final ClangIndexerCommand RESUME = new ClangIndexerCommand("unpause", "");
    @NotNull
    private static final ClangIndexerCommand REBUILD = new ClangIndexerCommand("rebuild", "");
    @NotNull
    private static final ClangIndexerCommand REINDEX = new ClangIndexerCommand("reindex", "");
    @NotNull
    private static final ClangIndexerCommand SYNC = new ClangIndexerCommand("sync", "");
    @NotNull
    private static final ClangIndexerCommand CANCEL = new ClangIndexerCommand("cancel", "");
    @NotNull
    private static final ClangIndexerCommand CLEAR_CACHES = new ClangIndexerCommand("clearCaches", "");
    @NotNull
    private static final ClangIndexerCommand CLEAR_STATE = new ClangIndexerCommand("clearState", "");
    @NotNull
    private static final ClangIndexerCommand USE_MODULES = new ClangIndexerCommand("UseModules", "true");
    @NotNull
    private static final ClangIndexerCommand DONT_USE_MODULES = new ClangIndexerCommand("UseModules", "false");

    public ClangIndexerCommand(@NotNull String command, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        this.command = command;
        this.argument = argument;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    public final boolean isPause() {
        return Intrinsics.areEqual((Object)this.command, (Object)ClangIndexerCommand.PAUSE.command);
    }

    public final boolean isResume() {
        return Intrinsics.areEqual((Object)this.command, (Object)ClangIndexerCommand.RESUME.command);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand$ActionState;", "", "<init>", "(Ljava/lang/String;I)V", "Do", "DoNot", "Default", "intellij.c.clangd"})
    public static final class ActionState
    extends Enum<ActionState> {
        public static final /* enum */ ActionState Do = new ActionState();
        public static final /* enum */ ActionState DoNot = new ActionState();
        public static final /* enum */ ActionState Default = new ActionState();
        private static final /* synthetic */ ActionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ActionState[] values() {
            return (ActionState[])$VALUES.clone();
        }

        public static ActionState valueOf(String value) {
            return Enum.valueOf(ActionState.class, value);
        }

        @NotNull
        public static EnumEntries<ActionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionStateArray = new ActionState[]{ActionState.Do, ActionState.DoNot, ActionState.Default};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010&\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u0014\u0010,\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u001e\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007\u00a8\u00062"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand$Companion;", "", "<init>", "()V", "PAUSE", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "getPAUSE", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "RESUME", "getRESUME", "REBUILD", "getREBUILD", "REINDEX", "getREINDEX", "SYNC", "getSYNC", "CANCEL", "getCANCEL", "CLEAR_CACHES", "getCLEAR_CACHES", "CLEAR_STATE", "getCLEAR_STATE", "USE_MODULES", "getUSE_MODULES", "DONT_USE_MODULES", "getDONT_USE_MODULES", "OPTIMIZE_INCLUDE_GRAPH", "enabled", "", "SET_INDEXING_STRATEGY", "strategy", "", "SET_PP_THREADS", "number", "", "SET_INDEXING_THREADS", "SET_VERBOSE_LOG", "SET_SKIP_BODIES", "SET_SKIP_IMPLICIT_INSTANTIATIONS", "SET_RESTRICT_UPDATING_THREADS", "INDEX", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "UPDATE", "setActionStates", "buildGraph", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand$ActionState;", "buildModuleMap", "buildIndex", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClangIndexerCommand getPAUSE() {
            return PAUSE;
        }

        @NotNull
        public final ClangIndexerCommand getRESUME() {
            return RESUME;
        }

        @NotNull
        public final ClangIndexerCommand getREBUILD() {
            return REBUILD;
        }

        @NotNull
        public final ClangIndexerCommand getREINDEX() {
            return REINDEX;
        }

        @NotNull
        public final ClangIndexerCommand getSYNC() {
            return SYNC;
        }

        @NotNull
        public final ClangIndexerCommand getCANCEL() {
            return CANCEL;
        }

        @NotNull
        public final ClangIndexerCommand getCLEAR_CACHES() {
            return CLEAR_CACHES;
        }

        @NotNull
        public final ClangIndexerCommand getCLEAR_STATE() {
            return CLEAR_STATE;
        }

        @NotNull
        public final ClangIndexerCommand getUSE_MODULES() {
            return USE_MODULES;
        }

        @NotNull
        public final ClangIndexerCommand getDONT_USE_MODULES() {
            return DONT_USE_MODULES;
        }

        @NotNull
        public final ClangIndexerCommand OPTIMIZE_INCLUDE_GRAPH(boolean enabled) {
            return new ClangIndexerCommand("setOptimizeIncludeGraph", String.valueOf(enabled));
        }

        @NotNull
        public final ClangIndexerCommand SET_INDEXING_STRATEGY(@NotNull String strategy) {
            Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
            return new ClangIndexerCommand("setIndexingStrategy", strategy);
        }

        @NotNull
        public final ClangIndexerCommand SET_PP_THREADS(int number) {
            return new ClangIndexerCommand("setPreprocessorThreadsNumber", String.valueOf(number));
        }

        @NotNull
        public final ClangIndexerCommand SET_INDEXING_THREADS(int number) {
            return new ClangIndexerCommand("setIndexingThreadsNumber", String.valueOf(number));
        }

        @NotNull
        public final ClangIndexerCommand SET_VERBOSE_LOG(boolean enabled) {
            return new ClangIndexerCommand("setVerboseLog", String.valueOf(enabled));
        }

        @NotNull
        public final ClangIndexerCommand SET_SKIP_BODIES(boolean enabled) {
            return new ClangIndexerCommand("setSkipBodies", String.valueOf(enabled));
        }

        @NotNull
        public final ClangIndexerCommand SET_SKIP_IMPLICIT_INSTANTIATIONS(boolean enabled) {
            return new ClangIndexerCommand("setSkipImplicitInstantiations", String.valueOf(enabled));
        }

        @NotNull
        public final ClangIndexerCommand SET_RESTRICT_UPDATING_THREADS(boolean enabled) {
            return new ClangIndexerCommand("setRestrictUpdatingThreads", String.valueOf(enabled));
        }

        @NotNull
        public final ClangIndexerCommand INDEX(@NotNull List<? extends VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new ClangIndexerCommand("index", CollectionsKt.joinToString$default((Iterable)files, (CharSequence)";", null, null, (int)0, null, Companion::INDEX$lambda$0, (int)30, null));
        }

        @NotNull
        public final ClangIndexerCommand UPDATE(@NotNull List<? extends VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new ClangIndexerCommand("update", CollectionsKt.joinToString$default((Iterable)files, (CharSequence)";", null, null, (int)0, null, Companion::UPDATE$lambda$1, (int)30, null));
        }

        @NotNull
        public final ClangIndexerCommand setActionStates(@NotNull ActionState buildGraph, @NotNull ActionState buildModuleMap, @NotNull ActionState buildIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)buildGraph), (String)"buildGraph");
            Intrinsics.checkNotNullParameter((Object)((Object)buildModuleMap), (String)"buildModuleMap");
            Intrinsics.checkNotNullParameter((Object)((Object)buildIndex), (String)"buildIndex");
            return new ClangIndexerCommand("setActionStates", "BuildGraph=" + buildGraph.name() + ";BuildModuleMap=" + buildModuleMap.name() + ";BuildIndex=" + buildIndex.name());
        }

        private static final CharSequence INDEX$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }

        private static final CharSequence UPDATE$lambda$1(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

