/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCustomRequestsManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilterImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDaemonContextImpl
implements ClangDaemonContext {
    private static final Logger LOG = Logger.getInstance((String)ClangDaemonContextImpl.class.getName());
    private final boolean myIsCustomClangdUsed;
    private final ClangLanguageService.Kind myKind;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final String myClangdModulesPath;
    @NotNull
    private final String myCpp20ModulesPath;
    @NotNull
    private final String myCpp20ModuleMapPath;
    @NotNull
    private final String myModuleMapPath;
    @NotNull
    private final ClangdSettings mySettings;
    @NotNull
    private final MessageBus myMessageBus;
    private final boolean myOwnMessageBus;
    @NotNull
    private final ClangLocalWorkspace myLocalWorkspace;
    @NotNull
    private final ClangRemoteWorkspace myRemoteWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ServerConnectionProvider myServerConnectionProvider;
    @NotNull
    private final ClangClientServerProvider myClientServerProvider;
    @NotNull
    private final ClangServerAccessorProvider myServerAccessorProvider;
    @NotNull
    private final ClangCrashHandler myGuard;
    @NotNull
    private final ClangTelemetry myTelemetry;
    @NotNull
    private final ClangUrlConverter myUrlConverter;
    @NotNull
    private final Charset myProtocolCharset;
    @NotNull
    private final ClangMessagesFilter myMessagesFilter;
    @NotNull
    private final ClangCustomRequestsManager myCustomRequestsManager;
    private final int myKeepAsts;
    private final int myMemoryWatcherDelay;
    private volatile boolean areCpp20ModulesEnabled;
    private volatile boolean isStopped;

    private ClangDaemonContextImpl(ClangLanguageService.Kind kind, boolean isCustomClangd, @NotNull String descriptor, @NotNull Project project, @NotNull ClangdSettings settings, @NotNull ServerConnectionProvider serverConnectionProvider, @NotNull ClangClientServerProvider clientServerProvider, @NotNull ClangServerAccessorProvider serverAccessorProvider, @NotNull ClangUrlConverter converter, @NotNull ClangIdeFacade facade, @Nullable MessageBus messageBus, @NotNull String clangdModulesPath, @NotNull String cpp20ModulesPath, @NotNull String cpp20ModuleMapPath, @NotNull String moduleMapPath, int keepAsts, int memoryWatcherDelay, @NotNull Function<ClangDaemonContext, ClangCrashHandler> crashHandlerProvider) {
        if (descriptor == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(2);
        }
        if (serverConnectionProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(3);
        }
        if (clientServerProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(4);
        }
        if (serverAccessorProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(5);
        }
        if (converter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(6);
        }
        if (facade == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(7);
        }
        if (clangdModulesPath == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(8);
        }
        if (cpp20ModulesPath == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(9);
        }
        if (cpp20ModuleMapPath == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(10);
        }
        if (moduleMapPath == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(11);
        }
        if (crashHandlerProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(12);
        }
        this.areCpp20ModulesEnabled = false;
        this.isStopped = false;
        this.myKind = kind;
        this.myDescriptor = descriptor;
        this.myIsCustomClangdUsed = isCustomClangd;
        this.myProject = project;
        this.mySettings = settings;
        this.myServerConnectionProvider = serverConnectionProvider;
        this.myClientServerProvider = clientServerProvider;
        this.myServerAccessorProvider = serverAccessorProvider;
        this.myUrlConverter = converter;
        this.myIdeFacade = facade;
        this.myMessageBus = messageBus != null ? messageBus : ClangDaemonContextImpl.createDefaultMessageBus(this);
        this.myOwnMessageBus = messageBus == null;
        this.myClangdModulesPath = clangdModulesPath;
        this.myCpp20ModulesPath = cpp20ModulesPath;
        this.myCpp20ModuleMapPath = cpp20ModuleMapPath;
        this.myModuleMapPath = moduleMapPath;
        this.myKeepAsts = keepAsts;
        this.myMemoryWatcherDelay = memoryWatcherDelay;
        this.myLocalWorkspace = new ClangLocalWorkspaceImpl(converter);
        this.myRemoteWorkspace = new ClangRemoteWorkspaceImpl();
        this.myGuard = crashHandlerProvider.apply(this);
        this.myTelemetry = new ClangTelemetry(this);
        this.myProtocolCharset = StandardCharsets.UTF_8;
        this.myMessagesFilter = new ClangMessagesFilterImpl(this);
        this.myCustomRequestsManager = new ClangCustomRequestsManager();
    }

    @Override
    public boolean isCpp20ModulesEnabled() {
        return this.areCpp20ModulesEnabled;
    }

    @Override
    public void setCpp20ModulesEnabled(boolean enabled) {
        this.areCpp20ModulesEnabled = enabled;
    }

    @Override
    public boolean isCustomClangdUsed() {
        return this.myIsCustomClangdUsed;
    }

    @Override
    @NotNull
    @NonNls
    public String getDescriptor() {
        String string = this.myDescriptor;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(14);
        }
        return project;
    }

    @Override
    public boolean isAnyIndexer() {
        return this.myKind.isIndexer();
    }

    @Override
    public boolean isRegularIndexer() {
        return this.myKind == ClangLanguageService.Kind.Indexer;
    }

    @Override
    public boolean isStatelessIndexer() {
        return this.myKind == ClangLanguageService.Kind.StatelessIndexer;
    }

    @Override
    public int getMemoryWatcherDelayMs() {
        return this.myMemoryWatcherDelay;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        String string = this.myClangdModulesPath;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCpp20ModulesPath() {
        String string = this.myCpp20ModulesPath;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCpp20ModuleMapPath() {
        String string = this.myCpp20ModuleMapPath;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public String getModuleMapPath() {
        String string = this.myModuleMapPath;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    public ClangdSettings getSettings() {
        ClangdSettings clangdSettings = this.mySettings;
        if (clangdSettings == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(19);
        }
        return clangdSettings;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(20);
        }
        return messageBus;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        ClangLocalWorkspace clangLocalWorkspace = this.myLocalWorkspace;
        if (clangLocalWorkspace == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(21);
        }
        return clangLocalWorkspace;
    }

    @Override
    @NotNull
    public ClangRemoteWorkspace getRemoteWorkspace() {
        ClangRemoteWorkspace clangRemoteWorkspace = this.myRemoteWorkspace;
        if (clangRemoteWorkspace == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(22);
        }
        return clangRemoteWorkspace;
    }

    @Override
    @NotNull
    public ClangIdeFacade getIdeFacade() {
        ClangIdeFacade clangIdeFacade = this.myIdeFacade;
        if (clangIdeFacade == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(23);
        }
        return clangIdeFacade;
    }

    @Override
    @NotNull
    public ServerConnectionProvider getConnectionProvider() {
        ServerConnectionProvider serverConnectionProvider = this.myServerConnectionProvider;
        if (serverConnectionProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(24);
        }
        return serverConnectionProvider;
    }

    @Override
    @NotNull
    public ClangClientServerProvider getClientServerProvider() {
        ClangClientServerProvider clangClientServerProvider = this.myClientServerProvider;
        if (clangClientServerProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(25);
        }
        return clangClientServerProvider;
    }

    @Override
    @NotNull
    public ClangServerAccessorProvider getServerAccessorProvider() {
        ClangServerAccessorProvider clangServerAccessorProvider = this.myServerAccessorProvider;
        if (clangServerAccessorProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(26);
        }
        return clangServerAccessorProvider;
    }

    @Override
    @NotNull
    public ClangCrashHandler getCrashHandler() {
        ClangCrashHandler clangCrashHandler = this.myGuard;
        if (clangCrashHandler == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(27);
        }
        return clangCrashHandler;
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        ClangTelemetry clangTelemetry = this.myTelemetry;
        if (clangTelemetry == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(28);
        }
        return clangTelemetry;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        ClangUrlConverter clangUrlConverter = this.myUrlConverter;
        if (clangUrlConverter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(29);
        }
        return clangUrlConverter;
    }

    @Override
    @NotNull
    public Charset getProtocolCharset() {
        Charset charset = this.myProtocolCharset;
        if (charset == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(30);
        }
        return charset;
    }

    @Override
    @NotNull
    public ClangMessagesFilter getMessagesFilter() {
        ClangMessagesFilter clangMessagesFilter = this.myMessagesFilter;
        if (clangMessagesFilter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(31);
        }
        return clangMessagesFilter;
    }

    @Override
    @NotNull
    public ClangCustomRequestsManager getCustomRequests() {
        ClangCustomRequestsManager clangCustomRequestsManager = this.myCustomRequestsManager;
        if (clangCustomRequestsManager == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(32);
        }
        return clangCustomRequestsManager;
    }

    @Override
    public int getKeepAsts() {
        return this.myKeepAsts;
    }

    @Override
    public boolean shouldStartServerImmediately() {
        return this.myProject.getUserData(START_SERVER_IMMEDIATELY) != null;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public boolean canPublishMessage() {
        return !this.isStopped && !this.myMessageBus.isDisposed();
    }

    public void dispose() {
        this.isStopped = true;
        this.myIdeFacade.stop();
        if (this.myOwnMessageBus) {
            Disposer.dispose((Disposable)this.myMessageBus);
        }
    }

    @NotNull
    private static MessageBus createDefaultMessageBus(final @NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(33);
        }
        MessageBus messageBus = MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Not supported.");
            }

            public boolean isDisposed() {
                return context.isStopped();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$1", "createListener"));
            }
        });
        if (messageBus == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(34);
        }
        return messageBus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConnectionProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientServerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverAccessorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdModulesPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20ModulesPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20ModuleMapPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMapPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashHandlerProvider";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdModulesPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpp20ModulesPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpp20ModuleMapPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleMapPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalWorkspace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteWorkspace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeFacade";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionProvider";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientServerProvider";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerAccessorProvider";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCrashHandler";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlConverter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolCharset";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagesFilter";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRequests";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultMessageBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultMessageBus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        @NotNull
        @NonNls
        private final String myDescriptor;
        @NotNull
        private final Project myProject;
        @Nullable
        private ClangdSettings mySettings;
        @Nullable
        private ClangIdeFacade myFacade;
        @Nullable
        private ClangUrlConverter myConverter;
        @Nullable
        private File myClangdPath;
        @Nullable
        private MessageBus myMessageBus;
        @Nullable
        private ClangServerAccessorProvider myServerAccessorProvider;
        @NotNull
        private Function<ClangDaemonContext, ClangCrashHandler> myCrashHandlerProvider;
        private boolean myIsCustomClangdPath;
        @NotNull
        private ClangLanguageService.Kind myKind;
        @NotNull
        private String myClangdModulesPath;
        @NotNull
        private String myCpp20ModulesPath;
        @NotNull
        private String myCpp20ModuleMapPath;
        @NotNull
        private String myModuleMapPath;
        @Nullable
        private Integer myKeepAsts;
        @NotNull
        private Integer myMemoryWatcherDelay;

        public Builder(@NotNull @NonNls String descriptor, @NotNull Project project) {
            if (descriptor == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myCrashHandlerProvider = context -> new ClangCrashHandler((ClangDaemonContext)context);
            this.myIsCustomClangdPath = false;
            this.myKind = ClangLanguageService.Kind.Clangd;
            this.myClangdModulesPath = "";
            this.myCpp20ModulesPath = "";
            this.myCpp20ModuleMapPath = "";
            this.myModuleMapPath = "";
            this.myKeepAsts = null;
            this.myMemoryWatcherDelay = 10000;
            this.myDescriptor = descriptor;
            this.myProject = project;
            this.mySettings = ClangdSettings.getInstance(project);
        }

        @NotNull
        public Builder setSettings(@NotNull ClangdSettings settings) {
            if (settings == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setIdeFacade(@NotNull ClangIdeFacade facade) {
            if (facade == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myFacade = facade;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setUrlConverter(@NotNull ClangUrlConverter converter) {
            if (converter == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myConverter = converter;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setClangdPath(@NotNull File clangdPath) {
            if (clangdPath == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myClangdPath = clangdPath;
            this.myIsCustomClangdPath = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder setMessageBus(@NotNull MessageBus messageBus) {
            if (messageBus == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myMessageBus = messageBus;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder setKind(ClangLanguageService.Kind kind) {
            this.myKind = kind;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setClangdModulesPath(@NotNull String clangdModulesPath) {
            if (clangdModulesPath == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myClangdModulesPath = clangdModulesPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder setCpp20ModulesPath(@NotNull String cpp20ModulesPath) {
            if (cpp20ModulesPath == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myCpp20ModulesPath = cpp20ModulesPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public Builder setCpp20ModuleMapPath(@NotNull String cpp20ModuleMapPath) {
            if (cpp20ModuleMapPath == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.myCpp20ModuleMapPath = cpp20ModuleMapPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder;
        }

        @NotNull
        public Builder setModuleMapPath(@NotNull String moduleMapPath) {
            if (moduleMapPath == null) {
                Builder.$$$reportNull$$$0(19);
            }
            this.myModuleMapPath = moduleMapPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder;
        }

        @NotNull
        public Builder setServerAccessorProvider(@NotNull ClangServerAccessorProvider provider2) {
            if (provider2 == null) {
                Builder.$$$reportNull$$$0(21);
            }
            this.myServerAccessorProvider = provider2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder;
        }

        @NotNull
        public Builder setCrashHandlerProvider(@NotNull Function<ClangDaemonContext, ClangCrashHandler> provider2) {
            if (provider2 == null) {
                Builder.$$$reportNull$$$0(23);
            }
            this.myCrashHandlerProvider = provider2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder;
        }

        @NotNull
        public Builder setKeepAsts(int keepAsts) {
            this.myKeepAsts = keepAsts;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(25);
            }
            return builder;
        }

        @NotNull
        public Builder setMemoryWatcherDelay(int delayMs) {
            this.myMemoryWatcherDelay = delayMs;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(26);
            }
            return builder;
        }

        @NotNull
        public ClangDaemonContextImpl create() {
            File clangdPath = this.getClangdPath();
            LOG.info("Using clangd from: " + (Serializable)(this.getUrlConverter().isWslMode() ? ClangUtils.getSystemIndependentUNCPrefix() + this.getUrlConverter().getWslMsId() + ClangUtils.getWslClangdDirPath(this.myProject) + "/clangd" : clangdPath));
            int keepAsts = this.myKeepAsts != null ? this.myKeepAsts : EditorWindow.getTabLimit();
            ProcessServerConnectionProvider connectionProvider = new ProcessServerConnectionProvider(this.myProject, clangdPath.getAbsolutePath(), this.myKind.isIndexer(), keepAsts);
            ClangClientServerProviderImpl clientServerProvider = new ClangClientServerProviderImpl();
            return new ClangDaemonContextImpl(this.myKind, this.myIsCustomClangdPath, this.myDescriptor, this.myProject, this.getSettings(), connectionProvider, clientServerProvider, this.getServerAccessorProvider(), this.getUrlConverter(), this.getIdeFacade(), this.getMessageBus(), this.myClangdModulesPath, this.myCpp20ModulesPath, this.myCpp20ModuleMapPath, this.myModuleMapPath, keepAsts, this.myMemoryWatcherDelay, this.myCrashHandlerProvider);
        }

        @NotNull
        private ClangIdeFacade getIdeFacade() {
            ClangIdeFacade facade = (ClangIdeFacade)this.myProject.getUserData(ClangDaemonContext.IDE_FACADE_KEY);
            if (facade != null) {
                ClangIdeFacade clangIdeFacade = facade;
                if (clangIdeFacade == null) {
                    Builder.$$$reportNull$$$0(27);
                }
                return clangIdeFacade;
            }
            if (this.myFacade != null) {
                ClangIdeFacade clangIdeFacade = this.myFacade;
                if (clangIdeFacade == null) {
                    Builder.$$$reportNull$$$0(28);
                }
                return clangIdeFacade;
            }
            return new ClangIdeFacadeImpl(this.myDescriptor);
        }

        @NotNull
        private ClangdSettings getSettings() {
            if (this.mySettings != null) {
                ClangdSettings clangdSettings = this.mySettings;
                if (clangdSettings == null) {
                    Builder.$$$reportNull$$$0(29);
                }
                return clangdSettings;
            }
            ClangdSettings clangdSettings = ClangdSettings.getInstance(this.myProject);
            if (clangdSettings == null) {
                Builder.$$$reportNull$$$0(30);
            }
            return clangdSettings;
        }

        @NotNull
        private ClangUrlConverter getUrlConverter() {
            if (this.myConverter != null) {
                ClangUrlConverter clangUrlConverter = this.myConverter;
                if (clangUrlConverter == null) {
                    Builder.$$$reportNull$$$0(31);
                }
                return clangUrlConverter;
            }
            ClangUrlConverter urlConverter = (ClangUrlConverter)this.myProject.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            return urlConverter != null ? urlConverter : new ClangUrlConverter();
        }

        @NotNull
        public ClangServerAccessorProvider getServerAccessorProvider() {
            return this.myServerAccessorProvider != null ? this.myServerAccessorProvider : new ClangServerAccessorProviderImpl();
        }

        @NotNull
        private File getClangdPath() {
            if (this.myClangdPath != null) {
                File file = this.myClangdPath;
                if (file == null) {
                    Builder.$$$reportNull$$$0(32);
                }
                return file;
            }
            Pair<File, Boolean> pathAndIsCustom = ClangUtils.getClangdPath();
            this.myIsCustomClangdPath = (Boolean)pathAndIsCustom.second;
            File file = (File)pathAndIsCustom.first;
            if (file == null) {
                Builder.$$$reportNull$$$0(33);
            }
            return file;
        }

        @Nullable
        private MessageBus getMessageBus() {
            return this.myMessageBus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 7, 9, 11, 12, 14, 16, 18, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangdPath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBus";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangdModulesPath";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpp20ModulesPath";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpp20ModuleMapPath";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleMapPath";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIdeFacade";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUrlConverter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClangdPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMessageBus";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKind";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClangdModulesPath";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpp20ModulesPath";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpp20ModuleMapPath";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setModuleMapPath";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setServerAccessorProvider";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCrashHandlerProvider";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKeepAsts";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMemoryWatcherDelay";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeFacade";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlConverter";
                    break;
                }
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClangdPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSettings";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setIdeFacade";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setUrlConverter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setClangdPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setMessageBus";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setClangdModulesPath";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setCpp20ModulesPath";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setCpp20ModuleMapPath";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleMapPath";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "setServerAccessorProvider";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "setCrashHandlerProvider";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 7, 9, 11, 12, 14, 16, 18, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> new IllegalStateException(string);
            };
        }
    }
}

