/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangErrorsAnnotatorPassFactory
implements Disposable,
DumbAware,
DirtyScopeTrackingHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorPassFactory.class.getName());
    private final int myPassId;

    public ClangErrorsAnnotatorPassFactory(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar, int reparsingPassId) {
        if (highlightingPassRegistrar == null) {
            ClangErrorsAnnotatorPassFactory.$$$reportNull$$$0(0);
        }
        if (reparsingPassId != -1) {
            this.myPassId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{reparsingPassId}, null, false, -1);
        } else {
            this.myPassId = -1;
            LOG.error("Failed to register clang annotator pass because reparsing pass is missing!");
        }
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            ClangErrorsAnnotatorPassFactory.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ClangErrorsAnnotatorPassFactory.$$$reportNull$$$0(2);
        }
        if (!ClangdBridge.isSupported(psiFile.getProject(), psiFile.getVirtualFile())) {
            return null;
        }
        TextRange dirtyRange = FileStatusMap.getDirtyTextRange((Document)editor.getDocument(), (PsiFile)psiFile, (int)this.myPassId);
        if (dirtyRange == null) {
            return null;
        }
        return new ClangErrorsAnnotatorPass(psiFile, editor, editor.getDocument(), dirtyRange);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingPassRegistrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

