/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangToolsUtilKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.util.ClangdCommonUtil;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CUDAToolkitInfo;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ClangUtils {
    @NotNull
    public static final String CLANG_UNUSED_INCLUDE_DIAG_ID = "clion_unused_include";
    @NonNls
    public static final String CLANGD_PATH = "CLANGD_PATH";
    @NonNls
    public static final String QT_CORE = "QtCore";
    @NonNls
    public static final String SYSTEM_INDEPENDENT_UNC_PREFIX = "//wsl$/";
    @NonNls
    public static final String SYSTEM_INDEPENDENT_WSL_LOCALHOST_PREFIX = "//wsl.localhost/";
    @NonNls
    public static final String DEFAULT_WSL_MNT_PATH = "/mnt/";
    @NonNls
    public static final String CLION_CUSTOM_CDB_NAME = "clion_compile_commands.json";
    public static final Pattern VERSION_PATTERN = Pattern.compile("clangd version (\\S*)(?:.*)?", 32);
    public static final String WSL_CLANGD_DIR_PARENT_PATH = "/tmp";
    public static final String WSL_CLANGD_DIR_BASE_PATH = "/tmp/clangd";
    public static final Key<String> CLANGD_ARCHITECTURE = Key.create((String)"CLANGD_ARCHITECTURE");
    public static final Key<String> CLANGD_OS = Key.create((String)"CLANGD_OS");
    public static final Key<String> CLANGD_ENVIRONMENT = Key.create((String)"CLANGD_ENVIRONMENT");
    public static final Key<OCLanguageStandard> CLANGD_C_LANGUAGE_STANDARD = Key.create((String)"CLANGD_C_LANGUAGE_STANDARD");
    public static final Key<OCLanguageStandard> CLANGD_CXX_LANGUAGE_STANDARD = Key.create((String)"CLANGD_CXX_LANGUAGE_STANDARD");
    @NotNull
    private static final AtomicReference<String> clangdRevision = new AtomicReference<String>("");
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)ClangUtils.class.getName());
    @NonNls
    private static final String[] ourPathOpts = new String[]{"--include-directory", "--include-directory-after", "--include-prefix", "--include-with-prefix", "--include-with-prefix-after", "--include-with-prefix-before", "--imacros", "--include", "-imacros", "-include", "-isysroot"};
    @NonNls
    private static final String[] ourPrefixPathOpts = new String[]{"-I", "--include-directory=", "-F", "-idirafter", "--include-directory-after=", "-iframework", "-iquote", "-isystem", "-iprefix", "--include-prefix=", "-iwithprefix", "--include-with-prefix-after=", "--include-with-prefix=", "-iwithprefixbefore", "--include-with-prefix-before=", "-isysroot", "-iwithsysroot", "-imacros", "--imacros=", "-include", "--include=", "-fmodule-map-file=", "-fcpp20-module-map-file=", "-fprebuilt-module-path="};
    private static final int MSVC_MAJOR_LENGTH = 2;
    private static final int MSVC_MINOR_LENGTH = 2;
    private static final Pattern VS_WARNINGS = Pattern.compile("^-[wW](?:[0-4]|d|e)[0-9]{4}$");
    private static final Key<Boolean> CLANGD_ON = Key.create((String)"CLANGD_ON");
    private static final Key<Boolean> CLANGD_INDEXER_ON = Key.create((String)"CLANGD_INDEXER_ON");
    private static final Key<Boolean> CLANGD_STATELESS_INDEXER_ON = Key.create((String)"CLANGD_STATELESS_INDEXER_ON");
    private static final Key<Boolean> CLANGD_CLANG_TIDY_ON = Key.create((String)"CLANG_TIDY_VIA_CLANGD_ON");
    private static final Key<Boolean> CLANGD_NAVIGATION_ON = Key.create((String)"CLANGD_NAVIGATION_ON");
    private static final Key<Boolean> CLANGD_PARAMETER_INFO_ON = Key.create((String)"CLANGD_PARAMETER_INFO_ON");
    private static final AtomicBoolean copyToWSLInProgress = new AtomicBoolean(false);

    public static boolean isClangdAllowed(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return TrustedProjects.isTrusted((Project)project);
        }
        return project.getUserData(CLANGD_ON) == Boolean.TRUE;
    }

    private static boolean isBlacklistedPPDefine(@NotNull String macro) {
        if (macro == null) {
            ClangUtils.$$$reportNull$$$0(1);
        }
        return macro.contains(" __has_include") || macro.contains(" __has_cpp_attribute");
    }

    private static @Unmodifiable @NotNull List<String> filterPPDefines(@NotNull List<String> defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.filter(defines, define -> !ClangUtils.isBlacklistedPPDefine(define));
        if (list == null) {
            ClangUtils.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<String> splitCommandLine(@NotNull String commandLine) {
        String newArg;
        if (commandLine == null) {
            ClangUtils.$$$reportNull$$$0(4);
        }
        ArrayList<String> args = new ArrayList<String>();
        int argStart = 0;
        boolean inQuotes = false;
        for (int i = 0; i < commandLine.length(); ++i) {
            if (inQuotes) {
                if (commandLine.charAt(i) != '\"') continue;
                args.add(commandLine.substring(argStart, i));
                argStart = i + 1;
                inQuotes = false;
                continue;
            }
            if (commandLine.charAt(i) == '\"') {
                argStart = i + 1;
                inQuotes = true;
                continue;
            }
            if (commandLine.charAt(i) != ' ') continue;
            String newArg2 = commandLine.substring(argStart, i);
            if (!StringUtil.isEmptyOrSpaces((String)newArg2)) {
                args.add(newArg2);
            }
            argStart = i + 1;
        }
        if (argStart < commandLine.length() && !StringUtil.isEmptyOrSpaces((String)(newArg = commandLine.substring(argStart)))) {
            args.add(newArg);
        }
        ArrayList<String> arrayList = args;
        if (arrayList == null) {
            ClangUtils.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static CLionCompilationInfo getCLionCompilationInfo(@NotNull Project project, @Nullable ResolveInfo resolveInfo) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(6);
        }
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        VirtualFile root = resolveInfo.root;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, root);
        UnknownCompilerKind compiler = compilerSettings.getCompilerKind() != null ? compilerSettings.getCompilerKind() : UnknownCompilerKind.INSTANCE;
        File compilerExecutable = compilerSettings.getCompilerExecutable() != null ? compilerSettings.getCompilerExecutable() : new File("unknown");
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir() != null ? compilerSettings.getCompilerWorkingDir() : new File("");
        List headerPaths = compilerSettings.getHeadersSearchPaths();
        return new CLionCompilationInfo(project, configuration, compilerSettings, (OCCompilerKind)compiler, compilerExecutable, compilerWorkingDir, root, headerPaths, languageKind, resolveInfo.guessed);
    }

    @NotNull
    private static List<HeadersSearchPath> findHeadersSearchPaths(@NotNull OCResolveConfiguration config) {
        List headersSearchPaths;
        if (config == null) {
            ClangUtils.$$$reportNull$$$0(7);
        }
        if (!(headersSearchPaths = config.getCompilerSettings((OCLanguageKind)CLanguageKind.CPP).getHeadersSearchPaths()).isEmpty()) {
            List list = headersSearchPaths;
            if (list == null) {
                ClangUtils.$$$reportNull$$$0(8);
            }
            return list;
        }
        headersSearchPaths = config.getCompilerSettings((OCLanguageKind)CLanguageKind.C).getHeadersSearchPaths();
        if (!headersSearchPaths.isEmpty()) {
            List list = headersSearchPaths;
            if (list == null) {
                ClangUtils.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<HeadersSearchPath> list = config.getAllCompilerSettings().map(it -> it.getHeadersSearchPaths()).filter(it -> !it.isEmpty()).findFirst().orElse(Collections.emptyList());
        if (list == null) {
            ClangUtils.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private static OCResolveConfiguration getAnyResolveConfiguration(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(11);
        }
        @NotNull List configs = OCWorkspace.getInstance((Project)project).getConfigurations();
        return (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
    }

    @Nullable
    public static List<HeadersSearchPath> headerSearchPathsForProject(@NotNull Project project) {
        OCResolveConfiguration config;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(12);
        }
        return (config = ClangUtils.getAnyResolveConfiguration(project)) != null ? ClangUtils.findHeadersSearchPaths(config) : null;
    }

    @VisibleForTesting
    @NotNull
    public static PathOptType getPathOptType(@NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(13);
        }
        PathOptType pathOptType = ClangUtils.getPathOptInfo((String)option).type;
        if (pathOptType == null) {
            ClangUtils.$$$reportNull$$$0(14);
        }
        return pathOptType;
    }

    @NotNull
    public static PathOptInfo getPathOptInfo(@NonNls @NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(15);
        }
        if (option.equals("-I-")) {
            return new PathOptInfo(PathOptType.NotAPathOpt, "-I-");
        }
        for (String opt : ourPathOpts) {
            if (!option.equals(opt)) continue;
            return new PathOptInfo(PathOptType.NextWithPath, opt);
        }
        for (String opt : ourPrefixPathOpts) {
            if (!option.startsWith(opt)) continue;
            return new PathOptInfo(PathOptType.ThisWithPath, opt);
        }
        return new PathOptInfo(PathOptType.NotAPathOpt, option);
    }

    /*
     * WARNING - void declaration
     */
    private static void addPreparedCompilerOptions(@NotNull List<String> transformed, @NotNull List<String> original, ClangUrlConverter converter) {
        if (transformed == null) {
            ClangUtils.$$$reportNull$$$0(16);
        }
        if (original == null) {
            ClangUtils.$$$reportNull$$$0(17);
        }
        boolean nextIsPathOption = false;
        for (String string : original) {
            void var5_5;
            if (nextIsPathOption) {
                if (converter.isWslMode()) {
                    String string2 = converter.fixWslPathWhenRequired(string);
                } else {
                    String string3 = FileUtil.toSystemDependentName((String)string);
                }
                nextIsPathOption = false;
            } else if (string.startsWith("-std:")) {
                String string4 = string.replaceFirst(":", "=");
            } else {
                @NotNull PathOptInfo optInfo = ClangUtils.getPathOptInfo(string);
                switch (optInfo.type) {
                    case NextWithPath: {
                        nextIsPathOption = true;
                        break;
                    }
                    case ThisWithPath: {
                        if (converter.isWslMode()) {
                            String string5 = optInfo.opt + converter.fixWslPathWhenRequired(string.substring(optInfo.opt.length()));
                            break;
                        }
                        String string6 = FileUtil.toSystemDependentName((String)string);
                    }
                }
            }
            transformed.add((String)var5_5);
        }
    }

    @Nullable
    public static ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull @NonNls String pathToMacrosFile, @NotNull Cpp20ModulesContext cpp20Paths, @Nullable ResolveInfo resolveInfo) {
        ClangCompilationCommand clangCommand;
        OCCompilerKind compKind;
        CLionCompilationInfo ccInfo;
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ClangUtils.$$$reportNull$$$0(20);
        }
        if (pathToMacrosFile == null) {
            ClangUtils.$$$reportNull$$$0(21);
        }
        if (cpp20Paths == null) {
            ClangUtils.$$$reportNull$$$0(22);
        }
        if ((ccInfo = ClangUtils.getCLionCompilationInfo(project, resolveInfo)) == null) {
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.logOnce((Level)Level.WARNING, (String)("Failed to get or create compile command for file " + file.getPath()));
            }
            return null;
        }
        Trustworthiness trustworthiness = new Trustworthiness();
        if (ccInfo.isGuessed()) {
            trustworthiness = trustworthiness.with(2);
        }
        boolean usePredefines = (compKind = ClangUtils.getCompilerKind(ccInfo)) == MSVCCompilerKind.INSTANCE && Registry.is((String)"clion.clang.clangd.use.predefines.msvc") || compKind != MSVCCompilerKind.INSTANCE && Registry.is((String)"clion.clang.clangd.use.predefines");
        try {
            clangCommand = ClangUtils.createCompilationCommand(converter, file, ccInfo, false, usePredefines);
        }
        catch (IOException ex) {
            LOG.error("Failed to get or create compile command for file " + file.getPath(), (Throwable)ex);
            return null;
        }
        String entryFileUri = converter.toUri(clangCommand.entryFile);
        ArrayList<String> compilerOptions = new ArrayList<String>();
        Map userCompilationCommands = (Map)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
        boolean isHeader = ClangdBridge.isHeaderFile(project, clangCommand.inputFile);
        boolean isWsl = converter.isWslMode();
        List userDefinedCommand = null;
        if (userCompilationCommands != null && (userDefinedCommand = (List)userCompilationCommands.get(clangCommand.inputFile.getPath())) == null && isHeader) {
            userDefinedCommand = (List)userCompilationCommands.get("UseThisCommandToParseHeaders");
        }
        if (userDefinedCommand == null) {
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.compilerExecutable));
            compilerOptions.add("-nostdinc");
            compilerOptions.add("-nostdlib");
            compilerOptions.add("-nocudalib");
            compilerOptions.add("-nostdlibinc");
            if (Registry.is((String)"clion.clang.clangd.use.builtin.includes")) {
                compilerOptions.add("-ibuiltininc");
            }
            compilerOptions.add("-ccc-no-implicit-pch-or-pth");
            List ideMacros = ContainerUtil.map((Collection)PredefinedVariables.getIDEVariables(), it -> String.format("-D__%s__=%sL", it, PredefinedVariables.getVersionNumber()));
            compilerOptions.addAll(ideMacros);
            ClangUtils.addPreparedCompilerOptions(compilerOptions, clangCommand.compilerOptions, converter);
            String macroFile = converter.path2ClangdPath(new File(pathToMacrosFile), false);
            if (!macroFile.isEmpty()) {
                compilerOptions.add("-imacros" + macroFile);
            }
            if (!(cpp20Paths.modulesCachePath.isEmpty() || cpp20Paths.moduleMapPath.isEmpty() || cpp20Paths.cpp20ModuleMapPath.isEmpty())) {
                compilerOptions.add("-fmodules");
                compilerOptions.add("-fcxx-modules");
                compilerOptions.add("-fno-implicit-module-maps");
                compilerOptions.add("-fno-builtin-module-map");
                String moduleCachePath = converter.fixWslPathWhenRequired(cpp20Paths.modulesCachePath);
                compilerOptions.add("-fprebuilt-module-path=" + moduleCachePath);
                compilerOptions.add("-Xclang");
                String moduleMapPath = converter.fixWslPathWhenRequired(cpp20Paths.moduleMapPath);
                compilerOptions.add("-fmodule-map-file=" + moduleMapPath);
                compilerOptions.add("-Xclang");
                String cpp20ModuleMapPath = converter.fixWslPathWhenRequired(cpp20Paths.cpp20ModuleMapPath);
                compilerOptions.add("-fcpp20-module-map-file=" + cpp20ModuleMapPath);
                compilerOptions.add("-Xclang");
                compilerOptions.add("-fallow-pcm-with-compiler-errors");
            }
            compilerOptions.add("--");
            String path = URI.create(entryFileUri).getPath();
            if (SystemInfo.isWindows && !converter.isWslMode() && path.startsWith("/")) {
                path = path.substring(1);
            }
            compilerOptions.add(path);
        } else {
            String userEntryFile;
            compilerOptions.addAll(userDefinedCommand);
            if (!compilerOptions.isEmpty() && Files.exists(Paths.get(userEntryFile = (String)compilerOptions.get(compilerOptions.size() - 1), new String[0]), new LinkOption[0])) {
                entryFileUri = converter.toUri(new File(userEntryFile), false);
            }
            trustworthiness = new Trustworthiness();
        }
        String macroDefinitions = StringUtil.isNotEmpty((String)clangCommand.preprocessorDefines) ? clangCommand.preprocessorDefines : null;
        String workingDir = clangCommand.workingDir;
        if (isWsl) {
            workingDir = FileUtil.toSystemIndependentName((String)workingDir);
            workingDir = converter.toUri(new File(workingDir), false);
        }
        ClionCompileCommandParams compileCommandParams = new ClionCompileCommandParams(converter.toUri(clangCommand.inputFile), entryFileUri, workingDir, compilerOptions, "/dev/null", usePredefines);
        return new ClangdCompilationCommand(compileCommandParams, macroDefinitions, trustworthiness);
    }

    public static boolean isFromIncludedFile(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangUtils.$$$reportNull$$$0(23);
        }
        return StringUtil.startsWith((CharSequence)diag.getMessage(), (CharSequence)"In included file:");
    }

    @NotNull
    private static ClangCompilationCommand createCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull VirtualFile inputVirtualFile, @NotNull CLionCompilationInfo info, boolean useInputFileAsEntryFile, boolean usePredefines) throws IOException {
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(24);
        }
        if (inputVirtualFile == null) {
            ClangUtils.$$$reportNull$$$0(25);
        }
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(26);
        }
        if (info.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        VirtualFile rootVirtualFile = info.getRootVirtualFile();
        VirtualFile entryFile = useInputFileAsEntryFile ? inputVirtualFile : rootVirtualFile;
        OCResolveConfiguration configuration = info.getConfiguration();
        OCLanguageKind languageKind = info.getLanguageKind();
        OCCompilerKind compiler = info.getCompilerKind();
        File compilerWorkingDir = info.getCompilerWorkingDir();
        List<String> preprocessorDefines = ClangUtils.filterPPDefines(configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines());
        String compilerExecutable = compiler == MSVCCompilerKind.INSTANCE || compiler == ClangClCompilerKind.INSTANCE ? (preprocessorDefines.contains("__cplusplus") ? "clang++" : "clang") : info.getCompilerExecutable().getAbsolutePath();
        ClangUtils.addCompilerSwitches(converter, info, compilerOptions);
        ClangUtils.addQobjectDefsDirectories(info, compilerOptions);
        ClangUtils.addIncludeDirectories(info, compilerOptions);
        compilerOptions.addSingleRaw("-ferror-limit=0");
        return new ClangCompilationCommand(inputVirtualFile, entryFile, compilerWorkingDir.getAbsolutePath(), compilerExecutable, compilerOptions.getArgs(), ClangUtils.preparePreprocessorDefines(preprocessorDefines, usePredefines));
    }

    private static void addCompilerSwitches(@NotNull ClangUrlConverter converter, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        Map compilerFeatures;
        Object hostCompilerSwitches;
        OCCompilerSettings compilerSettings;
        CidrCompilerSwitches compilerSwitches;
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(27);
        }
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(28);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(29);
        }
        if ((compilerSwitches = (compilerSettings = ccInfo.getCompilerSettings()).getCompilerSwitches()) == null) {
            compilerSwitches = CidrCompilerSwitches.EMPTY;
        }
        if (ccInfo.getLanguageKind().isCuda() && (hostCompilerSwitches = (compilerFeatures = compilerSettings.getCompilerFeatures()).get(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS)) instanceof CidrCompilerSwitches) {
            compilerSwitches = (CidrCompilerSwitches)hostCompilerSwitches;
        }
        List<String> defines = ClangUtils.filterPPDefines(ccInfo.getConfiguration().getCompilerSettings(ccInfo.getLanguageKind(), ccInfo.getRootVirtualFile()).getPreprocessorDefines());
        ArrayList<String> XClangArgs = new ArrayList<String>();
        compilerSwitches = ClangUtils.translateExperimentalCoroutines(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutAndCollectXClangArgs(compilerSwitches, XClangArgs);
        compilerSwitches = ClangUtils.filterOutSearchPaths(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutOrFixUnknownArguments(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.addLanguageStandardIfNeeded(ccInfo, defines, compilerSwitches);
        compilerSwitches = ClangUtils.addGccConceptsIfNeeded(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.filterOutErroneousFlags(compilerSwitches);
        compilerSwitches = ClangUtils.addSizedDeallocation(compilerSwitches, ccInfo.getCompilerSettings());
        switchBuilder.addAll(compilerSwitches);
        switchBuilder.addAllRaw(XClangArgs);
        ClangUtils.addInputLanguageIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addTargetIfNeeded(ccInfo, defines, compilerSwitches, switchBuilder);
        ClangUtils.addCompatibilityModeIfNeeded(ccInfo, switchBuilder);
        ClangUtils.addCudaPathIfNeeded(converter, ccInfo, switchBuilder);
        ClangUtils.addCudaIncludeIfNeeded(converter, ccInfo, switchBuilder);
        ClangUtils.addCudaSwitches(ccInfo, switchBuilder);
        ClangUtils.addGnuCVersionIfNeeded(compilerSettings.getPreprocessorDefines(), switchBuilder);
        ClangUtils.addGccArmSveSupportIfNeeded(ccInfo, defines, switchBuilder);
        ClangUtils.addNoDefineTargetOSMacros(switchBuilder);
        ClangUtils.applyUserFlags(ccInfo.getProject(), switchBuilder);
    }

    private static void addNoDefineTargetOSMacros(@NotNull CidrSwitchBuilder builder) {
        if (builder == null) {
            ClangUtils.$$$reportNull$$$0(30);
        }
        builder.addSingleRaw("-fno-define-target-os-macros");
    }

    @NotNull
    private static CidrCompilerSwitches addGccConceptsIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(31);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(32);
        }
        if (ccInfo.getCompilerKind() != GCCCompilerKind.INSTANCE) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(33);
            }
            return cidrCompilerSwitches;
        }
        ArrayList<String> flags = new ArrayList<String>(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        boolean hasConceptsFlag = ContainerUtil.exists(flags, it -> it.equals("-fconcepts"));
        if (!hasConceptsFlag) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(34);
            }
            return cidrCompilerSwitches;
        }
        int cxxStandardIdx = ContainerUtil.indexOf(flags, it -> it.startsWith("-std="));
        if (cxxStandardIdx == -1) {
            flags.add("-std=c++20");
        } else {
            flags.set(cxxStandardIdx, "-std=c++20");
        }
        flags.remove("-fconcepts");
        return new CidrCompilerSwitches(flags);
    }

    @NotNull
    private static CidrCompilerSwitches translateExperimentalCoroutines(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(35);
        }
        ArrayList<String> compilerFlags = new ArrayList<String>(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        boolean hadCoroutineFlag = ContainerUtil.removeAll(compilerFlags, (Object[])new String[]{"-fcoroutines", "-fcoroutines-ts", "/await", "/await:strict"});
        if (!hadCoroutineFlag) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(36);
            }
            return cidrCompilerSwitches;
        }
        compilerFlags.add("-Xclang");
        compilerFlags.add("-fcoroutines");
        return new CidrCompilerSwitches(compilerFlags);
    }

    private static void addGnuCVersionIfNeeded(@NotNull List<String> defines, @NotNull CidrSwitchBuilder switchBuilder) {
        Map<String, String> versionMap;
        String majorVersion;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(37);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(38);
        }
        if ((majorVersion = (versionMap = ClangUtils.getGNUCVersions(defines)).get("__GNUC__")) == null) {
            return;
        }
        String gnucVersion = "-fgnuc-version=" + majorVersion + "." + versionMap.getOrDefault("__GNUC_MINOR__", "0") + "." + versionMap.getOrDefault("__GNUC_PATCH_LEVEL__", "0");
        switchBuilder.addSingleRaw(gnucVersion);
    }

    private static void addGccArmSveSupportIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull List<String> defines, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(39);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(40);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(41);
        }
        if (ccInfo.getCompilerKind() != GCCCompilerKind.INSTANCE || !ClangUtils.hasMacro(defines, "__ARM_NEON") || ClangUtils.hasMacro(defines, "__CLION_DISABLE_ARM_SVE_WORKAROUND") || ClangUtils.hasControllingMacroInUserFlags(ccInfo.getProject(), "__CLION_DISABLE_ARM_SVE_WORKAROUND")) {
            return;
        }
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("-target-feature");
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("+sve");
        switchBuilder.addSingleRaw("-include" + ClangRequestsHelper.getArmSveWorkaroundPath());
    }

    private static boolean hasMacro(@NotNull List<String> defines, @NotNull String name) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(42);
        }
        if (name == null) {
            ClangUtils.$$$reportNull$$$0(43);
        }
        return ContainerUtil.exists(defines, macro -> macro.contains(name));
    }

    private static boolean hasAnyMacro(@NotNull List<String> defines, String ... names) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(44);
        }
        if (names == null) {
            ClangUtils.$$$reportNull$$$0(45);
        }
        return ContainerUtil.exists(defines, macro -> {
            for (String name : names) {
                if (!macro.contains(name)) continue;
                return true;
            }
            return false;
        });
    }

    @NotNull
    private static @Unmodifiable Map<String, String> getGNUCVersions(@NotNull List<String> defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(46);
        }
        List versions = ContainerUtil.filter(defines, it -> it.contains("__GNUC__") || it.contains("__GNUC_MINOR__") || it.contains("__GNUC_PATCH_LEVEL__"));
        Map map = ContainerUtil.map2Map((Collection)versions, it -> {
            List split = StringUtil.split((String)it, (String)" ");
            String versionName = (String)split.get(1);
            String versionValue = (String)split.get(2);
            return new Pair((Object)versionName, (Object)versionValue);
        });
        if (map == null) {
            ClangUtils.$$$reportNull$$$0(47);
        }
        return map;
    }

    private static void addCudaSwitches(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(48);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(49);
        }
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("-fno-cuda-host-device-constexpr");
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("-fcuda-allow-variadic-functions");
        switchBuilder.addSingleRaw("--no-offload-new-driver");
    }

    private static void addInputLanguageIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(50);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(51);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(52);
        }
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.equals("-x")) continue;
            return;
        }
        OCLanguageKind kind = ccInfo.getLanguageKind();
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c");
                    break;
                }
                case OBJ_C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c");
                    break;
                }
                case CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c++");
                    break;
                }
                case OBJ_CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c++");
                    break;
                }
                default: {
                    LOG.warn("Unexpected language kind: " + kind);
                    break;
                }
            }
        } else if (kind instanceof CUDALanguageKind) {
            switchBuilder.addSingleRaw("-x");
            switchBuilder.addSingleRaw("cuda");
        }
    }

    @NotNull
    private static OCCompilerKind getCompilerKind(@NotNull CLionCompilationInfo ccInfo) {
        Map features;
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(53);
        }
        if ((features = ccInfo.getCompilerSettings().getCompilerFeatures()).containsKey(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND)) {
            OCCompilerKind oCCompilerKind = (OCCompilerKind)features.get(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND);
            if (oCCompilerKind == null) {
                ClangUtils.$$$reportNull$$$0(54);
            }
            return oCCompilerKind;
        }
        OCCompilerKind oCCompilerKind = ccInfo.getCompilerKind();
        if (oCCompilerKind == null) {
            ClangUtils.$$$reportNull$$$0(55);
        }
        return oCCompilerKind;
    }

    private static boolean isCpp17OrLater(@NotNull CidrCompilerSwitches compilerSwitches) {
        List asList;
        OCLanguageStandard stdArg;
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(56);
        }
        return (stdArg = OCLanguageStandard.findLanguageStandard((List)(asList = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)))) != null && stdArg.supports(OCLanguageStandard.CPP17);
    }

    private static void addCompatibilityModeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        OCCompilerKind compilerKind;
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(57);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(58);
        }
        if ((compilerKind = ClangUtils.getCompilerKind(ccInfo)) == MSVCCompilerKind.INSTANCE || compilerKind == ClangClCompilerKind.INSTANCE) {
            switchBuilder.addSingleRaw("-fms-compatibility");
        }
        if (ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.Feature.DATA_PLACEMENT_OPERATOR) != null) {
            switchBuilder.addSingleRaw("-fclion-iar-compatibility");
        }
    }

    private static void addCudaPathIfNeeded(@NotNull ClangUrlConverter converter, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(59);
        }
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(60);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(61);
        }
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        CUDAToolkitInfo cudaInstallInfo = (CUDAToolkitInfo)ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.CUDA_TOOLKIT);
        if (cudaInstallInfo == null) {
            LOG.info("No CUDA_INSTALL_INFO present");
            return;
        }
        String cudaToolkitPath = cudaInstallInfo.getInstallPath();
        boolean isWslToolchain = cudaInstallInfo.isWslInstall();
        if (StringUtil.isEmptyOrSpaces((String)cudaToolkitPath)) {
            LOG.info("No CUDA path given" + (isWslToolchain ? " under WSL" : ""));
            return;
        }
        String cudaPath = isWslToolchain ? converter.fixWslPathWhenRequired(cudaToolkitPath) : cudaToolkitPath;
        switchBuilder.addSingleRaw("--cuda-path=" + cudaPath);
    }

    private static void addCudaIncludeIfNeeded(@NotNull ClangUrlConverter converter, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(62);
        }
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(63);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(64);
        }
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        String cudaWrapperPath = ClangUtils.getClangCudaHeaderDir(converter, ccInfo.getProject()) + "/cuda_wrappers";
        switchBuilder.addSingleRaw("-isystem" + cudaWrapperPath);
        String cudaIncludePath = ClangUtils.getClangCudaHeaderDir(converter, ccInfo.getProject());
        switchBuilder.addSingleRaw("-isystem" + cudaIncludePath);
    }

    @NotNull
    static CidrCompilerSwitches addLanguageStandardIfNeeded(@NotNull CLionCompilationInfo ccInfo, @Unmodifiable @NotNull List<String> defines, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(65);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(66);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(67);
        }
        OCLanguageStandard featureStd = (OCLanguageStandard)ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD);
        OCLanguageStandard foundStandard = OCLanguageStandard.findLanguageStandard((List)compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        if (featureStd == null && foundStandard == null) {
            featureStd = ClangUtils.getFallbackLanguageStandard(ccInfo.getLanguageKind(), ccInfo.getProject());
        }
        if (featureStd == null) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(68);
            }
            return cidrCompilerSwitches;
        }
        boolean hasGNUExtensions = ClangUtils.hasMacro(defines, "__GNUC__") && !ClangUtils.hasMacro(defines, "__STRICT_ANSI__");
        return ClangUtils.setLangStandard(hasGNUExtensions ? featureStd.toGNU() : featureStd, foundStandard, compilerSwitches);
    }

    @NotNull
    private static OCLanguageStandard getFallbackLanguageStandard(@NotNull OCLanguageKind languageKind, @NotNull Project project) {
        if (languageKind == null) {
            ClangUtils.$$$reportNull$$$0(69);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(70);
        }
        if (languageKind.isCpp() || languageKind.isCuda()) {
            OCLanguageStandard keyLangStandard = (OCLanguageStandard)project.getUserData(CLANGD_CXX_LANGUAGE_STANDARD);
            OCLanguageStandard oCLanguageStandard = keyLangStandard != null ? keyLangStandard : OCLanguageStandard.latestCpp();
            if (oCLanguageStandard == null) {
                ClangUtils.$$$reportNull$$$0(71);
            }
            return oCLanguageStandard;
        }
        OCLanguageStandard keyLangStandard = (OCLanguageStandard)project.getUserData(CLANGD_C_LANGUAGE_STANDARD);
        OCLanguageStandard oCLanguageStandard = keyLangStandard != null ? keyLangStandard : OCLanguageStandard.latestC();
        if (oCLanguageStandard == null) {
            ClangUtils.$$$reportNull$$$0(72);
        }
        return oCLanguageStandard;
    }

    @NotNull
    private static CidrCompilerSwitches setLangStandard(@NotNull OCLanguageStandard std, @Nullable OCLanguageStandard foundStandard, @NotNull CidrCompilerSwitches switches) {
        if (std == null) {
            ClangUtils.$$$reportNull$$$0(73);
        }
        if (switches == null) {
            ClangUtils.$$$reportNull$$$0(74);
        }
        if (foundStandard == null || !std.toGNU().equals((Object)foundStandard.toGNU())) {
            ArrayList<String> updatedFlags = new ArrayList<String>(switches.getList(CidrCompilerSwitches.Format.RAW));
            updatedFlags.add(std.getCommandLineFlag());
            return new CidrCompilerSwitches(updatedFlags);
        }
        CidrCompilerSwitches cidrCompilerSwitches = switches;
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(75);
        }
        return cidrCompilerSwitches;
    }

    private static void addTargetIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull List<String> defines, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(76);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(77);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(78);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(79);
        }
        boolean hasTargetParam = false;
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.startsWith("--target=")) continue;
            hasTargetParam = true;
            break;
        }
        if (!hasTargetParam) {
            String architecture = ClangUtils.detectArchitecture(ccInfo.getProject(), defines);
            String vendor = "unknown";
            String os = ClangUtils.detectOS(ccInfo.getProject(), defines);
            String environment = ClangUtils.detectEnvironment(ccInfo.getProject(), defines, architecture);
            if (architecture != null) {
                switchBuilder.addSingleRaw("--target=" + architecture + "-" + vendor + "-" + os + "-" + environment);
            } else if (SystemInfoRt.isLinux) {
                switchBuilder.addSingleRaw("--target=x86_64-unknown-linux-unknown");
            } else if (SystemInfoRt.isMac) {
                switchBuilder.addSingleRaw("--target=x86_64-unknown-darwin-unknown");
            } else if (SystemInfoRt.isWindows) {
                switchBuilder.addSingleRaw("--target=x86_64-unknown-windows-unknown");
            }
        }
    }

    @Nullable
    private static String detectArchitecture(@NotNull Project project, @NotNull List<String> defines) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(80);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(81);
        }
        if ((forced = (String)project.getUserData(CLANGD_ARCHITECTURE)) != null) {
            return forced;
        }
        String architecture = null;
        if (ClangUtils.hasAnyMacro(defines, "__x86_64__", "__amd64__", "_M_X64", "_M_AMD64")) {
            architecture = "x86_64";
        } else if (ClangUtils.hasAnyMacro(defines, "__i386__", "__i486__", "__i586__", "__i686__", "__i786__", "__i886__", "__i986__", "_M_IX86", "_M_I86", "__X86__", "__I86__", "_X86_")) {
            architecture = "i386";
        } else if (ClangUtils.hasAnyMacro(defines, "__arm__", "_M_ARM")) {
            architecture = "arm";
        } else if (ClangUtils.hasMacro(defines, "__aarch64__")) {
            architecture = "arm64";
        } else if (ClangUtils.hasMacro(defines, "__mips__")) {
            architecture = "mips";
        } else if (ClangUtils.hasAnyMacro(defines, "__powerpc__", "_M_PPC")) {
            architecture = "powerpc";
        } else if (ClangUtils.hasMacro(defines, "__powerpc64__")) {
            architecture = "powerpc64";
        } else if (ClangUtils.hasMacro(defines, "ESP32")) {
            architecture = "riscv32";
        } else if (ClangUtils.hasMacro(defines, "__riscv")) {
            architecture = ClangUtils.getIntValueOfMacroOr(defines, "__riscv_xlen", 64) == 32 ? "riscv32" : "riscv64";
        } else if (ClangUtils.hasMacro(defines, "__AVR__")) {
            architecture = "avr";
        }
        return architecture;
    }

    @NotNull
    private static String detectOS(@NotNull Project project, @NotNull List<String> defines) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(82);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(83);
        }
        if ((forced = (String)project.getUserData(CLANGD_OS)) != null) {
            String string = forced;
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(84);
            }
            return string;
        }
        if (ClangUtils.hasAnyMacro(defines, "__APPLE__", "__MACH__")) {
            return "darwin";
        }
        if (ClangUtils.hasAnyMacro(defines, "_WIN32", "_WIN64")) {
            return "windows";
        }
        if (ClangUtils.hasMacro(defines, "__linux__")) {
            return "linux";
        }
        if (ClangUtils.hasMacro(defines, "__FreeBSD__")) {
            return "freebsd";
        }
        return "unknown";
    }

    @NotNull
    private static String detectEnvironment(@NotNull Project project, @NotNull List<String> defines, @Nullable String architecture) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(85);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(86);
        }
        if ((forced = (String)project.getUserData(CLANGD_ENVIRONMENT)) != null) {
            String string = forced;
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(87);
            }
            return string;
        }
        if (ClangUtils.hasMacro(defines, "__CYGWIN__")) {
            return "cygnus";
        }
        if (ClangUtils.hasAnyMacro(defines, "__MINGW32__", "__MINGW64__")) {
            return "gnu";
        }
        if (ClangUtils.hasMacro(defines, "_MSC_FULL_VER")) {
            String version = ClangUtils.getStringValueOfMacro(defines, "_MSC_FULL_VER");
            if (version != null && version.length() > 4) {
                String string = "msvc" + version.substring(0, 2) + "." + version.substring(2, 4) + "." + version.substring(4);
                if (string == null) {
                    ClangUtils.$$$reportNull$$$0(88);
                }
                return string;
            }
        } else {
            if (ClangUtils.hasMacro(defines, "__riscv_float_abi_single")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32f" : "lp64f";
            }
            if (ClangUtils.hasMacro(defines, "__riscv_float_abi_double")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32d" : "lp64d";
            }
            if (ClangUtils.hasMacro(defines, "__riscv_abi_rve")) {
                return "ilp32e";
            }
            if (ClangUtils.hasMacro(defines, "__riscv_float_abi_soft")) {
                return "unknown";
            }
        }
        return "unknown";
    }

    @Nullable
    private static String getStringValueOfMacro(@NotNull List<String> defines, @NotNull String macroName) {
        String macro;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(89);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(90);
        }
        if ((macro = (String)ContainerUtil.find(defines, m -> m.contains(macroName))) == null) {
            return null;
        }
        int indexOfMacroName = macro.indexOf(macroName);
        int indexOfMacroValue = indexOfMacroName + macroName.length() + 1;
        return macro.substring(indexOfMacroValue);
    }

    @Nullable
    private static Integer getIntValueOfMacro(@NotNull List<String> defines, @NotNull String macroName) {
        String stringValue;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(91);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(92);
        }
        if ((stringValue = ClangUtils.getStringValueOfMacro(defines, macroName)) != null) {
            try {
                return Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getIntValueOfMacroOr(@NotNull List<String> defines, @NotNull String macroName, int defaultValue) {
        Integer value;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(93);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(94);
        }
        return (value = ClangUtils.getIntValueOfMacro(defines, macroName)) != null ? value : defaultValue;
    }

    private static String preparePreprocessorDefines(@NotNull @Unmodifiable List<String> defines, boolean usePredefines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(95);
        }
        Stream<Object> definesStream = defines.stream();
        definesStream = definesStream.filter(define -> {
            if (define.startsWith("#define __has_feature(") || define.startsWith("#define __has_extension(") || define.startsWith("#define __has_builtin(") || define.startsWith("#define __has_attribute(") || define.startsWith("#define __has_include(") || define.startsWith("#define __has_include_next(") || define.startsWith("#define __has_warning(") || define.startsWith("#define __is_identifier(") || define.startsWith("#define __building_module(") || define.startsWith("#define __has_cpp_attribute(") || define.startsWith("#define __has_c_attribute(") || define.startsWith("#define __has_declspec(") || define.startsWith("#define __is_target_arch(") || define.startsWith("#define __is_target_vendor(") || define.startsWith("#define __is_target_os(") || define.startsWith("#define __is_target_environment(") || define.startsWith("#define __is_target_variant_os(") || define.startsWith("#define __is_target_variant_environment(")) {
                return false;
            }
            if (define.startsWith("#define __builtin_va_start(list, paramN)") || define.startsWith("#define __builtin_va_arg(list, type)") || define.startsWith("#define __builtin_va_end(list)") || define.startsWith("#define __builtin_va_copy(dest, src)") || define.startsWith("#define __builtin_offsetof(type, member)") || define.startsWith("#define __builtin_types_compatible_p(X,Y)") || define.startsWith("#define __builtin_choose_expr(C,T,E)")) {
                return false;
            }
            return !define.startsWith("#define __extension__");
        });
        StringBuilder filteredDefines = new StringBuilder();
        definesStream.forEach(define -> filteredDefines.append((String)define).append("\n"));
        ClangUtils.appendUnsupportedBuiltins2Intrinsics(filteredDefines);
        ClangUtils.appendArchitectureDefinesIfNeeded(filteredDefines, defines, usePredefines);
        ClangUtils.undefStaticCallOperatorUnlessPresent(filteredDefines, defines, usePredefines);
        return filteredDefines.toString();
    }

    private static void undefStaticCallOperatorUnlessPresent(@NotNull StringBuilder builder, @NotNull List<String> defines, boolean usePredefines) {
        if (builder == null) {
            ClangUtils.$$$reportNull$$$0(96);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(97);
        }
        if (!usePredefines) {
            return;
        }
        if (!defines.contains("__cpp_static_call_operator")) {
            builder.append("#undef __cpp_static_call_operator");
        }
    }

    private static void appendArchitectureDefinesIfNeeded(@NotNull StringBuilder builder, @NotNull List<String> defines, boolean usePredefines) {
        if (builder == null) {
            ClangUtils.$$$reportNull$$$0(98);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(99);
        }
        if (usePredefines) {
            return;
        }
        if (defines.contains("#define __SEG_FS 1") && !defines.contains("#define __seg_fs")) {
            builder.append("#define __seg_fs __attribute__((address_space(257)))\n");
        }
        if (defines.contains("#define __SEG_GS 1") && !defines.contains("#define __seg_gs")) {
            builder.append("#define __seg_gs __attribute__((address_space(256)))\n");
        }
    }

    private static void appendUnsupportedBuiltins2Intrinsics(@NotNull StringBuilder defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(100);
        }
        defines.append("#define __builtin_ia32_addps _mm_add_ps\n#define __builtin_ia32_addsd _mm_add_sd\n#define __builtin_ia32_addpd _mm_add_pd\n#define __builtin_ia32_addss _mm_add_ss\n#define __builtin_ia32_paddb128 _mm_add_epi8\n#define __builtin_ia32_paddw128 _mm_add_epi16\n#define __builtin_ia32_paddd128 _mm_add_epi32\n#define __builtin_ia32_paddq128 _mm_add_epi64\n#define __builtin_ia32_subps _mm_sub_ps\n#define __builtin_ia32_subsd _mm_sub_sd\n#define __builtin_ia32_subpd _mm_sub_pd\n#define __builtin_ia32_subss _mm_sub_ss\n#define __builtin_ia32_psubb128 _mm_sub_epi8\n#define __builtin_ia32_psubw128 _mm_sub_epi16\n#define __builtin_ia32_psubd128 _mm_sub_epi32\n#define __builtin_ia32_psubq128 _mm_sub_epi64\n#define __builtin_ia32_mulsd _mm_mul_sd\n#define __builtin_ia32_mulpd _mm_mul_pd\n#define __builtin_ia32_mulps _mm_mul_ps\n#define __builtin_ia32_mulss _mm_mul_ss\n#define __builtin_ia32_pmullw128 _mm_mullo_epi16\n#define __builtin_ia32_divsd _mm_div_sd\n#define __builtin_ia32_divpd _mm_div_pd\n#define __builtin_ia32_divps _mm_div_ps\n#define __builtin_ia32_subss _mm_div_ss\n#define __builtin_ia32_andpd _mm_and_pd\n#define __builtin_ia32_andps _mm_and_ps\n#define __builtin_ia32_pand128 _mm_and_si128\n#define __builtin_ia32_andnpd _mm_andnot_pd\n#define __builtin_ia32_andnps _mm_andnot_ps\n#define __builtin_ia32_pandn128 _mm_andnot_si128\n#define __builtin_ia32_orpd _mm_or_pd\n#define __builtin_ia32_orps _mm_or_ps\n#define __builtin_ia32_por128 _mm_or_si128\n#define __builtin_ia32_xorpd _mm_xor_pd\n#define __builtin_ia32_xorps _mm_xor_ps\n#define __builtin_ia32_pxor128 _mm_xor_si128\n#define __builtin_ia32_cvtps2dq _mm_cvtps_epi32\n#define __builtin_ia32_cvtsd2ss _mm_cvtsd_ss\n#define __builtin_ia32_cvtsi2sd _mm_cvtsi32_sd\n#define __builtin_ia32_cvtss2sd _mm_cvtss_sd\n#define __builtin_ia32_cvttsd2si _mm_cvttsd_si32\n#define __builtin_ia32_vec_ext_v2df _mm_cvtsd_f64\n#define __builtin_ia32_loadhpd _mm_loadh_pd\n#define __builtin_ia32_loadlpd _mm_loadl_pd\n#define __builtin_ia32_loadlv4si _mm_loadl_epi64\n#define __builtin_ia32_cmpeqps _mm_cmpeq_ps\n#define __builtin_ia32_cmpltps _mm_cmplt_ps\n#define __builtin_ia32_cmpleps _mm_cmple_ps\n#define __builtin_ia32_cmpgtps _mm_cmpgt_ps\n#define __builtin_ia32_cmpgeps _mm_cmpge_ps\n#define __builtin_ia32_cmpunordps _mm_cmpunord_ps\n#define __builtin_ia32_cmpneqps _mm_cmpneq_ps\n#define __builtin_ia32_cmpnltps _mm_cmpnlt_ps\n#define __builtin_ia32_cmpnleps _mm_cmpnle_ps\n#define __builtin_ia32_cmpngtps _mm_cmpngt_ps\n#define __builtin_ia32_cmpordps _mm_cmpord_ps\n#define __builtin_ia32_cmpeqss _mm_cmpeq_ss\n#define __builtin_ia32_cmpltss _mm_cmplt_ss\n#define __builtin_ia32_cmpless _mm_cmple_ss\n#define __builtin_ia32_cmpunordss _mm_cmpunord_ss\n#define __builtin_ia32_cmpneqss _mm_cmpneq_ss\n#define __builtin_ia32_cmpnltss _mm_cmpnlt_ss\n#define __builtin_ia32_cmpnless _mm_cmpnle_ss\n#define __builtin_ia32_cmpngtss _mm_cmpngt_ss\n#define __builtin_ia32_cmpngess _mm_cmpnge_ss\n#define __builtin_ia32_cmpordss _mm_cmpord_ss\n#define __builtin_ia32_movss _mm_move_ss\n#define __builtin_ia32_movsd _mm_move_sd\n#define __builtin_ia32_movhlps _mm_movehl_ps\n#define __builtin_ia32_movlhps _mm_movelh_ps\n#define __builtin_ia32_movqv4si _mm_move_epi64\n#define __builtin_ia32_unpckhps _mm_unpackhi_ps\n#define __builtin_ia32_unpckhpd _mm_unpackhi_pd\n#define __builtin_ia32_punpckhbw128 _mm_unpackhi_epi8\n#define __builtin_ia32_punpckhwd128 _mm_unpackhi_epi16\n#define __builtin_ia32_punpckhdq128 _mm_unpackhi_epi32\n#define __builtin_ia32_punpckhqdq128 _mm_unpackhi_epi64\n#define __builtin_ia32_unpcklps _mm_unpacklo_ps\n#define __builtin_ia32_unpcklpd _mm_unpacklo_pd\n#define __builtin_ia32_punpcklbw128 _mm_unpacklo_epi8\n#define __builtin_ia32_punpcklwd128 _mm_unpacklo_epi16\n#define __builtin_ia32_punpckldq128 _mm_unpacklo_epi32\n#define __builtin_ia32_punpcklqdq128 _mm_unpacklo_epi64\n#define __builtin_ia32_cmpeqpd _mm_cmpeq_pd\n#define __builtin_ia32_cmpltpd _mm_cmplt_pd\n#define __builtin_ia32_cmplepd _mm_cmple_pd\n#define __builtin_ia32_cmpgtpd _mm_cmpgt_pd\n#define __builtin_ia32_cmpgepd _mm_cmpge_pd\n#define __builtin_ia32_cmpunordpd _mm_cmpunord_pd\n#define __builtin_ia32_cmpneqpd _mm_cmpneq_pd\n#define __builtin_ia32_cmpnltpd _mm_cmpnlt_pd\n#define __builtin_ia32_cmpnlepd _mm_cmpnle_pd\n#define __builtin_ia32_cmpngtpd _mm_cmpngt_pd\n#define __builtin_ia32_cmpngepd _mm_cmpnge_pd\n#define __builtin_ia32_cmpordpd _mm_cmpord_pd\n#define __builtin_ia32_cmpeqsd _mm_cmpeq_sd\n#define __builtin_ia32_cmpltsd _mm_cmplt_sd\n#define __builtin_ia32_cmplesd _mm_cmple_sd\n#define __builtin_ia32_cmpunordsd _mm_cmpunord_sd\n#define __builtin_ia32_cmpneqsd _mm_cmpneq_sd\n#define __builtin_ia32_cmpnltsd _mm_cmpnlt_sd\n#define __builtin_ia32_cmpnlesd _mm_cmpnle_sd\n#define __builtin_ia32_cmpordsd _mm_cmpord_sd\n#define __builtin_ia32_cvtsi642ss _mm_cvtsi64_ss\n#define __builtin_ia32_cvttss2si64 _mm_cvtss_si64\n#define __builtin_ia32_shufps _mm_shuffle_ps\n#define __builtin_ia32_shufpd _mm_shuffle_pd\n#define __builtin_ia32_pshufhw _mm_shufflehi_epi16\n#define __builtin_ia32_pshuflw _mm_shufflelo_epi16\n#define __builtin_ia32_pshufd _mm_shuffle_epi32\n#define __builtin_ia32_movshdup _mm_movehdup_ps\n#define __builtin_ia32_movsldup _mm_moveldup_ps\n#define __builtin_ia32_maxps _mm_max_ps\n#define __builtin_ia32_pslldi128 _mm_slli_epi32\n#define __builtin_ia32_vec_set_v16qi _mm_insert_epi8\n#define __builtin_ia32_vec_set_v8hi _mm_insert_epi16\n#define __builtin_ia32_vec_set_v4si _mm_insert_epi32\n#define __builtin_ia32_vec_set_v2di _mm_insert_epi64\n#define __builtin_ia32_vec_set_v4hi _mm_insert_pi16\n#define __builtin_ia32_vec_ext_v16qi _mm_extract_epi8\n#define __builtin_ia32_vec_ext_v8hi _mm_extract_epi16\n#define __builtin_ia32_vec_ext_v4si _mm_extract_epi32\n#define __builtin_ia32_vec_ext_v2di _mm_extract_epi64\n#define __builtin_ia32_vec_ext_v4hi _mm_extract_pi16\n#define __builtin_ia32_vec_ext_v4sf _mm_extract_ps\n#define __builtin_ia32_paddb _mm_add_pi8\n#define __builtin_ia32_paddw _mm_add_pi16\n#define __builtin_ia32_paddd _mm_add_pi32\n#define __builtin_ia32_paddsb _mm_adds_pi8\n#define __builtin_ia32_paddsw _mm_adds_pi16\n#define __builtin_ia32_paddusb _mm_adds_pu8\n#define __builtin_ia32_paddusw _mm_adds_pu16\n#define __builtin_ia32_psubb _mm_sub_pi8\n#define __builtin_ia32_psubw _mm_sub_pi16\n#define __builtin_ia32_psubd _mm_sub_pi32\n#define __builtin_ia32_psubsb _mm_subs_pi8\n#define __builtin_ia32_psubsw _mm_subs_pi16\n#define __builtin_ia32_psubusb _mm_subs_pu8\n#define __builtin_ia32_psubusw _mm_subs_pu16\n#define __builtin_ia32_pmulhw _mm_mulhi_pi16\n#define __builtin_ia32_pmullw _mm_mullo_pi16\n#define __builtin_ia32_pmaddwd _mm_madd_pi16\n#define __builtin_ia32_pand _mm_and_si64\n#define __builtin_ia32_pandn _mm_andnot_si64\n#define __builtin_ia32_por _mm_or_si64\n#define __builtin_ia32_pxor _mm_xor_si64\n#define __builtin_ia32_psllw _mm_sll_pi16\n#define __builtin_ia32_pslld _mm_sll_pi32\n#define __builtin_ia32_psllq _mm_sll_si64\n#define __builtin_ia32_psrlw _mm_srl_pi16\n#define __builtin_ia32_psrld _mm_srl_pi32\n#define __builtin_ia32_psrlq _mm_srl_si64\n#define __builtin_ia32_psraw _mm_sra_pi16\n#define __builtin_ia32_psrad _mm_sra_pi32\n#define __builtin_ia32_psllwi _mm_slli_pi16\n#define __builtin_ia32_pslldi _mm_slli_pi32\n#define __builtin_ia32_psllqi _mm_slli_si64\n#define __builtin_ia32_psrlwi _mm_srli_pi16\n#define __builtin_ia32_psrldi _mm_srli_pi32\n#define __builtin_ia32_psrlqi _mm_srli_si64\n#define __builtin_ia32_psrawi _mm_srai_pi16\n#define __builtin_ia32_psradi _mm_srai_pi32\n#define __builtin_ia32_packsswb _mm_packs_pi16\n#define __builtin_ia32_packssdw _mm_packs_pi32\n#define __builtin_ia32_packuswb _mm_packs_pu16\n#define __builtin_ia32_punpckhbw _mm_unpackhi_pi8\n#define __builtin_ia32_punpckhwd _mm_unpackhi_pi16\n#define __builtin_ia32_punpckhdq _mm_unpackhi_pi32\n#define __builtin_ia32_punpcklbw _mm_unpacklo_pi8\n#define __builtin_ia32_punpcklwd _mm_unpacklo_pi16\n#define __builtin_ia32_punpckldq _mm_unpacklo_pi32\n#define __builtin_ia32_pcmpeqb _mm_cmpeq_pi8\n#define __builtin_ia32_pcmpeqw _mm_cmpeq_pi16\n#define __builtin_ia32_pcmpeqd _mm_cmpeq_pi32\n#define __builtin_ia32_pcmpgtb _mm_cmpgt_pi8\n#define __builtin_ia32_pcmpgtw _mm_cmpgt_pi16\n#define __builtin_ia32_pcmpgtd _mm_cmpgt_pi32\n#define __builtin_ia32_maskmovq _mm_maskmove_si64\n#define __builtin_ia32_movntq _mm_stream_pi\n#define __builtin_ia32_vec_init_v2si _mm_setr_pi32\n#define __builtin_ia32_vec_init_v4hi _mm_setr_pi16\n#define __builtin_ia32_vec_init_v8qi _mm_setr_pi8\n#define __builtin_ia32_cvtpi2ps _mm_cvtpi32_ps\n#define __builtin_ia32_cvtps2pi _mm_cvtps_pi32\n#define __builtin_ia32_cvttps2pi _mm_cvttps_pi32\n#define __builtin_ia32_pavgb _mm_avg_pu8\n#define __builtin_ia32_pavgw _mm_avg_pu16\n#define __builtin_ia32_pmaxsw _mm_max_pi16\n#define __builtin_ia32_pmaxub _mm_max_pu8\n#define __builtin_ia32_pminsw _mm_min_pi16\n#define __builtin_ia32_pminub _mm_min_pu8\n#define __builtin_ia32_pmovmskb _mm_movemask_pi8\n#define __builtin_ia32_pmulhuw _mm_mulhi_pu16\n#define __builtin_ia32_psadbw _mm_sad_pu8\n#define __builtin_ia32_pshufw _mm_shuffle_pi16\n#define __builtin_ia32_cvtpd2pi _mm_cvtpd_pi32\n#define __builtin_ia32_cvtpi2pd _mm_cvtpi32_pd\n#define __builtin_ia32_cvttpd2pi _mm_cvttpd_pi32\n#define __builtin_ia32_paddq _mm_add_si64\n#define __builtin_ia32_pmuludq _mm_mul_su32\n#define __builtin_ia32_psubq _mm_sub_si64\n#define __builtin_ia32_pabsb _mm_abs_pi8\n#define __builtin_ia32_pabsd _mm_abs_pi32\n#define __builtin_ia32_pabsw _mm_abs_pi16\n#define __builtin_ia32_palignr _mm_alignr_pi8\n#define __builtin_ia32_phaddd _mm_hadd_pi32\n#define __builtin_ia32_phaddsw _mm_hadds_pi16\n#define __builtin_ia32_phaddw _mm_hadd_pi16\n#define __builtin_ia32_phsubd _mm_hsub_pi32\n#define __builtin_ia32_phsubsw _mm_hsubs_pi16\n#define __builtin_ia32_phsubw _mm_hsub_pi16\n#define __builtin_ia32_pmaddubsw _mm_maddubs_pi16\n#define __builtin_ia32_pmulhrsw _mm_mulhrs_pi16\n#define __builtin_ia32_pshufb _mm_shuffle_pi8\n#define __builtin_ia32_psignw _mm_sign_pi16\n#define __builtin_ia32_psignb _mm_sign_pi8\n#define __builtin_ia32_psignd _mm_sign_pi32\n");
    }

    private static boolean hasControllingMacroInUserFlags(@NotNull Project project, @NotNull String macroName) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(101);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(102);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        List userFlags = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangFlags(), (String)","), StringUtil::trim);
        return userFlags.contains("-D" + macroName);
    }

    private static void applyUserFlags(@NotNull Project project, @NotNull CidrSwitchBuilder switchBuilder) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(103);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(104);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        List userFlags = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangFlags(), (String)","), StringUtil::trim);
        List disabledWarnings = (List)project.getUserData(ClangdCommonUtil.DISABLED_WARNINGS);
        if (!ContainerUtil.isEmpty((Collection)userFlags)) {
            for (String flag : userFlags) {
                if (ClangUtils.isWarningOption(flag)) {
                    String warnOptName = ClangUtils.getWarningName(flag);
                    if (disabledWarnings != null && disabledWarnings.contains(warnOptName)) continue;
                }
                switchBuilder.addSingleRaw(flag);
            }
        }
    }

    @NotNull
    private static CidrCompilerSwitches filterOutSearchPaths(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(105);
        }
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                PathOptType pathOptType = ClangUtils.getPathOptType(parameter);
                switch (pathOptType) {
                    case NextWithPath: {
                        this.skipOptionValue = true;
                        return false;
                    }
                    case ThisWithPath: {
                        return false;
                    }
                }
                return true;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches.filterOptions((BiFunction)filter);
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(106);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches filterOutAndCollectXClangArgs(@NotNull CidrCompilerSwitches compilerSwitches, final @NotNull List<String> rawArgs) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(107);
        }
        if (rawArgs == null) {
            ClangUtils.$$$reportNull$$$0(108);
        }
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches.filterOptions((BiFunction)new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;

            @Override
            public Boolean apply(@NonNls String param, @NonNls String nextParam) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (param.equals("-Xclang")) {
                    rawArgs.add(param);
                    rawArgs.add(nextParam);
                    this.skipNext = true;
                    return false;
                }
                if (param.startsWith("/clang:") && param.length() > "/clang:".length()) {
                    rawArgs.add(param.substring("/clang:".length()));
                    return false;
                }
                return true;
            }
        });
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(109);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches filterOutErroneousFlags(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(110);
        }
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;
            boolean hasArchArg = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (parameter.equals("-include-pch")) {
                    this.skipNext = true;
                    return false;
                }
                if (parameter.equals("-fconcepts")) {
                    return false;
                }
                if (parameter.equals("-fmodules-ts")) {
                    return false;
                }
                if (parameter.equals("-fbuiltin-module-map")) {
                    return false;
                }
                if (parameter.startsWith("-fprebuilt-module-path=")) {
                    return false;
                }
                if (parameter.startsWith("-mabi=")) {
                    return false;
                }
                if (parameter.startsWith("-mfloat-gprs=")) {
                    return false;
                }
                if (parameter.equals("-arch")) {
                    if (this.hasArchArg) {
                        this.skipNext = true;
                        return false;
                    }
                    this.hasArchArg = true;
                }
                return true;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches.filterOptions((BiFunction)filter);
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(111);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches addSizedDeallocation(@NotNull CidrCompilerSwitches compilerSwitches, @NotNull OCCompilerSettings compilerSettings) {
        OCLanguageStandard featureStd;
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(112);
        }
        if (compilerSettings == null) {
            ClangUtils.$$$reportNull$$$0(113);
        }
        if ((featureStd = (OCLanguageStandard)compilerSettings.getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD)) == null || !featureStd.supports(OCLanguageStandard.CPP14)) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(114);
            }
            return cidrCompilerSwitches;
        }
        List switchesList = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        if (switchesList.contains("-fsized-deallocation")) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(115);
            }
            return cidrCompilerSwitches;
        }
        ArrayList<String> updatedFlags = new ArrayList<String>(switchesList);
        updatedFlags.add("-fsized-deallocation");
        return new CidrCompilerSwitches(updatedFlags);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutOrFixUnknownArguments(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(116);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(117);
        }
        if (ccInfo.getCompilerKind() != MSVCCompilerKind.INSTANCE && ccInfo.getCompilerKind() != ClangClCompilerKind.INSTANCE) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(118);
            }
            return cidrCompilerSwitches;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        List switches = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        boolean addNext = false;
        for (String aSwitch : switches) {
            String parameter = aSwitch.trim();
            if (addNext) {
                filtered.add(parameter);
                addNext = false;
                continue;
            }
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/D", "-D")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/D", "-D")) continue;
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/FI", "-include")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/FI", "-include") || ClangUtils.fixGluedParameter(parameter, filtered, "/std:", "-std=") || ClangUtils.fixGluedParameter(parameter, filtered, "-std:", "-std=") || ClangUtils.isMsvcParam(parameter, "MT") || ClangUtils.isMsvcParam(parameter, "MTd") || ClangUtils.isMsvcParam(parameter, "MD") || ClangUtils.isMsvcParam(parameter, "MDd") || parameter.startsWith("/") || parameter.startsWith("@") || VS_WARNINGS.matcher(parameter).matches() || parameter.equalsIgnoreCase("-bigobj")) continue;
            filtered.add(parameter);
        }
        return filtered.isEmpty() ? CidrCompilerSwitches.EMPTY : new CidrCompilerSwitches(filtered);
    }

    private static boolean fixGluedParameter(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter == null) {
            ClangUtils.$$$reportNull$$$0(119);
        }
        if (filtered == null) {
            ClangUtils.$$$reportNull$$$0(120);
        }
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(121);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(122);
        }
        if (parameter.startsWith(from) && parameter.length() > from.length()) {
            filtered.add(to + parameter.substring(from.length()));
            return true;
        }
        return false;
    }

    private static boolean fixParameterWithArgument(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter == null) {
            ClangUtils.$$$reportNull$$$0(123);
        }
        if (filtered == null) {
            ClangUtils.$$$reportNull$$$0(124);
        }
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(125);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(126);
        }
        if (parameter.equals(from)) {
            filtered.add(to);
            return true;
        }
        return false;
    }

    private static boolean isMsvcParam(@NotNull String param, @NotNull String name) {
        if (param == null) {
            ClangUtils.$$$reportNull$$$0(127);
        }
        if (name == null) {
            ClangUtils.$$$reportNull$$$0(128);
        }
        return param.equalsIgnoreCase("/" + name) || param.equalsIgnoreCase("-" + name);
    }

    private static void addQobjectDefsDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(129);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(130);
        }
        boolean hasQtCore = false;
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (!path.getPath().contains(QT_CORE)) continue;
            hasQtCore = true;
            break;
        }
        if (hasQtCore) {
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath());
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath() + "/QtCore");
        }
    }

    private static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(131);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(132);
        }
        ClangUtils.addIncludeDirectories(info, switchBuilder, info.getRootVirtualFile().getParent(), false);
    }

    private static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder, @Nullable VirtualFile parentDirectory, boolean restrictToClang) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(133);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(134);
        }
        ClangSwitchBuilder clangSwitchBuilder = new ClangSwitchBuilder(switchBuilder);
        if (parentDirectory != null && parentDirectory.isDirectory()) {
            clangSwitchBuilder.withQuoteIncludePath(parentDirectory.getPath());
        }
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (restrictToClang) {
                clangSwitchBuilder.withSwitch("-Xclang");
            }
            clangSwitchBuilder.withHeaderSearchPath(path);
        }
        for (VirtualFile implicitInclude : info.getCompilerSettings().getImplicitIncludes()) {
            clangSwitchBuilder.withForceInclude(implicitInclude.getPath());
        }
    }

    @NotNull
    public static Pair<File, Boolean> getClangdPath() {
        boolean customClangd = true;
        File clangdPath = ClangUtils.getCustomClangdPath();
        if (clangdPath == null) {
            customClangd = false;
            clangdPath = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clangd.exe" : "clangd");
        }
        Pair pair = Pair.create((Object)clangdPath, (Object)customClangd);
        if (pair == null) {
            ClangUtils.$$$reportNull$$$0(135);
        }
        return pair;
    }

    @Nullable
    private static File getCustomClangdPath() {
        String path = System.getProperty(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        path = System.getenv(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    @NotNull
    public static File getBuiltinClangPath(@NonNls @NotNull String relativePath) {
        if (relativePath == null) {
            ClangUtils.$$$reportNull$$$0(136);
        }
        if (PluginManagerCore.isRunningFromSources() && (relativePath.equals("bin/clangd") || relativePath.equals("bin/clangd.exe"))) {
            relativePath = relativePath.substring(4);
            String relPath = CidrPathManager.getPlatformRelativePath((String)relativePath);
            File file = Paths.get(PathManager.getHomePath(), "../../prebuilts/tools/clion/bin/clang", relPath).normalize().toFile();
            if (file == null) {
                ClangUtils.$$$reportNull$$$0(137);
            }
            return file;
        }
        File file = CidrPathManager.getBinPath(ClangUtils.class, (String)"cidr-lang/bin", (String)("clang/" + CidrPathManager.getPlatformRelativePath((String)relativePath)), null).toFile();
        if (file == null) {
            ClangUtils.$$$reportNull$$$0(138);
        }
        return file;
    }

    @NotNull
    public static File getBuiltinClangToolPath(@NonNls @NotNull String toolName) {
        if (toolName == null) {
            ClangUtils.$$$reportNull$$$0(139);
        }
        return ClangUtils.getBuiltinClangPath("bin/" + toolName);
    }

    public static String getWslClangdDirPath(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(140);
        }
        if (clangdRevision.get().isEmpty()) {
            try {
                ((CompletableFuture)ClangUtils.getClangToolVersionAsync("clangd", ClangUtils.getBuiltinClangToolPath("clangd").getPath()).thenAccept(output2 -> {
                    Matcher matcher;
                    Matcher matcher2 = matcher = StringUtil.isNotEmpty((String)output2) ? VERSION_PATTERN.matcher((CharSequence)output2) : null;
                    if (matcher == null || !matcher.matches()) {
                        return;
                    }
                    clangdRevision.set(matcher.group(3));
                })).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Timeout. Could not get clangd revision.");
            }
        }
        return WSL_CLANGD_DIR_BASE_PATH + clangdRevision.get();
    }

    @NotNull
    @NonNls
    private static String getClangCudaHeaderDir(@NotNull ClangUrlConverter converter, @NotNull Project project) {
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(141);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(142);
        }
        File includeDir = ClangUtils.getBuiltinClangPath("include");
        File cudaIncludesDir = ClangUtils.getBuiltinClangPath("cuda_includes");
        boolean isWSL = converter.isWslMode();
        if (includeDir.exists()) {
            String string = isWSL ? converter.fromWslPath(ClangUtils.getWslClangdDirPath(project) + "/include") : includeDir.getAbsolutePath();
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(143);
            }
            return string;
        }
        String string = isWSL ? converter.fromWslPath(ClangUtils.getWslClangdDirPath(project) + "/cuda_includes") : cudaIncludesDir.getAbsolutePath();
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(144);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getClangHeaderDir(boolean isWSL, @NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(145);
        }
        Object object = isWSL ? ClangUtils.getWslClangdDirPath(project) + "/include" : ClangUtils.getBuiltinClangPath("include").getAbsolutePath();
        if (object == null) {
            ClangUtils.$$$reportNull$$$0(146);
        }
        return object;
    }

    private static boolean isWarningOption(@NonNls @NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(147);
        }
        return option.startsWith("-W");
    }

    private static boolean isWarningOptionOn(@NonNls @NotNull String warning) {
        if (warning == null) {
            ClangUtils.$$$reportNull$$$0(148);
        }
        assert (ClangUtils.isWarningOption(warning));
        return !warning.startsWith("-Wno-");
    }

    private static boolean isWarningOptionOff(@NonNls @NotNull String warning) {
        if (warning == null) {
            ClangUtils.$$$reportNull$$$0(149);
        }
        return !ClangUtils.isWarningOptionOn(warning);
    }

    @NotNull
    @NlsSafe
    private static String getWarningName(@NotNull @NlsSafe String warningOption) {
        if (warningOption == null) {
            ClangUtils.$$$reportNull$$$0(150);
        }
        assert (ClangUtils.isWarningOption(warningOption));
        String string = ClangUtils.isWarningOptionOn(warningOption) ? warningOption.substring("-W".length()) : warningOption.substring("-Wno-".length());
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(151);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOn(@NotNull @NlsSafe String warningOptName) {
        if (warningOptName == null) {
            ClangUtils.$$$reportNull$$$0(152);
        }
        assert (!ClangUtils.isWarningOption(warningOptName));
        String string = "-W" + warningOptName;
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(153);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOff(@NotNull @NlsSafe String warningOptName) {
        if (warningOptName == null) {
            ClangUtils.$$$reportNull$$$0(154);
        }
        assert (!ClangUtils.isWarningOption(warningOptName));
        String string = "-Wno-" + warningOptName;
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(155);
        }
        return string;
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(156);
        }
        if (logTask == null) {
            ClangUtils.$$$reportNull$$$0(157);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.warn(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(158);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(159);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(msg);
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Throwable ex) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(160);
        }
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(161);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(ex);
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(162);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(163);
        }
        if (ClangDebugLevel.isInfoOrMore()) {
            logger.info(msg);
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(164);
        }
        if (logTask == null) {
            ClangUtils.$$$reportNull$$$0(165);
        }
        if (ClangDebugLevel.isTraceOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(166);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(167);
        }
        if (ClangDebugLevel.isTraceOrMore()) {
            logger.info(msg);
        }
    }

    public static void putCustomCommand(@NotNull Project project, @NotNull String forFile, @NotNull List<String> cmdLine) {
        HashMap<String, List<String>> commandsMap;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(168);
        }
        if (forFile == null) {
            ClangUtils.$$$reportNull$$$0(169);
        }
        if (cmdLine == null) {
            ClangUtils.$$$reportNull$$$0(170);
        }
        if ((commandsMap = (HashMap<String, List<String>>)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS)) == null) {
            commandsMap = new HashMap<String, List<String>>();
            project.putUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS, commandsMap);
        }
        commandsMap.put(forFile, cmdLine);
    }

    public static boolean isClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(171);
        }
        if (!ClangdBridge.isClangdKindSupported(ClangLanguageService.Kind.Clangd)) {
            return false;
        }
        if (!ClangUtils.isClangdAllowed(project)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_ON, project)) {
            return ClangUtils.getKey(CLANGD_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn();
    }

    public static void forceClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(172);
        }
        project.putUserData(CLANGD_ON, (Object)true);
    }

    public static void forceClangdOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(173);
        }
        project.putUserData(CLANGD_ON, (Object)false);
    }

    public static void nonForceClangd(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(174);
        }
        project.putUserData(CLANGD_ON, null);
    }

    public static boolean isClangdIndexerOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(175);
        }
        if (!ClangdBridge.isClangdKindSupported(ClangLanguageService.Kind.Indexer)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_INDEXER_ON, project)) {
            return ClangUtils.getKey(CLANGD_INDEXER_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isIndexerOn();
    }

    public static boolean isClangdStatelessIndexerOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(176);
        }
        if (!ClangdBridge.isClangdKindSupported(ClangLanguageService.Kind.StatelessIndexer)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_STATELESS_INDEXER_ON, project)) {
            return ClangUtils.getKey(CLANGD_STATELESS_INDEXER_ON, project);
        }
        return Registry.is((String)"clion.clang.clangd.index.stateless.on");
    }

    @TestOnly
    public static void forceClangdIndexerOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(177);
        }
        project.putUserData(CLANGD_INDEXER_ON, (Object)true);
    }

    @TestOnly
    public static void forceClangdStatelessIndexerOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(178);
        }
        project.putUserData(CLANGD_STATELESS_INDEXER_ON, (Object)true);
    }

    @TestOnly
    public static void forceClangdIndexerOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(179);
        }
        project.putUserData(CLANGD_INDEXER_ON, (Object)false);
    }

    @TestOnly
    public static void nonForceClangdIndexer(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(180);
        }
        project.putUserData(CLANGD_INDEXER_ON, null);
    }

    public static boolean isClangTidyViaClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(181);
        }
        if (ClangUtils.hasKey(CLANGD_CLANG_TIDY_ON, project)) {
            return ClangUtils.getKey(CLANGD_CLANG_TIDY_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn() && settings.isClangTidyViaClangd();
    }

    @TestOnly
    public static void forceClangTidyViaClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(182);
        }
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)true);
    }

    @TestOnly
    public static void forceClangTidyViaClangdOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(183);
        }
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)false);
    }

    public static boolean isClangTidyViaClangdForced(@Nullable Project project) {
        return project != null && project.getUserData(CLANGD_CLANG_TIDY_ON) != null;
    }

    public static void forceClangdShowErrorsOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(184);
        }
        project.putUserData(ClangdBridge.CLANGD_SHOW_ERRORS_ON, (Object)true);
    }

    public static void forceClangdShowErrorsOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(185);
        }
        project.putUserData(ClangdBridge.CLANGD_SHOW_ERRORS_ON, (Object)false);
    }

    public static void nonForceClangdShowErrors(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(186);
        }
        project.putUserData(ClangdBridge.CLANGD_SHOW_ERRORS_ON, null);
    }

    public static void forceClangdNavigationOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(187);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)true);
    }

    public static void forceClangdNavigationOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(188);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)false);
    }

    public static void stopForcingClangdNavigation(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(189);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, null);
    }

    public static boolean isNavigationViaClangd(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(190);
        }
        if (ClangUtils.hasKey(CLANGD_NAVIGATION_ON, project)) {
            return ClangUtils.getKey(CLANGD_NAVIGATION_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isNavigationViaClangd();
    }

    public static boolean isParameterInfoViaClangd(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(191);
        }
        if (ClangUtils.hasKey(CLANGD_PARAMETER_INFO_ON, project)) {
            return ClangUtils.getKey(CLANGD_PARAMETER_INFO_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isParameterInfoViaClangd();
    }

    public static boolean hasKey(@NotNull Key<?> projectKey, @Nullable Project project) {
        if (projectKey == null) {
            ClangUtils.$$$reportNull$$$0(192);
        }
        if (project != null) {
            Object forced = project.getUserData(projectKey);
            return forced != null;
        }
        return false;
    }

    public static boolean getKey(@NotNull Key<Boolean> projectKey, @Nullable Project project) {
        Boolean forced;
        if (projectKey == null) {
            ClangUtils.$$$reportNull$$$0(193);
        }
        if (project != null && (forced = (Boolean)project.getUserData(projectKey)) != null) {
            return forced;
        }
        return false;
    }

    @NotNull
    public static String renderHumanReadableSize(long bytes) {
        double dblBytes;
        String[] suffix = new String[]{"B", "KB", "MB", "GB", "TB"};
        int i = 0;
        for (dblBytes = (double)bytes; dblBytes >= 1024.0 && i < suffix.length - 1; dblBytes /= 1024.0, ++i) {
        }
        String string = String.format("%.2f %s", dblBytes, suffix[i]);
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(194);
        }
        return string;
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException {
        Supplier supplier;
        if (future == null) {
            ClangUtils.$$$reportNull$$$0(195);
        }
        return (supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(future, (String)"clang future")) != null ? (T)supplier.get() : null;
    }

    private static boolean isServerException(@NotNull ExecutionException ex) {
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(196);
        }
        return ex.getCause() instanceof JsonRpcException || ex.getCause() instanceof ResponseErrorException && Objects.equals("invalid AST", ex.getCause().getMessage()) || ex.getCause() instanceof ResponseErrorException && ex.getCause().getMessage() != null && ex.getCause().getMessage().startsWith("Request cancelled");
    }

    public static void logServerException(@NotNull Logger logger, @NotNull String message, @NotNull ExecutionException ex) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(197);
        }
        if (message == null) {
            ClangUtils.$$$reportNull$$$0(198);
        }
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(199);
        }
        if (ClangUtils.isServerException(ex)) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)message, (Throwable)ex);
        } else if (ex.getCause() instanceof TimeoutException) {
            logger.warn(message, (Throwable)ex);
        } else {
            logger.error(message, (Throwable)ex);
        }
    }

    public static void logIfServerExceptionOrRethrow(@NotNull ExecutionException ex) throws ExecutionException {
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(200);
        }
        if (!ClangUtils.isServerException(ex)) {
            throw ex;
        }
        CidrLogService.logOnce((Level)Level.WARNING, (String)ex.getMessage(), (Throwable)ex);
    }

    public static void subscribeToStyleChanges(final @NotNull ClangdLanguageServiceProvider provider2, final @NotNull Project project) {
        if (provider2 == null) {
            ClangUtils.$$$reportNull$$$0(201);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(202);
        }
        final Ref headerExtensions = new Ref((Object)ClangUtils.getCurrentHeaderExtensions(project));
        CodeStyleSettingsManager.getInstance((Project)project).subscribe(new CodeStyleSettingsListener(){

            public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
                String currentHeaderExtensions;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!(currentHeaderExtensions = ClangUtils.getCurrentHeaderExtensions(project)).equals(headerExtensions.get())) {
                    headerExtensions.set((Object)currentHeaderExtensions);
                    ClangLanguageService service = provider2.getIfStarted();
                    if (service != null) {
                        service.shutDownServer();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$4", "codeStyleSettingsChanged"));
            }
        });
    }

    public static String getCurrentHeaderExtensions(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(203);
        }
        List<FileExtensionPair> extensionPairs = ClangdBridge.getFileExtensions(project);
        StringBuilder headerExtBuilder = new StringBuilder();
        for (FileExtensionPair extensionPair : extensionPairs) {
            headerExtBuilder.append(extensionPair.myHeaderExt).append(';');
        }
        return headerExtBuilder.toString();
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        if (checks == null) {
            ClangUtils.$$$reportNull$$$0(204);
        }
        if (checkOptions == null) {
            ClangUtils.$$$reportNull$$$0(205);
        }
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangUtils.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        String string = rootObject.toString();
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(206);
        }
        return string;
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        if (check == null) {
            ClangUtils.$$$reportNull$$$0(207);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            ClangUtils.$$$reportNull$$$0(208);
        }
        return jsonObject2;
    }

    public static <T> void tie(@NotNull CompletableFuture<T> first, @NotNull CompletableFuture<T> second) {
        if (first == null) {
            ClangUtils.$$$reportNull$$$0(209);
        }
        if (second == null) {
            ClangUtils.$$$reportNull$$$0(210);
        }
        ClangUtils.propagate(first, second);
        ClangUtils.propagate(second, first);
    }

    private static <T> void propagate(@NotNull CompletableFuture<T> from, @NotNull CompletableFuture<T> to) {
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(211);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(212);
        }
        from.whenComplete((res, ex) -> {
            if (!to.isDone()) {
                if (ex != null) {
                    to.completeExceptionally((Throwable)ex);
                } else {
                    to.complete(res);
                }
            }
        });
    }

    public static CompletableFuture<String> getClangToolVersionAsync(@NotNull String toolName, @NotNull String path) {
        if (toolName == null) {
            ClangUtils.$$$reportNull$$$0(213);
        }
        if (path == null) {
            ClangUtils.$$$reportNull$$$0(214);
        }
        LOG.info("Checking " + toolName + " version (" + path + ")");
        return ClangToolsUtilKt.getClangToolVersion(path);
    }

    public static int skipPreamble(@Nullable Document document) {
        return document != null ? ClangUtils.skipPreamble(document.getImmutableCharSequence()) : 0;
    }

    public static int skipPreamble(@Nullable CharSequence sequence) {
        if (sequence == null) {
            return 0;
        }
        int i = 0;
        while (i < sequence.length()) {
            char chr = sequence.charAt(i);
            if (chr == '#') {
                i = ClangUtils.skipDirective(sequence, i);
                continue;
            }
            int nextI = ClangUtils.skipBlockComment(sequence, i);
            if (nextI != i) {
                i = nextI;
                continue;
            }
            nextI = ClangUtils.skipLineComment(sequence, i);
            if (nextI != i) {
                i = nextI;
                continue;
            }
            if (chr != '\n') break;
            i = ClangUtils.nextSignificantChar(sequence, i + 1);
        }
        int lines = 0;
        for (int k = 0; k < i; ++k) {
            if (sequence.charAt(k) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private static int skipDirective(@NotNull CharSequence sequence, int i) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(215);
        }
        if (ClangUtils.startsWith(sequence, i, '#')) {
            ++i;
            while (i < sequence.length()) {
                int prevIndex;
                int nextI = ClangUtils.skipBlockComment(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipLineComment(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipCharLiteral(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipStringLiteral(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                if (i < sequence.length() && sequence.charAt(i) == '\n' && sequence.charAt(prevIndex = ClangUtils.prevSignificantChar(sequence, i - 1)) != '\\') {
                    return i + 1;
                }
                i = ClangUtils.nextSignificantChar(sequence, i + 1);
            }
        }
        return i;
    }

    private static int skipBlockComment(@NotNull CharSequence sequence, int i) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(216);
        }
        if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"/*")) {
            i += 2;
            while (i < sequence.length()) {
                if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"*/")) {
                    return i + 2;
                }
                ++i;
            }
        }
        return i;
    }

    private static int skipLineComment(@NotNull CharSequence sequence, int i) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(217);
        }
        if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"//")) {
            return ClangUtils.skipUntil(sequence, i, '\n');
        }
        return i;
    }

    private static int skipStringLiteral(@NotNull CharSequence sequence, int i) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(218);
        }
        if (ClangUtils.startsWith(sequence, i, '\"')) {
            return ClangUtils.skipUntil(sequence, i, '\"');
        }
        return i;
    }

    private static int skipCharLiteral(@NotNull CharSequence sequence, int i) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(219);
        }
        if (ClangUtils.startsWith(sequence, i, '\'')) {
            return ClangUtils.skipUntil(sequence, i, '\'');
        }
        return i;
    }

    private static int nextSignificantChar(@NotNull CharSequence sequence, int i) {
        char c;
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(220);
        }
        while (i < sequence.length() && Character.isWhitespace(c = sequence.charAt(i)) && c != '\n') {
            ++i;
        }
        return i;
    }

    private static int prevSignificantChar(@NotNull CharSequence sequence, int i) {
        char c;
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(221);
        }
        while (i > 0 && Character.isWhitespace(c = sequence.charAt(i)) && c != '\n') {
            --i;
        }
        return i;
    }

    private static int skipUntil(@NotNull CharSequence sequence, int i, char targetChar) {
        if (sequence == null) {
            ClangUtils.$$$reportNull$$$0(222);
        }
        boolean escaped = false;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == targetChar) {
                return i + 1;
            }
            i = ClangUtils.nextSignificantChar(sequence, i + 1);
        }
        return i;
    }

    private static boolean startsWith(@NotNull CharSequence seq, int startIndex, char chr) {
        if (seq == null) {
            ClangUtils.$$$reportNull$$$0(223);
        }
        return startIndex < seq.length() && seq.charAt(startIndex) == chr;
    }

    @Nullable
    public static TextRange findIdentifierRange(@NotNull CharSequence text, int offset) {
        if (text == null) {
            ClangUtils.$$$reportNull$$$0(224);
        }
        if (offset >= 0 && offset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(offset))) {
            int curOffset;
            for (curOffset = offset; curOffset >= 0 && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); --curOffset) {
            }
            ++curOffset;
            while (Character.isDigit(text.charAt(curOffset)) && curOffset < offset) {
                ++curOffset;
            }
            if (ClangUtils.isCppIdentifierStart(text.charAt(curOffset))) {
                int startRange = curOffset;
                for (curOffset = offset; curOffset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); ++curOffset) {
                }
                int endRange = curOffset;
                return new TextRange(startRange, endRange);
            }
        }
        return null;
    }

    private static boolean isCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean clangdCopyInWslExists(@NotNull String wslMsId, @NotNull Project project) {
        if (wslMsId == null) {
            ClangUtils.$$$reportNull$$$0(225);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(226);
        }
        if (copyToWSLInProgress.get()) {
            return false;
        }
        String tmpWslClangdPath = ClangUtils.getSystemIndependentUNCPrefix() + wslMsId + ClangUtils.getWslClangdDirPath(project);
        return FileUtil.exists((String)tmpWslClangdPath);
    }

    @NotNull
    public static String getSystemIndependentUNCPrefix() {
        return SystemInfo.isWin11OrNewer ? SYSTEM_INDEPENDENT_WSL_LOCALHOST_PREFIX : SYSTEM_INDEPENDENT_UNC_PREFIX;
    }

    public static boolean startsWithAnyUNCPrefix(@NotNull String path) {
        if (path == null) {
            ClangUtils.$$$reportNull$$$0(227);
        }
        return path.startsWith(SYSTEM_INDEPENDENT_WSL_LOCALHOST_PREFIX) || path.startsWith(SYSTEM_INDEPENDENT_UNC_PREFIX);
    }

    @NotNull
    public static String pathWithoutUNCPrefix(@NotNull String path) {
        if (path == null) {
            ClangUtils.$$$reportNull$$$0(228);
        }
        if (path.startsWith(SYSTEM_INDEPENDENT_WSL_LOCALHOST_PREFIX)) {
            String string = path.substring(SYSTEM_INDEPENDENT_WSL_LOCALHOST_PREFIX.length());
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(229);
            }
            return string;
        }
        if (path.startsWith(SYSTEM_INDEPENDENT_UNC_PREFIX)) {
            String string = path.substring(SYSTEM_INDEPENDENT_UNC_PREFIX.length());
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(230);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(231);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9, 10, 14, 33, 34, 36, 47, 54, 55, 68, 71, 72, 75, 84, 87, 88, 106, 109, 111, 114, 115, 118, 135, 137, 138, 143, 144, 146, 151, 153, 155, 194, 206, 208, 229, 230, 231 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 2: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 66: 
            case 77: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 33: 
            case 34: 
            case 36: 
            case 47: 
            case 54: 
            case 55: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 84: 
            case 87: 
            case 88: 
            case 106: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 118: 
            case 135: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 146: 
            case 151: 
            case 153: 
            case 155: 
            case 194: 
            case 206: 
            case 208: 
            case 229: 
            case 230: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: 
            case 15: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformed";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 18: 
            case 24: 
            case 27: 
            case 59: 
            case 62: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToMacrosFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20Paths";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVirtualFile";
                break;
            }
            case 26: 
            case 129: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 28: 
            case 31: 
            case 39: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 76: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ccInfo";
                break;
            }
            case 29: 
            case 38: 
            case 41: 
            case 49: 
            case 52: 
            case 58: 
            case 61: 
            case 64: 
            case 79: 
            case 104: 
            case 130: 
            case 132: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBuilder";
                break;
            }
            case 30: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 32: 
            case 35: 
            case 51: 
            case 56: 
            case 67: 
            case 78: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 43: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "std";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 90: 
            case 92: 
            case 94: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawArgs";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSettings";
                break;
            }
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filtered";
                break;
            }
            case 121: 
            case 125: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 122: 
            case 126: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 139: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 148: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningOption";
                break;
            }
            case 152: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningOptName";
                break;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 157: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logTask";
                break;
            }
            case 159: 
            case 163: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 161: 
            case 196: 
            case 199: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFile";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 192: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectKey";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 214: 
            case 227: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslMsId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPPDefines";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitCommandLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findHeadersSearchPaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathOptType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addGccConceptsIfNeeded";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExperimentalCoroutines";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getGNUCVersions";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerKind";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "addLanguageStandardIfNeeded";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackLanguageStandard";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "setLangStandard";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "detectOS";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "detectEnvironment";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutSearchPaths";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutAndCollectXClangArgs";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutErroneousFlags";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "addSizedDeallocation";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutOrFixUnknownArguments";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdPath";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClangPath";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangCudaHeaderDir";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangHeaderDir";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningName";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningOn";
                break;
            }
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningOff";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "renderHumanReadableSize";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyConfig";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "toJsonObject";
                break;
            }
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "pathWithoutUNCPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClangdAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBlacklistedPPDefine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterPPDefines";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 33: 
            case 34: 
            case 36: 
            case 47: 
            case 54: 
            case 55: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 84: 
            case 87: 
            case 88: 
            case 106: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 118: 
            case 135: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 146: 
            case 151: 
            case 153: 
            case 155: 
            case 194: 
            case 206: 
            case 208: 
            case 229: 
            case 230: 
            case 231: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCLionCompilationInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findHeadersSearchPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnyResolveConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "headerSearchPathsForProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPathOptType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPathOptInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPreparedCompilerOptions";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationCommand";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFromIncludedFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationCommand";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addCompilerSwitches";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addNoDefineTargetOSMacros";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addGccConceptsIfNeeded";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "translateExperimentalCoroutines";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addGnuCVersionIfNeeded";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addGccArmSveSupportIfNeeded";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasMacro";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyMacro";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getGNUCVersions";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addCudaSwitches";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addInputLanguageIfNeeded";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerKind";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isCpp17OrLater";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addCompatibilityModeIfNeeded";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addCudaPathIfNeeded";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addCudaIncludeIfNeeded";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageStandardIfNeeded";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackLanguageStandard";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setLangStandard";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addTargetIfNeeded";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "detectArchitecture";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "detectOS";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "detectEnvironment";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueOfMacro";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getIntValueOfMacro";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getIntValueOfMacroOr";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "preparePreprocessorDefines";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "undefStaticCallOperatorUnlessPresent";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "appendArchitectureDefinesIfNeeded";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "appendUnsupportedBuiltins2Intrinsics";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "hasControllingMacroInUserFlags";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "applyUserFlags";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "filterOutSearchPaths";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "filterOutAndCollectXClangArgs";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "filterOutErroneousFlags";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "addSizedDeallocation";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "filterOutOrFixUnknownArguments";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "fixGluedParameter";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "fixParameterWithArgument";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isMsvcParam";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "addQobjectDefsDirectories";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "addIncludeDirectories";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinClangPath";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinClangToolPath";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getWslClangdDirPath";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getClangCudaHeaderDir";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getClangHeaderDir";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOption";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOptionOn";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOptionOff";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "getWarningName";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "makeWarningOn";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "makeWarningOff";
                break;
            }
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "warnClangd";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "infoClangd";
                break;
            }
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "traceClangd";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "putCustomCommand";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "isClangdOn";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdOn";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdOff";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "nonForceClangd";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "isClangdIndexerOn";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "isClangdStatelessIndexerOn";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdIndexerOn";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdStatelessIndexerOn";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdIndexerOff";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "nonForceClangdIndexer";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "isClangTidyViaClangdOn";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "forceClangTidyViaClangdOn";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "forceClangTidyViaClangdOff";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdShowErrorsOn";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdShowErrorsOff";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "nonForceClangdShowErrors";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdNavigationOn";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdNavigationOff";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "stopForcingClangdNavigation";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "isNavigationViaClangd";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "isParameterInfoViaClangd";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "hasKey";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "waitForClangFuture";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "isServerException";
                break;
            }
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "logServerException";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "logIfServerExceptionOrRethrow";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToStyleChanges";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHeaderExtensions";
                break;
            }
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "toJsonObject";
                break;
            }
            case 209: 
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "tie";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "propagate";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "getClangToolVersionAsync";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "skipDirective";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "skipBlockComment";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "skipLineComment";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "skipStringLiteral";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "skipCharLiteral";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "nextSignificantChar";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "prevSignificantChar";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "skipUntil";
                break;
            }
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "findIdentifierRange";
                break;
            }
            case 225: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "clangdCopyInWslExists";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "startsWithAnyUNCPrefix";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "pathWithoutUNCPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9, 10, 14, 33, 34, 36, 47, 54, 55, 68, 71, 72, 75, 84, 87, 88, 106, 109, 111, 114, 115, 118, 135, 137, 138, 143, 144, 146, 151, 153, 155, 194, 206, 208, 229, 230, 231 -> new IllegalStateException(string);
        };
    }

    public static class ResolveInfo {
        @NotNull
        public final OCResolveConfiguration configuration;
        @NotNull
        public final VirtualFile root;
        @NotNull
        public final OCLanguageKind languageKind;
        public final boolean guessed;

        public ResolveInfo(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @NotNull OCLanguageKind languageKind, boolean guessed) {
            if (configuration == null) {
                ResolveInfo.$$$reportNull$$$0(0);
            }
            if (root == null) {
                ResolveInfo.$$$reportNull$$$0(1);
            }
            if (languageKind == null) {
                ResolveInfo.$$$reportNull$$$0(2);
            }
            this.configuration = configuration;
            this.root = root;
            this.languageKind = languageKind;
            this.guessed = guessed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageKind";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class PathOptInfo {
        @NotNull
        public final PathOptType type;
        @NlsSafe
        @NotNull
        public final String opt;

        public PathOptInfo(@NotNull PathOptType type, @NlsSafe @NotNull String opt) {
            if (type == null) {
                PathOptInfo.$$$reportNull$$$0(0);
            }
            if (opt == null) {
                PathOptInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.opt = opt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "opt";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$PathOptInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PathOptType {
        ThisWithPath,
        NextWithPath,
        NotAPathOpt;

    }

    private static final class ClangCompilationCommand {
        @NotNull
        private final VirtualFile inputFile;
        @NotNull
        private final VirtualFile entryFile;
        @NotNull
        private final String workingDir;
        @NotNull
        private final String compilerExecutable;
        @NotNull
        private final List<String> compilerOptions;
        @Nullable
        private final String preprocessorDefines;

        ClangCompilationCommand(@NotNull VirtualFile inputFile, @NotNull VirtualFile entryFile, @NotNull String workingDir, @NotNull String compilerExecutable, @NotNull List<String> compilerOptions, @Nullable String defines) {
            if (inputFile == null) {
                ClangCompilationCommand.$$$reportNull$$$0(0);
            }
            if (entryFile == null) {
                ClangCompilationCommand.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                ClangCompilationCommand.$$$reportNull$$$0(2);
            }
            if (compilerExecutable == null) {
                ClangCompilationCommand.$$$reportNull$$$0(3);
            }
            if (compilerOptions == null) {
                ClangCompilationCommand.$$$reportNull$$$0(4);
            }
            this.inputFile = inputFile;
            this.entryFile = entryFile;
            this.workingDir = workingDir;
            this.compilerExecutable = compilerExecutable;
            this.compilerOptions = Collections.unmodifiableList(compilerOptions);
            this.preprocessorDefines = defines;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerExecutable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerOptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$ClangCompilationCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

