/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.idea.ndk.NativeHeaderDir;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fH\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0011H\u0007J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0015\u001a\u00020\nJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/ndk/sync/NativeHeaderDirCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "headerDirsByModule", "", "Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "", "Lcom/android/tools/idea/ndk/NativeHeaderDir;", "headerDirFiles", "Ljava/util/TreeSet;", "Ljava/nio/file/Path;", "jniHeaderFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "refresh", "", "add", "moduleVariantAbi", "nativeHeaderDir", "addJniHeader", "virtualFile", "getNativeHeaderDirs", "", "module", "", "getJniHeaders", "isUnderSomeNativeHeaderDir", "", "file", "Ljava/io/File;", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nNativeHeaderDirCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeHeaderDirCache.kt\ncom/android/tools/ndk/sync/NativeHeaderDirCache\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,100:1\n3829#2:101\n4344#2,2:102\n1863#3,2:104\n487#4,7:106\n*S KotlinDebug\n*F\n+ 1 NativeHeaderDirCache.kt\ncom/android/tools/ndk/sync/NativeHeaderDirCache\n*L\n72#1:101\n72#1:102,2\n73#1:104,2\n85#1:106,7\n*E\n"})
public final class NativeHeaderDirCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ModuleVariantAbi, Set<NativeHeaderDir>> headerDirsByModule;
    @NotNull
    private final TreeSet<Path> headerDirFiles;
    @NotNull
    private final Set<VirtualFile> jniHeaderFiles;

    public NativeHeaderDirCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.headerDirsByModule = new LinkedHashMap();
        this.headerDirFiles = SetsKt.sortedSetOf((Object[])new Path[0]);
        this.jniHeaderFiles = new LinkedHashSet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void refresh() {
        if (LanguageUtils.Companion.getInstance().isCppSupportDisabled(this.project)) {
            return;
        }
        this.headerDirsByModule.clear();
        this.headerDirFiles.clear();
        this.jniHeaderFiles.clear();
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        OCWorkspace ocWorkspace = oCWorkspace;
        for (OCResolveConfiguration configuration : ocWorkspace.getConfigurations()) {
            ModuleVariantAbi moduleVariantAbi;
            Intrinsics.checkNotNull((Object)configuration);
            if (CxxSyncUtilsKt.getModuleVariantAbi(configuration) == null) continue;
            configuration.getAllCompilerSettings().flatMap(arg_0 -> NativeHeaderDirCache.refresh$lambda$1(NativeHeaderDirCache::refresh$lambda$0, arg_0)).map(arg_0 -> NativeHeaderDirCache.refresh$lambda$3(NativeHeaderDirCache::refresh$lambda$2, arg_0)).forEach(arg_0 -> NativeHeaderDirCache.refresh$lambda$5(arg_0 -> NativeHeaderDirCache.refresh$lambda$4(this, moduleVariantAbi, arg_0), arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void add(@NotNull ModuleVariantAbi moduleVariantAbi, @NotNull NativeHeaderDir nativeHeaderDir) {
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter((Object)moduleVariantAbi, (String)"moduleVariantAbi");
        Intrinsics.checkNotNullParameter((Object)nativeHeaderDir, (String)"nativeHeaderDir");
        Set set = this.headerDirsByModule.computeIfAbsent(moduleVariantAbi, arg_0 -> NativeHeaderDirCache.add$lambda$7(NativeHeaderDirCache::add$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set nativeHeaderDirs = set;
        nativeHeaderDirs.add(nativeHeaderDir);
        File headerDir = nativeHeaderDir.getDir().getAbsoluteFile();
        this.headerDirFiles.add(headerDir.toPath());
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(headerDir.toPath());
        if (virtualFile != null && (virtualFileArray = virtualFile.getChildren()) != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"jni.h")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile p0 = (VirtualFile)element$iv;
                boolean bl = false;
                this.addJniHeader(p0);
            }
        }
    }

    @VisibleForTesting
    public final void addJniHeader(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ((Collection)this.jniHeaderFiles).add(virtualFile);
    }

    @NotNull
    public final Set<NativeHeaderDir> getNativeHeaderDirs(@NotNull ModuleVariantAbi moduleVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)moduleVariantAbi, (String)"moduleVariantAbi");
        Set set = this.headerDirsByModule.get(moduleVariantAbi);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<NativeHeaderDir> getNativeHeaderDirs(@NotNull String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<ModuleVariantAbi, Set<NativeHeaderDir>> $this$filterKeys$iv = this.headerDirsByModule;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ModuleVariantAbi, Set<NativeHeaderDir>> result$iv = new LinkedHashMap<ModuleVariantAbi, Set<NativeHeaderDir>>();
        for (Map.Entry<ModuleVariantAbi, Set<NativeHeaderDir>> entry$iv : $this$filterKeys$iv.entrySet()) {
            ModuleVariantAbi moduleVariantAbi = entry$iv.getKey();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)moduleVariantAbi.getModuleName(), (Object)module)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((Map)result$iv).values()));
    }

    @NotNull
    public final Set<VirtualFile> getJniHeaders() {
        return this.jniHeaderFiles;
    }

    public final boolean isUnderSomeNativeHeaderDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.getAbsoluteFile().toPath();
        Path path2 = this.headerDirFiles.floor(path);
        if (path2 == null) {
            return false;
        }
        Path prefix = path2;
        return Intrinsics.areEqual((Object)path, (Object)prefix) || path.startsWith(prefix);
    }

    private static final Stream refresh$lambda$0(OCCompilerSettings it) {
        return it.getHeadersSearchPaths().stream();
    }

    private static final Stream refresh$lambda$1(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final NativeHeaderDir refresh$lambda$2(HeadersSearchPath it) {
        File dir = new File(it.getPath());
        return new NativeHeaderDir(dir, it.isBuiltInHeaders(), it.getKind() == HeadersSearchPath.Kind.USER);
    }

    private static final NativeHeaderDir refresh$lambda$3(Function1 $tmp0, Object p0) {
        return (NativeHeaderDir)$tmp0.invoke(p0);
    }

    private static final Unit refresh$lambda$4(NativeHeaderDirCache this$0, ModuleVariantAbi $moduleVariantAbi, NativeHeaderDir it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.add($moduleVariantAbi, it);
        return Unit.INSTANCE;
    }

    private static final void refresh$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Set add$lambda$6(ModuleVariantAbi it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set add$lambda$7(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/sync/NativeHeaderDirCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/ndk/sync/NativeHeaderDirCache;", "project", "Lcom/intellij/openapi/project/Project;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeHeaderDirCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion $this$getInstance_u24lambda_u240 = this;
            boolean bl = false;
            NativeHeaderDirCache nativeHeaderDirCache = (NativeHeaderDirCache)project.getService(NativeHeaderDirCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)nativeHeaderDirCache, (String)"run(...)");
            return nativeHeaderDirCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

