/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.repository.Revision;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.idea.ndk.NativeCompilerSetting;
import com.android.tools.idea.ndk.NativeWorkspaceService;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.LaunchNativeDebuggerNotifier;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0003\u00a8\u0006\r"}, d2={"getClientABIs", "", "Lcom/android/sdklib/devices/Abi;", "client", "Lcom/android/ddmlib/Client;", "verify", "", "project", "Lcom/intellij/openapi/project/Project;", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "maybeShowBrokenNdkMessage", "checkRunAsUnderRestrictedUser", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/android/tools/ndk/run/lldb/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1611#2,9:110\n1863#2:119\n1864#2:121\n1620#2:122\n774#2:123\n865#2,2:124\n1755#2,3:126\n1#3:120\n1#3:129\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/android/tools/ndk/run/lldb/UtilsKt\n*L\n43#1:110,9\n43#1:119\n43#1:121\n43#1:122\n50#1:123\n50#1:124,2\n68#1:126,3\n43#1:120\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Abi> getClientABIs(@NotNull Client client) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Logger logger = Logger.getInstance((String)"getClientABIs");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger LOG = logger;
        String string = client.getClientData().getAbi();
        int clientAddrByteSize = (string != null ? StringsKt.startsWith$default((String)string, (String)"64-bit", (boolean)false, (int)2, null) : false) ? 8 : 4;
        List list = client.getDevice().getAbis();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAbis(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Abi it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Abi abi = Abi.getEnum((String)it);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + it);
            }
            if (abi == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Abi it = (Abi)element$iv$iv;
            boolean bl = false;
            if (!(it.getAddressSizeInBytes() == clientAddrByteSize)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List abis = (List)destination$iv$iv;
        LOG.info("ABIs supported by app: " + abis);
        return abis;
    }

    @WorkerThread
    public static final void verify(@NotNull Project project, @NotNull ClientShellHelper clientShellHelper, @NotNull Client client) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)clientShellHelper, (String)"clientShellHelper");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (clientShellHelper.isRestrictedUser()) {
            UtilsKt.checkRunAsUnderRestrictedUser(client);
        }
        UtilsKt.maybeShowBrokenNdkMessage(project, client);
    }

    private static final void maybeShowBrokenNdkMessage(Project project, Client client) {
        boolean hasBrokenNdkABI;
        block8: {
            Iterable $this$any$iv = UtilsKt.getClientABIs(client);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Abi it = (Abi)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.toString(), (Object)"x86")) continue;
                    v0 = true;
                    break block8;
                }
                v0 = hasBrokenNdkABI = false;
            }
        }
        if (!hasBrokenNdkABI) {
            return;
        }
        NativeWorkspaceService nativeWorkspaceService = NativeWorkspaceService.Companion.getInstance(project);
        Optional anyFileSetting = nativeWorkspaceService.getCompilerSettings(UtilsKt::maybeShowBrokenNdkMessage$lambda$3).findFirst();
        if (!anyFileSetting.isPresent()) {
            return;
        }
        File cc = ((NativeCompilerSetting)anyFileSetting.get()).getCompilerExe();
        String string = cc.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"clang", (boolean)false, (int)2, null)) {
            return;
        }
        Pair<File, Revision> pair = CxxSyncUtilsKt.findNdkFolderFromFileInNdk(cc);
        if (pair == null) {
            return;
        }
        Revision second = (Revision)pair.component2();
        if (second.getMajor() > 16) {
            return;
        }
        LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, "While debugging with an x86 device, the version of Clang included in NDK r16 and lower has a known issue that prevents function argument values from displaying correctly. To avoid this issue, either use an x86_64 device, or update the NDK to r17 or higher.");
    }

    @WorkerThread
    private static final void checkRunAsUnderRestrictedUser(Client client) throws ExecutionException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            client.getDevice().executeShellCommand("run-as", (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            throw new ExecutionException("Error executing adb command: run-as");
        }
        String string = receiver.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutput(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"--user", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = "Native debugging under restricted user is not supported yet.";
            throw new IllegalStateException(string2.toString());
        }
    }

    private static final boolean maybeShowBrokenNdkMessage$lambda$3(ModuleVariantAbi it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

