/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.ndk.run.editor.HybridDebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class HybridDebuggerSteppingConfigurableUi
implements ConfigurableUi<HybridDebuggerSettings> {
    private JPanel myPanel;
    private JCheckBox myAlwaysSmartStepInto;
    private static Method cachedGetBundleMethod = null;

    public HybridDebuggerSteppingConfigurableUi() {
        this.setupUI();
    }

    public void reset(@NotNull HybridDebuggerSettings settings) {
        this.myAlwaysSmartStepInto.setSelected(settings.ALWAYS_SMART_STEP_INTO);
    }

    public boolean isModified(@NotNull HybridDebuggerSettings settings) {
        return this.myAlwaysSmartStepInto.isSelected() != settings.ALWAYS_SMART_STEP_INTO;
    }

    public void apply(@NotNull HybridDebuggerSettings settings) {
        settings.ALWAYS_SMART_STEP_INTO = this.myAlwaysSmartStepInto.isSelected();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myAlwaysSmartStepInto = new JCheckBox();
        this.loadButtonText(this.myAlwaysSmartStepInto, this.getMessageFromBundle("messages/AndroidNdkBundle", "label.debugger.general.configurable.always.smart.step.into"));
        this.myPanel.add((Component)this.myAlwaysSmartStepInto, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadButtonText(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }
}

