/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.reference.JniReferenceContributorKt;
import com.android.tools.ndk.jni.reference.JvmReference;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmMethodReference;", "Lcom/android/tools/ndk/jni/reference/JvmReference;", "jvmMethodId", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "element", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "<init>", "(Lcom/android/tools/ndk/jni/model/JvmMethodId;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)V", "getJvmMethodId", "()Lcom/android/tools/ndk/jni/model/JvmMethodId;", "resolve", "Lcom/intellij/psi/PsiElement;", "isReferenceTo", "", "handleElementRename", "newElementName", "", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmMethodReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n295#2,2:229\n*S KotlinDebug\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmMethodReference\n*L\n195#1:229,2\n*E\n"})
public final class JvmMethodReference
extends JvmReference {
    @NotNull
    private final JvmMethodId jvmMethodId;

    public JvmMethodReference(@NotNull JvmMethodId jvmMethodId, @NotNull OCLiteralExpression element) {
        Intrinsics.checkNotNullParameter((Object)jvmMethodId, (String)"jvmMethodId");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange textRange = JniReferenceContributorKt.access$getContentTextRange(element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"access$getContentTextRange(...)");
        super(element, textRange, null);
        this.jvmMethodId = jvmMethodId;
    }

    @NotNull
    public final JvmMethodId getJvmMethodId() {
        return this.jvmMethodId;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiElement resolve() {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)((OCLiteralExpression)this.getElement()).getProject()).findClass(this.jvmMethodId.getClassName().getJava(), GlobalSearchScope.allScope((Project)((OCLiteralExpression)this.getElement()).getProject()));
            if (psiClass == null) return null;
            List<JvmMethodInfo> list = JniUtilsKt.findAllMethodsByName(psiClass, this.jvmMethodId.getMethodName());
            if (list == null) return null;
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JvmMethodInfo it = (JvmMethodInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)this.jvmMethodId.getMethodType())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        JvmMethodInfo jvmMethodInfo = v0;
        if (jvmMethodInfo == null) return null;
        PsiElement psiElement = jvmMethodInfo.getPsiElement();
        return psiElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiMethod) {
            JvmMethodInfo jvmMethodInfo = JvmMethodInfo.Companion.fromJavaMethod((PsiMethod)element);
            bl = Intrinsics.areEqual((Object)(jvmMethodInfo != null ? jvmMethodInfo.toJvmMethodId() : null), (Object)this.jvmMethodId);
        } else {
            bl = element instanceof PsiClass ? Intrinsics.areEqual((Object)this.jvmMethodId.getClassName(), (Object)FullyQualifiedClassName.Companion.fromJavaClass((PsiClass)element)) && Intrinsics.areEqual((Object)this.jvmMethodId.getMethodName(), (Object)"<init>") && Intrinsics.areEqual((Object)this.jvmMethodId.getMethodType(), (Object)"()V") : false;
        }
        return bl;
    }

    @Override
    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        if (Intrinsics.areEqual((Object)this.jvmMethodId.getMethodName(), (Object)"<init>")) {
            throw new IncorrectOperationException("Cannot rename '<init>'.");
        }
        return super.handleElementRename(newElementName);
    }
}

