/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.reference.JniRelatedItemMarkerProviderKt;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.LanguageUtils;
import icons.CidrLangIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/ndk/jni/reference/JniRelatedItemMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniRelatedItemMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniRelatedItemMarkerProvider.kt\ncom/android/tools/ndk/jni/reference/JniRelatedItemMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1755#2,3:119\n1755#2,3:122\n1557#2:125\n1628#2,3:126\n1557#2:129\n1628#2,3:130\n1557#2:133\n1628#2,3:134\n1557#2:137\n1628#2,3:138\n*S KotlinDebug\n*F\n+ 1 JniRelatedItemMarkerProvider.kt\ncom/android/tools/ndk/jni/reference/JniRelatedItemMarkerProvider\n*L\n65#1:119,3\n87#1:122,3\n73#1:125\n73#1:126,3\n76#1:129\n76#1:130,3\n95#1:133\n95#1:134,3\n98#1:137\n98#1:138,3\n*E\n"})
public final class JniRelatedItemMarkerProvider
extends RelatedItemLineMarkerProvider {
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (elements.isEmpty()) break block2;
                LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
                Project project = ((PsiElement)CollectionsKt.first(elements)).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!languageUtils.isCppSupportDisabled(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    /*
     * WARNING - void declaration
     */
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JniMethodResolver jniMethodResolver = JniMethodResolver.Companion.getInstance(project);
        MethodInfo methodInfo = MethodInfo.Companion.fromIdentifier(element);
        if (methodInfo == null) {
            return;
        }
        MethodInfo methodInfo2 = methodInfo;
        if (methodInfo2 instanceof NativeMethodInfo) {
            List<JvmMethodInfo> jvmMethodInfos = jniMethodResolver.resolveNativeMethod((NativeMethodInfo)methodInfo2);
            if (!((Collection)jvmMethodInfos).isEmpty()) {
                boolean bl;
                PsiElement psiElement;
                TextRange textRange;
                block14: {
                    void $this$any$iv;
                    Iterable iterable = jvmMethodInfos;
                    textRange = ((NativeMethodInfo)methodInfo2).getNameIdentifier().getTextRange();
                    psiElement = ((NativeMethodInfo)methodInfo2).getNameIdentifier();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            JvmMethodInfo it = (JvmMethodInfo)element$iv;
                            boolean bl2 = false;
                            if (!it.isKotlin()) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                NotNullFactory notNullFactory = () -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$7(jvmMethodInfos);
                GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
                GutterIconNavigationHandler gutterIconNavigationHandler = (arg_0, arg_1) -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$5(jvmMethodInfos, methodInfo2, arg_0, arg_1);
                Function function = arg_0 -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$3(arg_0 -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$2(jvmMethodInfos, arg_0), arg_0);
                Icon icon = bl3 ? KotlinIcons.FILE : AllIcons.FileTypes.Java;
                TextRange textRange2 = textRange;
                PsiElement psiElement2 = psiElement;
                RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo(psiElement2, textRange2, icon, function, gutterIconNavigationHandler, alignment, notNullFactory);
                result.add(info);
            }
        } else if (methodInfo2 instanceof JvmMethodInfo) {
            if (!((JvmMethodInfo)methodInfo2).isNative()) {
                return;
            }
            List<NativeMethodInfo> nativeMethodInfos = jniMethodResolver.resolveJavaOrKotlinMethod((JvmMethodInfo)methodInfo2);
            if (!((Collection)nativeMethodInfos).isEmpty()) {
                boolean bl;
                PsiElement psiElement;
                TextRange textRange;
                block15: {
                    Iterable $this$any$iv = nativeMethodInfos;
                    textRange = ((JvmMethodInfo)methodInfo2).getNameIdentifier().getTextRange();
                    psiElement = ((JvmMethodInfo)methodInfo2).getNameIdentifier();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            NativeMethodInfo it = (NativeMethodInfo)element$iv;
                            boolean bl4 = false;
                            if (!it.isCpp()) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                boolean bl5 = bl;
                NotNullFactory notNullFactory = () -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$15(nativeMethodInfos);
                GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
                GutterIconNavigationHandler gutterIconNavigationHandler = (arg_0, arg_1) -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$13(nativeMethodInfos, methodInfo2, arg_0, arg_1);
                Function function = arg_0 -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$11(arg_0 -> JniRelatedItemMarkerProvider.collectNavigationMarkers$lambda$10(nativeMethodInfos, arg_0), arg_0);
                Icon icon = bl5 ? CidrLangIcons.FileTypes.Cpp : CidrLangIcons.FileTypes.C;
                TextRange textRange3 = textRange;
                PsiElement psiElement3 = psiElement;
                RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo(psiElement3, textRange3, icon, function, gutterIconNavigationHandler, alignment, notNullFactory);
                result.add(info);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final CharSequence collectNavigationMarkers$lambda$2$lambda$1(JvmMethodInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDescription() + " " + JniRelatedItemMarkerProviderKt.access$getFileAndLine(it.getPsiElement());
    }

    private static final String collectNavigationMarkers$lambda$2(List $jvmMethodInfos, PsiElement it) {
        return StringsKt.trimIndent((String)("\n              JNI declaration" + ($jvmMethodInfos.size() == 1 ? "" : "s") + ":\n              " + CollectionsKt.joinToString$default((Iterable)$jvmMethodInfos, (CharSequence)"\n", null, null, (int)0, null, JniRelatedItemMarkerProvider::collectNavigationMarkers$lambda$2$lambda$1, (int)30, null) + "\n              "));
    }

    private static final String collectNavigationMarkers$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectNavigationMarkers$lambda$5(List $jvmMethodInfos, MethodInfo $methodInfo, MouseEvent mouseEvent, PsiElement psiElement) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $jvmMethodInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPsiElement());
        }
        List list = (List)destination$iv$iv;
        String string = ((NativeMethodInfo)$methodInfo).getNativeMethodId().getFunctionName();
        Intrinsics.checkNotNull((Object)mouseEvent);
        JniRelatedItemMarkerProviderKt.access$navigateToTargets(list, string, mouseEvent);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection collectNavigationMarkers$lambda$7(List $jvmMethodInfos) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $jvmMethodInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GotoRelatedItem(it.getPsiElement()));
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence collectNavigationMarkers$lambda$10$lambda$9(NativeMethodInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPsiElement().getName();
        Intrinsics.checkNotNull((Object)string);
        return string + " " + JniRelatedItemMarkerProviderKt.access$getFileAndLine((PsiElement)it.getPsiElement());
    }

    private static final String collectNavigationMarkers$lambda$10(List $nativeMethodInfos, PsiElement it) {
        return StringsKt.trimIndent((String)("\n              JNI implementation" + ($nativeMethodInfos.size() == 1 ? "" : "s") + ":\n              " + CollectionsKt.joinToString$default((Iterable)$nativeMethodInfos, (CharSequence)"\n", null, null, (int)0, null, JniRelatedItemMarkerProvider::collectNavigationMarkers$lambda$10$lambda$9, (int)30, null) + "\n              "));
    }

    private static final String collectNavigationMarkers$lambda$11(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectNavigationMarkers$lambda$13(List $nativeMethodInfos, MethodInfo $methodInfo, MouseEvent mouseEvent, PsiElement psiElement) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $nativeMethodInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NativeMethodInfo nativeMethodInfo = (NativeMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPsiElement());
        }
        List list = (List)destination$iv$iv;
        String string = ((JvmMethodInfo)$methodInfo).getMethodName();
        Intrinsics.checkNotNull((Object)mouseEvent);
        JniRelatedItemMarkerProviderKt.access$navigateToTargets(list, string, mouseEvent);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection collectNavigationMarkers$lambda$15(List $nativeMethodInfos) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $nativeMethodInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NativeMethodInfo nativeMethodInfo = (NativeMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GotoRelatedItem((PsiElement)it.getPsiElement()));
        }
        return (List)destination$iv$iv;
    }
}

