/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.completion.UnimplementedJniMethodStubProvider;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nKotlinJniMissingFunctionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJniMissingFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 3 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n62#2,4:237\n66#2:245\n67#2:258\n516#3,4:241\n522#3,9:246\n1755#4,3:255\n*S KotlinDebug\n*F\n+ 1 KotlinJniMissingFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection\n*L\n74#1:237,4\n74#1:245\n74#1:258\n74#1:241,4\n74#1:246,9\n86#1:255,3\n*E\n"})
public final class KotlinJniMissingFunctionInspection
extends JniInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinJniMissingFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.MISSING_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project) || !NdkHelper.isNdkProject(holder.getProject()) || OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)holder.getProject()).isEmpty()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor(arg_0 -> KotlinJniMissingFunctionInspection.buildVisitor$lambda$2(this, holder, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit buildVisitor$lambda$2(KotlinJniMissingFunctionInspection this$0, ProblemsHolder $holder, KtNamedFunction it) {
        void inspectionType$iv$iv;
        void $this$reportJniPerf$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!JniUtilsKt.isNative((KtFunction)it)) {
            return Unit.INSTANCE;
        }
        JniInspectionTool jniInspectionTool = this$0;
        PsiElement psiElement$iv = (PsiElement)it;
        boolean $i$f$reportPerf$android_ndk = false;
        Project project = psiElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
        int n = 100;
        boolean $i$f$reportJniPerf = false;
        JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
        Instant startTime$iv$iv = Instant.now();
        try {
            boolean bl;
            JvmMethodInfo jvmMethodInfo;
            block14: {
                JvmMethodInfo jvmMethodInfo2;
                JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                boolean bl2 = false;
                boolean bl3 = false;
                if (it.isLocal()) {
                    KtModifierList ktModifierList = it.getModifierList();
                    Intrinsics.checkNotNull((Object)ktModifierList);
                    PsiElement psiElement = ktModifierList.getModifier(KtTokens.EXTERNAL_KEYWORD);
                    Intrinsics.checkNotNull((Object)psiElement);
                    $holder.registerProblem(psiElement, "JNI cannot link to a local external function.", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                if (JvmMethodInfo.Companion.fromKotlinFunction((KtFunction)it) == null) {
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                jvmMethodInfo = jvmMethodInfo2;
                Project project3 = it.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                Iterable $this$any$iv = JniMethodResolver.Companion.getInstance(project3).resolveJavaOrKotlinMethod(jvmMethodInfo);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NativeMethodInfo it2 = (NativeMethodInfo)element$iv;
                        boolean bl4 = false;
                        if (!it2.isDefinition()) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            Companion.registerMissingJniDefinitionProblem($holder, this$0, jvmMethodInfo);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            void inverseSampleRate$iv$iv;
            if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                Instant bl2 = Instant.now();
                JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl2).toMillis())));
            }
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void registerMissingJniDefinitionProblem(@NotNull ProblemsHolder holder, @NotNull JniInspectionTool tool, @NotNull JvmMethodInfo jvmMethodInfo) {
        Companion.registerMissingJniDefinitionProblem(holder, tool, jvmMethodInfo);
    }

    @JvmStatic
    private static final boolean showPopupAndCreateJniStub(Project project, JvmMethodInfo methodInfo, int sizeLimit) {
        return KotlinJniMissingFunctionInspection.Companion.showPopupAndCreateJniStub(project, methodInfo, sizeLimit);
    }

    @JvmStatic
    private static final List<OCFile> findNativeSourceFilesWithExistingJniFunctions(Project project) {
        return KotlinJniMissingFunctionInspection.Companion.findNativeSourceFilesWithExistingJniFunctions(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0003J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0003\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection$Companion;", "", "<init>", "()V", "registerMissingJniDefinitionProblem", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "tool", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "jvmMethodInfo", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "showPopupAndCreateJniStub", "", "project", "Lcom/intellij/openapi/project/Project;", "methodInfo", "sizeLimit", "", "createJniStub", "ocFile", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "hasNativeSourceFiles", "findNativeSourceFiles", "", "findNativeSourceFilesWithExistingJniFunctions", "android-ndk"})
    @SourceDebugExtension(value={"SMAP\nKotlinJniMissingFunctionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJniMissingFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1755#2,3:237\n1611#2,9:240\n1863#2:249\n1864#2:251\n1620#2:252\n1#3:250\n*S KotlinDebug\n*F\n+ 1 KotlinJniMissingFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection$Companion\n*L\n204#1:237,3\n232#1:240,9\n232#1:249\n232#1:251\n232#1:252\n232#1:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerMissingJniDefinitionProblem(@NotNull ProblemsHolder holder, @NotNull JniInspectionTool tool, @NotNull JvmMethodInfo jvmMethodInfo) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
            Intrinsics.checkNotNullParameter((Object)jvmMethodInfo, (String)"jvmMethodInfo");
            String jniMethodName = JvmMethodInfo.toJniNativeMethodId$default(jvmMethodInfo, false, 1, null).getFunctionName();
            String message = "Cannot resolve corresponding JNI function " + jniMethodName + ".";
            Project project = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            boolean hasNativeSourceFiles = this.hasNativeSourceFiles(project);
            if (!hasNativeSourceFiles) {
                message = message + " Could not find any C or C++ source files in the project. Please create one first.";
            }
            if (hasNativeSourceFiles) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{tool.quickFix("Create JNI function", "Create JNI function for " + jvmMethodInfo.getMethodName(), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> Companion.registerMissingJniDefinitionProblem$lambda$0(jvmMethodInfo, arg_0, arg_1)))};
                holder.registerProblem(jvmMethodInfo.getNameIdentifier(), message, ProblemHighlightType.ERROR, localQuickFixArray);
            } else {
                holder.registerProblem(jvmMethodInfo.getNameIdentifier(), message, ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }

        @JvmStatic
        private final boolean showPopupAndCreateJniStub(Project project, JvmMethodInfo methodInfo, int sizeLimit) {
            List<OCFile> files = this.findNativeSourceFiles(project, sizeLimit);
            if (files.size() == 1) {
                this.createJniStub(project, (OCFile)CollectionsKt.single(files), methodInfo);
            } else {
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor == null) {
                    return false;
                }
                Editor editor2 = editor;
                Object object = WindowManagerEx.getInstanceEx().getFrame(project);
                int maxWidth = object != null && (object = object.getSize()) != null ? object.width : 500;
                new PsiTargetNavigator(files).presentationProvider(arg_0 -> Companion.showPopupAndCreateJniStub$lambda$1(maxWidth, arg_0)).createPopup(project, "Select native file to place the JNI function" + (String)(files.size() == sizeLimit ? " (showing " + files.size() + " results)" : ""), arg_0 -> Companion.showPopupAndCreateJniStub$lambda$2(project, methodInfo, arg_0)).showInBestPositionFor(editor2);
            }
            return true;
        }

        static /* synthetic */ boolean showPopupAndCreateJniStub$default(Companion companion, Project project, JvmMethodInfo jvmMethodInfo, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1000;
            }
            return companion.showPopupAndCreateJniStub(project, jvmMethodInfo, n);
        }

        private final void createJniStub(Project project, OCFile ocFile, JvmMethodInfo methodInfo) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> Companion.createJniStub$lambda$3(ocFile, methodInfo, project));
        }

        private final boolean hasNativeSourceFiles(Project project) {
            boolean bl;
            block3: {
                List list = OCWorkspace.getInstance((Project)project).getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        OCResolveConfiguration it = (OCResolveConfiguration)element$iv;
                        boolean bl2 = false;
                        if (!(!UtilKt.isEmpty((Stream)it.getAllCompilerSettings()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<OCFile> findNativeSourceFiles(Project project, int sizeLimit) {
            List<OCFile> filesWithJniFunctions = this.findNativeSourceFilesWithExistingJniFunctions(project);
            Set excluded = CollectionsKt.toSet((Iterable)filesWithJniFunctions);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            Collection collection = filesWithJniFunctions;
            List list = OCWorkspace.getInstance((Project)project).getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
            return CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.take((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), Companion::findNativeSourceFiles$lambda$5), arg_0 -> Companion.findNativeSourceFiles$lambda$6(psiManager2, arg_0)), arg_0 -> Companion.findNativeSourceFiles$lambda$7(excluded, arg_0))), (int)(sizeLimit - filesWithJniFunctions.size())));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final List<OCFile> findNativeSourceFilesWithExistingJniFunctions(Project project) {
            void $this$mapNotNullTo$iv$iv;
            PsiFile[] psiFileArray = CacheManager.getInstance((Project)project).getFilesWithWord("JNIEXPORT", (short)1, GlobalSearchScope.projectScope((Project)project), true);
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesWithWord(...)");
            Iterable $this$mapNotNull$iv = ArraysKt.distinct((Object[])psiFileArray);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OCFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiFile it = (PsiFile)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof OCFile ? (OCFile)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final boolean registerMissingJniDefinitionProblem$lambda$0(JvmMethodInfo $jvmMethodInfo, Project project, ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection$Companion.showPopupAndCreateJniStub$default(Companion, project, $jvmMethodInfo, 0, 4, null);
        }

        private static final TargetPresentation showPopupAndCreateJniStub$lambda$1(int $maxWidth, OCFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TargetPresentation targetPresentation = new GotoFileCellRenderer($maxWidth).computePresentation((PsiElement)it);
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"computePresentation(...)");
            return targetPresentation;
        }

        private static final boolean showPopupAndCreateJniStub$lambda$2(Project $project, JvmMethodInfo $methodInfo, OCFile ocFile) {
            Intrinsics.checkNotNullParameter((Object)ocFile, (String)"ocFile");
            Companion.createJniStub($project, ocFile, $methodInfo);
            return true;
        }

        private static final void createJniStub$lambda$3(OCFile $ocFile, JvmMethodInfo $methodInfo, Project $project) {
            boolean cpp = $ocFile.getKind() == CLanguageKind.CPP;
            String text = JvmMethodInfo.generateNativeMethod$default($methodInfo, cpp, false, 2, null);
            UnimplementedJniMethodStubProvider.Companion.insertJniHeaderIfNeeded($ocFile);
            OCChangeUtil.changeText((Project)$ocFile.getProject(), (PsiFile)((PsiFile)$ocFile), (int)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)$ocFile)), (int)0, (String)"\n", (boolean)false);
            DocumentUtilsKt.commitAndUnblockDocument((PsiFile)((PsiFile)$ocFile));
            PsiElement psiElement = OCElementFactory.topLevelDeclarationFromText((String)text, (PsiElement)((PsiElement)$ocFile), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"topLevelDeclarationFromText(...)");
            PsiElement declaration = psiElement;
            PsiElement added = OCChangeUtil.add((PsiElement)((PsiElement)$ocFile), (PsiElement)declaration);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$project);
            Document document = documentManager.getDocument((PsiFile)$ocFile);
            Intrinsics.checkNotNull((Object)document);
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)((PsiFile)$ocFile), (int)added.getTextOffset(), (int)(added.getTextOffset() + added.getTextLength()));
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)added, PsiComment.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Collection comments = collection;
            if (!comments.isEmpty()) {
                PsiComment firstComment = (PsiComment)comments.iterator().next();
                PsiNavigateUtil.navigate((PsiElement)((PsiElement)firstComment));
                TextRange textRange = firstComment.getTextRange();
                Editor editor = FileEditorManager.getInstance((Project)$project).getSelectedTextEditor();
                Editor editor2 = editor;
                if (editor2 != null && (editor2 = editor2.getSelectionModel()) != null) {
                    editor2.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                }
            } else {
                Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)added, OCFunctionDeclaration.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findChildrenOfType(...)");
                Collection functions = collection2;
                if (!functions.isEmpty()) {
                    OCFunctionDeclaration first = (OCFunctionDeclaration)functions.iterator().next();
                    PsiNavigateUtil.navigate((PsiElement)((PsiElement)first));
                } else {
                    PsiNavigateUtil.navigate((PsiElement)added);
                }
            }
        }

        private static final Sequence findNativeSourceFiles$lambda$5(OCResolveConfiguration config) {
            Collection collection = config.getSources();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSources(...)");
            return CollectionsKt.asSequence((Iterable)collection);
        }

        private static final OCFile findNativeSourceFiles$lambda$6(PsiManager $psiManager, VirtualFile it) {
            PsiFile psiFile = $psiManager.findFile(it);
            return psiFile instanceof OCFile ? (OCFile)psiFile : null;
        }

        private static final boolean findNativeSourceFiles$lambda$7(Set $excluded, OCFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !$excluded.contains(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

