/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.model.RegisterNativesCall;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.service.RegisterNativesProcessor;
import com.android.tools.ndk.jni.service.RegisteredNativesBundle;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J6\u0010\n\u001a\u00020\u000b*\u00020\f2 \u0010\r\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J2\u0010\u0013\u001a\u00020\u000b2 \u0010\r\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniRegisterNativesInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectMethods", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "bindingToInitializer", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "Lcom/jetbrains/cidr/lang/psi/OCCompoundInitializer;", "inspectRedundantBindings", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniRegisterNativesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniRegisterNativesInspection.kt\ncom/android/tools/ndk/jni/inspections/JniRegisterNativesInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n51#2,9:119\n1863#3:128\n2632#3,3:129\n1864#3:132\n1863#3:133\n1863#3,2:134\n1864#3:136\n1557#3:137\n1628#3,3:138\n*S KotlinDebug\n*F\n+ 1 JniRegisterNativesInspection.kt\ncom/android/tools/ndk/jni/inspections/JniRegisterNativesInspection\n*L\n49#1:119,9\n69#1:128\n87#1:129,3\n69#1:132\n108#1:133\n111#1:134,2\n108#1:136\n97#1:137\n97#1:138,3\n*E\n"})
public final class JniRegisterNativesInspection
extends JniInspectionTool {
    public JniRegisterNativesInspection() {
        super(JniInspectionEvent.JniInspectionType.REGISTER_NATIVES_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, holder, this){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            final /* synthetic */ JniRegisterNativesInspection this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$holder$inlined = problemsHolder;
                this.this$0 = jniRegisterNativesInspection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof RegisterNativesCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (RegisterNativesCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool jniInspectionTool = this.this$0$inline_fun;
                PsiElement psiElement$iv = (PsiElement)expression;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    RegisterNativesCall registerNativesCall = (RegisterNativesCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    JvmTypeInfo jvmTypeInfo = $this$buildVisitor_u24lambda_u240.inferTypeInfo(call2.getClassExpression());
                    Object object = jvmTypeInfo instanceof ClassTypeInfo ? (ClassTypeInfo)jvmTypeInfo : null;
                    if (object == null || (object = ((ClassTypeInfo)object).getClassType()) == null) {
                    } else {
                        Object jvmType = object;
                        if (!(jvmType instanceof JvmObjectType)) {
                            InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)call2.getClassExpression(), "'" + ((JvmType)jvmType).toShortJavaType() + "' is not a valid class to register native functions.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                        } else {
                            RegisteredNativesBundle registeredNativesBundle = RegisterNativesProcessor.Companion.getInstance($this$buildVisitor_u24lambda_u240.getProject()).process((RegisterNativesCall)call2);
                            if (registeredNativesBundle == null) {
                            } else {
                                RegisteredNativesBundle bundle = registeredNativesBundle;
                                JniRegisterNativesInspection.access$inspectMethods(this.this$0, $this$buildVisitor_u24lambda_u240, bundle.getBindingToInitializer(), this.$holder$inlined);
                                JniRegisterNativesInspection.access$inspectRedundantBindings(this.this$0, bundle.getBindingToInitializer(), this.$holder$inlined);
                            }
                        }
                    }
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectMethods(JniInfoInferencer $this$inspectMethods, BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bindingToInitializer, ProblemsHolder holder) {
        JniMethodResolver jniMethodResolver = JniMethodResolver.Companion.getInstance($this$inspectMethods.getProject());
        Set set = bindingToInitializer.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getValues(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List initializerExpressions;
            List<JvmMethodInfo> matchedJniMethods;
            String methodName;
            block5: {
                OCCompoundInitializer initializer = (OCCompoundInitializer)element$iv;
                boolean bl2 = false;
                Set set2 = bindingToInitializer.getKeys((Object)initializer);
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getKeys(...)");
                JvmMethodId jvmMethodId = (JvmMethodId)((Pair)CollectionsKt.single((Iterable)set2)).component1();
                methodName = jvmMethodId.getMethodName();
                matchedJniMethods = jniMethodResolver.findDeclaredJniMethods(jvmMethodId.getClassName(), methodName);
                Intrinsics.checkNotNullExpressionValue((Object)initializer.getInitializerExpressions(), (String)"getInitializerExpressions(...)");
                if (matchedJniMethods.isEmpty()) {
                    OCExpression methodNameExpression = (OCExpression)initializerExpressions.get(0);
                    ProblemHighlightType problemType = methodNameExpression instanceof OCLiteralExpression ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                    Intrinsics.checkNotNull((Object)methodNameExpression);
                    InspectionUtilsKt.registerOcProblem(holder, (PsiElement)methodNameExpression, "Class '" + jvmMethodId.getClassName().getShortName() + "' does not declare JNI method named '" + methodName + "'.", problemType, new JniLocalQuickFix[0]);
                    continue;
                }
                Iterable $this$none$iv = matchedJniMethods;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        JvmMethodInfo it = (JvmMethodInfo)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)jvmMethodId.getMethodType())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            JvmMethodInfo uniqueMatch = (JvmMethodInfo)CollectionsKt.singleOrNull(matchedJniMethods);
            OCExpression methodTypeExpression = (OCExpression)initializerExpressions.get(1);
            Intrinsics.checkNotNull((Object)methodTypeExpression);
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix type specifier for RegisterNatives", "Fix type specifier of method '" + methodName + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniRegisterNativesInspection.inspectMethods$lambda$5$lambda$4(matchedJniMethods, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)methodTypeExpression, uniqueMatch == null ? "The type specifier does not match any version of the overloaded JNI native method '" + methodName + "'." : "The type specifier does not match JNI native method '" + uniqueMatch.getDescription() + "'.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
    }

    private final void inspectRedundantBindings(BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bindingToInitializer, ProblemsHolder holder) {
        Set set = bindingToInitializer.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set initializers;
            Pair key = (Pair)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)bindingToInitializer.getValues((Object)key), (String)"getValues(...)");
            if (initializers.size() <= 1) continue;
            Iterable $this$forEach$iv2 = CollectionsKt.drop((Iterable)initializers, (int)1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                OCCompoundInitializer initializer = (OCCompoundInitializer)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)initializer);
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)initializer, "Redundant JNI binding.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new JniLocalQuickFix[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean inspectMethods$lambda$5$lambda$4$lambda$3(ProblemDescriptor $descriptor, List $matchedJniMethods) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $matchedJniMethods;
        ProblemDescriptor problemDescriptor = $descriptor;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JniUtilsKt.quoted(it.getMethodType()));
        }
        return InspectionUtilsKt.replaceAtHighlighted(problemDescriptor, (List)destination$iv$iv);
    }

    private static final boolean inspectMethods$lambda$5$lambda$4(List $matchedJniMethods, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniRegisterNativesInspection.inspectMethods$lambda$5$lambda$4$lambda$3(descriptor, $matchedJniMethods));
    }

    public static final /* synthetic */ void access$inspectMethods(JniRegisterNativesInspection $this, JniInfoInferencer $receiver, BidirectionalMultiMap bindingToInitializer, ProblemsHolder holder) {
        $this.inspectMethods($receiver, (BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer>)bindingToInitializer, holder);
    }

    public static final /* synthetic */ void access$inspectRedundantBindings(JniRegisterNativesInspection $this, BidirectionalMultiMap bindingToInitializer, ProblemsHolder holder) {
        $this.inspectRedundantBindings((BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer>)bindingToInitializer, holder);
    }
}

