/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniGetMethodIdInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspect", "", "declaredClassType", "Lcom/android/tools/ndk/jni/model/JvmType;", "methodSourceClass", "Lcom/intellij/psi/PsiClass;", "call", "Lcom/android/tools/ndk/jni/model/GetMethodIdCall;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniGetMethodIdInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniGetMethodIdInspection.kt\ncom/android/tools/ndk/jni/inspections/JniGetMethodIdInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n51#2,9:123\n774#3:132\n865#3,2:133\n2632#3,3:135\n1557#3:138\n1628#3,3:139\n*S KotlinDebug\n*F\n+ 1 JniGetMethodIdInspection.kt\ncom/android/tools/ndk/jni/inspections/JniGetMethodIdInspection\n*L\n50#1:123,9\n85#1:132\n85#1:133,2\n100#1:135,3\n95#1:138\n95#1:139,3\n*E\n"})
public final class JniGetMethodIdInspection
extends JniInspectionTool {
    public JniGetMethodIdInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_METHOD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, holder, this){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            final /* synthetic */ JniGetMethodIdInspection this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$holder$inlined = problemsHolder;
                this.this$0 = jniGetMethodIdInspection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof GetMethodIdCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (GetMethodIdCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool jniInspectionTool = this.this$0$inline_fun;
                PsiElement psiElement$iv = (PsiElement)expression;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    GetMethodIdCall getMethodIdCall = (GetMethodIdCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    if (call2.getMethodNameExpression() != null) {
                        if (call2.getMethodTypeExpression() == null) {
                        } else {
                            InspectionUtilsKt.inspectClass($this$buildVisitor_u24lambda_u240, this.$holder$inlined, call2.getClassExpression(), (Function2<? super JniInfoInferencer, ? super JvmType, Unit>)((Function2)new Function2<JniInfoInferencer, JvmType, Unit>(this.$holder$inlined, (GetMethodIdCall)call2, this.this$0){
                                final /* synthetic */ ProblemsHolder $holder;
                                final /* synthetic */ GetMethodIdCall $call;
                                final /* synthetic */ JniGetMethodIdInspection this$0;
                                {
                                    this.$holder = $holder;
                                    this.$call = $call;
                                    this.this$0 = $receiver;
                                }

                                public final void invoke(JniInfoInferencer $this$inspectClass, JvmType classType) {
                                    Intrinsics.checkNotNullParameter((Object)$this$inspectClass, (String)"$this$inspectClass");
                                    Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                                    JvmType jvmType = classType;
                                    if (jvmType instanceof JvmPrimitiveType) {
                                        InspectionUtilsKt.registerOcProblem(this.$holder, (PsiElement)this.$call.getClassExpression(), "'" + ((JvmPrimitiveType)classType).toShortJavaType() + "' does not have any member methods.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                                    } else if (jvmType instanceof JvmArrayType) {
                                        PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspectClass, JvmTypeKt.getOBJECT_TYPE(), false, 1, null);
                                        if (psiClass == null) {
                                            return;
                                        }
                                        JniGetMethodIdInspection.access$inspect(this.this$0, classType, psiClass, this.$call, this.$holder);
                                    } else if (jvmType instanceof JvmObjectType) {
                                        PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspectClass, classType, false, 1, null);
                                        if (psiClass == null) {
                                            return;
                                        }
                                        JniGetMethodIdInspection.access$inspect(this.this$0, classType, psiClass, this.$call, this.$holder);
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }));
                        }
                    }
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspect(JvmType declaredClassType, PsiClass methodSourceClass, GetMethodIdCall call, ProblemsHolder holder) {
        boolean bl;
        List matchedMethodInfos;
        block9: {
            Iterator $this$filterTo$iv$iv;
            OCExpression oCExpression = call.getMethodNameExpression();
            Intrinsics.checkNotNull((Object)oCExpression);
            DataSource dataSource = DataSourceKt.getDataSource((OCElement)oCExpression);
            StringDataSource stringDataSource = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
            if (stringDataSource == null) {
                return;
            }
            StringDataSource methodNameDataSource = stringDataSource;
            OCExpression oCExpression2 = call.getMethodTypeExpression();
            Intrinsics.checkNotNull((Object)oCExpression2);
            DataSource dataSource2 = DataSourceKt.getDataSource((OCElement)oCExpression2);
            StringDataSource stringDataSource2 = dataSource2 instanceof StringDataSource ? (StringDataSource)dataSource2 : null;
            if (stringDataSource2 == null) {
                return;
            }
            StringDataSource methodTypeDataSource = stringDataSource2;
            String methodName = methodNameDataSource.getString();
            List<JvmMethodInfo> matchedMethodInfosByName = JniUtilsKt.findAllMethodsByName(methodSourceClass, methodName);
            if (matchedMethodInfosByName.isEmpty()) {
                ProblemHighlightType problemType = Intrinsics.areEqual((Object)methodNameDataSource.getSourceExpression(), (Object)call.getMethodNameExpression()) ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call.getMethodNameExpression(), "Class '" + declaredClassType.toShortJavaType() + "' has no method named '" + methodName + "'.", problemType, new JniLocalQuickFix[0]);
                return;
            }
            Iterable $this$filter$iv = matchedMethodInfosByName;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                JvmMethodInfo it = (JvmMethodInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)methodTypeDataSource.getString())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            matchedMethodInfos = (List)destination$iv$iv;
            if (matchedMethodInfos.isEmpty()) {
                JvmMethodInfo uniqueMatch = (JvmMethodInfo)CollectionsKt.singleOrNull(matchedMethodInfosByName);
                JniLocalQuickFix[] $i$f$filter2 = new JniLocalQuickFix[]{this.quickFix("Fix type specifier in JNI GetMethodID call", "Fix type specifier of method '" + methodName + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniGetMethodIdInspection.inspect$lambda$4(matchedMethodInfosByName, arg_0, arg_1)))};
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call.getMethodTypeExpression(), uniqueMatch == null ? "The type specifier does not match any version of the overloaded method '" + methodName + "'." : "The type specifier does not match method '" + uniqueMatch.getDescription() + "'.", ProblemHighlightType.GENERIC_ERROR, $i$f$filter2);
                return;
            }
            Iterable $this$none$iv = matchedMethodInfos;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    JvmMethodInfo it = (JvmMethodInfo)element$iv;
                    boolean bl3 = false;
                    if (!(it.isStatic() == call.isStatic())) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            JvmMethodInfo matchedMethodInfo = (JvmMethodInfo)CollectionsKt.first((List)matchedMethodInfos);
            boolean shouldBeStatic = matchedMethodInfo.isStatic();
            GetMethodIdCall correctCall = call.toggleStaticity();
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix JNI GetMethodID call", "Replace with '" + correctCall.getFunctionName() + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniGetMethodIdInspection.inspect$lambda$7(correctCall, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, call.getFunctionIdentifier(), (String)(matchedMethodInfo.isConstructor() ? "A constructor ID should be acquired by calling 'GetMethodID'." : "'" + matchedMethodInfo.getDescription() + "' is " + (shouldBeStatic ? "a static" : "an instance") + " method and should be acquired by '" + correctCall.getFunctionName() + "'."), ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean inspect$lambda$4$lambda$3(ProblemDescriptor $descriptor, List $matchedMethodInfosByName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $matchedMethodInfosByName;
        ProblemDescriptor problemDescriptor = $descriptor;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JniUtilsKt.quoted(it.getMethodType()));
        }
        return InspectionUtilsKt.replaceAtHighlighted(problemDescriptor, (List)destination$iv$iv);
    }

    private static final boolean inspect$lambda$4(List $matchedMethodInfosByName, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniGetMethodIdInspection.inspect$lambda$4$lambda$3(descriptor, $matchedMethodInfosByName));
    }

    private static final boolean inspect$lambda$7$lambda$6(ProblemDescriptor $descriptor, GetMethodIdCall $correctCall) {
        String[] stringArray = new String[]{$correctCall.getFunctionName()};
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    private static final boolean inspect$lambda$7(GetMethodIdCall $correctCall, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniGetMethodIdInspection.inspect$lambda$7$lambda$6(descriptor, $correctCall));
    }

    public static final /* synthetic */ void access$inspect(JniGetMethodIdInspection $this, JvmType declaredClassType, PsiClass methodSourceClass, GetMethodIdCall call, ProblemsHolder holder) {
        $this.inspect(declaredClassType, methodSourceClass, call, holder);
    }
}

