/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.color;

import com.android.tools.pixelprobe.color.CieLabColorSpace;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class Colors {
    private Colors() {
    }

    public static float[] linearRgbToRgb(float[] c) {
        float[] v = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            v[i] = Colors.linearRgbToRgb(c[i]);
        }
        return v;
    }

    public static float linearRgbToRgb(float c) {
        return c <= 0.0031308f ? c * 12.92f : (float)Math.pow(c, 0.4166666567325592) * 1.055f - 0.055f;
    }

    public static float toneMappingReinhard(float x) {
        return x / (1.0f + x);
    }

    public static float toneMappingACES(float x) {
        float a = 2.51f;
        float b = 0.03f;
        float c = 2.43f;
        float d = 0.59f;
        float e = 0.14f;
        return x * (a * x + b) / (x * (c * x + d) + e);
    }

    public static ColorSpace getLabColorSpace() {
        return CieLabColorSpace.getInstance();
    }

    public static ColorSpace getCmykColorSpace() {
        return ColorSpaceHolder.CMYK_ICC_ColorSpace;
    }

    public static float[] hsbToRgb(float H, float S, float B) {
        if (S == 0.0f) {
            return new float[]{B, B, B};
        }
        double h = (double)H * 6.0;
        if (h >= 6.0) {
            h = 0.0;
        }
        double f = h - Math.floor(h);
        double u = (double)B * (1.0 - (double)S);
        double v = (double)B * (1.0 - (double)S * f);
        double w = (double)B * (1.0 - (double)S * (1.0 - f));
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        switch ((int)h) {
            case 0: {
                r = B;
                g = w;
                b = u;
                break;
            }
            case 1: {
                r = v;
                g = B;
                b = u;
                break;
            }
            case 2: {
                r = u;
                g = B;
                b = w;
                break;
            }
            case 3: {
                r = u;
                g = v;
                b = B;
                break;
            }
            case 4: {
                r = w;
                g = u;
                b = B;
                break;
            }
            case 5: {
                r = B;
                g = u;
                b = v;
            }
        }
        return new float[]{(float)r, (float)g, (float)b};
    }

    public static String getIccProfileDescription(ColorSpace colorSpace) {
        if (colorSpace == null) {
            return "";
        }
        if (colorSpace.isCS_sRGB()) {
            return "sRGB IEC61966-2.1";
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            return Colors.getIccProfileDescription(((ICC_ColorSpace)colorSpace).getProfile());
        }
        return "";
    }

    public static String getIccProfileDescription(ICC_Profile profile) {
        if (profile == null) {
            return "";
        }
        byte[] data = profile.getData(1684370275);
        if (data == null) {
            return "";
        }
        try {
            if (data[0] == 109 && data[1] == 108 && data[2] == 117 && data[3] == 99) {
                int count = data[8] << 24 | data[9] << 16 | data[10] << 8 | data[11];
                int index = 12;
                for (int i = 0; i < count; ++i) {
                    String locale = new String(data, index += 4, 4, "US-ASCII");
                    index += 4;
                    if (!locale.startsWith("en")) continue;
                    int length = data[index++] << 24 | data[index++] << 16 | data[index++] << 8 | data[index++];
                    int offset = data[index++] << 24 | data[index++] << 16 | data[index++] << 8 | data[index++];
                    index += offset - index;
                    return new String(data, index, Math.max(0, length - 2), "UTF-16BE");
                }
            }
            int length = data[8] << 24 | data[9] << 16 | data[10] << 8 | data[11];
            return new String(data, 12, length - 1, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private static final class ColorSpaceHolder {
        static ICC_Profile CMYK_ICC_Profile;
        static ICC_ColorSpace CMYK_ICC_ColorSpace;

        private ColorSpaceHolder() {
        }

        static {
            try (InputStream in = Colors.class.getResourceAsStream("/icc/cmyk/USWebCoatedSWOP.icc");){
                CMYK_ICC_Profile = ICC_Profile.getInstance(in);
                CMYK_ICC_ColorSpace = new ICC_ColorSpace(CMYK_ICC_Profile);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot find built-in CMYK ICC color profile");
            }
        }
    }
}

