/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.google.services.firebase.directaccess.client.TokenCallCredentialsKt;
import io.grpc.CallCredentials;
import io.grpc.Status;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/services/firebase/directaccess/client/TokenCallCredentials;", "Lio/grpc/CallCredentials;", "tokenFetcher", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "applyRequestMetadata", "", "requestInfo", "Lio/grpc/CallCredentials$RequestInfo;", "executor", "Ljava/util/concurrent/Executor;", "applier", "Lio/grpc/CallCredentials$MetadataApplier;", "thisUsesUnstableApi", "directaccess-client"})
public final class TokenCallCredentials
extends CallCredentials {
    @NotNull
    private final Function0<String> tokenFetcher;

    public TokenCallCredentials(@NotNull Function0<String> tokenFetcher) {
        Intrinsics.checkNotNullParameter(tokenFetcher, (String)"tokenFetcher");
        this.tokenFetcher = tokenFetcher;
    }

    public void applyRequestMetadata(@NotNull CallCredentials.RequestInfo requestInfo, @NotNull Executor executor, @NotNull CallCredentials.MetadataApplier applier) {
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        executor.execute(() -> TokenCallCredentials.applyRequestMetadata$lambda$0(this, applier));
    }

    public void thisUsesUnstableApi() {
    }

    private static final void applyRequestMetadata$lambda$0(TokenCallCredentials this$0, CallCredentials.MetadataApplier $applier) {
        try {
            String string = (String)this$0.tokenFetcher.invoke();
            if (string == null) {
                throw Status.UNAUTHENTICATED.asException();
            }
            String token = string;
            io.grpc.Metadata headers = new io.grpc.Metadata();
            headers.put(TokenCallCredentialsKt.access$getAUTHORIZATION_METADATA_KEY$p(), (Object)("Bearer " + token));
            $applier.apply(headers);
        }
        catch (Throwable e) {
            Status status = Status.fromThrowable((Throwable)e);
            if (status.getCode() == Status.UNAUTHENTICATED.getCode()) {
                $applier.fail(status);
            }
            Logger.getLogger(Reflection.getOrCreateKotlinClass(TokenCallCredentials.class).getQualifiedName()).log(Level.SEVERE, "Error applying header", e);
            $applier.fail(Status.UNAUTHENTICATED.withCause(e));
        }
    }
}

