/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class XmlEndElementChunk
extends XmlNodeChunk {
    private final int namespace;
    private final int name;

    protected XmlEndElementChunk(ByteBuffer buffer, Chunk parent) {
        super(buffer, parent);
        this.namespace = buffer.getInt();
        this.name = buffer.getInt();
    }

    public String getNamespace() {
        return this.getString(this.namespace);
    }

    public String getName() {
        return this.getString(this.name);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_END_ELEMENT;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        output.writeInt(this.namespace);
        output.writeInt(this.name);
    }

    @Override
    public String toString() {
        return String.format("XmlEndElementChunk{line=%d, comment=%s, namespace=%s, name=%s}", this.getLineNumber(), this.getComment(), this.getNamespace(), this.getName());
    }
}

