/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelLibraryResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/model/DefaultLintModelDependencyGraph;", "Lcom/android/tools/lint/model/LintModelDependencyGraph;", "roots", "", "Lcom/android/tools/lint/model/LintModelDependency;", "libraryResolver", "Lcom/android/tools/lint/model/LintModelLibraryResolver;", "<init>", "(Ljava/util/List;Lcom/android/tools/lint/model/LintModelLibraryResolver;)V", "getRoots", "()Ljava/util/List;", "transitiveDependencies", "", "", "mavenTransitiveDependencies", "register", "", "item", "findLibrary", "Lcom/android/tools/lint/model/LintModelLibrary;", "mavenName", "direct", "", "allLibraries", "allItems", "getAllGraphItems", "getAllLibraries", "toString", "android.sdktools.lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelDependencies.kt\ncom/android/tools/lint/model/DefaultLintModelDependencyGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n295#2,2:240\n1611#2,9:243\n1863#2:252\n1864#2:254\n1620#2:255\n1#3:242\n1#3:253\n*S KotlinDebug\n*F\n+ 1 LintModelDependencies.kt\ncom/android/tools/lint/model/DefaultLintModelDependencyGraph\n*L\n172#1:240,2\n194#1:243,9\n194#1:252\n194#1:254\n194#1:255\n194#1:253\n*E\n"})
public final class DefaultLintModelDependencyGraph
implements LintModelDependencyGraph {
    @NotNull
    private final List<LintModelDependency> roots;
    @NotNull
    private final LintModelLibraryResolver libraryResolver;
    @NotNull
    private final Map<String, LintModelDependency> transitiveDependencies;
    @NotNull
    private final Map<String, LintModelDependency> mavenTransitiveDependencies;
    @Nullable
    private List<? extends LintModelLibrary> allLibraries;
    @Nullable
    private List<? extends LintModelDependency> allItems;

    public DefaultLintModelDependencyGraph(@NotNull List<? extends LintModelDependency> roots, @NotNull LintModelLibraryResolver libraryResolver) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)libraryResolver, (String)"libraryResolver");
        this.roots = roots;
        this.libraryResolver = libraryResolver;
        this.transitiveDependencies = new LinkedHashMap();
        this.mavenTransitiveDependencies = new LinkedHashMap();
        for (LintModelDependency item : this.getRoots()) {
            this.register(item);
        }
    }

    @Override
    @NotNull
    public List<LintModelDependency> getRoots() {
        return this.roots;
    }

    private final void register(LintModelDependency item) {
        if (this.transitiveDependencies.containsKey(item.getIdentifier())) {
            return;
        }
        this.transitiveDependencies.put(item.getIdentifier(), item);
        if (!Intrinsics.areEqual((Object)item.getArtifactName(), (Object)":")) {
            this.mavenTransitiveDependencies.put(item.getArtifactName(), item);
        }
        for (LintModelDependency dependsOn : item.getDependencies()) {
            this.register(dependsOn);
        }
    }

    @Override
    @Nullable
    public LintModelLibrary findLibrary(@NotNull String mavenName, boolean direct) {
        String identifier;
        String string2;
        Intrinsics.checkNotNullParameter((Object)mavenName, (String)"mavenName");
        if (direct) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = this.getRoots();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LintModelDependency it = (LintModelDependency)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getArtifactName(), (Object)mavenName)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            LintModelDependency lintModelDependency = v0;
            string2 = lintModelDependency != null ? lintModelDependency.getIdentifier() : null;
        } else {
            LintModelDependency lintModelDependency = this.mavenTransitiveDependencies.get(mavenName);
            string2 = lintModelDependency != null ? lintModelDependency.getIdentifier() : null;
        }
        if ((identifier = string2) == null) {
            return null;
        }
        return this.libraryResolver.getLibrary(identifier);
    }

    @Override
    @NotNull
    public List<LintModelDependency> getAllGraphItems() {
        List list2 = this.allItems;
        if (list2 == null) {
            List list3;
            List it = list3 = CollectionsKt.toList((Iterable)this.transitiveDependencies.values());
            boolean bl = false;
            this.allItems = it;
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LintModelLibrary> getAllLibraries() {
        List list2 = this.allLibraries;
        if (list2 == null) {
            List list3;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.getAllGraphItems();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LintModelLibrary it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LintModelDependency it = (LintModelDependency)element$iv$iv;
                boolean bl2 = false;
                if (this.libraryResolver.getLibrary(it.getIdentifier()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List it = list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            this.allLibraries = it;
            list2 = list3;
        }
        return list2;
    }

    @NotNull
    public String toString() {
        return this.getRoots().toString();
    }
}

