/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.fx.result;

import com.android.tools.lint.checks.fx.result.MethodId;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u000b2\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0005\f\r\u000e\u000f\u0010\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId;", "", "fqn", "", "getFqn", "()Ljava/lang/String;", "Named", "Anon", "Guarded", "Common", "Local", "Companion", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Common;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Guarded;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Local;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Named;", "android.sdktools.lint-checks"})
public interface ClassId {
    @NotNull
    public static final Companion Companion = com.android.tools.lint.checks.fx.result.ClassId$Companion.$$INSTANCE;

    @Nullable
    default public String getFqn() {
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H&J\u0006\u0010\r\u001a\u00020\u0005R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\t\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\u0007\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Anon;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "<init>", "()V", "path", "", "getPath", "()Ljava/lang/String;", "offsetString", "str", "getStr", "str$delegate", "Lkotlin/Lazy;", "toString", "Precise", "Imprecise", "Companion", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon$Imprecise;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon$Precise;", "android.sdktools.lint-checks"})
    private static abstract class Anon
    implements ClassId {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lazy str$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Anon.str_delegate$lambda$0(this));

        private Anon() {
        }

        @NotNull
        public abstract String getPath();

        @NotNull
        public abstract String offsetString();

        private final String getStr() {
            Lazy lazy = this.str$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String toString() {
            return this.getStr();
        }

        @Override
        @Nullable
        public String getFqn() {
            return ClassId.super.getFqn();
        }

        private static final String str_delegate$lambda$0(Anon this$0) {
            return "\u2e28Anon@$" + new File(this$0.getPath()).getName() + ":" + this$0.offsetString() + "\u2e29";
        }

        public /* synthetic */ Anon(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Anon$Companion;", "", "<init>", "()V", "invoke", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon;", "elem", "Lcom/intellij/psi/PsiClass;", "android.sdktools.lint-checks"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Anon invoke(@NotNull PsiClass elem) {
                Anon anon;
                Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                PsiFile file = elem.getContainingFile();
                TextRange textRange = elem.getTextRange();
                if (textRange == null) {
                    String string2 = file.getVirtualFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    anon = new Imprecise(string2, elem.getTextOffset());
                } else {
                    Document document = PsiDocumentManager.getInstance((Project)elem.getProject()).getDocument(file);
                    Intrinsics.checkNotNull((Object)document);
                    Document doc = document;
                    int startOffset = textRange.getStartOffset();
                    int l = startOffset == -1 ? -1 : doc.getLineNumber(startOffset) + 1;
                    int c1 = startOffset - doc.getLineStartOffset(doc.getLineNumber(startOffset)) + 1;
                    int c2 = c1 + textRange.getEndOffset() - startOffset;
                    String string3 = file.getVirtualFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    anon = new Precise(string3, l, c1, c2);
                }
                return anon;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Anon$Imprecise;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon;", "path", "", "offset", "", "<init>", "(Ljava/lang/String;I)V", "getPath", "()Ljava/lang/String;", "getOffset", "()I", "offsetString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "android.sdktools.lint-checks"})
        private static final class Imprecise
        extends Anon {
            @NotNull
            private final String path;
            private final int offset;

            public Imprecise(@NotNull String path, int offset) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
                this.offset = offset;
            }

            @Override
            @NotNull
            public String getPath() {
                return this.path;
            }

            public final int getOffset() {
                return this.offset;
            }

            @Override
            @NotNull
            public String offsetString() {
                return "~" + this.offset;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            public final int component2() {
                return this.offset;
            }

            @NotNull
            public final Imprecise copy(@NotNull String path, int offset) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new Imprecise(path, offset);
            }

            public static /* synthetic */ Imprecise copy$default(Imprecise imprecise, String string2, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string2 = imprecise.path;
                }
                if ((n2 & 2) != 0) {
                    n = imprecise.offset;
                }
                return imprecise.copy(string2, n);
            }

            public int hashCode() {
                int result2 = this.path.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.offset);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Imprecise)) {
                    return false;
                }
                Imprecise imprecise = (Imprecise)other;
                if (!Intrinsics.areEqual((Object)this.path, (Object)imprecise.path)) {
                    return false;
                }
                return this.offset == imprecise.offset;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Anon$Precise;", "Lcom/android/tools/lint/checks/fx/result/ClassId$Anon;", "path", "", "line", "", "col1", "col2", "<init>", "(Ljava/lang/String;III)V", "getPath", "()Ljava/lang/String;", "getLine", "()I", "getCol1", "getCol2", "offsetString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "android.sdktools.lint-checks"})
        public static final class Precise
        extends Anon {
            @NotNull
            private final String path;
            private final int line;
            private final int col1;
            private final int col2;

            public Precise(@NotNull String path, int line, int col1, int col2) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
                this.line = line;
                this.col1 = col1;
                this.col2 = col2;
            }

            @Override
            @NotNull
            public String getPath() {
                return this.path;
            }

            public final int getLine() {
                return this.line;
            }

            public final int getCol1() {
                return this.col1;
            }

            public final int getCol2() {
                return this.col2;
            }

            @Override
            @NotNull
            public String offsetString() {
                return this.line == -1 ? "?" : this.line + ":" + this.col1 + "-" + this.col2;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            public final int component2() {
                return this.line;
            }

            public final int component3() {
                return this.col1;
            }

            public final int component4() {
                return this.col2;
            }

            @NotNull
            public final Precise copy(@NotNull String path, int line, int col1, int col2) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new Precise(path, line, col1, col2);
            }

            public static /* synthetic */ Precise copy$default(Precise precise, String string2, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    string2 = precise.path;
                }
                if ((n4 & 2) != 0) {
                    n = precise.line;
                }
                if ((n4 & 4) != 0) {
                    n2 = precise.col1;
                }
                if ((n4 & 8) != 0) {
                    n3 = precise.col2;
                }
                return precise.copy(string2, n, n2, n3);
            }

            public int hashCode() {
                int result2 = this.path.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.line);
                result2 = result2 * 31 + Integer.hashCode(this.col1);
                result2 = result2 * 31 + Integer.hashCode(this.col2);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Precise)) {
                    return false;
                }
                Precise precise = (Precise)other;
                if (!Intrinsics.areEqual((Object)this.path, (Object)precise.path)) {
                    return false;
                }
                if (this.line != precise.line) {
                    return false;
                }
                if (this.col1 != precise.col1) {
                    return false;
                }
                return this.col2 == precise.col2;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000f\b\u0082\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0017\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0012\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\b\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Common;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "", "aliases", "", "", "<init>", "(Ljava/lang/String;ILjava/util/List;)V", "", "(Ljava/lang/String;I[Ljava/lang/String;)V", "getAliases", "()Ljava/util/List;", "Boolean", "Int", "Char", "Byte", "Short", "Long", "Float", "Double", "String", "Unit", "Array", "android.sdktools.lint-checks"})
    private static final class Common
    extends Enum<Common>
    implements ClassId {
        @NotNull
        private final List<String> aliases;
        public static final /* enum */ Common Boolean;
        public static final /* enum */ Common Int;
        public static final /* enum */ Common Char;
        public static final /* enum */ Common Byte;
        public static final /* enum */ Common Short;
        public static final /* enum */ Common Long;
        public static final /* enum */ Common Float;
        public static final /* enum */ Common Double;
        public static final /* enum */ Common String;
        public static final /* enum */ Common Unit;
        public static final /* enum */ Common Array;
        private static final /* synthetic */ Common[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Common(List<String> aliases) {
            this.aliases = aliases;
        }

        @NotNull
        public final List<String> getAliases() {
            return this.aliases;
        }

        private Common(String ... aliases) {
            this(ArraysKt.asList((Object[])aliases));
        }

        public static Common[] values() {
            return (Common[])$VALUES.clone();
        }

        public static Common valueOf(String value) {
            return Enum.valueOf(Common.class, value);
        }

        @NotNull
        public static EnumEntries<Common> getEntries() {
            return $ENTRIES;
        }

        @Override
        @Nullable
        public String getFqn() {
            return ClassId.super.getFqn();
        }

        static {
            String[] stringArray = new String[]{"java.lang.Boolean", "kotlin.Boolean"};
            Boolean = new Common(stringArray);
            stringArray = new String[]{"java.lang.Integer", "kotlin.Int"};
            Int = new Common(stringArray);
            stringArray = new String[]{"java.lang.Char", "kotlin.Char"};
            Char = new Common(stringArray);
            stringArray = new String[]{"java.lang.Byte", "kotlin.Byte"};
            Byte = new Common(stringArray);
            stringArray = new String[]{"java.lang.Short", "kotlin.Short"};
            Short = new Common(stringArray);
            stringArray = new String[]{"java.lang.Long", "kotlin.Long"};
            Long = new Common(stringArray);
            stringArray = new String[]{"java.lang.Float", "kotlin.Float"};
            Float = new Common(stringArray);
            stringArray = new String[]{"java.lang.Double", "kotlin.Double"};
            Double = new Common(stringArray);
            stringArray = new String[]{"java.lang.String", "kotlin.String"};
            String = new Common(stringArray);
            stringArray = new String[]{"kotlin.Unit"};
            Unit = new Common(stringArray);
            stringArray = new String[]{"kotlin.Array"};
            Array = new Common(stringArray);
            $VALUES = commonArray = new Common[]{Common.Boolean, Common.Int, Common.Char, Common.Byte, Common.Short, Common.Long, Common.Float, Common.Double, Common.String, Common.Unit, Common.Array};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0011\u0010\u0004\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0011\u0018\u0001H\u0086\bR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Companion;", "", "<init>", "()V", "of", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "ref", "Lcom/intellij/psi/PsiClass;", "fqn", "", "guard", "base", "of$android_sdktools_lint_checks", "type", "Lcom/intellij/psi/PsiClassType;", "c", "Lkotlin/reflect/KClass;", "C", "Array", "getArray", "()Lcom/android/tools/lint/checks/fx/result/ClassId;", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Class.kt\ncom/android/tools/lint/checks/fx/result/ClassId$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ClassId Array;

        private Companion() {
        }

        @NotNull
        public final ClassId of(@NotNull PsiClass ref) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            String fqn = ref.getQualifiedName();
            return fqn == null ? (ClassId)Anon.Companion.invoke(ref) : this.of(fqn);
        }

        @NotNull
        public final ClassId of(@NotNull String fqn) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
                Iterable iterable = (Iterable)Common.getEntries();
                for (Object t : iterable) {
                    Common it = (Common)t;
                    boolean bl = false;
                    if (!it.getAliases().contains(fqn)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Common common = v0;
            return common != null ? (ClassId)common : (ClassId)Named.Companion.of(fqn);
        }

        @NotNull
        public final ClassId of$android_sdktools_lint_checks(@NotNull Object guard, @NotNull PsiClass base) {
            Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            String string2 = base.getQualifiedName();
            Intrinsics.checkNotNull((Object)string2);
            return new Guarded(guard, this.of(string2));
        }

        @NotNull
        public final ClassId of(@NotNull PsiClassType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string2 = type.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
            return this.of(string2);
        }

        @NotNull
        public final ClassId of(@NotNull KClass<?> c) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            String string2 = JvmClassMappingKt.getJavaClass(c).getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalName(...)");
            return this.of(string2);
        }

        public final /* synthetic */ <C> ClassId of() {
            boolean $i$f$of = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"C");
            return this.of(Reflection.getOrCreateKotlinClass(Object.class));
        }

        @NotNull
        public final ClassId getArray() {
            return Array;
        }

        static {
            $$INSTANCE = new Companion();
            Array = Common.Array;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static String getFqn(@NotNull ClassId $this) {
            return $this.getFqn();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Guarded;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "guard", "", "base", "<init>", "(Ljava/lang/Object;Lcom/android/tools/lint/checks/fx/result/ClassId;)V", "getGuard", "()Ljava/lang/Object;", "getBase", "()Lcom/android/tools/lint/checks/fx/result/ClassId;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "android.sdktools.lint-checks"})
    public static final class Guarded
    implements ClassId {
        @NotNull
        private final Object guard;
        @NotNull
        private final ClassId base;

        public Guarded(@NotNull Object guard, @NotNull ClassId base) {
            Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.guard = guard;
            this.base = base;
        }

        @NotNull
        public final Object getGuard() {
            return this.guard;
        }

        @NotNull
        public final ClassId getBase() {
            return this.base;
        }

        @NotNull
        public String toString() {
            return this.guard + " \u25c1 " + this.base;
        }

        @NotNull
        public final Object component1() {
            return this.guard;
        }

        @NotNull
        public final ClassId component2() {
            return this.base;
        }

        @NotNull
        public final Guarded copy(@NotNull Object guard, @NotNull ClassId base) {
            Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            return new Guarded(guard, base);
        }

        public static /* synthetic */ Guarded copy$default(Guarded guarded, Object object, ClassId classId, int n, Object object2) {
            if ((n & 1) != 0) {
                object = guarded.guard;
            }
            if ((n & 2) != 0) {
                classId = guarded.base;
            }
            return guarded.copy(object, classId);
        }

        public int hashCode() {
            int result2 = this.guard.hashCode();
            result2 = result2 * 31 + this.base.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Guarded)) {
                return false;
            }
            Guarded guarded = (Guarded)other;
            if (!Intrinsics.areEqual((Object)this.guard, (Object)guarded.guard)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.base, (Object)guarded.base);
        }

        @Override
        @Nullable
        public String getFqn() {
            return ClassId.super.getFqn();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0001H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Local;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "root", "path", "", "Lcom/android/tools/lint/checks/fx/result/MethodId;", "<init>", "(Lcom/android/tools/lint/checks/fx/result/ClassId;Ljava/util/List;)V", "getRoot", "()Lcom/android/tools/lint/checks/fx/result/ClassId;", "getPath", "()Ljava/util/List;", "asContainingClassAndInnermostMethod", "Lkotlin/Pair;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "android.sdktools.lint-checks"})
    public static final class Local
    implements ClassId {
        @NotNull
        private final ClassId root;
        @NotNull
        private final List<MethodId> path;

        public Local(@NotNull ClassId root2, @NotNull List<MethodId> path) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter(path, (String)"path");
            this.root = root2;
            this.path = path;
            if (!(!((Collection)this.path).isEmpty())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @NotNull
        public final ClassId getRoot() {
            return this.root;
        }

        @NotNull
        public final List<MethodId> getPath() {
            return this.path;
        }

        @NotNull
        public final Pair<ClassId, MethodId> asContainingClassAndInnermostMethod() {
            ClassId parentClassId = this.path.size() == 1 ? this.root : (ClassId)new Local(this.root, this.path.subList(0, this.path.size() - 1));
            return TuplesKt.to((Object)parentClassId, (Object)CollectionsKt.last(this.path));
        }

        @NotNull
        public String toString() {
            return this.root + "\u219d" + CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)"\u219d", null, null, (int)0, null, Local::toString$lambda$0, (int)30, null);
        }

        @NotNull
        public final ClassId component1() {
            return this.root;
        }

        @NotNull
        public final List<MethodId> component2() {
            return this.path;
        }

        @NotNull
        public final Local copy(@NotNull ClassId root2, @NotNull List<MethodId> path) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return new Local(root2, path);
        }

        public static /* synthetic */ Local copy$default(Local local, ClassId classId, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                classId = local.root;
            }
            if ((n & 2) != 0) {
                list2 = local.path;
            }
            return local.copy(classId, list2);
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)local.root)) {
                return false;
            }
            return Intrinsics.areEqual(this.path, local.path);
        }

        @Override
        @Nullable
        public String getFqn() {
            return ClassId.super.getFqn();
        }

        private static final CharSequence toString$lambda$0(MethodId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Named;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "fqn", "", "<init>", "(Ljava/lang/String;)V", "getFqn", "()Ljava/lang/String;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "android.sdktools.lint-checks"})
    private static final class Named
    implements ClassId {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String fqn;

        public Named(@NotNull String fqn) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            this.fqn = fqn;
        }

        @Override
        @NotNull
        public String getFqn() {
            return this.fqn;
        }

        @NotNull
        public String toString() {
            String string2;
            String string3;
            int i = StringsKt.indexOf$default((CharSequence)this.getFqn(), (char)'<', (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string3 = this.getFqn();
            } else {
                String string4 = this.getFqn().substring(0, i);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String untilBracket = string3;
            int j = StringsKt.lastIndexOf$default((CharSequence)untilBracket, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (j == -1) {
                string2 = this.getFqn();
            } else {
                String string5 = this.getFqn().substring(j + 1, this.getFqn().length());
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            }
            return string2;
        }

        @NotNull
        public final String component1() {
            return this.fqn;
        }

        @NotNull
        public final Named copy(@NotNull String fqn) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            return new Named(fqn);
        }

        public static /* synthetic */ Named copy$default(Named named, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = named.fqn;
            }
            return named.copy(string2);
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Named)) {
                return false;
            }
            Named named = (Named)other;
            return Intrinsics.areEqual((Object)this.fqn, (Object)named.fqn);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/fx/result/ClassId$Named$Companion;", "", "<init>", "()V", "of", "Lcom/android/tools/lint/checks/fx/result/ClassId$Named;", "name", "", "android.sdktools.lint-checks"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Named of(@NotNull String name) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int bracketStart = StringsKt.indexOf$default((CharSequence)name, (char)'<', (int)0, (boolean)false, (int)6, null);
                if (bracketStart == -1) {
                    string2 = name;
                } else {
                    String string3 = name.substring(0, bracketStart);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
                return new Named(string2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

