/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotatedCallPath;
import com.android.tools.lint.checks.WrongThreadInterproceduralDetectorKt;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.interprocedural.CallGraphKt;
import com.android.tools.lint.detector.api.interprocedural.CallGraphResult;
import com.android.tools.lint.detector.api.interprocedural.ContextualEdge;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/WrongThreadInterproceduralDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "isCallGraphRequired", "", "analyzeCallGraph", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "callGraph", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraphResult;", "Companion", "android.sdktools.lint-checks"})
public final class WrongThreadInterproceduralDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public boolean isCallGraphRequired() {
        return true;
    }

    @Override
    public void analyzeCallGraph(@NotNull Context context2, @NotNull CallGraphResult callGraph) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callGraph, (String)"callGraph");
        Collection<AnnotatedCallPath> badPaths = WrongThreadInterproceduralDetectorKt.searchForInterproceduralThreadAnnotationViolations(callGraph.getCallGraph(), callGraph.getReceiverEval());
        for (AnnotatedCallPath annotatedCallPath : badPaths) {
            List<ContextualEdge> searchNodes = annotatedCallPath.component1();
            String sourceAnnotation = annotatedCallPath.component2();
            String sinkAnnotation = annotatedCallPath.component3();
            if (searchNodes.size() == 1) continue;
            ContextualEdge second = searchNodes.get(1);
            UElement pathBeginning = second.getCause();
            UastParser parser2 = context2.getClient().getUastParser(context2.getProject());
            Location location = parser2.createLocation(pathBeginning);
            String pathStr = CollectionsKt.joinToString$default((Iterable)searchNodes, (CharSequence)" -> ", null, null, (int)0, null, WrongThreadInterproceduralDetector::analyzeCallGraph$lambda$0, (int)30, null);
            String sourceStr = StringsKt.substringAfterLast$default((String)sourceAnnotation, (char)'.', null, (int)2, null);
            String sinkStr = StringsKt.substringAfterLast$default((String)sinkAnnotation, (char)'.', null, (int)2, null);
            String message = "Interprocedural thread annotation violation (" + sourceStr + " to " + sinkStr + "):\n" + pathStr;
            context2.report(ISSUE, location, message, null);
        }
    }

    private static final CharSequence analyzeCallGraph$lambda$0(ContextualEdge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CallGraphKt.getShortName(it.getContextualNode().getNode());
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(WrongThreadInterproceduralDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
        ISSUE = Issue.Companion.create$default(companion, "WrongThreadInterprocedural", "Wrong Thread (Interprocedural)", "\n                Searches for interprocedural call paths that violate thread annotations \\\n                in the program. Tracks the flow of instantiated types and lambda \\\n                expressions to increase accuracy across method boundaries.\n                ", implementation, "https://developer.android.com/guide/components/processes-and-threads.html#Threads", category, 6, severity, false, true, null, null, 3072, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/WrongThreadInterproceduralDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

