/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "evaluatePermissionRequest", "element", "Lorg/w3c/dom/Element;", "getValidCoverageRanges", "", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "purposeElements", "permissionInfo", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$PermissionInfo;", "mergeRanges", "ranges", "subtractRanges", "source", "toSubtract", "formatRange", "", "range", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPurposeDeclarationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1611#2,9:338\n1863#2:347\n1864#2:350\n1620#2:351\n1053#2:352\n1#3:348\n1#3:349\n*S KotlinDebug\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector\n*L\n139#1:338,9\n139#1:347\n139#1:350\n139#1:351\n169#1:352\n139#1:349\n*E\n"})
public final class PurposeDeclarationDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ATTR_MIN = "min";
    @NotNull
    private static final String ATTR_MAX = "max";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_MIN = "requiresPurposeMin";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_MAX = "requiresPurposeMax";
    private static final int MIN_SDK_VERSION_DEFAULT = 1;
    private static final int MAX_SDK_VERSION_DEFAULT = 999999;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PurposeDeclarationDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue MISSING_PURPOSE;
    @NotNull
    private static final ConcurrentHashMap<String, Map<String, Companion.PermissionInfo>> cache;

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getMainProject().getTargetSdkVersion().getFeatureLevel() < 37) {
            return;
        }
        Node node = context2.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node root2 = node;
        Element element = XmlUtils.getFirstSubTag((Node)root2);
        while (element != null) {
            if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission") || Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission-sdk-23")) {
                this.evaluatePermissionRequest(context2, element);
            }
            element = XmlUtils.getNextTag((Node)element);
        }
    }

    private final void evaluatePermissionRequest(Context context2, Element element) {
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2 == null) {
            return;
        }
        String permissionName = string2;
        Map permissionsMap = PurposeDeclarationDetector.Companion.getPermissionsMap(context2.getMainProject());
        Companion.PermissionInfo permissionInfo = (Companion.PermissionInfo)permissionsMap.get(permissionName);
        if (permissionInfo == null) {
            return;
        }
        Companion.PermissionInfo permissionInfo2 = permissionInfo;
        int requiresPurposeMinSdkVersion = permissionInfo2.getRequiresPurposeSdkRange().getMin();
        int projectMinSdk = context2.getMainProject().getMinSdkVersion().getFeatureLevel();
        String string3 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeNS(...)");
        Integer n = StringsKt.toIntOrNull((String)string3);
        int usesPermissionMinSdkVersion = n != null ? n : 1;
        int minSdk = Math.max(requiresPurposeMinSdkVersion, Math.max(projectMinSdk, usesPermissionMinSdkVersion));
        int requiresPurposeMaxSdkVersion = permissionInfo2.getRequiresPurposeSdkRange().getMax();
        int projectTargetSdk = context2.getMainProject().getTargetSdkVersion().getFeatureLevel();
        String string4 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "maxSdkVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeNS(...)");
        Integer n2 = StringsKt.toIntOrNull((String)string4);
        int usesPermissionMaxSdkVersion = n2 != null ? n2 : 999999;
        int maxSdk = Math.min(requiresPurposeMaxSdkVersion, Math.min(projectTargetSdk, usesPermissionMaxSdkVersion));
        if (minSdk > maxSdk) {
            return;
        }
        Companion.SdkRange requiredRange = new Companion.SdkRange(minSdk, maxSdk);
        Iterable iterable = XmlUtils.getSubTagsByName((Node)element, (String)"purpose");
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTagsByName(...)");
        List purposeElements = CollectionsKt.toList((Iterable)iterable);
        if (purposeElements.isEmpty()) {
            String message = "`" + permissionName + "` will not be granted due to missing `<purpose>`. Possible valid purposes: " + CollectionsKt.joinToString$default((Iterable)permissionInfo2.getValidPurposes().keySet(), null, null, null, (int)0, null, null, (int)63, null);
            Context.report$default(context2, MISSING_PURPOSE, Context.getLocation$default(context2, element, null, 2, null), message, null, 8, null);
            return;
        }
        List<Companion.SdkRange> validCoverageRanges = this.getValidCoverageRanges(purposeElements, permissionInfo2);
        List<Companion.SdkRange> uncoveredRanges = this.subtractRanges(requiredRange, validCoverageRanges);
        if (!((Collection)uncoveredRanges).isEmpty()) {
            String formattedUncoveredRanges = CollectionsKt.joinToString$default((Iterable)uncoveredRanges, null, null, null, (int)0, null, arg_0 -> PurposeDeclarationDetector.evaluatePermissionRequest$lambda$0(this, arg_0), (int)31, null);
            String message = "`" + permissionName + "` will not be granted on API level(s) " + formattedUncoveredRanges + " due to no valid `<purpose>`. Ensure valid purpose(s) cover all API level(s). Possible valid purposes: " + CollectionsKt.joinToString$default((Iterable)permissionInfo2.getValidPurposes().keySet(), null, null, null, (int)0, null, null, (int)63, null);
            Context.report$default(context2, MISSING_PURPOSE, Context.getLocation$default(context2, element, null, 2, null), message, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Companion.SdkRange> getValidCoverageRanges(List<? extends Element> purposeElements, Companion.PermissionInfo permissionInfo) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = purposeElements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Companion.SdkRange sdkRange;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element purposeElement = (Element)element$iv$iv;
            boolean bl2 = false;
            String it = string2 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((((CharSequence)it).length() > 0 ? string2 : null) == null) {
                sdkRange = null;
            } else {
                String declaredPurposeName;
                declaredPurposeName = declaredPurposeName;
                if (permissionInfo.getValidPurposes().get(declaredPurposeName) == null) {
                    sdkRange = null;
                } else {
                    Companion.SdkRange platformRange;
                    String string3 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeNS(...)");
                    Integer n = StringsKt.toIntOrNull((String)string3);
                    int purposeMinSdk = n != null ? n : 1;
                    String string4 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", "maxSdkVersion");
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeNS(...)");
                    Integer n2 = StringsKt.toIntOrNull((String)string4);
                    int purposeMaxSdk = n2 != null ? n2 : 999999;
                    int effectiveMin = Math.max(platformRange.getMin(), purposeMinSdk);
                    int effectiveMax = Math.min(platformRange.getMax(), purposeMaxSdk);
                    sdkRange = effectiveMin <= effectiveMax ? new Companion.SdkRange(effectiveMin, effectiveMax) : null;
                }
            }
            if (sdkRange == null) continue;
            Companion.SdkRange it$iv$iv = sdkRange;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List effectiveRanges = (List)destination$iv$iv;
        return this.mergeRanges(effectiveRanges);
    }

    private final List<Companion.SdkRange> mergeRanges(List<Companion.SdkRange> ranges) {
        if (ranges.size() <= 1) {
            return ranges;
        }
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Companion.SdkRange it = (Companion.SdkRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getMin());
                it = (Companion.SdkRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMin()));
            }
        });
        List merged = new ArrayList();
        Companion.SdkRange currentMerge = (Companion.SdkRange)CollectionsKt.first((List)sortedRanges);
        int n = sortedRanges.size();
        for (int i = 1; i < n; ++i) {
            Companion.SdkRange nextRange = (Companion.SdkRange)sortedRanges.get(i);
            if (nextRange.getMin() <= currentMerge.getMax() + 1) {
                currentMerge = new Companion.SdkRange(currentMerge.getMin(), Math.max(currentMerge.getMax(), nextRange.getMax()));
                continue;
            }
            merged.add(currentMerge);
            currentMerge = nextRange;
        }
        merged.add(currentMerge);
        return merged;
    }

    private final List<Companion.SdkRange> subtractRanges(Companion.SdkRange source, List<Companion.SdkRange> toSubtract) {
        List uncovered = new ArrayList();
        int currentSdk = source.getMin();
        for (Companion.SdkRange subtractRange : toSubtract) {
            if (currentSdk < subtractRange.getMin()) {
                uncovered.add(new Companion.SdkRange(currentSdk, Math.min(source.getMax(), subtractRange.getMin() - 1)));
            }
            if ((currentSdk = Math.max(currentSdk, subtractRange.getMax() + 1)) <= source.getMax()) continue;
        }
        if (currentSdk <= source.getMax()) {
            uncovered.add(new Companion.SdkRange(currentSdk, source.getMax()));
        }
        return uncovered;
    }

    private final String formatRange(Companion.SdkRange range) {
        return range.getMin() == range.getMax() ? String.valueOf(range.getMin()) : range.getMin() + "-" + range.getMax();
    }

    private static final CharSequence evaluatePermissionRequest$lambda$0(PurposeDeclarationDetector this$0, Companion.SdkRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.formatRange(it);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = IMPLEMENTATION;
        MISSING_PURPOSE = Issue.Companion.create$default(companion, "MissingPurpose", "Missing purpose for permission", "\n              Some permissions require a valid `<purpose>` child element(s) to be included under \\\n              the `<uses-permission>` declaration.\n              ", implementation, null, category, 10, severity, false, true, null, null, 3344, null);
        cache = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion;", "", "<init>", "()V", "ATTR_MIN", "", "ATTR_MAX", "ATTR_REQUIRES_PURPOSE_MIN", "ATTR_REQUIRES_PURPOSE_MAX", "MIN_SDK_VERSION_DEFAULT", "", "MAX_SDK_VERSION_DEFAULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING_PURPOSE", "Lcom/android/tools/lint/detector/api/Issue;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$PermissionInfo;", "clearPermissionsMap", "", "getPermissionsMap", "project", "Lcom/android/tools/lint/detector/api/Project;", "computePermissionsMap", "SdkRange", "PermissionInfo", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPurposeDeclarationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void clearPermissionsMap() {
            cache.clear();
        }

        private final Map<String, PermissionInfo> getPermissionsMap(Project project) {
            Object object = project.getBuildTarget();
            if (object == null || (object = object.hashString()) == null) {
                return this.computePermissionsMap(project);
            }
            Object targetHash = object;
            Map map2 = cache.computeIfAbsent(targetHash, arg_0 -> Companion.getPermissionsMap$lambda$1(arg_0 -> Companion.getPermissionsMap$lambda$0(project, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
            return map2;
        }

        private final Map<String, PermissionInfo> computePermissionsMap(Project project) {
            File dataFile;
            Path path;
            IAndroidTarget iAndroidTarget = project.getBuildTarget();
            if (iAndroidTarget != null && (path = iAndroidTarget.getPath(29)) != null) {
                Comparable<Path> it = path;
                boolean bl = false;
                File file = new File(it.toString());
                it = file;
                boolean bl2 = false;
                v0 = ((File)it).exists() ? file : null;
            } else {
                v0 = dataFile = null;
            }
            if (dataFile == null) {
                return MapsKt.emptyMap();
            }
            Map mapBuilder = new LinkedHashMap();
            try {
                Document document = XmlUtils.parseUtfXmlFile(dataFile, (boolean)true);
                NodeList permissionNodes = document.getElementsByTagName("permission");
                int n = permissionNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    String permissionName;
                    String string2;
                    Node node = permissionNodes.item(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    Element permissionElement = (Element)node;
                    String it = string2 = permissionElement.getAttribute("name");
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if ((((CharSequence)it).length() > 0 ? string2 : null) == null) continue;
                    permissionName = permissionName;
                    String string3 = permissionElement.getAttribute(PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_MIN);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(...)");
                    Integer n2 = StringsKt.toIntOrNull((String)string3);
                    if (n2 == null) {
                        continue;
                    }
                    int requiresMinSdk = n2;
                    String string4 = permissionElement.getAttribute(PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_MAX);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttribute(...)");
                    Integer n3 = StringsKt.toIntOrNull((String)string4);
                    int requiresMaxSdk = n3 != null ? n3 : 999999;
                    Map purposesMap = new LinkedHashMap();
                    NodeList validPurposeNodes = permissionElement.getElementsByTagName("valid-purpose");
                    int n4 = validPurposeNodes.getLength();
                    for (int j = 0; j < n4; ++j) {
                        String purposeName;
                        String string5;
                        Node node2 = validPurposeNodes.item(j);
                        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                        Element purposeElement = (Element)node2;
                        String it2 = string5 = purposeElement.getAttribute("name");
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it2);
                        if ((((CharSequence)it2).length() > 0 ? string5 : null) == null) continue;
                        purposeName = purposeName;
                        String string6 = purposeElement.getAttribute(PurposeDeclarationDetector.ATTR_MIN);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAttribute(...)");
                        Integer n5 = StringsKt.toIntOrNull((String)string6);
                        if (n5 == null) {
                            continue;
                        }
                        int purposeMinSdk = n5;
                        String string7 = purposeElement.getAttribute(PurposeDeclarationDetector.ATTR_MAX);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAttribute(...)");
                        Integer n6 = StringsKt.toIntOrNull((String)string7);
                        int purposeMaxSdk = n6 != null ? n6 : 999999;
                        purposesMap.put(purposeName, new SdkRange(purposeMinSdk, purposeMaxSdk));
                    }
                    if (!(!purposesMap.isEmpty())) continue;
                    mapBuilder.put(permissionName, new PermissionInfo(new SdkRange(requiresMinSdk, requiresMaxSdk), MapsKt.toMap((Map)purposesMap)));
                }
            }
            catch (Exception exception) {
                return MapsKt.emptyMap();
            }
            return MapsKt.toMap((Map)mapBuilder);
        }

        private static final Map getPermissionsMap$lambda$0(Project $project, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.computePermissionsMap($project);
        }

        private static final Map getPermissionsMap$lambda$1(Function1 $tmp0, Object p0) {
            return (Map)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$PermissionInfo;", "", "requiresPurposeSdkRange", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "validPurposes", "", "", "<init>", "(Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;Ljava/util/Map;)V", "getRequiresPurposeSdkRange", "()Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "getValidPurposes", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
        private static final class PermissionInfo {
            @NotNull
            private final SdkRange requiresPurposeSdkRange;
            @NotNull
            private final Map<String, SdkRange> validPurposes;

            public PermissionInfo(@NotNull SdkRange requiresPurposeSdkRange, @NotNull Map<String, SdkRange> validPurposes) {
                Intrinsics.checkNotNullParameter((Object)requiresPurposeSdkRange, (String)"requiresPurposeSdkRange");
                Intrinsics.checkNotNullParameter(validPurposes, (String)"validPurposes");
                this.requiresPurposeSdkRange = requiresPurposeSdkRange;
                this.validPurposes = validPurposes;
            }

            @NotNull
            public final SdkRange getRequiresPurposeSdkRange() {
                return this.requiresPurposeSdkRange;
            }

            @NotNull
            public final Map<String, SdkRange> getValidPurposes() {
                return this.validPurposes;
            }

            @NotNull
            public final SdkRange component1() {
                return this.requiresPurposeSdkRange;
            }

            @NotNull
            public final Map<String, SdkRange> component2() {
                return this.validPurposes;
            }

            @NotNull
            public final PermissionInfo copy(@NotNull SdkRange requiresPurposeSdkRange, @NotNull Map<String, SdkRange> validPurposes) {
                Intrinsics.checkNotNullParameter((Object)requiresPurposeSdkRange, (String)"requiresPurposeSdkRange");
                Intrinsics.checkNotNullParameter(validPurposes, (String)"validPurposes");
                return new PermissionInfo(requiresPurposeSdkRange, validPurposes);
            }

            public static /* synthetic */ PermissionInfo copy$default(PermissionInfo permissionInfo, SdkRange sdkRange, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    sdkRange = permissionInfo.requiresPurposeSdkRange;
                }
                if ((n & 2) != 0) {
                    map2 = permissionInfo.validPurposes;
                }
                return permissionInfo.copy(sdkRange, map2);
            }

            @NotNull
            public String toString() {
                return "PermissionInfo(requiresPurposeSdkRange=" + this.requiresPurposeSdkRange + ", validPurposes=" + this.validPurposes + ")";
            }

            public int hashCode() {
                int result2 = this.requiresPurposeSdkRange.hashCode();
                result2 = result2 * 31 + ((Object)this.validPurposes).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PermissionInfo)) {
                    return false;
                }
                PermissionInfo permissionInfo = (PermissionInfo)other;
                if (!Intrinsics.areEqual((Object)this.requiresPurposeSdkRange, (Object)permissionInfo.requiresPurposeSdkRange)) {
                    return false;
                }
                return Intrinsics.areEqual(this.validPurposes, permissionInfo.validPurposes);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "", "min", "", "max", "<init>", "(II)V", "getMin", "()I", "getMax", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "android.sdktools.lint-checks"})
        private static final class SdkRange {
            private final int min;
            private final int max;

            public SdkRange(int min, int max) {
                this.min = min;
                this.max = max;
            }

            public final int getMin() {
                return this.min;
            }

            public final int getMax() {
                return this.max;
            }

            public final int component1() {
                return this.min;
            }

            public final int component2() {
                return this.max;
            }

            @NotNull
            public final SdkRange copy(int min, int max) {
                return new SdkRange(min, max);
            }

            public static /* synthetic */ SdkRange copy$default(SdkRange sdkRange, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = sdkRange.min;
                }
                if ((n3 & 2) != 0) {
                    n2 = sdkRange.max;
                }
                return sdkRange.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "SdkRange(min=" + this.min + ", max=" + this.max + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.min);
                result2 = result2 * 31 + Integer.hashCode(this.max);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SdkRange)) {
                    return false;
                }
                SdkRange sdkRange = (SdkRange)other;
                if (this.min != sdkRange.min) {
                    return false;
                }
                return this.max == sdkRange.max;
            }
        }
    }
}

