/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/GestureBackNavDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableReferenceNames", "", "", "visitReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "applicableSuperClasses", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "sameMessage", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nGestureBackNavDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GestureBackNavDetector.kt\ncom/android/tools/lint/checks/GestureBackNavDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,207:1\n18#2:208\n*S KotlinDebug\n*F\n+ 1 GestureBackNavDetector.kt\ncom/android/tools/lint/checks/GestureBackNavDetector\n*L\n72#1:208\n*E\n"})
public final class GestureBackNavDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENABLE_ON_BACK_INVOKED_CALLBACK = "enableOnBackInvokedCallback";
    @NotNull
    private static final String DIALOG_CLASS = "android.app.Dialog";
    @NotNull
    private static final String DIALOG_INTERFACE_ON_KEY_LISTENER = "android.content.DialogInterface.OnKeyListener";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"KEYCODE_BACK");
    }

    @Override
    public void visitReference(@NotNull JavaContext context2, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (referenced instanceof PsiField && context2.getEvaluator().isMemberInClass((PsiMember)referenced, "android.view.KeyEvent")) {
            UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)reference.getUastParent());
            if (uElement == null) {
                return;
            }
            UElement keycodeBack = uElement;
            UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)keycodeBack.getUastParent());
            if (uElement2 == null) {
                return;
            }
            UElement parent = uElement2;
            UElement uElement3 = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
            if (uElement3 == null) {
                return;
            }
            UElement ifExpression = uElement3;
            UElement $this$getParentOfType_u24default$iv = (UElement)reference;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
            if (uMethod == null || (uMethod = uMethod.getJavaPsi()) == null) {
                return;
            }
            UMethod containingMethod = uMethod;
            if (context2.getEvaluator().isStatic((PsiModifierListOwner)containingMethod)) {
                return;
            }
            if (!(context2.getEvaluator().isMemberInSubClassOf((PsiMember)containingMethod, "android.app.Activity", true) || context2.getEvaluator().isMemberInSubClassOf((PsiMember)containingMethod, DIALOG_CLASS, true) || context2.getEvaluator().isMemberInSubClassOf((PsiMember)containingMethod, DIALOG_INTERFACE_ON_KEY_LISTENER, true))) {
                return;
            }
            if (ifExpression instanceof UIfExpression || ifExpression instanceof USwitchClauseExpression || parent instanceof USwitchClauseExpression) {
                String message = "If intercepting back events, this should be handled through the registration of callbacks; see https://developer.android.com/guide/navigation/custom-back/predictive-back-gesture";
                LintFix fix2 = this.fix().url("https://developer.android.com/guide/navigation/custom-back/predictive-back-gesture").build();
                context2.report(new Incident(ISSUE, reference, context2.getLocation(keycodeBack), message, fix2), this.map());
            }
        }
    }

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{"android.app.Activity", DIALOG_CLASS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        for (UMethod method : declaration.getMethods()) {
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"onBackPressed") || method.getVisibility() != UastVisibility.PUBLIC || !((Collection)method.getUastParameters()).isEmpty() || !Intrinsics.areEqual((Object)method.getReturnType(), (Object)PsiTypes.voidType())) continue;
            LintFix fix2 = this.fix().url("https://developer.android.com/guide/navigation/custom-back/predictive-back-gesture").build();
            context2.report(new Incident(ISSUE, method, context2.getNameLocation(method), "`onBackPressed` is no longer called for back gestures; migrate to AndroidX's backward compatible `OnBackPressedDispatcher`", fix2), new LintMap());
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        Project project = context2.getMainProject();
        if (project.isLibrary()) {
            return false;
        }
        Node node = project.getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null || (node = DomExtensions.subtag((Element)node, (String)"application")) == null) {
            return false;
        }
        Node applicationTag = node;
        String flag = applicationTag.getAttributeNS("http://schemas.android.com/apk/res/android", ENABLE_ON_BACK_INVOKED_CALLBACK);
        if (project.getTargetSdk() < 36) {
            return Intrinsics.areEqual((Object)flag, (Object)"true");
        }
        if (Intrinsics.areEqual((Object)flag, (Object)"false")) {
            return false;
        }
        incident.setSeverity(Severity.ERROR);
        return true;
    }

    @Override
    public boolean sameMessage(@NotNull Issue issue, @NotNull String string2, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        return true;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(GestureBackNavDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "GestureBackNavigation", "Usage of KeyEvent.KEYCODE_BACK", "\n          For apps targeting and running on Android 16+ (API 36+), predictive back animations \\\n          are enabled by default. A back gesture does not trigger `{Activity,Dialog}.onBackPressed`, \\\n          and does not dispatch `KeyEvent.KEYCODE_BACK`.\n\n          Apps should migrate to AndroidX's backward compatible `OnBackPressedDispatcher`.\n\n          This lint check does not consider per-activity opt-in/opt-out, so you may need to suppress \\\n          or baseline reported incidents if migrating per-activity.\n          ", implementation, "https://developer.android.com/guide/navigation/custom-back/predictive-back-gesture", category, 7, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/GestureBackNavDetector$Companion;", "", "<init>", "()V", "ENABLE_ON_BACK_INVOKED_CALLBACK", "", "DIALOG_CLASS", "DIALOG_INTERFACE_ON_KEY_LISTENER", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

