/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerDigitalAssetLinkDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "afterCheckRootProject", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nCredentialManagerDigitalAssetLinkDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialManagerDigitalAssetLinkDetector.kt\ncom/android/tools/lint/checks/CredentialManagerDigitalAssetLinkDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n320#2,7:176\n2341#3,14:183\n*S KotlinDebug\n*F\n+ 1 CredentialManagerDigitalAssetLinkDetector.kt\ncom/android/tools/lint/checks/CredentialManagerDigitalAssetLinkDetector\n*L\n80#1:176,7\n114#1:183,14\n*E\n"})
public final class CredentialManagerDigitalAssetLinkDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CREATE_PASSWORD_REQUEST_SEEN_KEY = "CreatePasswordRequestSeen";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CredentialManagerDigitalAssetLinkDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"androidx.credentials.CreatePasswordRequest");
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        context2.getPartialResults(ISSUE).map().put(CREATE_PASSWORD_REQUEST_SEEN_KEY, true);
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Object v3;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context2.getProject().isLibrary()) {
            return;
        }
        boolean createPasswordRequestSeen = partialResults.maps().stream().anyMatch(arg_0 -> CredentialManagerDigitalAssetLinkDetector.checkPartialResults$lambda$1(CredentialManagerDigitalAssetLinkDetector::checkPartialResults$lambda$0, arg_0));
        if (!createPasswordRequestSeen) {
            return;
        }
        Node node = context2.getProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node manifest = node;
        Element element = DomExtensions.subtag((Element)manifest, (String)"application");
        if (element == null) {
            return;
        }
        Element application = element;
        Sequence $this$lastOrNull$iv = SequencesKt.asSequence((Iterator)DomExtensions.iterator((Element)application));
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getLocalName(), (Object)"meta-data") && Intrinsics.areEqual((Object)it.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)"asset_statements"))) continue;
            last$iv = element$iv;
        }
        Element assetMetadata = last$iv;
        if (assetMetadata == null) {
            context2.report(new Incident(ISSUE, "Missing `<meta-data>` tag for asset statements for Credential Manager", Context.getLocation$default(context2, application, null, 2, null)));
            return;
        }
        String resourceRef = assetMetadata.getAttributeNS("http://schemas.android.com/apk/res/android", "resource");
        Intrinsics.checkNotNull((Object)resourceRef);
        if (((CharSequence)resourceRef).length() == 0) {
            context2.report(new Incident(ISSUE, "Missing `android:resource` attribute for asset statements string resource", Context.getLocation$default(context2, assetMetadata, null, 2, null)));
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)resourceRef);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        if (resourceUrl2.type != ResourceType.STRING) {
            return;
        }
        ResourceRepository projectResources = context2.getClient().getResources(context2.getProject(), ResourceRepositoryScope.ALL_DEPENDENCIES);
        List statementsResources = projectResources.getResources(ResourceNamespace.TODO(), resourceUrl2.type, resourceUrl2.name);
        if (statementsResources.isEmpty()) {
            return;
        }
        Intrinsics.checkNotNull((Object)statementsResources);
        Iterable $this$minByOrNull$iv = statementsResources;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                ResourceItem it = (ResourceItem)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = (Comparable)((Object)it.getKey());
                do {
                    Object e$iv = iterator$iv.next();
                    ResourceItem it2 = (ResourceItem)e$iv;
                    $i$a$-minByOrNull-CredentialManagerDigitalAssetLinkDetector$checkPartialResults$statementsResource$1 = false;
                    Comparable v$iv = (Comparable)((Object)it2.getKey());
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        ResourceItem resourceItem = v3;
        if (resourceItem == null) {
            return;
        }
        ResourceItem statementsResource = resourceItem;
        Object object = statementsResource.getResourceValue();
        if (object == null || (object = object.getValue()) == null) {
            return;
        }
        Object statementsString = object;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)statementsString), (CharSequence)"include", (boolean)false, (int)2, null)) {
            context2.report(new Incident(ISSUE, "Could not find \"include\" in asset statements string resource", Context.getLocation$default(context2, assetMetadata, null, 2, null)));
            return;
        }
        if (!StringsKt.contains$default((CharSequence)((CharSequence)statementsString), (CharSequence)".well-known/assetlinks.json", (boolean)false, (int)2, null)) {
            context2.report(new Incident(ISSUE, "Could not find `.well-known/assetlinks.json` in asset statements string resource", Context.getLocation$default(context2, assetMetadata, null, 2, null)));
            return;
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            this.checkPartialResults(context2, context2.getPartialResults(ISSUE));
        }
    }

    private static final boolean checkPartialResults$lambda$0(LintMap it) {
        return Intrinsics.areEqual((Object)LintMap.getBoolean$default(it, CREATE_PASSWORD_REQUEST_SEEN_KEY, null, 2, null), (Object)true);
    }

    private static final boolean checkPartialResults$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "CredManMissingDal", "Missing Digital Asset Link for Credential Manager", "\n          When using password sign-in through Credential Manager, \\\n          an asset statements string resource file \\\n          that includes the `assetlinks.json` files to load \\\n          must be declared in the manifest using a `<meta-data>` element.\n          ", implementation, "https://developer.android.com/identity/sign-in/credential-manager#add-support-dal", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerDigitalAssetLinkDetector$Companion;", "", "<init>", "()V", "CREATE_PASSWORD_REQUEST_SEEN_KEY", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

