/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiDetectorKt;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.AppCompatCustomViewDetectorKt;
import com.android.tools.lint.checks.DesugaredMethodLookup;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ApiLevel;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.SourceSetType;
import com.android.tools.lint.detector.api.UImplicitCallExpressionKt;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.VersionChecks;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScannerConstants;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastSpecialExpressionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \\2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002[\\B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JD\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0016H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\tH\u0016J(\u0010+\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J(\u0010+\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00104\u001a\u00020\u00162\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J8\u0010;\u001a\u00020\u00162\u0006\u00105\u001a\u0002062\b\u0010*\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u001e2\u0014\b\u0002\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160?H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\f\u001a\u00020,H\u0016J\u0014\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\u0016\u0010F\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0G0%H\u0016J \u0010H\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016J@\u0010M\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010N\u001a\u0002032\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001eH\u0002J\u0018\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020,H\u0002J \u0010U\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020,2\u0006\u0010V\u001a\u00020-2\u0006\u0010W\u001a\u00020\u0016H\u0002J\u0018\u0010X\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\tH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/android/tools/lint/checks/ApiDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "<init>", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/ApiLookup;", "invalidDatabaseFormatError", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableElements", "", "getApplicableAttributes", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "isAttributeOfGradientOrGradientItem", "", "visitElement", "element", "Lorg/w3c/dom/Element;", "checkLevelList", "checkElement", "tag", "api", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "gradleVersion", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "useName", "getMinSdk", "applicableAnnotations", "", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "inheritAnnotation", "annotation", "visitAnnotationUsage", "Lcom/android/tools/lint/detector/api/JavaContext;", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "reference", "Lorg/w3c/dom/Node;", "isSuperCallFromOverride", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "isSurroundedByHigherTargetAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "atLeast", "isApiLevelAnnotation", "Lkotlin/Function1;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "firstSourceElement", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/uast/UFile;", "getApplicableUastTypes", "Ljava/lang/Class;", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "report", "scope", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "minSdk", "getApiLevelString", "requires", "checkObsoleteSdkVersion", "node", "expectFull", "checkFolder", "Lcom/android/tools/lint/detector/api/ResourceContext;", "folderName", "ApiVisitor", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,4213:1\n1#2:4214\n1863#3,2:4215\n*S KotlinDebug\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector\n*L\n742#1:4215,2\n*E\n"})
public final class ApiDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
ResourceFolderScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ApiLookup apiDatabase;
    @Nullable
    private String invalidDatabaseFormatError;
    @NotNull
    public static final String KEY_FILE = "file";
    @NotNull
    public static final String KEY_REQUIRES_API = "requiresApi";
    @NotNull
    public static final String KEY_FOLDER_NAME = "folderName";
    @NotNull
    public static final String KEY_CONDITIONAL = "conditional";
    @NotNull
    public static final String KEY_REQUIRE_CLASS = "requireClass";
    @NotNull
    public static final String KEY_MIN_API = "minSdk";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final String KEY_OWNER = "owner";
    @NotNull
    private static final String KEY_NAME = "name";
    @NotNull
    private static final String KEY_DESC = "desc";
    @NotNull
    private static final String KEY_DESUGAR = "desugar";
    @NotNull
    private static final String KEY_SOURCE_SET = "sourceSet";
    @NotNull
    private static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    @NotNull
    private static final String ANDROIDX_SDK_SUPPRESS_ANNOTATION = "androidx.test.filters.SdkSuppress";
    @NotNull
    private static final String ROBO_ELECTRIC_CONFIG_ANNOTATION = "org.robolectric.annotation.Config";
    @NotNull
    private static final String ATTR_PROPERTY_VALUES_HOLDER = "propertyValuesHolder";
    public static final boolean REPEATED_API_ANNOTATION_REQUIRES_ALL = true;
    @NotNull
    private static final Implementation JAVA_IMPLEMENTATION = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final Pair<Boolean, ApiConstraint> NOT_SUPPRESSED = new Pair((Object)false, null);
    @NotNull
    private static final Pair<Boolean, ApiConstraint> SUPPRESSED = new Pair((Object)true, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_9 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 9, 0, 2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_19 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 19, 0, 2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_21 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 21, 0, 2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_23 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 23, 0, 2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_24 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 24, 0, 2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_26 = ApiConstraint.Companion.get$default(ApiConstraint.Companion, 26, 0, 2, null);
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED;
    @JvmField
    @NotNull
    public static final Issue INLINED;
    @JvmField
    @NotNull
    public static final Issue UNUSED;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_SDK;
    @JvmField
    @NotNull
    public static final Issue WRONG_SDK_INT;
    @JvmField
    @NotNull
    public static final Issue NIO_DESUGARING;
    @NotNull
    private static final String TAG_RIPPLE = "ripple";
    @NotNull
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    @NotNull
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.apiDatabase == null && this.invalidDatabaseFormatError == null) {
            try {
                this.apiDatabase = ApiLookup.get(context2.getClient(), context2.getProject().getBuildTarget());
            }
            catch (ApiLookup.UnsupportedVersionException e) {
                this.invalidDatabaseFormatError = e.getDisplayMessage(context2.getClient()) + ": Lint API checks unavailable.";
            }
        }
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        List<String> list2 = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ALL");
        return list2;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        List<String> list2 = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ALL");
        return list2;
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Location location4;
        Object minSdk;
        Object owner;
        String name;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        ApiConstraint attributeApiLevel = ApiConstraint.ALL;
        String namespace = attribute.getNamespaceURI();
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace)) {
            String message;
            Location location2;
            ApiConstraint minSdk2;
            name = attribute.getLocalName();
            if (!(Intrinsics.areEqual((Object)name, (Object)"layout_width") || Intrinsics.areEqual((Object)name, (Object)"layout_height") || Intrinsics.areEqual((Object)name, (Object)"id") || (this.isAttributeOfGradientOrGradientItem(attribute) || Intrinsics.areEqual((Object)name, (Object)"fillType")) && AppCompatCustomViewDetectorKt.dependsOnAppCompat$default(context2.getProject(), false, 1, null))) {
                owner = "android/R$attr";
                ApiConstraint apiConstraint = apiDatabase.getFieldVersions((String)owner, name);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getFieldVersions(...)");
                attributeApiLevel = apiConstraint;
                ApiConstraint apiConstraint2 = this.getMinSdk(context2);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk3 = apiConstraint2;
                if (!(Intrinsics.areEqual((Object)attributeApiLevel, (Object)ApiConstraint.UNKNOWN) || minSdk3.isAtLeast(attributeApiLevel) || ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), attributeApiLevel))) {
                    Element element = attribute.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
                    if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(attributeApiLevel)) {
                        Intrinsics.checkNotNull((Object)name);
                        if (!(Companion.isBenignUnusedAttribute(name) || ApiDetector.Companion.isAlreadyWarnedDrawableFile(context2, attribute, attributeApiLevel) || RtlDetector.isRtlAttributeName(name) || Intrinsics.areEqual((Object)"supportsRtl", (Object)name))) {
                            Location location3 = context2.getLocation(attribute);
                            String localName = attribute.getLocalName();
                            String message2 = "Attribute `" + localName + "` is only used in API level " + attributeApiLevel.minString() + " and higher (current min is %1$s)";
                            if (Intrinsics.areEqual((Object)"fontFamily", (Object)localName) && AppCompatCustomViewDetectorKt.dependsOnAppCompat$default(context2.getProject(), false, 1, null)) {
                                String prefix = XmlUtils.lookupNamespacePrefix((Node)attribute, (String)"http://schemas.android.com/apk/res-auto", (String)"app", (boolean)false);
                                message2 = message2 + " Did you mean `" + prefix + ":fontFamily` ?";
                            }
                            this.report(context2, UNUSED, attribute, location3, message2, attributeApiLevel, minSdk3);
                        }
                    }
                }
            }
            if (Intrinsics.areEqual((Object)name, (Object)"divider")) {
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"theme") && Intrinsics.areEqual((Object)"include", (Object)attribute.getOwnerElement().getTagName())) {
                ApiConstraint apiConstraint = this.getMinSdk(context2);
                if (apiConstraint == null) {
                    return;
                }
                minSdk2 = apiConstraint;
                if (!minSdk2.isAtLeast(API_23) && !ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), API_23)) {
                    location2 = context2.getLocation(attribute);
                    message = "Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is %1$s)";
                    this.report(context2, UNUSED, attribute, location2, message, API_23, minSdk2);
                }
            }
            if (Intrinsics.areEqual((Object)name, (Object)"foreground") && context2.getResourceFolderType() == ResourceFolderType.LAYOUT) {
                String string2 = attribute.getOwnerElement().getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTagName(...)");
                if (!ApiDetector.Companion.isFrameLayout(context2, string2, true)) {
                    ApiConstraint apiConstraint = this.getMinSdk(context2);
                    if (apiConstraint == null) {
                        return;
                    }
                    minSdk2 = apiConstraint;
                    if (!minSdk2.isAtLeast(API_23) && !ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), API_23)) {
                        location2 = context2.getLocation(attribute);
                        message = "Attribute `android:foreground` has no effect on API levels lower than 23 (current min is %1$s)";
                        this.report(context2, UNUSED, attribute, location2, message, API_23, minSdk2);
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace) && Intrinsics.areEqual((Object)(name = attribute.getLocalName()), (Object)"targetApi")) {
            String targetApiString = attribute.getValue();
            Intrinsics.checkNotNull((Object)targetApiString);
            ApiConstraint.SdkApiConstraint api2 = ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, targetApiString, 0, false, 4, null);
            if (api2 != null) {
                String message = "Unnecessary; `SDK_INT` is always >= " + api2.minString();
                LintFix fix2 = this.fix().replace().all().with("").range(context2.getLocation(attribute)).name("Delete " + attribute.getName()).build();
                context2.report(new Incident(OBSOLETE_SDK, message, context2.getLocation(attribute), attribute, fix2), Constraints.minSdkAtLeast(api2));
                return;
            }
        }
        String value = attribute.getValue();
        owner = null;
        String name2 = null;
        String prefix = null;
        Intrinsics.checkNotNull((Object)value);
        if (StringsKt.startsWith$default((String)value, (String)"@android:", (boolean)false, (int)2, null)) {
            prefix = "@android:";
        } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
            prefix = "?android:";
            if (context2.getResourceFolderType() == ResourceFolderType.DRAWABLE) {
                ApiConstraint.SdkApiConstraint api3 = API_21;
                ApiConstraint apiConstraint = this.getMinSdk(context2);
                if (apiConstraint == null) {
                    return;
                }
                minSdk = apiConstraint;
                if (!((ApiConstraint)minSdk).isAtLeast(api3) && !ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api3)) {
                    Element element = attribute.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
                    if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api3)) {
                        location4 = context2.getLocation(attribute);
                        String message = "Using theme references in XML drawables requires API level " + api3.minString() + " (current min is %1$s)";
                        this.report(context2, UNSUPPORTED, attribute, location4, message, api3, (ApiConstraint)minSdk);
                        return;
                    }
                }
            }
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)KEY_NAME, (Object)attribute.getName()) && Intrinsics.areEqual((Object)"item", (Object)attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            String string3 = value.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            name2 = string3;
            prefix = null;
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)"parent", (Object)attribute.getName()) && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            String string4 = value.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            name2 = ResourcesUtil.resourceNameToFieldName((String)string4);
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            String string5 = prefix;
            int index2 = StringsKt.indexOf$default((CharSequence)value, (char)'/', (int)(string5 != null ? string5.length() : 0), (boolean)false, (int)4, null);
            if (index2 >= 0) {
                minSdk = value;
                String string6 = prefix;
                int location4 = string6 != null ? string6.length() : 0;
                String string7 = ((String)minSdk).substring(location4, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                owner = "android/R$" + string7;
                String string8 = value.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                name2 = ResourcesUtil.resourceNameToFieldName((String)string8);
            } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
                owner = "android/R$attr";
                String string9 = value.substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                name2 = string9;
            } else {
                return;
            }
        }
        if (name2 == null) {
            return;
        }
        ApiConstraint apiConstraint = apiDatabase.getFieldVersions((String)owner, name2);
        Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getFieldVersions(...)");
        ApiConstraint api4 = apiConstraint;
        if (Intrinsics.areEqual((Object)api4, (Object)ApiConstraint.UNKNOWN)) {
            return;
        }
        ApiConstraint apiConstraint3 = this.getMinSdk(context2);
        if (apiConstraint3 == null) {
            return;
        }
        minSdk = apiConstraint3;
        if (!((ApiConstraint)minSdk).isAtLeast(api4) && !ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api4)) {
            Element element = attribute.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
            if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api4)) {
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)attributeApiLevel, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                if (!attributeApiLevel.isAtLeast(api4)) {
                    if (!((ApiConstraint)minSdk).isAtLeast(attributeApiLevel)) {
                        String attributeName = attribute.getLocalName();
                        Location location5 = context2.getLocation(attribute);
                        String message = "`" + name2 + "` requires API level " + api4.minString() + " (current min is %1$s), but note that attribute `" + attributeName + "` is only used in API level " + attributeApiLevel.minString() + " and higher";
                        this.report(context2, UNSUPPORTED, attribute, location5, message, api4, (ApiConstraint)minSdk);
                    } else {
                        String old;
                        if (api4.min() == 17 && RtlDetector.isRtlAttributeName(name2) && !Intrinsics.areEqual((Object)name2, (Object)(old = RtlDetector.convertNewToOld(name2)))) {
                            Element parent = attribute.getOwnerElement();
                            if (Intrinsics.areEqual((Object)"item", (Object)parent.getTagName())) {
                                Node node = parent.getParentNode();
                                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getParentNode(...)");
                                for (Element item : Lint.getChildren(node)) {
                                    String v = item.getAttribute(KEY_NAME);
                                    Intrinsics.checkNotNull((Object)v);
                                    Intrinsics.checkNotNull((Object)old);
                                    if (!StringsKt.endsWith$default((String)v, (String)old, (boolean)false, (int)2, null)) continue;
                                    return;
                                }
                            } else if (parent.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                                return;
                            }
                        }
                        location4 = context2.getLocation(attribute);
                        String minString = api4.minString();
                        String message = "`" + value + "` requires API level " + minString + " (current min is %1$s)";
                        this.report(context2, UNSUPPORTED, attribute, location4, message, api4, (ApiConstraint)minSdk);
                    }
                }
            }
        }
    }

    private final boolean isAttributeOfGradientOrGradientItem(Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"gradient")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"item")) {
            Node node = element.getParentNode();
            return Intrinsics.areEqual((Object)(node != null ? node.getLocalName() : null), (Object)"gradient");
        }
        return false;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        String string2 = element.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTagName(...)");
        String tag = string2;
        ResourceFolderType folderType = context2.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                ApiDetector.checkElement$default(this, context2, element, "vector", API_21, "1.4.0", UNSUPPORTED, false, 64, null);
                ApiDetector.checkElement$default(this, context2, element, TAG_RIPPLE, API_21, null, UNSUPPORTED, false, 64, null);
                ApiDetector.checkElement$default(this, context2, element, TAG_ANIMATED_SELECTOR, API_21, null, UNSUPPORTED, false, 64, null);
                ApiDetector.checkElement$default(this, context2, element, "animated-vector", API_21, null, UNSUPPORTED, false, 64, null);
                ApiDetector.checkElement$default(this, context2, element, "drawable", API_24, null, UNSUPPORTED, false, 64, null);
                if (Intrinsics.areEqual((Object)"layer-list", (Object)tag)) {
                    this.checkLevelList(context2, element);
                } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    ApiDetector.checkElement$default(this, context2, element, tag, API_24, null, UNSUPPORTED, false, 64, null);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                ApiConstraint minSdk;
                ApiConstraint api2;
                String typeString;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3) continue;
                String string3 = text = textNode.getNodeValue();
                Intrinsics.checkNotNull((Object)string3);
                if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"@android:", (boolean)false, (int)2, null)) continue;
                string3 = text;
                Intrinsics.checkNotNull((Object)string3);
                text = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                int index2 = StringsKt.indexOf$default((CharSequence)text, (char)'/', (int)9, (boolean)false, (int)4, null);
                if (index2 == -1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(9, index2), (String)"substring(...)");
                if (ResourceType.fromXmlValue((String)typeString) == null) continue;
                String owner = "android/R$" + typeString;
                String string4 = text.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String name = ResourcesUtil.resourceNameToFieldName((String)string4);
                Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getFieldVersions(owner, name), (String)"getFieldVersions(...)");
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) continue;
                if (this.getMinSdk(context2) == null) {
                    return;
                }
                if (minSdk.isAtLeast(api2) || ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api2) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api2)) continue;
                Intrinsics.checkNotNull((Object)textNode);
                Location location = context2.getLocation(textNode);
                String message = "`" + text + "` requires API level " + api2.minString() + " (current min is %1$s)";
                this.report(context2, UNSUPPORTED, element, location, message, api2, minSdk);
            }
        } else {
            ApiConstraint localMinSdk;
            if (Intrinsics.areEqual((Object)"view", (Object)tag)) {
                String string5 = element.getAttribute("class");
                if (string5 == null) {
                    return;
                }
                tag = string5;
                if (((CharSequence)tag).length() == 0) {
                    return;
                }
            } else {
                ApiDetector.checkElement$default(this, context2, element, "tag", API_21, null, UNUSED, false, 64, null);
            }
            if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            Object fqn = "android/widget/" + tag;
            if (Intrinsics.areEqual((Object)tag, (Object)"TextureView")) {
                fqn = "android/view/TextureView";
            }
            ApiConstraint apiConstraint = apiDatabase.getClassVersions((String)fqn);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getClassVersions(...)");
            ApiConstraint api3 = apiConstraint;
            if (Intrinsics.areEqual((Object)api3, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = this.getMinSdk(context2);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (!(minSdk.isAtLeast(api3) || ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api3) || (localMinSdk = ApiDetector.Companion.getLocalMinSdk(element)).isAtLeast(api3))) {
                Location location = context2.getNameLocation(element);
                String message = "View requires API level " + api3.minString() + " (current min is %1$s): `<" + tag + ">`";
                this.report(context2, UNSUPPORTED, element, location, message, api3, localMinSdk);
            }
        }
    }

    private final void checkLevelList(XmlContext context2, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            ApiConstraint minSdk;
            Element e;
            if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)"item", (Object)curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height")) continue;
            ApiConstraint.SdkApiConstraint attributeApiLevel = API_23;
            if (this.getMinSdk(context2) == null) {
                return;
            }
            if (minSdk.isAtLeast(attributeApiLevel) || ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), attributeApiLevel) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(attributeApiLevel)) continue;
            String[] stringArray = new String[]{"width", "height"};
            for (String attributeName : stringArray) {
                Attr attribute;
                if (e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName) == null) continue;
                Location location = context2.getLocation(attribute);
                String message = "Attribute `" + attribute.getLocalName() + "` is only used in API level " + attributeApiLevel.minString() + " and higher (current min is %1$s)";
                this.report(context2, UNUSED, attribute, location, message, attributeApiLevel, minSdk);
            }
        }
    }

    private final void checkElement(XmlContext context2, Element element, String tag, ApiConstraint api2, String gradleVersion, Issue issue, boolean useName) {
        String realTag = tag;
        if (Intrinsics.areEqual((Object)realTag, (Object)element.getTagName())) {
            ApiConstraint apiConstraint = this.getMinSdk(context2);
            if (apiConstraint == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            if (!(minSdk.isAtLeast(api2) || ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api2) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api2) || ApiDetector.Companion.featureProvidedByGradle(context2, gradleVersion))) {
                Location location = context2.getNameLocation(element);
                if (Intrinsics.areEqual((Object)"drawable", (Object)realTag)) {
                    Attr attr = element.getAttributeNode("class");
                    if (attr == null) {
                        return;
                    }
                    Attr attribute = attr;
                    location = context2.getLocation(attribute);
                    String string2 = attribute.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    realTag = string2;
                }
                String message = null;
                if (issue == UNSUPPORTED) {
                    message = "`<" + realTag + ">` requires API level " + api2.minString() + " (current min is %1$s)";
                    if (gradleVersion != null) {
                        message = message + " or building with Android Gradle plugin " + gradleVersion + " or higher";
                    } else if (StringsKt.contains$default((CharSequence)realTag, (CharSequence)".", (boolean)false, (int)2, null) && !useName) {
                        message = "Custom drawables requires API level " + api2.minString() + " (current min is %1$s)";
                    }
                } else {
                    boolean bl;
                    boolean bl2 = bl = issue == UNUSED;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        Issue issue2 = issue;
                        throw new AssertionError(issue2);
                    }
                    message = "`<" + realTag + ">` is only used in API level " + api2.minString() + " and higher (current min is %1$s)";
                }
                this.report(context2, issue, element, location, message, api2, minSdk);
            }
        }
    }

    static /* synthetic */ void checkElement$default(ApiDetector apiDetector, XmlContext xmlContext, Element element, String string2, ApiConstraint apiConstraint, String string3, Issue issue, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        apiDetector.checkElement(xmlContext, element, string2, apiConstraint, string3, issue, bl);
    }

    private final ApiConstraint getMinSdk(Context context2) {
        Project project = context2.isGlobalAnalysis() ? context2.getMainProject() : context2.getProject();
        return !project.isAndroidProject() ? null : project.getMinSdkVersions();
    }

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[6];
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.oldName(), (String)"oldName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.newName(), (String)"newName(...)");
        objectArray[2] = "androidx.annotation.RequiresExtension";
        objectArray[3] = ANDROIDX_SDK_SUPPRESS_ANNOTATION;
        objectArray[4] = "android.annotation.TargetApi";
        objectArray[5] = ROBO_ELECTRIC_CONFIG_ANNOTATION;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> false;
        };
    }

    @Override
    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Issue issue;
        ApiConstraint apiConstraint;
        PsiMember member;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMember psiMember = member = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
        if (!VersionChecks.Companion.isRequiresApiAnnotation(annotationInfo.getQualifiedName()) || usageInfo.getAnnotations().size() == 1) {
            ApiConstraint.SdkApiConstraint sdkApiConstraint = Companion.getApiLevel(context2, annotation, annotationInfo.getQualifiedName());
            if (sdkApiConstraint == null) {
                return;
            }
            apiConstraint = sdkApiConstraint;
        } else {
            if (usageInfo.getType() != AnnotationUsageType.DEFINITION && usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)ApiDetector::visitAnnotationUsage$lambda$1))) {
                return;
            }
            ApiConstraint constraint = null;
            PsiElement target2 = annotationInfo.getAnnotated();
            Iterable $this$forEach$iv = usageInfo.getAnnotations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiConstraint.SdkApiConstraint apiLevel;
                AnnotationInfo info = (AnnotationInfo)element$iv;
                boolean bl = false;
                String qualifiedName = info.getQualifiedName();
                if (info.getAnnotated() != target2 || !VersionChecks.Companion.isRequiresApiAnnotation(qualifiedName) || (apiLevel = Companion.getApiLevel(context2, info.getAnnotation(), qualifiedName)) == null) continue;
                if (constraint != null) {
                    if (ApiConstraint.findSdk$default(constraint, apiLevel.getSdkId(), false, 2, null) != null) continue;
                    constraint = ApiConstraint.Companion.max(constraint, apiLevel, false);
                    continue;
                }
                constraint = apiLevel;
            }
            apiConstraint = constraint;
            if (apiConstraint == null) {
                return;
            }
        }
        ApiConstraint api2 = apiConstraint;
        String string2 = annotation.getQualifiedName();
        if (string2 == null) {
            return;
        }
        String qualifiedName = string2;
        ApiConstraint apiConstraint2 = this.getMinSdk(context2);
        if (apiConstraint2 == null) {
            return;
        }
        ApiConstraint minSdk = apiConstraint2;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
            if (api2.getSdk() != 0) {
                return;
            }
            LintFix fix2 = this.fix().replace().all().with("").range(context2.getLocation((UElement)annotation)).name("Delete @" + StringsKt.substringAfterLast$default((String)qualifiedName, (char)'.', null, (int)2, null)).build();
            UElement uElement = element.getUastParent();
            Pair pair2 = VersionChecks.Companion.getTargetApiAnnotation$default(VersionChecks.Companion, evaluator, (UElement)(uElement != null ? uElement.getUastParent() : null), null, 4, null);
            UAnnotation targetAnnotation = (UAnnotation)pair2.component1();
            ApiConstraint target3 = (ApiConstraint)pair2.component2();
            if (target3 != null && !api2.isAtLeast(target3)) {
                Object object = targetAnnotation;
                String outerAnnotation = "@" + (object != null && (object = object.getQualifiedName()) != null ? StringsKt.substringAfterLast$default((String)object, (char)'.', null, (int)2, null) : null) + "(" + target3.minString() + ")";
                String message = "Unnecessary; `SDK_INT` is always >= " + target3.minString() + " from outer annotation (`" + outerAnnotation + "`)";
                context2.report(new Incident(OBSOLETE_SDK, message, context2.getLocation((UElement)annotation), annotation, fix2));
            } else {
                if (element instanceof UAnnotation && Intrinsics.areEqual((Object)((UAnnotation)element).getQualifiedName(), (Object)ROBO_ELECTRIC_CONFIG_ANNOTATION)) {
                    return;
                }
                String message = "Unnecessary; `SDK_INT` is always >= " + api2.minString();
                context2.report(new Incident(OBSOLETE_SDK, message, context2.getLocation((UElement)annotation), annotation, fix2), Constraints.minSdkAtLeast(api2.min()));
            }
            return;
        }
        if (!VersionChecks.Companion.isRequiresApiAnnotation(qualifiedName)) {
            return;
        }
        Pair<Boolean, ApiConstraint> pair3 = Companion.getSuppressed(context2, api2, element, minSdk);
        boolean suppressed = (Boolean)pair3.component1();
        ApiConstraint localMinSdk = (ApiConstraint)pair3.component2();
        if (suppressed) {
            return;
        }
        minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
        UAnnotation targetAnnotation = (UAnnotation)VersionChecks.Companion.getTargetApiAnnotation$default(VersionChecks.Companion, evaluator, element, null, 4, null).component1();
        if (targetAnnotation != null && ApiDetector.isSurroundedByHigherTargetAnnotation$default(this, evaluator, targetAnnotation, api2, null, 8, null)) {
            return;
        }
        if (usageInfo.getType() == AnnotationUsageType.CLASS_REFERENCE) {
            PsiType type;
            UElement parent = element.getUastParent();
            Object object = parent instanceof UBinaryExpressionWithType ? ((UBinaryExpressionWithType)parent).getType() : (type = element instanceof UClassLiteralExpression ? ((UClassLiteralExpression)element).getType() : null);
            if (type != null) {
                ApiLookup apiLookup = this.apiDatabase;
                if (apiLookup == null) {
                    return;
                }
                ApiLookup apiDatabase = apiLookup;
                PsiClass psiClass = evaluator.getTypeClass(type);
                if (psiClass == null) {
                    return;
                }
                PsiClass cls = psiClass;
                ApiConstraint max = ApiConstraint.ALL;
                LinkedHashSet superClasses = InheritanceUtil.getSuperClasses((PsiClass)cls);
                Iterator iterator = superClasses.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    ApiConstraint versions;
                    String superClassQualifiedName;
                    PsiClass superClass = (PsiClass)iterator2.next();
                    if (superClass.getQualifiedName() == null || Intrinsics.areEqual((Object)superClassQualifiedName, (Object)"java.lang.Object")) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getClassVersions(superClassQualifiedName), (String)"getClassVersions(...)");
                    if (Intrinsics.areEqual((Object)versions, (Object)ApiConstraint.UNKNOWN)) continue;
                    max = max.and(versions);
                }
                if (minSdk.isAtLeast(max)) {
                    return;
                }
            }
        }
        if (element instanceof UCallExpression && member instanceof PsiMethod && this.isSuperCallFromOverride(evaluator, (UCallExpression)element, (PsiMethod)member)) {
            return;
        }
        Location location = null;
        Object fqcn = null;
        if (element instanceof UCallExpression && !Intrinsics.areEqual((Object)((UCallExpression)element).getKind(), (Object)UastCallKind.METHOD_CALL) && ((UCallExpression)element).getClassReference() != null) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)element).getClassReference();
            Intrinsics.checkNotNull((Object)uReferenceExpression);
            UReferenceExpression classReference = uReferenceExpression;
            location = context2.getRangeLocation(element, 0, (UElement)classReference, 0);
            String string3 = classReference.getResolvedName();
            if (string3 == null) {
                PsiMember psiMember2 = member;
                string3 = psiMember2 != null ? psiMember2.getName() : null;
                if (string3 == null) {
                    string3 = "";
                }
            }
            fqcn = string3;
        } else {
            location = context2.getNameLocation(element);
            Object object = member;
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            fqcn = object;
        }
        Object type = switch (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()]) {
            case 6 -> "Extending " + (String)fqcn;
            case 4, 5 -> "Class";
            case 9, 10 -> "Method";
            case 3, 11 -> "Field";
            default -> "Call";
        };
        PsiElement field = usageInfo.getReferenced();
        if (field instanceof PsiField && Lint.isInlined((PsiField)field, context2.getEvaluator())) {
            JavaEvaluator javaEvaluator = context2.getEvaluator();
            PsiField psiField = (PsiField)field;
            String string4 = ((PsiField)field).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            Object object = ((PsiField)field).getContainingClass();
            if (object == null || (object = object.getQualifiedName()) == null) {
                object = "";
            }
            if (Companion.isBenignConstantUsage(javaEvaluator, psiField, element, string4, (String)object)) {
                return;
            }
            issue = INLINED;
        } else {
            issue = UNSUPPORTED;
        }
        Issue issue2 = issue;
        ApiVisitor.report$default(new ApiVisitor(context2), issue2, element, location, (String)type, (String)fqcn, api2, minSdk, null, null, null, null, null, null, 8064, null);
    }

    @Override
    public void visitAnnotationUsage(@NotNull XmlContext context2, @NotNull Node reference, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String qualifiedName = annotationInfo.getQualifiedName();
        if (VersionChecks.Companion.isRequiresApiAnnotation(qualifiedName)) {
            Element element;
            ApiConstraint.SdkApiConstraint sdkApiConstraint = Companion.getApiLevel(context2, annotation, qualifiedName);
            if (sdkApiConstraint == null) {
                return;
            }
            ApiConstraint.SdkApiConstraint api2 = sdkApiConstraint;
            PsiElement psiElement = usageInfo.getReferenced();
            Object object = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            if (object == null || (object = object.getQualifiedName()) == null) {
                return;
            }
            Object className = object;
            ApiConstraint apiConstraint = this.getMinSdk(context2);
            if (apiConstraint == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            Element element2 = reference instanceof Element ? (Element)reference : null;
            if (element2 == null) {
                Node node;
                Attr attr = reference instanceof Attr ? (Attr)reference : null;
                element2 = attr != null ? attr.getOwnerElement() : null;
                if (element2 == null && (element2 = (node = reference.getParentNode()) instanceof Element ? (Element)node : null) == null) {
                    element2 = element = reference.getOwnerDocument().getDocumentElement();
                }
            }
            if (!minSdk.isAtLeast(api2) && !ApiDetectorKt.access$isAtLeast(context2.getFolderVersion(), api2)) {
                Intrinsics.checkNotNull((Object)element);
                if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api2)) {
                    String message = "`<" + (String)className + ">` requires API level " + api2.minString() + " (current min is %1$s)";
                    this.report(context2, UNSUPPORTED, element, context2.getLocation(element), message, api2, minSdk);
                }
            }
        }
    }

    private final boolean isSuperCallFromOverride(JavaEvaluator evaluator, UCallExpression call2, PsiMethod method) {
        UExpression receiver = call2.getReceiver();
        if (receiver instanceof USuperExpression) {
            PsiMethod containingMethod;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)call2));
            Object object = containingMethod = uMethod != null ? uMethod.getJavaPsi() : null;
            if (containingMethod != null && Intrinsics.areEqual((Object)Lint.getInternalMethodName(method), (Object)containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                return true;
            }
        }
        return false;
    }

    private final boolean isSurroundedByHigherTargetAnnotation(JavaEvaluator evaluator, UAnnotation annotation, ApiConstraint atLeast, Function1<? super String, Boolean> isApiLevelAnnotation) {
        UAnnotation uAnnotation = annotation;
        if (uAnnotation == null) {
            return false;
        }
        UAnnotation curr = uAnnotation;
        while (true) {
            UElement uElement = curr.getUastParent();
            Pair<UAnnotation, ApiConstraint> pair2 = VersionChecks.Companion.getTargetApiAnnotation(evaluator, (UElement)(uElement != null ? uElement.getUastParent() : null), isApiLevelAnnotation);
            UAnnotation outer = (UAnnotation)pair2.component1();
            ApiConstraint target2 = (ApiConstraint)pair2.component2();
            if (target2 != null && target2.isAtLeast(atLeast)) {
                return true;
            }
            if (outer != null) continue;
            return false;
        }
    }

    static /* synthetic */ boolean isSurroundedByHigherTargetAnnotation$default(ApiDetector apiDetector, JavaEvaluator javaEvaluator, UAnnotation uAnnotation, ApiConstraint apiConstraint, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                public final Boolean invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                }
            };
        }
        return apiDetector.isSurroundedByHigherTargetAnnotation(javaEvaluator, uAnnotation, apiConstraint, (Function1<? super String, Boolean>)function1);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.apiDatabase == null) {
            if (this.invalidDatabaseFormatError != null) {
                PsiElement psiElement = this.firstSourceElement(context2.getUastFile());
                if (psiElement != null) {
                    PsiElement declaration = psiElement;
                    boolean bl = false;
                    String string2 = this.invalidDatabaseFormatError;
                    Intrinsics.checkNotNull((Object)string2);
                    String message = string2;
                    JavaContext.report$default(context2, UNSUPPORTED, declaration, context2.getLocation(declaration), message, null, 16, null);
                }
            }
            return null;
        }
        Project project = context2.isGlobalAnalysis() ? context2.getMainProject() : context2.getProject();
        return project.isAndroidProject() ? (UElementHandler)new ApiVisitor(context2) : null;
    }

    private final PsiElement firstSourceElement(UFile file) {
        PsiElement first;
        if (file == null) {
            return null;
        }
        PsiElement curr = first = file.getSourcePsi().getFirstChild();
        while (curr instanceof PsiWhiteSpace) {
            curr = ((PsiWhiteSpace)curr).getNextSibling();
        }
        return curr;
    }

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{USimpleNameReferenceExpression.class, ULocalVariable.class, UTryExpression.class, UBinaryExpressionWithType.class, UBinaryExpression.class, UUnaryExpression.class, UCallExpression.class, UClass.class, UMethod.class, UForEachExpression.class, UClassLiteralExpression.class, USwitchExpression.class, UCallableReferenceExpression.class, UArrayAccessExpression.class, UAnnotation.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        String owner;
        boolean libraryDesugaring;
        ApiConstraint requires;
        ApiConstraint mainMinSdk;
        Project mainProject;
        block33: {
            Desugaring desugaring;
            block32: {
                Object sourceSet;
                String desc;
                String name;
                String owner2;
                block35: {
                    Object object;
                    block34: {
                        Desugaring desugaring2;
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
                        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
                        mainProject = context2.getMainProject();
                        if (!mainProject.isAndroidProject()) {
                            return false;
                        }
                        mainMinSdk = mainProject.getMinSdkVersions();
                        ApiConstraint apiConstraint = LintMap.getApiConstraint$default(map2, KEY_REQUIRES_API, null, 2, null);
                        if (apiConstraint == null) {
                            return false;
                        }
                        requires = apiConstraint;
                        if (mainMinSdk.isAtLeast(requires)) {
                            return false;
                        }
                        Integer n = map2.getInt(KEY_DESUGAR, null);
                        if (n != null) {
                            int it = ((Number)n).intValue();
                            boolean bl = false;
                            desugaring2 = Desugaring.Companion.fromConstant(it);
                        } else {
                            desugaring2 = null;
                        }
                        desugaring = desugaring2;
                        libraryDesugaring = false;
                        if (desugaring != null && desugaring != Desugaring.JAVA_8_LIBRARY) break block32;
                        if (!mainProject.isDesugaring(Desugaring.JAVA_8_LIBRARY)) break block33;
                        libraryDesugaring = true;
                        owner2 = map2.getString(KEY_OWNER, null);
                        if (owner2 == null || !DesugaredMethodLookup.Companion.canBeDesugaredLater(owner2)) break block33;
                        name = LintMap.getString$default(map2, KEY_NAME, null, 2, null);
                        desc = LintMap.getString$default(map2, KEY_DESC, null, 2, null);
                        object = LintMap.getString$default(map2, KEY_SOURCE_SET, null, 2, null);
                        if (object == null) break block34;
                        String it = object;
                        boolean bl = false;
                        SourceSetType sourceSetType = SourceSetType.valueOf(it);
                        object = sourceSetType;
                        if (sourceSetType != null) break block35;
                    }
                    object = sourceSet = SourceSetType.MAIN;
                }
                if (name != null && desc != null) {
                    if (DesugaredMethodLookup.Companion.isDesugaredMethod(owner2, name, desc, (SourceSetType)((Object)sourceSet), mainProject, null)) {
                        return false;
                    }
                } else if (name != null) {
                    if (DesugaredMethodLookup.Companion.isDesugaredField(owner2, name, (SourceSetType)((Object)sourceSet), mainProject, null)) {
                        return false;
                    }
                } else {
                    String message;
                    DesugaredMethodLookup lookup = DesugaredMethodLookup.Companion.getLookup(mainProject, (SourceSetType)((Object)sourceSet));
                    if (lookup.isDesugaredClass(owner2)) {
                        return false;
                    }
                    String string2 = map2.getString(KEY_MESSAGE, "");
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (StringsKt.startsWith$default((String)(message = string2), (String)"Implicit cast ", (boolean)false, (int)2, null) && lookup.isClassPartiallyDesugared(owner2)) {
                        return false;
                    }
                }
                break block33;
            }
            if (mainProject.isDesugaring(desugaring)) {
                return false;
            }
        }
        ApiConstraint apiConstraint = LintMap.getApiConstraint$default(map2, KEY_MIN_API, null, 2, null);
        if (apiConstraint == null) {
            return false;
        }
        ApiConstraint target2 = apiConstraint;
        ApiConstraint maxMinSdk = !target2.isEmpty() ? ApiConstraint.Companion.max$default(ApiConstraint.Companion, target2, mainMinSdk, false, 4, null) : mainMinSdk;
        Object object = maxMinSdk.findSdk(((ApiConstraint.SdkApiConstraint)CollectionsKt.first(requires.getConstraints())).getSdk(), true);
        if (object == null || (object = ((ApiConstraint)object).minString()) == null) {
            object = "0";
        }
        Object minSdk = object;
        String string3 = LintMap.getString$default(map2, KEY_MESSAGE, null, 2, null);
        if (string3 == null) {
            return false;
        }
        String formatString = string3;
        Object[] objectArray = new Object[]{minSdk};
        String string4 = String.format(formatString, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String message = string4;
        incident.setMessage(message);
        if (!libraryDesugaring && (owner = map2.getString(KEY_OWNER, null)) != null && DesugaredMethodLookup.Companion.canBeDesugaredLater(owner)) {
            int index2;
            String name = LintMap.getString$default(map2, KEY_NAME, null, 2, null);
            String desc = LintMap.getString$default(map2, KEY_DESC, null, 2, null);
            DesugaredMethodLookup lookup = DesugaredMethodLookup.Companion.getBundledLibraryDesugaringRules(mainProject);
            boolean isDesugarable = false;
            if (name != null && desc != null) {
                if (lookup.isDesugaredMethod(owner, name, desc)) {
                    isDesugarable = true;
                }
            } else if (name != null) {
                if (lookup.isDesugaredField(owner, name)) {
                    isDesugarable = true;
                }
            } else if (lookup.isDesugaredClass(owner)) {
                isDesugarable = true;
            }
            if (isDesugarable && (index2 = StringsKt.indexOf$default((CharSequence)message, (String)" (", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string5 = message;
                int n = 0;
                String string6 = string5.substring(n, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                String string7 = message.substring(index2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                incident.setMessage(string6 + ", or core library desugaring" + string7);
            }
        }
        return true;
    }

    private final void report(XmlContext context2, Issue issue, Node scope, Location location, String message, ApiConstraint api2, ApiConstraint minSdk) {
        boolean bl;
        LintMap lintMap;
        boolean bl2 = StringsKt.contains$default((CharSequence)message, (CharSequence)"%1$s", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        LintFix lintFix = ApiDetector.Companion.apiLevelFix(api2, minSdk);
        Incident incident = new Incident(issue, scope, location, "", lintFix);
        LintMap $this$report_u24lambda_u246 = lintMap = this.map();
        boolean bl3 = false;
        $this$report_u24lambda_u246.put(KEY_REQUIRES_API, api2);
        $this$report_u24lambda_u246.put(KEY_MESSAGE, message);
        boolean bl4 = bl = minSdk != ApiConstraint.UNKNOWN;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Node node = scope;
        Element element = node instanceof Attr ? ((Attr)scope).getOwnerElement() : (node instanceof Element ? (Element)scope : scope.getOwnerDocument().getDocumentElement());
        Intrinsics.checkNotNull((Object)element);
        $this$report_u24lambda_u246.put(KEY_MIN_API, ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, ApiDetector.Companion.getLocalMinSdk(element), false, 4, null));
        LintMap map2 = lintMap;
        context2.report(incident, map2);
    }

    private final String getApiLevelString(ApiConstraint requires, JavaContext context2) {
        int level = requires.fromInclusive();
        if (requires.getSdk() == 0) {
            if (level > 36 && level > context2.getProject().getBuildSdk()) {
                IAndroidTarget iAndroidTarget = context2.getProject().getBuildTarget();
                boolean bl = iAndroidTarget != null && (iAndroidTarget = iAndroidTarget.getVersion()) != null ? iAndroidTarget.isPreview() : false;
                if (bl) {
                    String string2 = SdkVersionInfo.getCodeName((int)level);
                    if (string2 == null) {
                        string2 = requires.toString();
                    }
                    return string2;
                }
            }
            if (level == 10000) {
                return "CUR_DEVELOPMENT/10000";
            }
        }
        return requires.minString();
    }

    private final void checkObsoleteSdkVersion(JavaContext context2, UElement node, boolean expectFull) {
        UBinaryExpression binary = (UBinaryExpression)UastUtils.getParentOfType((UElement)node, UBinaryExpression.class, (boolean)true);
        if (binary != null) {
            ApiConstraint.SdkApiConstraint sdkApiConstraint;
            ApiConstraint apiConstraint = this.getMinSdk(context2);
            if (apiConstraint == null || (sdkApiConstraint = ApiConstraint.findSdk$default(apiConstraint, 0, false, 2, null)) == null) {
                return;
            }
            ApiConstraint.SdkApiConstraint environmentConstraint = sdkApiConstraint;
            ApiConstraint apiConstraint2 = VersionChecks.Companion.getVersionCheckConditional$default(VersionChecks.Companion, binary, context2.getClient(), context2.getEvaluator(), context2.getProject(), null, 16, null);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint constraint = apiConstraint2;
            int sdkId = constraint.getSdk();
            if (sdkId == 0) {
                String string2;
                ApiConstraint target2;
                ApiConstraint.SdkApiConstraint outer;
                int constant;
                Object value = binary.getRightOperand().evaluate();
                if (value instanceof Number && !ApiConstraint.Companion.isInfinity(constant = ((Number)value).intValue()) && expectFull != ApiLevel.Companion.isFullSdkInt(constant)) {
                    Object object = UastUtils.skipParenthesizedExprDown((UExpression)binary.getRightOperand()).getSourcePsi();
                    if (object == null || (object = object.getText()) == null) {
                        object = "";
                    }
                    Object rhs = object;
                    String message = expectFull ? "The API level (`" + (String)rhs + "`) appears to be a full SDK int (encoding major and minor versions), so it should be compared with `SDK_INT_FULL`, not `SDK_INT`" : "The API level (`" + (String)rhs + "`) appears to be a plain SDK int, so it should be compared with `SDK_INT`, not `SDK_INT`, or you should switch the API level to a full SDK constant";
                    UExpression lhs = binary.getLeftOperand();
                    PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)lhs));
                    LintFix fix2 = resolved instanceof PsiField ? this.fix().name(expectFull ? "Switch to `SDK_INT`" : "Switch to `SDK_INT_FULL`").replace().range(context2.getLocation((UElement)lhs)).all().with(expectFull ? "android.os.Build.VERSION.SDK_INT" : "android.os.Build.VERSION.SDK_INT_FULL").shortenNames().build() : null;
                    context2.report(WRONG_SDK_INT, (UElement)binary, context2.getLocation((UElement)binary), message, fix2);
                }
                ApiConstraint apiConstraint3 = VersionChecks.Companion.getOuterVersionCheckConstraint(context2, (UElement)binary);
                ApiConstraint.SdkApiConstraint sdkApiConstraint2 = outer = apiConstraint3 != null ? ApiConstraint.findSdk$default(apiConstraint3, sdkId, false, 2, null) : null;
                if (outer != null && outer.isNotEmpty()) {
                    environmentConstraint = environmentConstraint.and(outer);
                }
                if ((target2 = (ApiConstraint)VersionChecks.Companion.getTargetApiAnnotation(context2.getEvaluator(), (UElement)binary, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    public final Boolean invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                })).getSecond()) != null) {
                    environmentConstraint = environmentConstraint.and(target2);
                }
                ApiConstraint both = constraint.and(environmentConstraint);
                boolean always = both.alwaysAtLeast(environmentConstraint);
                boolean never = both.not().alwaysAtLeast(environmentConstraint);
                if (!always && !never) {
                    return;
                }
                String sdkInt = "SDK_INT" + (expectFull ? "_FULL" : "");
                if (both.isEmpty() && (outer != null || target2 != null) || !environmentConstraint.isOpenEnded()) {
                    Object object = binary.getSourcePsi();
                    if (object == null || (object = object.getText()) == null) {
                        object = binary.asSourceString();
                    }
                    Object source = object;
                    String constraintString = StringsKt.replace$default((String)environmentConstraint.toString(), (String)"API level ", (String)"", (boolean)false, (int)4, null);
                    String suffix = !both.isEmpty() ? " (`" + sdkInt + "` " + constraintString + ")" : "";
                    String frequency = always && !never ? "always" : "never";
                    string2 = "Unnecessary; `" + (String)source + "` is " + frequency + " true here" + suffix;
                } else {
                    string2 = always ? "Unnecessary; `" + sdkInt + "` is always >= " + environmentConstraint.minString() : "Unnecessary; `" + sdkInt + "` is never < " + environmentConstraint.minString();
                }
                String message = string2;
                Object[] objectArray = new Object[]{KEY_CONDITIONAL, always};
                context2.report(new Incident(OBSOLETE_SDK, message, context2.getLocation((UElement)binary), binary, LintFix.Companion.create().data(objectArray)));
            }
        }
    }

    @Override
    public void checkFolder(@NotNull ResourceContext context2, @NotNull String folderName) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)KEY_FOLDER_NAME);
        int folderVersion = context2.getFolderVersion();
        AndroidVersion minSdkVersion = context2.getProject().getMinSdkVersion();
        if (folderVersion > 1 && folderVersion <= minSdkVersion.getFeatureLevel()) {
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfiguration == null) {
                throw new IllegalStateException(((Object)context2.file).toString());
            }
            FolderConfiguration folderConfig = folderConfiguration;
            folderConfig.setVersionQualifier(null);
            ResourceFolderType resourceFolderType = context2.getResourceFolderType();
            if (resourceFolderType == null) {
                throw new IllegalStateException(((Object)context2.file).toString());
            }
            ResourceFolderType resourceFolderType2 = resourceFolderType;
            String newFolderName = folderConfig.getFolderName(resourceFolderType2);
            String message = "This folder configuration (`v" + folderVersion + "`) is unnecessary; `minSdkVersion` is " + minSdkVersion.getApiString() + ". Merge all the resources in this folder into `" + newFolderName + "`.";
            Object[] objectArray = new Object[]{KEY_FILE, context2.file, KEY_FOLDER_NAME, newFolderName, KEY_REQUIRES_API, minSdkVersion.getApiLevel()};
            context2.report(new Incident(OBSOLETE_SDK, message, Location.Companion.create(context2.file), this.fix().data(objectArray)));
        }
    }

    private static final boolean visitAnnotationUsage$lambda$1(AnnotationInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VersionChecks.Companion.isRequiresApiAnnotation(it.getQualifiedName());
    }

    @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(evaluator, scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @Nullable
    public static final ApiConstraint.SdkApiConstraint getApiLevel(@NotNull Context context2, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
        return Companion.getApiLevel(context2, annotation, qualifiedName);
    }

    @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable UElement scope) {
        return Companion.getTargetApi(scope);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope) {
        return Companion.getTargetApi(evaluator, scope);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        Implementation implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        UNSUPPORTED = Issue.Companion.create$default(companion, "NewApi", "Calling new methods on older versions", "\n                This check scans through all the Android API calls in the application and \\\n                warns about any calls that are not available on **all** versions targeted by \\\n                this application (according to its minimum SDK attribute in the manifest).\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n\n                If you are deliberately setting `android:` attributes in style definitions, \\\n                make sure you place this in a `values-v`*NN* folder in order to avoid running \\\n                into runtime conflicts on certain devices where manufacturers have added \\\n                custom attributes whose ids conflict with the new ones on later platforms.\n\n                Similarly, you can use tools:targetApi=\"11\" in an XML file to indicate that \\\n                the element will only be inflated in an adequate context.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        INLINED = Issue.Companion.create$default(companion, "InlinedApi", "Using inlined constants on older versions", "\n                This check scans through all the Android API field references in the \\\n                application and flags certain constants, such as static final integers and \\\n                Strings, which were introduced in later versions. These will actually be \\\n                copied into the class files rather than being referenced, which means that \\\n                the value is available even when running on older devices. In some cases \\\n                that's fine, and in other cases it can result in a runtime crash or \\\n                incorrect behavior. It depends on the context, so consider the code carefully \\\n                and decide whether it's safe and can be suppressed or whether the code needs \\\n                to be guarded.\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.RESOURCE_FOLDER_SCOPE};
        implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER), enumSetArray);
        UNUSED = Issue.Companion.create$default(companion, "UnusedAttribute", "Attribute unused on older versions", "\n                This check finds attributes set in XML files that were introduced in a version \\\n                newer than the oldest version targeted by your application (with the \\\n                `minSdkVersion` attribute).\n\n                This is not an error; the application will simply ignore the attribute. \\\n                However, if the attribute is important to the appearance or functionality of \\\n                your application, you should consider finding an alternative way to achieve the \\\n                same result with only available attributes, and then you can optionally create \\\n                a copy of the layout in a layout-vNN folder which will be used on API NN or \\\n                higher where you can take advantage of the newer attribute.\n\n                Note: This check does not only apply to attributes. For example, some tags can \\\n                be unused too, such as the new `<tag>` element in layouts introduced in API 21.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        OBSOLETE_SDK = Issue.Companion.create$default(companion, "ObsoleteSdkInt", "Obsolete SDK_INT Version Check", "\n                This check flags version checks that are not necessary, because the \\\n                `minSdkVersion` (or surrounding known API level) is already at least as high \\\n                as the version checked for.\n\n                Similarly, it also looks for resources in `-vNN` folders, such as `values-v14` \\\n                where the version qualifier is less than or equal to the `minSdkVersion`, \\\n                where the contents should be merged into the best folder.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = JAVA_IMPLEMENTATION;
        WRONG_SDK_INT = Issue.Companion.create$default(companion, "WrongSdkInt", "Mismatched SDK_INT or SDK_INT_FULL", "\n          The `SDK_INT` constant can be used to check what the current API level is. \\\n          The `SDK_INT_FULL` constant also contains this information, but it also \\\n          carries additional information about minor versions between major releases, \\\n          and cannot be compared directly with the normal API levels.\n\n          You should typically compare `SDK_INT` with the constants in `Build.VERSION_CODES`, \\\n          and `SDK_INT_FULL` with the constants in `Build.VERSION_CODES_FULL`. This lint check \\\n          flags suspicious combinations of these comparisons.\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = JAVA_IMPLEMENTATION;
        NIO_DESUGARING = Issue.Companion.create$default(companion, "NioDesugaring", "Unsupported `java.nio` operations", "\n          Core library desugaring handles most of the `java.nio` APIs, but \\\n          prior to API level 26, a handful of APIs are not fully supported.\n\n          This is detailed in the documentation at \\\n          https://developer.android.com/studio/write/java11-nio-support-table#java-nio-customizations .\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0086\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fJt\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\"\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010)\u001a\u00020.H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0002J*\u00104\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u0002032\b\b\u0002\u00106\u001a\u000201H\u0002J,\u00104\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000f2\b\u00105\u001a\u0004\u0018\u00010\u000f2\u0006\u00106\u001a\u000201H\u0002J\u0010\u00107\u001a\u00020\u00072\u0006\u0010\n\u001a\u000208H\u0016J\u000e\u00109\u001a\u000201*\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020=H\u0016J\"\u0010>\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u000b2\u0006\u00102\u001a\u0002032\b\u0010?\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010@\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020BH\u0002J*\u0010@\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u000b2\b\u0010?\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020GH\u0016J \u0010H\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020\u000bH\u0002J\u0018\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u000203H\u0002JL\u0010H\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020B2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010P\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010I\u001a\u00020GH\u0002J(\u0010P\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J\f\u0010U\u001a\u00020\u000f*\u00020\u000fH\u0002J\f\u0010V\u001a\u00020\u000f*\u00020\u000fH\u0002J\"\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020G2\b\b\u0002\u0010Y\u001a\u000201H\u0002J,\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000b2\b\b\u0002\u0010Y\u001a\u0002012\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J8\u0010Z\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020G2\u0006\u0010[\u001a\u00020\\2\u0006\u0010+\u001a\u00020,2\u0006\u0010J\u001a\u00020\u000bH\u0002J\f\u0010]\u001a\u000201*\u00020GH\u0002JJ\u0010^\u001a\u00020\u00072\u0006\u0010I\u001a\u00020G2\u0006\u0010[\u001a\u00020\\2\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000f2\u0006\u0010a\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010J\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010I\u001a\u00020GH\u0002J\u0010\u0010c\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020jH\u0016J \u0010k\u001a\u0002012\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010l\u001a\u00020\u0012H\u0002J\u0010\u0010m\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020RH\u0016J\"\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\b\u0010\u000e\u001a\u0004\u0018\u00010#H\u0002J*\u0010p\u001a\u0004\u0018\u00010\u00122\b\u0010q\u001a\u0004\u0018\u00010\u000b2\u0014\b\u0002\u0010r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002010sH\u0002J\u0010\u0010t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020uH\u0016J\u0018\u0010v\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010w\u001a\u00020xH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$ApiVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "<init>", "(Lcom/android/tools/lint/checks/ApiDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "report", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "node", "Lorg/jetbrains/uast/UElement;", "location", "Lcom/android/tools/lint/detector/api/Location;", "type", "", "sig", "requires", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "minSdk", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "owner", "name", "desc", "desugaring", "Lcom/android/tools/lint/detector/api/Desugaring;", "original", "formatString", "min", "visitAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "checkInjection", "element", "checkInjectionType", "Lcom/intellij/psi/PsiType;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "checkMethodReference", "expression", "Lorg/jetbrains/uast/UReferenceExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitTypeCastExpression", "checkClassReference", "", "classType", "Lcom/intellij/psi/PsiClassType;", "checkCast", "interfaceType", "implicit", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "isInjectAnnotationName", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "checkClassType", "descriptor", "checkClass", "cls", "Lcom/intellij/psi/PsiClass;", "fqcn", "visitForEachExpression", "Lorg/jetbrains/uast/UForEachExpression;", "visitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "visitCall", "call", "reference", "checkArgumentCast", "argument", "Lorg/jetbrains/uast/UExpression;", "parameterType", "containingClass", "handleNioDesugaringSpecialCases", "tryExpression", "Lorg/jetbrains/uast/UTryExpression;", "typeReference", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "byLibDesugaring", "withLibDesugaring", "reportNioIssue", "message", "warnOnly", "handleKotlinExtensionMethods", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isAliased", "checkKotlinStdlibAlias", "aliasClassName", "aliasMethodName", "aliasDesc", "checkAnimator", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitArrayAccessExpression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitUnaryExpression", "Lorg/jetbrains/uast/UUnaryExpression;", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "isAtLeast", "api", "visitTryExpression", "checkCatchTypeElement", "statement", "getTargetApi", "scope", "isApiLevelAnnotation", "Lkotlin/Function1;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "checkField", "field", "Lcom/intellij/psi/PsiField;", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$ApiVisitor\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,4213:1\n18#2:4214\n18#2:4219\n12567#3,2:4215\n1310#3,2:4217\n*S KotlinDebug\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$ApiVisitor\n*L\n1317#1:4214\n3060#1:4219\n1347#1:4215,2\n2734#1:4217,2\n*E\n"})
    private final class ApiVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public ApiVisitor(JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        public final void report(@NotNull Issue issue, @NotNull UElement node, @NotNull Location location, @NotNull String type, @NotNull String sig, @NotNull ApiConstraint requires, @NotNull ApiConstraint minSdk, @Nullable LintFix fix2, @Nullable String owner, @Nullable String name, @Nullable String desc, @Nullable Desugaring desugaring, @Nullable String original) {
            LintFix lintFix;
            String formatString;
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
            Intrinsics.checkNotNullParameter((Object)requires, (String)"requires");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            ApiConstraint.SdkApiConstraint sdkApiConstraint = minSdk.firstMissing(requires);
            ApiConstraint missing = sdkApiConstraint != null ? (ApiConstraint)sdkApiConstraint : requires;
            String apiLevel = ApiDetector.this.getApiLevelString(missing, this.context);
            String typeString = StringHelper.usLocaleCapitalize((String)type);
            int sdk = missing.getSdk();
            if (sdk == 0) {
                v1 = typeString + " requires API level " + apiLevel + " (current min is %1$s): `" + sig + "`";
            } else {
                Object sdkString;
                Object object = ApiDetector.this.apiDatabase;
                if (object == null || (object = ((ApiLookup)object).getSdkName(sdk)) == null) {
                    object = ExtensionSdk.Companion.getSdkExtensionField(sdk, false);
                }
                v1 = formatString = typeString + " requires version " + apiLevel + " of " + (Character.isDigit(((String)(sdkString = object)).charAt(0)) ? "SDK " + (String)sdkString : "the " + (String)sdkString + " SDK") + " (current min is %1$s): `" + sig + "`";
            }
            if (original != null) {
                formatString = formatString + " (called from `" + original + "`)";
            }
            if ((lintFix = fix2) == null) {
                lintFix = Companion.apiLevelFix(missing, minSdk);
            }
            LintFix suggestedFix = lintFix;
            Location location2 = location;
            if (Intrinsics.areEqual((Object)owner, (Object)"java.util.List") && (Intrinsics.areEqual((Object)name, (Object)"removeFirst") || Intrinsics.areEqual((Object)name, (Object)"removeLast")) && node instanceof UCallExpression) {
                location2 = this.context.getCallLocation((UCallExpression)node, false, true);
                String replacement = Companion.getRemoveReplacementSource(name, node);
                String display = Companion.getRemoveReplacementSourceDisplay(replacement);
                formatString = formatString + " (Prior to API level 35, this call would resolve to a Kotlin stdlib extension function. You can use `" + display + "` instead.)";
                LintFix[] lintFixArray = new LintFix[]{Companion.createRemoveFirstFix(location2, name, replacement, display), suggestedFix};
                suggestedFix = ApiDetector.this.fix().alternatives(lintFixArray);
            }
            this.report(issue, node, location2, formatString, suggestedFix, owner, name, desc, missing, minSdk, desugaring);
        }

        public static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string2, String string3, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, LintFix lintFix, String string4, String string5, String string6, Desugaring desugaring, String string7, int n, Object object) {
            if ((n & 0x80) != 0) {
                lintFix = null;
            }
            if ((n & 0x100) != 0) {
                string4 = null;
            }
            if ((n & 0x200) != 0) {
                string5 = null;
            }
            if ((n & 0x400) != 0) {
                string6 = null;
            }
            if ((n & 0x800) != 0) {
                desugaring = null;
            }
            if ((n & 0x1000) != 0) {
                string7 = null;
            }
            apiVisitor.report(issue, uElement, location, string2, string3, apiConstraint, apiConstraint2, lintFix, string4, string5, string6, desugaring, string7);
        }

        private final void report(Issue issue, UElement node, Location location, String formatString, LintFix fix2, String owner, String name, String desc, ApiConstraint requires, ApiConstraint min, Desugaring desugaring) {
            LintMap lintMap;
            Incident incident = new Incident(issue, node, location, "", fix2);
            LintMap $this$report_u24lambda_u240 = lintMap = ApiDetector.this.map();
            boolean bl = false;
            $this$report_u24lambda_u240.put(ApiDetector.KEY_REQUIRES_API, requires);
            $this$report_u24lambda_u240.put(ApiDetector.KEY_MIN_API, ApiConstraint.Companion.max$default(ApiConstraint.Companion, min, ApiVisitor.getTargetApi$default(this, node, null, 2, null), false, 4, null));
            $this$report_u24lambda_u240.put(ApiDetector.KEY_MESSAGE, formatString);
            if (owner != null && DesugaredMethodLookup.Companion.canBeDesugaredLater(owner)) {
                SourceSetType sourceSetType;
                $this$report_u24lambda_u240.put(ApiDetector.KEY_OWNER, owner);
                if (name != null) {
                    $this$report_u24lambda_u240.put(ApiDetector.KEY_NAME, name);
                    if (desc != null) {
                        $this$report_u24lambda_u240.put(ApiDetector.KEY_DESC, desc);
                    }
                }
                if ((sourceSetType = this.context.getSourceSetType()) != SourceSetType.INVALID && sourceSetType != SourceSetType.MAIN) {
                    $this$report_u24lambda_u240.put(ApiDetector.KEY_SOURCE_SET, sourceSetType.name());
                }
            }
            if (desugaring != null) {
                $this$report_u24lambda_u240.put(ApiDetector.KEY_DESUGAR, desugaring.getConstant());
            }
            LintMap map2 = lintMap;
            this.context.report(incident, map2);
        }

        static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string2, LintFix lintFix, String string3, String string4, String string5, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, Desugaring desugaring, int n, Object object) {
            if ((n & 0x10) != 0) {
                lintFix = null;
            }
            if ((n & 0x20) != 0) {
                string3 = null;
            }
            if ((n & 0x40) != 0) {
                string4 = null;
            }
            if ((n & 0x80) != 0) {
                string5 = null;
            }
            if ((n & 0x400) != 0) {
                desugaring = null;
            }
            apiVisitor.report(issue, uElement, location, string2, lintFix, string3, string4, string5, apiConstraint, apiConstraint2, desugaring);
        }

        @Override
        public void visitAnnotation(@NotNull UAnnotation node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.isInjectAnnotationName(node.getQualifiedName())) {
                UElement $this$getParentOfType_u24default$iv = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UAnnotated anchor = (UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UAnnotated.class, (boolean)strict$iv);
                if (anchor != null) {
                    this.checkInjection((UElement)anchor);
                }
            }
        }

        private final void checkInjection(UElement element) {
            if (element == null) {
                return;
            }
            if (element instanceof UMethod) {
                UElement node = element;
                for (UParameter parameter : ((UMethod)node).getUastParameters()) {
                    this.checkInjectionType((UElement)parameter, UastLintUtilsKt.getTypeFromPsi((UVariable)parameter));
                }
                if (((UMethod)element).getSourcePsi() instanceof KtProperty) {
                    this.checkInjectionType(element, ((UMethod)element).getReturnType());
                }
            } else if (element instanceof UField) {
                this.checkInjectionType(element, UastLintUtilsKt.getTypeFromPsi((UVariable)element));
            }
        }

        private final void checkInjectionType(UElement element, PsiType type) {
            PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
            if (psiClassType == null) {
                return;
            }
            PsiClassType classType = psiClassType;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass cls = psiClass;
            String string2 = cls.getQualifiedName();
            if (string2 == null) {
                return;
            }
            String owner = string2;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            boolean bl = apiLookup != null ? !apiLookup.containsClass(owner) : false;
            if (bl) {
                for (PsiMethod constructor : cls.getConstructors()) {
                    boolean bl2;
                    block8: {
                        PsiAnnotation[] psiAnnotationArray = constructor.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                        Object[] $this$any$iv = psiAnnotationArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiAnnotation it = (PsiAnnotation)element$iv;
                            boolean bl3 = false;
                            if (!this.isInjectAnnotationName(it.getQualifiedName())) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    for (PsiParameter injectedParameter : constructor.getParameterList().getParameters()) {
                        PsiClassType type2;
                        PsiType psiType = injectedParameter.getType();
                        if ((psiType instanceof PsiClassType ? (PsiClassType)psiType : null) == null) continue;
                        type2 = type2;
                        this.checkClassReference(element, type2);
                    }
                }
            } else {
                this.checkClassReference(element, classType);
            }
        }

        @Override
        public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            }
        }

        @Override
        public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiMethod) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        private final void checkMethodReference(UReferenceExpression expression, PsiMethod method) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(containingClass);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName(method);
            String string3 = evaluator.getMethodDescription(method, false, false);
            if (string3 == null) {
                return;
            }
            String desc = string3;
            ApiConstraint apiConstraint = apiDatabase.getMethodVersions(owner, name, desc);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getMethodVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, (UElement)expression, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return;
            }
            if (DesugaredMethodLookup.Companion.canBeDesugaredLater(owner) && DesugaredMethodLookup.Companion.isDesugaredMethod(owner, name, desc, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject(), containingClass)) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            String signature = expression.asSourceString();
            Location location = this.context.getLocation((UElement)expression);
            ApiVisitor.report$default(this, UNSUPPORTED, (UElement)expression, location, "Method reference", signature, api2, minSdk, null, owner, name, desc, null, null, 6144, null);
        }

        @Override
        public void visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            PsiType type;
            UTypeReferenceExpression typeReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isTypeCast((UElement)((UElement)node))) {
                this.visitTypeCastExpression(node);
            } else if (UastExpressionUtils.isInstanceCheck((UElement)((UElement)node)) && (typeReference = node.getTypeReference()) != null && (type = typeReference.getType()) instanceof PsiClassType) {
                this.checkClassReference((UElement)typeReference, (PsiClassType)type);
            }
        }

        private final void visitTypeCastExpression(UBinaryExpressionWithType expression) {
            UExpression operand = expression.getOperand();
            PsiType operandType = operand.getExpressionType();
            PsiType castType = expression.getType();
            if (Intrinsics.areEqual((Object)castType, (Object)operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            UTypeReferenceExpression typeReference = expression.getTypeReference();
            if (typeReference != null && !this.checkClassReference((UElement)typeReference, (PsiClassType)castType)) {
                return;
            }
            this.checkCast((UElement)expression, (PsiClassType)operandType, (PsiClassType)castType, false);
        }

        private final boolean checkClassReference(UElement node, PsiClassType classType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return true;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(classType);
            if (string2 == null) {
                return true;
            }
            String expressionOwner = string2;
            ApiConstraint apiConstraint = apiDatabase.getClassVersions(expressionOwner);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getClassVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return true;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return true;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return true;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            Location location = this.context.getLocation(node);
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, "Class", expressionOwner, api2, minSdk, null, expressionOwner, null, null, null, null, 7680, null);
            return false;
        }

        private final void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType, boolean implicit) {
            if (Intrinsics.areEqual((Object)classType, (Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String classTypeInternal = evaluator.getQualifiedName(classType);
            String interfaceTypeInternal = evaluator.getQualifiedName(interfaceType);
            this.checkCast(node, classTypeInternal, interfaceTypeInternal, implicit);
        }

        static /* synthetic */ void checkCast$default(ApiVisitor apiVisitor, UElement uElement, PsiClassType psiClassType, PsiClassType psiClassType2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            apiVisitor.checkCast(uElement, psiClassType, psiClassType2, bl);
        }

        private final void checkCast(UElement node, String classType, String interfaceType, boolean implicit) {
            Object owner;
            if (interfaceType == null || classType == null) {
                return;
            }
            if (ApiLookup.equivalentName(interfaceType, "java/lang/Object")) {
                return;
            }
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            ApiConstraint apiConstraint = apiDatabase.getValidCastVersions(classType, interfaceType);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getValidCastVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (minSdk.isAtLeast(api2)) {
                return;
            }
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            if (node instanceof UReferenceExpression) {
                PsiElement resolved = UastUtils.tryResolve((UElement)node);
                if (resolved instanceof PsiField) {
                    PsiClass psiClass = ((PsiField)resolved).getContainingClass();
                    String string2 = owner = psiClass != null ? psiClass.getQualifiedName() : null;
                    if (owner != null) {
                        ApiConstraint apiConstraint3 = apiDatabase.getFieldVersions((String)owner, ((PsiField)resolved).getName());
                        Intrinsics.checkNotNullExpressionValue((Object)apiConstraint3, (String)"getFieldVersions(...)");
                        ApiConstraint versions = apiConstraint3;
                        if (!minSdk.isAtLeast(versions)) {
                            return;
                        }
                    }
                } else if (resolved instanceof PsiMethod) {
                    String desc;
                    PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
                    String string3 = owner = psiClass != null ? psiClass.getQualifiedName() : null;
                    if (owner != null && (desc = this.context.getEvaluator().getMethodDescription((PsiMethod)resolved, false, false)) != null) {
                        ApiConstraint apiConstraint4 = apiDatabase.getMethodVersions((String)owner, Lint.getInternalMethodName((PsiMethod)resolved), desc);
                        Intrinsics.checkNotNullExpressionValue((Object)apiConstraint4, (String)"getMethodVersions(...)");
                        ApiConstraint versions = apiConstraint4;
                        if (!minSdk.isAtLeast(versions)) {
                            return;
                        }
                    }
                }
            }
            UElement curr = node;
            while (true) {
                if ((owner = curr) instanceof UIfExpression) {
                    PsiType type;
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((UIfExpression)curr).getThenExpression()), (boolean)true) && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)curr).getCondition())) instanceof UBinaryExpressionWithType && (type = ((UBinaryExpressionWithType)condition).getType()) instanceof PsiClassType && Intrinsics.areEqual((Object)this.context.getEvaluator().getQualifiedName((PsiClassType)type), (Object)interfaceType)) {
                        return;
                    }
                } else if (owner instanceof USwitchClauseExpressionWithBody) {
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((USwitchClauseExpressionWithBody)curr).getBody()), (boolean)true)) {
                        condition = ((USwitchClauseExpressionWithBody)curr).getCaseValues().iterator();
                        while (condition.hasNext()) {
                            PsiType type;
                            UExpression uExpression = (UExpression)condition.next();
                            UExpression condition = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                            if (!(condition instanceof UBinaryExpressionWithType) || !((type = ((UBinaryExpressionWithType)condition).getType()) instanceof PsiClassType) || !Intrinsics.areEqual((Object)this.context.getEvaluator().getQualifiedName((PsiClassType)type), (Object)interfaceType)) continue;
                            return;
                        }
                    }
                } else if (owner instanceof UMethod) break;
                if (curr.getUastParent() == null) break;
            }
            if (DesugaredMethodLookup.Companion.canBeDesugaredLater(classType) && DesugaredMethodLookup.Companion.isDesugaredClass(classType, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject()) || (Intrinsics.areEqual((Object)classType, (Object)"java.nio.file.attribute.UserPrincipal") || Intrinsics.areEqual((Object)classType, (Object)"java.nio.file.attribute.GroupPrincipal")) && this.context.getProject().getDesugaring().contains((Object)Desugaring.JAVA_8_LIBRARY)) {
                return;
            }
            UElement locationNode = node;
            boolean implicitCast = implicit;
            if (Intrinsics.areEqual((Object)interfaceType, (Object)"java.lang.AutoCloseable") || Intrinsics.areEqual((Object)interfaceType, (Object)"java.io.Closeable")) {
                UElement selector;
                UElement uElement = node.getUastParent();
                Object object = selector = uElement != null ? UastLintUtilsKt.findSelector(uElement) : null;
                if (selector instanceof UCallExpression) {
                    UIdentifier uIdentifier = ((UCallExpression)selector).getMethodIdentifier();
                    if (Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)"use")) {
                        implicitCast = true;
                        UIdentifier uIdentifier2 = ((UCallExpression)selector).getMethodIdentifier();
                        locationNode = uIdentifier2 != null ? (UElement)uIdentifier2 : selector;
                    }
                }
            }
            String castType = implicitCast ? "Implicit cast" : "Cast";
            Location location = this.context.getLocation(locationNode);
            String message = null;
            String to = StringsKt.substringAfterLast$default((String)interfaceType, (char)'.', null, (int)2, null);
            String from = StringsKt.substringAfterLast$default((String)classType, (char)'.', null, (int)2, null);
            message = Intrinsics.areEqual((Object)interfaceType, (Object)classType) ? castType + " to `" + to + "` requires API level " + api2.minString() + " (current min is %1$s)" : castType + " from `" + from + "` to `" + to + "` requires API level " + api2.minString() + " (current min is %1$s)";
            ApiVisitor.report$default(this, UNSUPPORTED, locationNode, location, message, Companion.apiLevelFix(api2, minSdk), classType, null, null, api2, minSdk, null, 1216, null);
        }

        @Override
        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiClass containingClass = node.getJavaPsi().getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !this.context.getProject().isDesugaring(Desugaring.INTERFACE_METHODS)) {
                PsiModifierList psiModifierList = node.getJavaPsi().getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"getModifierList(...)");
                PsiModifierList methodModifierList = psiModifierList;
                if (methodModifierList.hasExplicitModifier("default") || methodModifierList.hasExplicitModifier("static")) {
                    ApiConstraint.SdkApiConstraint api2 = API_24;
                    ApiConstraint apiConstraint = ApiDetector.this.getMinSdk(this.context);
                    if (apiConstraint == null) {
                        return;
                    }
                    ApiConstraint minSdk = apiConstraint;
                    if (!Companion.isSuppressed(this.context, api2, (UElement)node, minSdk)) {
                        Location location = this.context.getLocation(node);
                        String desc = methodModifierList.hasExplicitModifier("default") ? "Default method" : "Static interface method";
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, desc, containingClass.getName() + "#" + node.getName(), api2, minSdk, null, containingClass.getQualifiedName(), null, null, Desugaring.INTERFACE_METHODS, null, 5632, null);
                    }
                }
            }
        }

        private final boolean isInjectAnnotationName(String $this$isInjectAnnotationName) {
            return $this$isInjectAnnotationName != null && StringsKt.endsWith$default((String)$this$isInjectAnnotationName, (String)"Inject", (boolean)false, (int)2, null);
        }

        @Override
        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.isAnnotationType() && !this.context.getProject().isDesugaring(Desugaring.TYPE_ANNOTATIONS)) {
                JavaEvaluator evaluator = this.context.getEvaluator();
                for (UAnnotation annotation : JavaEvaluator.getAnnotations$default(evaluator, (PsiModifierListOwner)node, false, null, 4, null)) {
                    ApiConstraint minSdk;
                    String name = annotation.getQualifiedName();
                    if (!Intrinsics.areEqual((Object)"java.lang.annotation.Repeatable", (Object)name)) continue;
                    ApiConstraint.SdkApiConstraint api2 = API_24;
                    if (ApiDetector.this.getMinSdk(this.context) == null) {
                        return;
                    }
                    if (Companion.isSuppressed(this.context, api2, (UElement)node, minSdk)) continue;
                    Location location = this.context.getLocation((UElement)annotation);
                    ApiConstraint min = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, ApiVisitor.getTargetApi$default(this, (UElement)node, null, 2, null), false, 4, null);
                    Issue issue = UNSUPPORTED;
                    Object object = Companion.apiLevelFix(api2, min);
                    Incident incident = new Incident(issue, annotation, location, "", (LintFix)object);
                    Object $this$visitClass_u24lambda_u242 = object = ApiDetector.this.map();
                    boolean bl = false;
                    ((LintMap)$this$visitClass_u24lambda_u242).put(ApiDetector.KEY_REQUIRES_API, api2);
                    ((LintMap)$this$visitClass_u24lambda_u242).put(ApiDetector.KEY_MIN_API, min);
                    ((LintMap)$this$visitClass_u24lambda_u242).put(ApiDetector.KEY_MESSAGE, "Repeatable annotation requires API level " + api2.minString() + " (current min is %1$s)");
                    ((LintMap)$this$visitClass_u24lambda_u242).put(ApiDetector.KEY_DESUGAR, Desugaring.TYPE_ANNOTATIONS.getConstant());
                    Object map2 = object;
                    this.context.report(incident, (LintMap)map2);
                }
            }
            for (UTypeReferenceExpression typeReferenceExpression : node.getUastSuperTypes()) {
                PsiClass cls;
                PsiType type = typeReferenceExpression.getType();
                if (!(type instanceof PsiClassType) || (cls = ((PsiClassType)type).resolve()) == null) continue;
                this.checkClass((UElement)typeReferenceExpression, cls);
            }
        }

        @Override
        public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiType type = node.getType();
            if (type instanceof PsiClassType) {
                UExpression lhs = node.getExpression();
                UExpression uExpression = lhs;
                if (uExpression == null) {
                    uExpression = (UExpression)node;
                }
                UExpression locationElement = uExpression;
                this.checkClassType((UElement)locationElement, (PsiClassType)type, null);
            }
        }

        private final void checkClassType(UElement element, PsiClassType classType, String descriptor) {
            String owner = this.context.getEvaluator().getQualifiedName(classType);
            String string2 = classType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
            String fqcn = string2;
            if (owner != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, PsiClass cls) {
            String string2 = this.context.getEvaluator().getQualifiedName(cls);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, null, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, String descriptor, String owner, String fqcn) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            ApiConstraint apiConstraint = apiDatabase.getClassVersions(owner);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getClassVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, element, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            if (UastUtils.getParentOfType$default((UElement)element, UAnnotation.class, (boolean)false, (int)2, null) != null) {
                return;
            }
            Location location = this.context.getNameLocation(element);
            String string2 = descriptor;
            if (string2 == null) {
                string2 = "Class";
            }
            String desc = string2;
            ApiVisitor.report$default(this, UNSUPPORTED, element, location, desc, fqcn, api2, minSdk, null, owner, null, null, null, null, 7680, null);
        }

        @Override
        public void visitForEachExpression(@NotNull UForEachExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            UExpression value = node.getIteratedValue();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiType type = value.getExpressionType();
            if (type instanceof PsiClassType) {
                PsiClass containingClass;
                PsiElement keySet;
                String string2 = evaluator.getQualifiedName((PsiClassType)type);
                if (string2 == null) {
                    return;
                }
                String expressionOwner = string2;
                ApiConstraint apiConstraint = apiDatabase.getClassVersions(expressionOwner);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getClassVersions(...)");
                ApiConstraint api2 = apiConstraint;
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint2;
                Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, (UElement)node, minSdk);
                boolean suppressed = (Boolean)pair2.component1();
                ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
                if (suppressed) {
                    return;
                }
                minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
                Location location = this.context.getLocation((UElement)value);
                String message = "The type of the for loop iterated value is " + ((PsiClassType)type).getCanonicalText() + ", which requires API level " + api2.minString() + " (current min is %1$s)";
                if (value instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)"keySet", (Object)((UQualifiedReferenceExpression)value).getResolvedName()) && (keySet = ((UQualifiedReferenceExpression)value).resolve()) instanceof PsiMethod && (containingClass = ((PsiMethod)keySet).getContainingClass()) != null && Intrinsics.areEqual((Object)"java.util.concurrent.ConcurrentHashMap", (Object)containingClass.getQualifiedName())) {
                    message = message + "; to work around this, add an explicit cast to `(Map)` before the `keySet` call.";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, message, Companion.apiLevelFix(api2, minSdk), expressionOwner, "iterator", "()", api2, minSdk, null, 1024, null);
            }
        }

        @Override
        public void visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolve();
            if (method != null) {
                this.visitCall(method, node, (UElement)node);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void visitCall(PsiMethod method, UCallExpression call2, UElement reference) {
            boolean fromBinary;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"getParameterList(...)");
            PsiParameterList parameterList = psiParameterList;
            if (parameterList.getParametersCount() > 0) {
                PsiParameter[] psiParameterArray = parameterList.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                PsiParameter[] parameters = psiParameterArray;
                int n = parameters.length;
                for (int i = 0; i < n; ++i) {
                    PsiClassType elementType;
                    PsiType psiType;
                    UExpression argument;
                    PsiType parameterType;
                    Intrinsics.checkNotNullExpressionValue((Object)parameters[i].getType(), (String)"getType(...)");
                    if (parameterType instanceof PsiClassType) {
                        if (call2.getArgumentForParameter(i) == null) continue;
                        this.checkArgumentCast(argument, (PsiClassType)parameterType);
                        continue;
                    }
                    if (!(parameterType instanceof PsiEllipsisType) || call2.getArgumentForParameter(i) == null || ((psiType = ((PsiEllipsisType)parameterType).getComponentType()) instanceof PsiClassType ? (PsiClassType)psiType : null) == null) continue;
                    elementType = elementType;
                    if (argument instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)argument).getKind(), (Object)UastSpecialExpressionKind.VARARGS)) {
                        for (UExpression expression : ((UExpressionList)argument).getExpressions()) {
                            this.checkArgumentCast(expression, elementType);
                        }
                        continue;
                    }
                    this.checkArgumentCast(argument, elementType);
                }
            }
            boolean bl = fromBinary = method instanceof PsiCompiledElement || containingClass instanceof PsiCompiledElement || containingClass instanceof KtLightClassForDecompiledDeclaration;
            if (!fromBinary && !(method instanceof KtLightElementBase)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(containingClass);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            String name = Lint.getInternalMethodName(method);
            if (!apiDatabase.containsClass(owner)) {
                if (Intrinsics.areEqual((Object)name, (Object)"get") && StringsKt.endsWith$default((String)owner, (String)"Provider", (boolean)false, (int)2, null) && method.getParameterList().isEmpty()) {
                    PsiType psiType = method.getReturnType();
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    if ((psiClassType != null ? psiClassType.resolve() : null) instanceof PsiTypeParameter) {
                        psiType = call2.getExpressionType();
                        PsiClassType type = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                        if (type == null) return;
                        this.checkClassReference((UElement)call2, type);
                        return;
                    }
                }
                this.handleKotlinExtensionMethods(name, owner, call2, evaluator, method, reference);
                return;
            }
            String string3 = evaluator.getMethodDescription(method, false, false);
            if (string3 == null) {
                return;
            }
            String desc = string3;
            ApiVisitor.visitCall$default(this, method, call2, reference, containingClass, owner, name, desc, null, 128, null);
        }

        private final void checkArgumentCast(UExpression argument, PsiClassType parameterType) {
            PsiType argumentType = argument.getExpressionType();
            if (argumentType == null || Intrinsics.areEqual((Object)parameterType, (Object)argumentType) || !(argumentType instanceof PsiClassType) || Intrinsics.areEqual((Object)parameterType.rawType(), (Object)((PsiClassType)argumentType).rawType())) {
                return;
            }
            this.checkCast((UElement)argument, (PsiClassType)argumentType, parameterType, true);
        }

        private final void visitCall(PsiMethod method, UCallExpression call2, UElement reference, PsiClass containingClass, String owner, String name, String desc, String original) {
            Location location;
            UExpression receiver;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (ApiLookup.startsWithEquivalentPrefix(owner, "java/text/SimpleDateFormat") && Intrinsics.areEqual((Object)name, (Object)"<init>") && !Intrinsics.areEqual((Object)desc, (Object)"()V")) {
                ApiConstraint apiConstraint = ApiDetector.this.getMinSdk(this.context);
                if (apiConstraint == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint;
                Companion.checkSimpleDateFormat(this.context, call2, minSdk);
            } else if (Intrinsics.areEqual((Object)name, (Object)"loadAnimator") && Intrinsics.areEqual((Object)owner, (Object)"android.animation.AnimatorInflater") && Intrinsics.areEqual((Object)desc, (Object)"(Landroid.content.Context;I)")) {
                this.checkAnimator(this.context, call2);
            }
            ApiConstraint apiConstraint = apiDatabase.getMethodVersions(owner, name, desc);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getMethodVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (minSdk.isAtLeast(api2)) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            UExpression uExpression = receiver = UastExpressionUtils.isMethodCall((UElement)((UElement)call2)) ? call2.getReceiver() : null;
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)call2))) {
                if (receiver != null && !(receiver instanceof UThisExpression) && !(receiver.getSourcePsi() instanceof PsiSuperExpression)) {
                    PsiClassType containingType;
                    List inheritanceChain;
                    PsiType receiverType = receiver.getExpressionType();
                    if (receiverType instanceof PsiClassType && (inheritanceChain = Companion.getInheritanceChain((PsiClassType)receiverType, containingType = this.context.getEvaluator().getClassType(containingClass))) != null) {
                        for (PsiClassType type : inheritanceChain) {
                            ApiConstraint specificApi;
                            String expressionOwner = evaluator.getQualifiedName(type);
                            if (expressionOwner == null || Intrinsics.areEqual((Object)expressionOwner, (Object)owner)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(expressionOwner, name, desc), (String)"getMethodVersions(...)");
                            if (Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN)) {
                                if (!apiDatabase.isRelevantOwner(expressionOwner)) continue;
                                return;
                            }
                            if (minSdk.isAtLeast(specificApi)) {
                                return;
                            }
                            if (specificApi.isAtLeast(api2)) continue;
                            api2 = specificApi;
                            fqcn = type.getCanonicalText();
                        }
                    }
                } else {
                    UInstanceExpression pte;
                    PsiElement resolved;
                    PsiClass cls = null;
                    PsiType receiverType = call2.getReceiverType();
                    if (receiverType instanceof PsiClassType) {
                        cls = ((PsiClassType)receiverType).resolve();
                    }
                    if ((receiver instanceof UThisExpression || receiver instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)receiver).resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        ApiConstraint specificApi;
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            PsiClassType anonymousBaseType;
                            boolean found = false;
                            Intrinsics.checkNotNullExpressionValue((Object)((PsiAnonymousClass)cls).getBaseClassType(), (String)"getBaseClassType(...)");
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)cls), PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getQualifiedName(cls)) == null || ApiLookup.equivalentName(expressionOwner, "java/lang/Object")) break;
                        Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(expressionOwner, name, desc), (String)"getMethodVersions(...)");
                        if (Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN)) {
                            if (apiDatabase.isRelevantOwner(expressionOwner)) {
                                break;
                            }
                        } else {
                            if (minSdk.isAtLeast(specificApi)) {
                                return;
                            }
                            if (specificApi.isAtLeast(api2)) break;
                            api2 = specificApi;
                            fqcn = cls.getQualifiedName();
                            break;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, reference, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            if (receiver != null || UastExpressionUtils.isMethodCall((UElement)((UElement)call2))) {
                PsiClass target2 = null;
                if (!method.isConstructor()) {
                    if (receiver != null) {
                        PsiClassType type;
                        type = receiver.getExpressionType();
                        if (type instanceof PsiClassType) {
                            target2 = type.resolve();
                        }
                    } else {
                        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)call2));
                        Object object = target2 = uClass != null ? uClass.getJavaPsi() : null;
                    }
                }
                if (target2 != null) {
                    PsiMethod[] psiMethodArray = target2.findMethodsBySignature(method, true);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsBySignature(...)");
                    PsiMethod[] methods = psiMethodArray;
                    if (methods.length > 1) {
                        for (PsiMethod m : methods) {
                            ApiConstraint methodApi;
                            String methodOwner;
                            PsiClass provider;
                            if (Intrinsics.areEqual((Object)method, (Object)m) || (provider = m.getContainingClass()) == null || (methodOwner = evaluator.getQualifiedName(provider)) == null) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(methodOwner, name, desc), (String)"getMethodVersions(...)");
                            if (!Intrinsics.areEqual((Object)methodApi, (Object)ApiConstraint.UNKNOWN) && !minSdk.isAtLeast(methodApi)) continue;
                            ApiConstraint apiConstraint3 = provider.isInterface() ? apiDatabase.getValidCastVersions(owner, methodOwner) : (ApiConstraint)ApiConstraint.UNKNOWN;
                            Intrinsics.checkNotNull((Object)apiConstraint3);
                            ApiConstraint interfaceRequirement = apiConstraint3;
                            if (!Intrinsics.areEqual((Object)interfaceRequirement, (Object)ApiConstraint.UNKNOWN) && !minSdk.isAtLeast(interfaceRequirement)) continue;
                            return;
                        }
                    }
                }
                if (ApiDetector.this.isSuperCallFromOverride(evaluator, call2, method)) {
                    return;
                }
            }
            if (DesugaredMethodLookup.Companion.canBeDesugaredLater(owner) && DesugaredMethodLookup.Companion.isDesugaredMethod(owner, name, desc, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject(), containingClass)) {
                this.handleNioDesugaringSpecialCases(owner, name, minSdk, call2);
                return;
            }
            Desugaring desugaring = null;
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.Throwable") && (Intrinsics.areEqual((Object)name, (Object)"addSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.Throwable;)") || Intrinsics.areEqual((Object)name, (Object)"getSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"()"))) {
                if (this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                    return;
                }
                desugaring = Desugaring.TRY_WITH_RESOURCES;
            }
            String signature = fqcn == null ? name : (Intrinsics.areEqual((Object)"<init>", (Object)name) ? (Lint.isKotlin(reference.getLang()) ? fqcn + "()" : "new " + fqcn) : fqcn + "#" + name);
            UIdentifier nameIdentifier = call2.getMethodIdentifier();
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call2)) && call2.getClassReference() != null) {
                UElement uElement = (UElement)call2;
                UReferenceExpression uReferenceExpression = call2.getClassReference();
                Intrinsics.checkNotNull((Object)uReferenceExpression);
                location = this.context.getRangeLocation(uElement, 0, (UElement)uReferenceExpression, 0);
            } else {
                location = nameIdentifier != null ? this.context.getLocation((UElement)nameIdentifier) : this.context.getLocation(reference);
            }
            Location location2 = location;
            this.report(UNSUPPORTED, reference, location2, "Call", signature, api2, minSdk, null, owner, name, desc, desugaring, original);
        }

        static /* synthetic */ void visitCall$default(ApiVisitor apiVisitor, PsiMethod psiMethod, UCallExpression uCallExpression, UElement uElement, PsiClass psiClass, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 0x80) != 0) {
                string5 = null;
            }
            apiVisitor.visitCall(psiMethod, uCallExpression, uElement, psiClass, string2, string3, string4, string5);
        }

        private final void handleNioDesugaringSpecialCases(String owner, String name, ApiConstraint minSdk, UCallExpression call2) {
            if (!StringsKt.startsWith$default((String)owner, (String)"java.nio.", (boolean)false, (int)2, null) || minSdk.isAtLeast(API_26)) {
                return;
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java.nio.channels.AsynchronousFileChannel")) {
                ApiVisitor.reportNioIssue$default(this, this.byLibDesugaring("Using `AsynchronousFileChannel` is not supported"), call2, false, 4, null);
            } else if (Intrinsics.areEqual((Object)name, (Object)"newWatchService") && Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.FileSystem")) {
                ApiVisitor.reportNioIssue$default(this, this.byLibDesugaring("Using a `WatchService` is not supported"), call2, false, 4, null);
            } else if (Intrinsics.areEqual((Object)name, (Object)"getUserPrincipalLookupService") && Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.FileSystem") || Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.attribute.UserPrincipalLookupService") || Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.attribute.PosixFilePermissions") || (Intrinsics.areEqual((Object)name, (Object)"getPosixFilePermissions") || Intrinsics.areEqual((Object)name, (Object)"setPosixFilePermissions")) && Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.Files")) {
                ApiVisitor.reportNioIssue$default(this, this.byLibDesugaring("POSIX file features are not supported"), call2, false, 4, null);
            } else if (Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.spi.FileSystemProvider") && (Intrinsics.areEqual((Object)name, (Object)"createLink") || Intrinsics.areEqual((Object)name, (Object)"createSymbolicLink"))) {
                ApiVisitor.reportNioIssue$default(this, this.byLibDesugaring("Creating links is not supported"), call2, false, 4, null);
            } else if (Intrinsics.areEqual((Object)name, (Object)"copy") && Intrinsics.areEqual((Object)owner, (Object)"java.nio.file.Files")) {
                for (UExpression argument : call2.getValueArguments()) {
                    resolved = UastUtils.tryResolve((UElement)((UElement)argument));
                    if (!(resolved instanceof PsiField)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((PsiField)resolved).getName(), (String)"getName(...)");
                    if (Intrinsics.areEqual((Object)fieldName, (Object)"ATOMIC_MOVE")) {
                        ApiVisitor.reportNioIssue$default(this, this.withLibDesugaring("file move with the `ATOMIC_MOVE` option uses file renaming. Linux does not guarantee renaming to be atomic, though it usually is, and the desugaring implementation will have the semantics of the OS."), (UElement)argument, true, null, 8, null);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)fieldName, (Object)"COPY_ATTRIBUTES")) continue;
                    ApiVisitor.reportNioIssue$default(this, this.withLibDesugaring("file copy with the `COPY_ATTRIBUTES` option does not copy attributes, though it is usually not important to copy basic attributes"), (UElement)argument, true, null, 8, null);
                }
            } else if (Intrinsics.areEqual((Object)name, (Object)"open") && Intrinsics.areEqual((Object)owner, (Object)"java.nio.channels.FileChannel")) {
                for (UExpression argument : call2.getValueArguments()) {
                    resolved = UastUtils.tryResolve((UElement)((UElement)argument));
                    if (!(resolved instanceof PsiField)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((PsiField)resolved).getName(), (String)"getName(...)");
                    if (Intrinsics.areEqual((Object)fieldName, (Object)"SPARSE")) {
                        ApiVisitor.reportNioIssue$default(this, this.byLibDesugaring("Option `SPARSE` is ignored"), (UElement)argument, false, null, 12, null);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)fieldName, (Object)"DELETE_ON_CLOSE")) continue;
                    ApiVisitor.reportNioIssue$default(this, this.withLibDesugaring("`DELETE_ON_CLOSE` is only partially supported; the file is only closed when FileChannel is closed"), (UElement)argument, true, null, 8, null);
                }
            }
            for (UExpression argument : call2.getValueArguments()) {
                PsiType type = argument.getExpressionType();
                if (!(type instanceof PsiClassType) || !Intrinsics.areEqual((Object)((PsiClassType)type).getCanonicalText(), (Object)"java.nio.file.attribute.FileAttribute")) continue;
                ApiVisitor.reportNioIssue$default(this, this.withLibDesugaring("`FileAttribute` arguments are ignored"), (UElement)argument, true, null, 8, null);
            }
        }

        private final void handleNioDesugaringSpecialCases(String owner, ApiConstraint minSdk, UTryExpression tryExpression, UTypeReferenceExpression typeReference) {
            if (!StringsKt.startsWith$default((String)owner, (String)"java.nio.", (boolean)false, (int)2, null) || minSdk.isAtLeast(API_26)) {
                return;
            }
            String signature = owner;
            if (Intrinsics.areEqual((Object)signature, (Object)"java.nio.file.NoSuchFileException")) {
                for (UCatchClause catchClause : tryExpression.getCatchClauses()) {
                    for (UTypeReferenceExpression typeReference2 : catchClause.getTypeReferences()) {
                        if (!Intrinsics.areEqual((Object)typeReference2.getType().getCanonicalText(), (Object)"java.io.IOException")) continue;
                        return;
                    }
                }
                ApiVisitor.reportNioIssue$default(this, "When using core library desugaring on API levels lower than 26, file operations sometimes raise `java.io.FileNotFoundException` instead of `java.nio.file.NoSuchFileException` when a file is not found. They are both subclasses of `java.io.IOException`, so the issue can be mitigated by catching `java.io.IOException` instead.", (UElement)typeReference, false, null, 12, null);
            }
        }

        private final String byLibDesugaring(String $this$byLibDesugaring) {
            return $this$byLibDesugaring + " by core library desugaring on API levels lower than 26";
        }

        private final String withLibDesugaring(String $this$withLibDesugaring) {
            return "With core library desugaring on API levels lower than 26, " + $this$withLibDesugaring;
        }

        private final void reportNioIssue(String message, UCallExpression call2, boolean warnOnly) {
            this.reportNioIssue(message, (UElement)call2, warnOnly, this.context.getCallLocation(call2, true, false));
        }

        static /* synthetic */ void reportNioIssue$default(ApiVisitor apiVisitor, String string2, UCallExpression uCallExpression, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            apiVisitor.reportNioIssue(string2, uCallExpression, bl);
        }

        private final void reportNioIssue(String message, UElement element, boolean warnOnly, Location location) {
            Incident incident = new Incident(NIO_DESUGARING, element, location, message);
            if (warnOnly) {
                incident.overrideSeverity(Severity.WARNING);
            }
            this.context.report(incident, Constraints.minSdkLessThan(API_26));
        }

        static /* synthetic */ void reportNioIssue$default(ApiVisitor apiVisitor, String string2, UElement uElement, boolean bl, Location location, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                location = apiVisitor.context.getLocation(uElement);
            }
            apiVisitor.reportNioIssue(string2, uElement, bl, location);
        }

        private final void handleKotlinExtensionMethods(String name, String owner, UCallExpression call2, JavaEvaluator evaluator, PsiMethod method, UElement reference) {
            if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.collections.jdk8.CollectionsJDK8Kt")) {
                if (Intrinsics.areEqual((Object)name, (Object)"getOrDefault")) {
                    this.checkKotlinStdlibAlias(call2, evaluator, "java.util.Map", name, "(Ljava/lang/Object;Ljava/lang/Object;)", method, reference, "kotlin.collections.Map#getOrDefault");
                } else if (Intrinsics.areEqual((Object)name, (Object)"remove")) {
                    this.checkKotlinStdlibAlias(call2, evaluator, "java.util.Map", name, "(Ljava/lang/Object;Ljava/lang/Object;)", method, reference, "kotlin.collections.Map#remove");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.text.jdk8.RegexExtensionsJDK8Kt") && Intrinsics.areEqual((Object)name, (Object)"get")) {
                String desc = evaluator.getMethodDescription(method, false, false);
                if (Intrinsics.areEqual((Object)desc, (Object)"(Lkotlin.text.MatchGroupCollection;Ljava.lang.String;)")) {
                    this.checkKotlinStdlibAlias(call2, evaluator, "java.util.regex.Matcher", "start", "(Ljava/lang/String;)", method, reference, "kotlin.text.MatchGroupCollection#get(String)");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.text.MatchNamedGroupCollection") && Intrinsics.areEqual((Object)name, (Object)"get")) {
                String desc = evaluator.getMethodDescription(method, false, false);
                if (Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.String;)")) {
                    this.checkKotlinStdlibAlias(call2, evaluator, "java.util.regex.Matcher", "start", "(Ljava/lang/String;)", method, reference, "kotlin.text.MatchNamedGroupCollection#get");
                }
            } else if ((Intrinsics.areEqual((Object)owner, (Object)"kotlin.collections.CollectionsKt__MutableCollectionsKt") || Intrinsics.areEqual((Object)owner, (Object)"kotlin.collections.CollectionsKt")) && (Intrinsics.areEqual((Object)name, (Object)"removeFirst") || Intrinsics.areEqual((Object)name, (Object)"removeLast")) && !this.isAliased(call2)) {
                String replacement = Companion.getRemoveReplacementSource(name, (UElement)call2);
                String display = Companion.getRemoveReplacementSourceDisplay(replacement);
                Location location = this.context.getCallLocation(call2, false, true);
                Incident incident = new Incident(UNSUPPORTED, call2, location, "This Kotlin extension function will be hidden by `java.util.SequencedCollection` starting in API 35: `" + name + "`. When this source code is recompiled against API level 35, it will crash on older levels. You can avoid this by using `" + display + "` instead.\n", Companion.createRemoveFirstFix(location, name, replacement, display));
                this.context.report(incident.overrideSeverity(Severity.WARNING));
            }
        }

        private final boolean isAliased(UCallExpression $this$isAliased) {
            UIdentifier uIdentifier = $this$isAliased.getMethodIdentifier();
            return !Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)$this$isAliased.getMethodName());
        }

        private final void checkKotlinStdlibAlias(UCallExpression call2, JavaEvaluator evaluator, String aliasClassName, String aliasMethodName, String aliasDesc, PsiMethod method, UElement reference, String original) {
            PsiClass psiClass = evaluator.findClass(aliasClassName);
            if (psiClass == null) {
                return;
            }
            PsiClass matcherClass = psiClass;
            this.visitCall(method, call2, reference, matcherClass, aliasClassName, aliasMethodName, aliasDesc, original);
        }

        private final void checkAnimator(JavaContext context2, UCallExpression call2) {
            UExpression resourceParameter = (UExpression)call2.getValueArguments().get(1);
            ResourceReference resourceReference = ResourceReference.Companion.get((UElement)resourceParameter);
            if (resourceReference == null) {
                return;
            }
            ResourceReference resource = resourceReference;
            if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android")) {
                return;
            }
            ApiConstraint.SdkApiConstraint api2 = API_21;
            ApiConstraint apiConstraint = ApiDetector.this.getMinSdk(context2);
            if (apiConstraint == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            if (minSdk.isAtLeast(api2)) {
                return;
            }
            if (VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context2, (UElement)call2, api2, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context2, (UElement)call2, api2)) {
                return;
            }
            LintClient client = context2.getClient();
            ResourceRepository resources = context2.isGlobalAnalysis() ? client.getResources(context2.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : client.getResources(context2.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
            List items = resources.getResources(ResourceNamespace.TODO(), resource.getType(), resource.getName());
            Intrinsics.checkNotNull((Object)items);
            Set paths = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)items), ApiVisitor::checkAnimator$lambda$3));
            for (PathString path : paths) {
                try {
                    XmlPullParser xmlPullParser = client.createXmlPullParser(path);
                    if (xmlPullParser == null) continue;
                    XmlPullParser parser2 = xmlPullParser;
                    block8: while (true) {
                        int event = parser2.next();
                        switch (event) {
                            case 2: {
                                String name;
                                if (parser2.getName() == null || !Intrinsics.areEqual((Object)name, (Object)ApiDetector.ATTR_PROPERTY_VALUES_HOLDER)) continue block8;
                                Object object = path.toFile();
                                if (object != null && (object = ((File)object).getParentFile()) != null && (object = ((File)object).getName()) != null) {
                                    Object nae = object;
                                    boolean bl = false;
                                    FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)nae);
                                    if (folderConfiguration != null) {
                                        FolderConfiguration config = folderConfiguration;
                                        boolean bl2 = false;
                                        VersionQualifier versionQualifier = config.getVersionQualifier();
                                        if (versionQualifier != null && ApiDetectorKt.access$isAtLeast(versionQualifier.getVersion(), api2)) {
                                            return;
                                        }
                                    }
                                }
                                JavaContext.report$default(context2, UNSUPPORTED, (UElement)call2, context2.getLocation((UElement)call2), "The resource `" + resource.getType() + "." + resource.getName() + "` includes the tag `propertyValuesHolder` which causes crashes on API < " + api2.minString() + ". Consider switching to `AnimatorInflaterCompat.loadAnimator` to safely load the animation.", null, 16, null);
                                return;
                            }
                            case 1: {
                                return;
                            }
                        }
                    }
                }
                catch (XmlPullParserException xmlPullParserException) {
                }
                catch (IOException iOException) {
                }
            }
        }

        @Override
        public void visitLocalVariable(@NotNull ULocalVariable node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression uExpression = node.getUastInitializer();
            if (uExpression == null) {
                return;
            }
            UExpression initializer = uExpression;
            PsiType psiType = initializer.getExpressionType();
            PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            PsiClassType initializerType = psiClassType;
            PsiType interfaceType = UastLintUtilsKt.getTypeFromPsi((UVariable)node);
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            if (Intrinsics.areEqual((Object)initializerType, (Object)interfaceType)) {
                return;
            }
            this.checkCast((UElement)initializer, initializerType, (PsiClassType)interfaceType, false);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod psiMethod = Lint.resolveOperator$default(node, false, 1, null);
            if (psiMethod == null) {
                return;
            }
            PsiMethod method = psiMethod;
            UCallExpression call2 = UImplicitCallExpressionKt.asCall(node, method);
            this.visitCall(method, call2, (UElement)node);
        }

        @Override
        public void visitUnaryExpression(@NotNull UUnaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call2 = UImplicitCallExpressionKt.asCall(node, method);
                this.visitCall(method, call2, (UElement)node);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull UBinaryExpression node) {
            UastBinaryOperator operator;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call2 = UImplicitCallExpressionKt.asCall(node, method);
                this.visitCall(method, call2, (UElement)node);
            }
            if ((operator = node.getOperator()) instanceof UastBinaryOperator.AssignOperator) {
                UExpression rExpression = node.getRightOperand();
                PsiType psiType = rExpression.getExpressionType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType rhsType = psiClassType;
                PsiType interfaceType = node.getLeftOperand().getExpressionType();
                if (!(interfaceType instanceof PsiClassType)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)rhsType, (Object)interfaceType)) {
                    return;
                }
                this.checkCast((UElement)rExpression, rhsType, (PsiClassType)interfaceType, true);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtLeast(ApiConstraint minSdk, UElement node, ApiConstraint api2) {
            if (minSdk.isAtLeast(api2)) return true;
            ApiConstraint apiConstraint = ApiVisitor.getTargetApi$default(this, node, null, 2, null);
            if (apiConstraint == null) return false;
            boolean bl = apiConstraint.isAtLeast(api2);
            if (!bl) return false;
            return true;
        }

        @Override
        public void visitTryExpression(@NotNull UTryExpression node) {
            Object message;
            Object localMinSdk;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List resourceList = node.getResourceVariables();
            if (!((Collection)resourceList).isEmpty() && !this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                ApiConstraint.SdkApiConstraint api2 = API_19;
                ApiConstraint apiConstraint = ApiDetector.this.getMinSdk(this.context);
                if (apiConstraint == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint;
                if (!this.isAtLeast(minSdk, (UElement)node, api2)) {
                    Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, (UElement)node, minSdk);
                    boolean suppressed = (Boolean)pair2.component1();
                    localMinSdk = (ApiConstraint)pair2.component2();
                    if (suppressed) {
                        return;
                    }
                    minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, (ApiConstraint)localMinSdk, false, 4, null);
                    UVariable first = (UVariable)resourceList.get(0);
                    UVariable last = (UVariable)resourceList.get(resourceList.size() - 1);
                    Location location = this.context.getRangeLocation((UDeclaration)first, 0, (UDeclaration)last, 0);
                    message = "Try-with-resources requires API level " + api2.minString() + " (current min is %1$s)";
                    ApiVisitor.report$default(this, UNSUPPORTED, (UElement)first, location, (String)message, null, null, null, null, api2, minSdk, Desugaring.TRY_WITH_RESOURCES, 240, null);
                }
            }
            for (UVariable resource : resourceList) {
                ApiConstraint minSdk;
                Object api3;
                PsiMethod closeMethod;
                PsiClass containingClass;
                Object object;
                Object object2;
                String desc;
                String name;
                PsiClassType classType;
                block13: {
                    PsiClass psiClass;
                    localMinSdk = TypeConversionUtil.erasure((PsiType)resource.getType());
                    PsiClassType psiClassType = localMinSdk instanceof PsiClassType ? (PsiClassType)localMinSdk : null;
                    if (psiClassType == null || (classType = psiClassType).resolve() == null) continue;
                    name = "close";
                    desc = "()";
                    PsiMethod[] psiMethodArray = psiClass.findMethodsByName(name, true);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                    Object[] $this$firstOrNull$iv = psiMethodArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        if (!(!it.hasParameters())) continue;
                        object2 = element$iv;
                        break block13;
                    }
                    object2 = null;
                }
                if ((PsiMethod)object2 == null || (object = (containingClass = closeMethod.getContainingClass())) == null || (object = object.getQualifiedName()) == null) continue;
                Object owner = object;
                Object object3 = ApiDetector.this.apiDatabase;
                if (object3 == null) continue;
                if ((object3 = ((ApiLookup)object3).getMethodVersions((String)owner, name, desc)) == null || Intrinsics.areEqual((Object)(api3 = object3), (Object)ApiConstraint.UNKNOWN) || ApiDetector.this.getMinSdk(this.context) == null || minSdk.isAtLeast((ApiConstraint)api3)) continue;
                Pair<Boolean, ApiConstraint> pair3 = Companion.getSuppressed(this.context, (ApiConstraint)api3, (UElement)node, minSdk);
                boolean suppressed = (Boolean)pair3.component1();
                ApiConstraint localMinSdk2 = (ApiConstraint)pair3.component2();
                if (suppressed) continue;
                if (DesugaredMethodLookup.Companion.canBeDesugaredLater((String)owner) && DesugaredMethodLookup.Companion.isDesugaredMethod((String)owner, name, desc, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject(), containingClass)) {
                    return;
                }
                minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk2, false, 4, null);
                Intrinsics.checkNotNull((Object)resource, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                Location location = this.context.getLocation((UElement)resource);
                String message2 = "Implicit `" + classType.getName() + ".close()` call from try-with-resources requires API level " + ((ApiConstraint)api3).minString() + " (current min is %1$s)";
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)resource, location, message2, Companion.apiLevelFix((ApiConstraint)api3, minSdk), classType.getCanonicalText(), null, null, (ApiConstraint)api3, minSdk, null, 1216, null);
            }
            for (UCatchClause catchClause : node.getCatchClauses()) {
                ApiConstraint minSdk;
                ApiConstraint.SdkApiConstraint required = API_19;
                if (ApiDetector.this.getMinSdk(this.context) == null) {
                    return;
                }
                List typeReferences = catchClause.getTypeReferences();
                if (!minSdk.isAtLeast(required) && Companion.isMultiCatchReflectiveOperationException(catchClause)) {
                    Iterator iterator = Companion.getSuppressed(this.context, API_19, (UElement)typeReferences.get(0), minSdk);
                    boolean suppressed = (Boolean)iterator.component1();
                    ApiConstraint localMinSdk3 = (ApiConstraint)iterator.component2();
                    if (suppressed) {
                        return;
                    }
                    minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk3, false, 4, null);
                    message = "Multi-catch with these reflection exceptions requires API level 19 (current min is %1$s) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.";
                    Location location = Companion.getCatchParametersLocation(this.context, catchClause);
                    Issue issue = UNSUPPORTED;
                    Object object = location.getSource();
                    UElement uElement = object instanceof UElement ? (UElement)object : null;
                    if (uElement == null) {
                        uElement = (UElement)node;
                    }
                    UElement uElement2 = uElement;
                    LintFix lintFix = Companion.apiLevelFix(required, minSdk);
                    object = minSdk;
                    ApiVisitor.report$default(this, issue, uElement2, location, (String)message, lintFix, null, null, null, required, (ApiConstraint)object, null, 1248, null);
                    continue;
                }
                for (UTypeReferenceExpression typeReference : typeReferences) {
                    this.checkCatchTypeElement(node, typeReference, typeReference.getType());
                }
            }
        }

        private final void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference, PsiType type) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass resolved = null;
            if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                LintFix lintFix;
                Location location;
                String string2 = this.context.getEvaluator().getQualifiedName(resolved);
                if (string2 == null) {
                    return;
                }
                String signature = string2;
                ApiConstraint apiConstraint = apiDatabase.getClassVersions(signature);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getClassVersions(...)");
                ApiConstraint api2 = apiConstraint;
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint2;
                if (minSdk.isAtLeast(api2)) {
                    return;
                }
                UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)statement));
                if (containingClass != null) {
                    ApiConstraint target2;
                    ApiConstraint apiConstraint3 = target2 = minSdk.isAtLeast(API_19) ? ApiVisitor.getTargetApi$default(this, (UElement)statement, null, 2, null) : this.getTargetApi((UElement)containingClass, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                        public final Boolean invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((VersionChecks.Companion)this.receiver).isRequiresApiAnnotation(p0);
                        }
                    }));
                    if (target2 != null && target2.isAtLeast(api2)) {
                        return;
                    }
                }
                if (DesugaredMethodLookup.Companion.canBeDesugaredLater(signature) && DesugaredMethodLookup.Companion.isDesugaredClass(signature, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject())) {
                    this.handleNioDesugaringSpecialCases(signature, minSdk, statement, typeReference);
                    return;
                }
                if (Companion.isSuppressed(this.context, api2, (UElement)typeReference, minSdk)) {
                    if (!minSdk.isAtLeast(API_19)) {
                        location = this.context.getLocation((UElement)typeReference);
                        String fqcn = resolved.getQualifiedName();
                        String apiLevel = ApiDetector.this.getApiLevelString(api2, this.context);
                        String string3 = StringHelper.usLocaleCapitalize((String)"Exception");
                        String string4 = fqcn;
                        if (string4 == null) {
                            string4 = "";
                        }
                        String apiMessage = string3 + " requires API level " + apiLevel + " (current min is %1$s): `" + string4 + "`";
                        String message = apiMessage + ", and having a surrounding/preceding version check **does not** help since prior to API level 19, just **loading** the class will cause a crash. Consider marking the surrounding class with `RequiresApi(19)` to ensure that the class is never loaded except when on API 19 or higher.";
                        Object[] objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_REQUIRE_CLASS, true};
                        LintFix fix2 = ApiDetector.this.fix().data(objectArray);
                        LintDriver lintDriver = this.context.getDriver();
                        Intrinsics.checkNotNull((Object)typeReference, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                        if (lintDriver.isSuppressed(this.context, UNSUPPORTED, (UElement)typeReference)) {
                            return;
                        }
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)typeReference, location, message, fix2, signature, null, null, API_19, minSdk, null, 1216, null);
                        return;
                    }
                    return;
                }
                location = this.context.getLocation((UElement)typeReference);
                String fqcn = resolved.getQualifiedName();
                if (minSdk.isAtLeast(API_19)) {
                    var13_16 = new Object[]{ApiDetector.KEY_REQUIRES_API, api2};
                    lintFix = ApiDetector.this.fix().data(var13_16);
                } else {
                    var13_16 = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_REQUIRE_CLASS, true};
                    lintFix = ApiDetector.this.fix().data(var13_16);
                }
                LintFix fix3 = lintFix;
                UElement uElement = (UElement)typeReference;
                String string5 = fqcn;
                if (string5 == null) {
                    string5 = "";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, uElement, location, "Exception", string5, api2, minSdk, fix3, signature, null, null, null, null, 7680, null);
            }
        }

        private final ApiConstraint getTargetApi(UElement scope, Function1<? super String, Boolean> isApiLevelAnnotation) {
            return Companion.getTargetApi(this.context.getEvaluator(), scope, isApiLevelAnnotation);
        }

        static /* synthetic */ ApiConstraint getTargetApi$default(ApiVisitor apiVisitor, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    public final Boolean invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return apiVisitor.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        @Override
        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            PsiType type;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression expression = node.getExpression();
            if (expression != null && (type = expression.getExpressionType()) instanceof PsiClassType) {
                this.checkClassType((UElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkField(UElement node, PsiField field) {
            List conditions;
            UElement parent;
            Issue issue;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            String string2 = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String name = string2;
            PsiClass psiClass = field.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string3 = evaluator.getQualifiedName(containingClass);
            if (string3 == null) {
                return;
            }
            String owner = string3;
            boolean isSdkInt = Intrinsics.areEqual((Object)"SDK_INT", (Object)name);
            boolean isSdkIntFull = Intrinsics.areEqual((Object)"SDK_INT_FULL", (Object)name);
            if ((isSdkInt || isSdkIntFull) && Intrinsics.areEqual((Object)"android.os.Build.VERSION", (Object)owner)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.context, node, isSdkIntFull);
                return;
            }
            ApiConstraint apiConstraint = apiDatabase.getFieldVersions(owner, name);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"getFieldVersions(...)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk(this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (this.isAtLeast(minSdk, node, api2)) return;
            Issue issue2 = issue = Lint.isInlined(field, evaluator) ? INLINED : UNSUPPORTED;
            if (Intrinsics.areEqual((Object)issue, (Object)UNSUPPORTED) ? (parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent())) instanceof USwitchClauseExpression && CollectionsKt.contains((Iterable)(conditions = ((USwitchClauseExpression)parent).getCaseValues()), (Object)node) : Intrinsics.areEqual((Object)issue, (Object)INLINED) && Companion.isBenignConstantUsage(evaluator, field, node, name, owner)) {
                return;
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.annotation.ElementType") && (parent = (UDeclaration)UastUtils.getParentOfType((UElement)node, UDeclaration.class, (boolean)true)) instanceof UClass && ((UClass)parent).isAnnotationType()) {
                return;
            }
            Pair<Boolean, ApiConstraint> pair2 = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair2.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair2.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, localMinSdk, false, 4, null);
            UElement parent2 = node.getUastParent();
            if (parent2 instanceof UQualifiedReferenceExpression) {
                Object object;
                UExpression receiver = ((UQualifiedReferenceExpression)parent2).getReceiver();
                Object object2 = receiver.getExpressionType();
                if (object2 == null || (object2 = object2.getCanonicalText()) == null) {
                    UReferenceExpression uReferenceExpression = receiver instanceof UReferenceExpression ? (UReferenceExpression)receiver : null;
                    object2 = uReferenceExpression != null ? UastUtils.getQualifiedName((UReferenceExpression)uReferenceExpression) : null;
                }
                Object object3 = object = object2;
                ApiConstraint apiConstraint3 = object3 != null ? apiDatabase.getFieldVersions((String)object3, name) : (ApiConstraint)ApiConstraint.UNKNOWN;
                Intrinsics.checkNotNull((Object)apiConstraint3);
                ApiConstraint specificApi = apiConstraint3;
                if (!Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN) && object != null) {
                    if (!specificApi.isAtLeast(api2)) {
                        api2 = specificApi;
                        owner = object;
                    }
                    if (this.isAtLeast(minSdk, node, specificApi)) return;
                    if (Companion.isSuppressed(this.context, specificApi, node, minSdk)) {
                        return;
                    }
                } else if (Intrinsics.areEqual((Object)object, (Object)"android.app.TaskInfo") && (specificApi.min() == 28 || specificApi.min() == 29)) {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)issue, (Object)INLINED)) {
                UElement $this$getParentOfType_u24default$iv = node;
                boolean bl = true;
                boolean $i$f$getParentOfType = false;
                if (UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UAnnotation.class, (boolean)bl) != null) {
                    return;
                }
            }
            if (DesugaredMethodLookup.Companion.canBeDesugaredLater(owner) && DesugaredMethodLookup.Companion.isDesugaredField(owner, name, this.context.getSourceSetType(), this.context.getDriver().isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject(), containingClass)) {
                return;
            }
            UElement locationNode = node;
            while (locationNode.getUastParent() instanceof UQualifiedReferenceExpression) {
                UElement uElement = locationNode.getUastParent();
                Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
                if (((UQualifiedReferenceExpression)uElement).getSelector() != locationNode) break;
                UElement uElement2 = locationNode.getUastParent();
                if (uElement2 == null) {
                    uElement2 = node;
                }
                locationNode = uElement2;
            }
            Location location = this.context.getLocation(locationNode);
            String fqcn = ClassContext.Companion.getFqcn(owner) + "#" + name;
            ApiVisitor.report$default(this, issue, node, location, "Field", fqcn, api2, minSdk, null, owner, name, null, null, null, 7168, null);
        }

        private static final PathString checkAnimator$lambda$3(ResourceItem it) {
            return it.getSource();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0016H\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001bH\u0002J\u001a\u00106\u001a\u00020\u00052\b\u00107\u001a\u0004\u0018\u00010\u00052\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005H\u0002J*\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u00010\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005H\u0002J \u0010A\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u001bH\u0002J\u000e\u0010E\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u0005J \u0010F\u001a\u00020G2\u0006\u0010.\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0010\u0010K\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020MH\u0002J\u001a\u0010N\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\b\u0010O\u001a\u0004\u0018\u00010\u0005H\u0002J0\u0010P\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u00107\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0005J\"\u0010V\u001a\n\u0012\u0004\u0012\u00020X\u0018\u00010W2\u0006\u0010Y\u001a\u00020X2\b\u0010Z\u001a\u0004\u0018\u00010XH\u0002JB\u0010V\u001a\n\u0012\u0004\u0012\u00020X\u0018\u00010[2\u0006\u0010Y\u001a\u00020X2\b\u0010Z\u001a\u0004\u0018\u00010X2\u0016\u0010\\\u001a\u0012\u0012\u0004\u0012\u00020^0]j\b\u0012\u0004\u0012\u00020^`_2\u0006\u0010`\u001a\u00020aH\u0002J&\u0010b\u001a\u00020\u00162\u0006\u0010.\u001a\u00020H2\u0006\u00104\u001a\u00020\u001b2\u0006\u0010L\u001a\u0002092\u0006\u00105\u001a\u00020\u001bJ4\u0010c\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010.\u001a\u00020H2\u0006\u00104\u001a\u00020\u001b2\u0006\u0010L\u001a\u0002092\u0006\u00105\u001a\u00020\u001bJ*\u0010d\u001a\u0004\u0018\u00010\u001b2\b\u0010e\u001a\u0004\u0018\u0001092\u0014\b\u0002\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160gH\u0007J4\u0010d\u001a\u0004\u0018\u00010\u001b2\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010e\u001a\u0004\u0018\u0001092\u0014\b\u0002\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160gH\u0007J\"\u0010h\u001a\u0004\u0018\u00010\u001e2\u0006\u0010.\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u0005H\u0007J(\u0010m\u001a\u0004\u0018\u00010\u001b2\b\u0010n\u001a\u0004\u0018\u00010o2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160gH\u0002J\u0016\u0010p\u001a\u00020>2\u0006\u0010.\u001a\u00020H2\u0006\u0010q\u001a\u00020rJ\u000e\u0010s\u001a\u00020\u00162\u0006\u0010q\u001a\u00020rJ\u0010\u0010u\u001a\u00020\u00162\u0006\u0010v\u001a\u00020^H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$Companion;", "", "<init>", "()V", "KEY_FILE", "", "KEY_REQUIRES_API", "KEY_FOLDER_NAME", "KEY_CONDITIONAL", "KEY_REQUIRE_CLASS", "KEY_MIN_API", "KEY_MESSAGE", "KEY_OWNER", "KEY_NAME", "KEY_DESC", "KEY_DESUGAR", "KEY_SOURCE_SET", "SDK_SUPPRESS_ANNOTATION", "ANDROIDX_SDK_SUPPRESS_ANNOTATION", "ROBO_ELECTRIC_CONFIG_ANNOTATION", "ATTR_PROPERTY_VALUES_HOLDER", "REPEATED_API_ANNOTATION_REQUIRES_ALL", "", "JAVA_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "NOT_SUPPRESSED", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "SUPPRESSED", "API_9", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "API_19", "API_21", "API_23", "API_24", "API_26", "UNSUPPORTED", "Lcom/android/tools/lint/detector/api/Issue;", "INLINED", "UNUSED", "OBSOLETE_SDK", "WRONG_SDK_INT", "NIO_DESUGARING", "TAG_RIPPLE", "TAG_ANIMATED_SELECTOR", "isFrameLayout", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "tagName", "defaultValue", "apiLevelFix", "Lcom/android/tools/lint/detector/api/LintFix;", "api", "minSdk", "getRemoveReplacementSource", "name", "node", "Lorg/jetbrains/uast/UElement;", "getRemoveReplacementSourceDisplay", "source", "createRemoveFirstFix", "range", "Lcom/android/tools/lint/detector/api/Location;", "replacement", "replacementDisplay", "isAlreadyWarnedDrawableFile", "attribute", "Lorg/w3c/dom/Attr;", "attributeApiLevel", "isBenignUnusedAttribute", "checkSimpleDateFormat", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "getLocalMinSdk", "element", "Lorg/w3c/dom/Element;", "featureProvidedByGradle", "minGradleVersionString", "isBenignConstantUsage", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "field", "Lcom/intellij/psi/PsiField;", "owner", "getInheritanceChain", "", "Lcom/intellij/psi/PsiClassType;", "derivedClass", "baseClass", "", "visited", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiType;", "Lkotlin/collections/HashSet;", "depth", "", "isSuppressed", "getSuppressed", "getTargetApi", "scope", "isApiLevelAnnotation", "Lkotlin/Function1;", "getApiLevel", "Lcom/android/tools/lint/detector/api/Context;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "getTargetApiForAnnotated", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "getCatchParametersLocation", "catchClause", "Lorg/jetbrains/uast/UCatchClause;", "isMultiCatchReflectiveOperationException", "REFLECTIVE_OPERATION_EXCEPTION", "isSubclassOfReflectiveOperationException", "type", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4213:1\n1#2:4214\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFrameLayout(XmlContext context2, String tagName, boolean defaultValue) {
            if (StringsKt.indexOf$default((CharSequence)tagName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                SdkInfo sdkInfo = context2.getClient().getSdkInfo(context2.getProject());
                return sdkInfo.isSubViewOf("FrameLayout", tagName);
            }
            UastParser parser2 = context2.getClient().getUastParser(context2.getProject());
            JavaEvaluator evaluator = parser2.getEvaluator();
            PsiClass psiClass = evaluator.findClass(tagName);
            if (psiClass == null) {
                return defaultValue;
            }
            PsiClass psiClass2 = psiClass;
            return evaluator.extendsClass(psiClass2, "android.widget.FrameLayout", false);
        }

        private final LintFix apiLevelFix(ApiConstraint api2, ApiConstraint minSdk) {
            Object[] objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_MIN_API, minSdk};
            return LintFix.Companion.create().data(objectArray);
        }

        private final String getRemoveReplacementSource(String name, UElement node) {
            Object object;
            if (Intrinsics.areEqual((Object)name, (Object)"removeFirst")) {
                object = "removeAt(0)";
            } else {
                UCallExpression uCallExpression = node instanceof UCallExpression ? (UCallExpression)node : null;
                String receiver = uCallExpression != null && (uCallExpression = uCallExpression.getReceiver()) != null && (uCallExpression = uCallExpression.getSourcePsi()) != null ? uCallExpression.getText() : null;
                object = receiver != null ? "removeAt(" + receiver + ".lastIndex)" : "removeAt(lastIndex)";
            }
            return object;
        }

        private final String getRemoveReplacementSourceDisplay(String source) {
            int max = 50;
            if (StringsKt.contains$default((CharSequence)source, (CharSequence)"\n", (boolean)false, (int)2, null) || source.length() > max) {
                int start2 = StringsKt.indexOf$default((CharSequence)source, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
                int end2 = StringsKt.lastIndexOf$default((CharSequence)source, (char)'.', (int)0, (boolean)false, (int)6, null);
                String string2 = source.substring(start2, end2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String receiver = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)string2), (CharSequence)"", null, null, (int)0, null, Companion::getRemoveReplacementSourceDisplay$lambda$0, (int)30, null);
                if (receiver.length() > max - 10) {
                    receiver = "list";
                }
                String string3 = source.substring(0, start2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String string4 = source.substring(end2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                return string3 + receiver + string4;
            }
            return source;
        }

        private final LintFix createRemoveFirstFix(Location range, String name, String replacement, String replacementDisplay) {
            LintFix replaceFix = LintFix.Companion.create().name("Replace with " + replacementDisplay).replace().pattern(name + "\\s*\\(").with(StringsKt.removeSuffix((String)replacement, (CharSequence)")")).range(range).reformat(StringsKt.contains$default((CharSequence)replacement, (CharSequence)"\n", (boolean)false, (int)2, null)).build();
            return replaceFix;
        }

        private final boolean isAlreadyWarnedDrawableFile(XmlContext context2, Attr attribute, ApiConstraint attributeApiLevel) {
            if (context2.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel.min() == 21) {
                Element element = attribute.getOwnerElement();
                while (element != null) {
                    String root2 = element.getTagName();
                    if (Intrinsics.areEqual((Object)ApiDetector.TAG_RIPPLE, (Object)root2) || Intrinsics.areEqual((Object)"vector", (Object)root2) || Intrinsics.areEqual((Object)"animated-vector", (Object)root2) || Intrinsics.areEqual((Object)ApiDetector.TAG_ANIMATED_SELECTOR, (Object)root2)) {
                        return true;
                    }
                    Node parentNode = element.getParentNode();
                    if (!(parentNode instanceof Element)) break;
                    element = (Element)parentNode;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBenignUnusedAttribute(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            String string2 = name;
            switch (string2.hashCode()) {
                case -1959280331: {
                    if (string2.equals("labelFor")) return true;
                    return false;
                }
                case 1192948249: {
                    if (string2.equals("importantForAutofill")) return true;
                    return false;
                }
                case 1193032953: {
                    if (string2.equals("layout_marginVertical")) return true;
                    return false;
                }
                case 1450157576: {
                    if (string2.equals("fullBackupContent")) return true;
                    return false;
                }
                case -980998419: {
                    if (string2.equals("textIsSelectable")) return true;
                    return false;
                }
                case -5379289: {
                    if (string2.equals("roundIcon")) return true;
                    return false;
                }
                case 1662263768: {
                    if (string2.equals("requestLegacyExternalStorage")) return true;
                    return false;
                }
                case 495144524: {
                    if (string2.equals("foregroundServiceType")) return true;
                    return false;
                }
                case -849964986: {
                    if (string2.equals("dataExtractionRules")) return true;
                    return false;
                }
                case -388883485: {
                    if (string2.equals("autofilledHighlight")) return true;
                    return false;
                }
                case 1343645351: {
                    if (string2.equals("paddingVertical")) return true;
                    return false;
                }
                case 930483431: {
                    if (string2.equals("layout_marginHorizontal")) return true;
                    return false;
                }
                case 2042756918: {
                    if (string2.equals("textAlignment")) return true;
                    return false;
                }
                case 58924602: {
                    if (string2.equals("autofillHints")) return true;
                    return false;
                }
                case -359890155: {
                    if (!string2.equals("paddingHorizontal")) return false;
                    return true;
                }
            }
            return false;
        }

        private final void checkSimpleDateFormat(JavaContext context2, UCallExpression call2, ApiConstraint minSdk) {
            Object object;
            if (minSdk.isAtLeast(API_24)) {
                return;
            }
            List expressions = call2.getValueArguments();
            if (expressions.isEmpty()) {
                return;
            }
            UExpression argument = (UExpression)expressions.get(0);
            ArrayList warned = null;
            char checked = '\u0000';
            UExpression uExpression = argument;
            if (uExpression instanceof ULiteralExpression) {
                object = ((ULiteralExpression)argument).getValue();
            } else if (uExpression instanceof UInjectionHost ? (object = ((UInjectionHost)argument).evaluateToString()) == null && (object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument)) == null : (object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument)) == null) {
                return;
            }
            Object constant = object;
            if (constant instanceof String) {
                boolean isEscaped = false;
                int n = ((String)constant).length();
                block7: for (int index2 = 0; index2 < n; ++index2) {
                    char c = ((String)constant).charAt(index2);
                    switch (c) {
                        case '\'': {
                            isEscaped = !isEscaped;
                            continue block7;
                        }
                        case 'L': 
                        case 'X': 
                        case 'Y': 
                        case 'c': 
                        case 'u': {
                            LintMap lintMap;
                            int end2;
                            ApiConstraint.SdkApiConstraint api2;
                            if (isEscaped || c == checked || warned != null && ((List)warned).contains(Character.valueOf(c))) continue block7;
                            switch (c) {
                                case 'L': 
                                case 'c': {
                                    ApiConstraint.SdkApiConstraint sdkApiConstraint = API_9;
                                    break;
                                }
                                default: {
                                    ApiConstraint.SdkApiConstraint sdkApiConstraint = api2 = API_24;
                                }
                            }
                            if (minSdk.isAtLeast(api2)) {
                                checked = c;
                                continue block7;
                            }
                            if (VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context2, (UElement)argument, api2, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context2, (UElement)argument, api2)) {
                                checked = c;
                                continue block7;
                            }
                            for (end2 = index2 + 1; end2 < ((String)constant).length() && ((String)constant).charAt(end2) == c; ++end2) {
                            }
                            Location location = argument instanceof ULiteralExpression ? context2.getRangeLocation((UElement)argument, index2, end2 - index2) : (argument instanceof UInjectionHost && argument instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)argument).getOperator(), (Object)UastBinaryOperator.PLUS) && ((UPolyadicExpression)argument).getOperands().size() == 1 && CollectionsKt.first((List)((UPolyadicExpression)argument).getOperands()) instanceof ULiteralExpression ? context2.getRangeLocation((UElement)((UPolyadicExpression)argument).getOperands().get(0), index2, end2 - index2) : context2.getLocation((UElement)argument));
                            Incident incident = new Incident(UNSUPPORTED, call2, location, "", this.apiLevelFix(api2, minSdk));
                            LintMap $this$checkSimpleDateFormat_u24lambda_u241 = lintMap = new LintMap();
                            boolean bl = false;
                            $this$checkSimpleDateFormat_u24lambda_u241.put(ApiDetector.KEY_REQUIRES_API, api2);
                            $this$checkSimpleDateFormat_u24lambda_u241.put(ApiDetector.KEY_MIN_API, minSdk);
                            $this$checkSimpleDateFormat_u24lambda_u241.put(ApiDetector.KEY_MESSAGE, "The pattern character '" + c + "' requires API level " + api2.minString() + " (current min is %1$s) : \"`" + constant + "`\"");
                            LintMap map2 = lintMap;
                            context2.report(incident, map2);
                            List list2 = warned;
                            if (list2 == null) {
                                ArrayList arrayList;
                                ArrayList it = arrayList = new ArrayList();
                                boolean bl2 = false;
                                warned = it;
                                list2 = arrayList;
                            }
                            List list3 = list2;
                            list3.add(Character.valueOf(c));
                        }
                    }
                }
            }
        }

        private final ApiConstraint getLocalMinSdk(Element element) {
            Element current = element;
            while (true) {
                ApiConstraint.SdkApiConstraint sdkApiConstraint;
                String targetApi = current.getAttributeNS("http://schemas.android.com/tools", "targetApi");
                Intrinsics.checkNotNull((Object)targetApi);
                if (((CharSequence)targetApi).length() > 0 && (sdkApiConstraint = ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, targetApi, 0, false, 4, null)) != null) {
                    ApiConstraint.SdkApiConstraint it = sdkApiConstraint;
                    boolean bl = false;
                    return it;
                }
                Node parent = current.getParentNode();
                if (parent == null || parent.getNodeType() != 1) break;
                current = (Element)parent;
            }
            return ApiConstraint.ALL;
        }

        private final boolean featureProvidedByGradle(XmlContext context2, String minGradleVersionString) {
            AgpVersion minVersion;
            if (minGradleVersionString == null) {
                return false;
            }
            AgpVersion gradleModelVersion = context2.getProject().getGradleModelVersion();
            return gradleModelVersion != null && (minVersion = AgpVersion.Companion.tryParse(minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
        }

        public final boolean isBenignConstantUsage(@NotNull JavaEvaluator evaluator, @NotNull PsiField field, @Nullable UElement node, @NotNull String name, @NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            Intrinsics.checkNotNullParameter((Object)owner, (String)ApiDetector.KEY_OWNER);
            if (ApiLookup.equivalentName(owner, "android.os.Build.VERSION_CODES")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.os.Build.VERSION") && Intrinsics.areEqual((Object)name, (Object)"SDK_INT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.view.ViewGroup.LayoutParams") && Intrinsics.areEqual((Object)name, (Object)"MATCH_PARENT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.widget.AbsListView") && (Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_NONE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_MULTIPLE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_SINGLE"))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.view.Gravity") && (Intrinsics.areEqual((Object)"START", (Object)name) || Intrinsics.areEqual((Object)"END", (Object)name))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.app.PendingIntent") && (Intrinsics.areEqual((Object)"FLAG_MUTABLE", (Object)name) || Intrinsics.areEqual((Object)"FLAG_IMMUTABLE", (Object)name))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.provider.MediaStore.MediaColumns")) {
                return true;
            }
            if (node == null) {
                return false;
            }
            for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
                if (curr instanceof USwitchClauseExpression) {
                    List caseValues = ((USwitchClauseExpression)curr).getCaseValues();
                    for (UExpression condition : caseValues) {
                        if (!UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false)) continue;
                        return true;
                    }
                    return false;
                }
                if (curr instanceof UIfExpression) {
                    UExpression condition = ((UIfExpression)curr).getCondition();
                    return UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false);
                }
                if (curr instanceof UMethod || curr instanceof UClass) break;
            }
            return false;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass) {
            List<PsiClassType> chain;
            block1: {
                if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                    return CollectionsKt.emptyList();
                }
                List<PsiClassType> list2 = chain = this.getInheritanceChain(derivedClass, baseClass, new HashSet<PsiType>(), 0);
                if (list2 == null) break block1;
                CollectionsKt.reverse(list2);
            }
            return chain;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass, HashSet<PsiType> visited, int depth) {
            if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                return new ArrayList(depth);
            }
            for (PsiType type : derivedClass.getSuperTypes()) {
                List<PsiClassType> chain;
                if (!visited.add(type) || !(type instanceof PsiClassType) || (chain = this.getInheritanceChain((PsiClassType)type, baseClass, visited, depth + 1)) == null) continue;
                chain.add(derivedClass);
                return chain;
            }
            return null;
        }

        public final boolean isSuppressed(@NotNull JavaContext context2, @NotNull ApiConstraint api2, @NotNull UElement element, @NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)api2, (String)"api");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            if (minSdk.isAtLeast(api2)) {
                return true;
            }
            ApiConstraint target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, context2.getEvaluator(), element, null, 4, null);
            if (target2 != null && target2.isAtLeast(api2)) {
                return true;
            }
            LintDriver driver = context2.getDriver();
            return driver.isSuppressed(context2, UNSUPPORTED, element) || driver.isSuppressed(context2, INLINED, element) || VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context2, element, api2, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context2, element, api2);
        }

        @NotNull
        public final Pair<Boolean, ApiConstraint> getSuppressed(@NotNull JavaContext context2, @NotNull ApiConstraint api2, @NotNull UElement element, @NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)api2, (String)"api");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            if (minSdk.isAtLeast(api2)) {
                return SUPPRESSED;
            }
            ApiConstraint target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, context2.getEvaluator(), element, null, 4, null);
            if (target2 != null && target2.isAtLeast(api2)) {
                return SUPPRESSED;
            }
            LintDriver driver = context2.getDriver();
            if (driver.isSuppressed(context2, UNSUPPORTED, element) || driver.isSuppressed(context2, INLINED, element)) {
                return SUPPRESSED;
            }
            ApiConstraint min = ApiConstraint.Companion.max$default(ApiConstraint.Companion, minSdk, target2, false, 4, null);
            ApiConstraint constraint = VersionChecks.Companion.getOuterVersionCheckConstraint(context2, element);
            if (constraint != null) {
                boolean suppressed = (constraint = constraint.isEmpty() ? constraint : ApiConstraint.Companion.max$default(ApiConstraint.Companion, constraint, min, false, 4, null)).isAtLeast(api2);
                if (!suppressed && VersionChecks.Companion.isPrecededByVersionCheckExit(context2, element, api2)) {
                    return SUPPRESSED;
                }
                ApiConstraint known = ApiConstraint.Companion.max$default(ApiConstraint.Companion, min, constraint, false, 4, null);
                return new Pair((Object)suppressed, (Object)known);
            }
            if (VersionChecks.Companion.isPrecededByVersionCheckExit(context2, element, api2)) {
                return SUPPRESSED;
            }
            if (target2 != null) {
                return new Pair((Object)false, (Object)min);
            }
            return NOT_SUPPRESSED;
        }

        @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            return this.getTargetApi(null, scope, isApiLevelAnnotation);
        }

        public static /* synthetic */ ApiConstraint getTargetApi$default(Companion companion, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    public final Boolean invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return companion.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                PsiPackage pkg;
                ApiConstraint targetApi;
                if (current instanceof UAnnotated && (targetApi = this.getTargetApiForAnnotated((UAnnotated)current, isApiLevelAnnotation)) != null) {
                    return targetApi;
                }
                if (!(current instanceof UFile) || evaluator == null) continue;
                PsiElement psiElement = ((UFile)current).getJavaPsi();
                if (psiElement == null) {
                    psiElement = (PsiElement)((UFile)current).getSourcePsi();
                }
                if ((pkg = evaluator.getPackage(psiElement)) == null) break;
                for (PsiAnnotation psiAnnotation : pkg.getAnnotations()) {
                    UAnnotation annotation;
                    ApiConstraint target2;
                    UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                    Intrinsics.checkNotNull((Object)psiAnnotation);
                    UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                    UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                    if (uAnnotation == null || (target2 = VersionChecks.Companion.getTargetApiForAnnotation(annotation = uAnnotation, isApiLevelAnnotation)) == null) continue;
                    return target2;
                }
                break;
            }
            return null;
        }

        public static /* synthetic */ ApiConstraint getTargetApi$default(Companion companion, JavaEvaluator javaEvaluator, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    public final Boolean invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return companion.getTargetApi(javaEvaluator, uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @Nullable
        public final ApiConstraint.SdkApiConstraint getApiLevel(@NotNull Context context2, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
            int n;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            String string2 = qualifiedName;
            if (Intrinsics.areEqual((Object)string2, (Object)VersionChecks.REQUIRES_API_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string2, (Object)VersionChecks.REQUIRES_API_ANNOTATION.newName())) {
                int api2 = (int)UastLintUtils.Companion.getLongAttribute(annotation, "value", -1L);
                n = api2 == -1 ? (int)UastLintUtils.Companion.getLongAttribute(annotation, "api", -1L) : api2;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"android.annotation.TargetApi")) {
                n = (int)UastLintUtils.Companion.getLongAttribute(annotation, "value", -1L);
            } else {
                if (Intrinsics.areEqual((Object)string2, (Object)"androidx.annotation.RequiresExtension")) {
                    int sdkId = (int)UastLintUtils.Companion.getLongAttribute(annotation, "extension", -1L);
                    int version2 = (int)UastLintUtils.Companion.getLongAttribute(annotation, "version", -1L);
                    if (sdkId != -1 && version2 != -1) {
                        int minor = (int)UastLintUtils.Companion.getLongAttribute(annotation, "minor", 0L);
                        return minor > 0 ? ApiConstraint.Companion.atLeast(version2, minor, sdkId) : ApiConstraint.Companion.atLeast(version2, sdkId);
                    }
                    return null;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)ApiDetector.ROBO_ELECTRIC_CONFIG_ANNOTATION)) {
                    n = (int)UastLintUtils.Companion.getLongAttribute(annotation, ApiDetector.KEY_MIN_API, -1L);
                } else if (Intrinsics.areEqual((Object)string2, (Object)ApiDetector.SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)string2, (Object)ApiDetector.ANDROIDX_SDK_SUPPRESS_ANNOTATION)) {
                    long fromCodeName = UastLintUtils.Companion.getLongAttribute(annotation, "codeName", -1L);
                    n = (int)UastLintUtils.Companion.getLongAttribute(annotation, "minSdkVersion", fromCodeName);
                } else {
                    return null;
                }
            }
            int api3 = n;
            if (api3 == 10000) {
                String name;
                UExpression value;
                AndroidVersion version3;
                IAndroidTarget iAndroidTarget = context2.getProject().getBuildTarget();
                Object object = version3 = iAndroidTarget != null ? iAndroidTarget.getVersion() : null;
                if (version3 != null && version3.isPreview()) {
                    return ApiConstraint.Companion.get(version3.getFeatureLevel(), 0);
                }
                api3 = 37;
                UExpression uExpression = annotation.findDeclaredAttributeValue("value");
                if (uExpression == null) {
                    uExpression = annotation.findDeclaredAttributeValue("api");
                }
                UExpression uExpression2 = value = uExpression;
                PsiElement psiElement = uExpression2 != null ? uExpression2.getJavaPsi() : null;
                PsiReferenceExpression psiReferenceExpression = psiElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiElement : null;
                String string3 = name = psiReferenceExpression != null ? psiReferenceExpression.getReferenceName() : null;
                boolean bl = string3 != null ? string3.length() == 1 : false;
                if (bl) {
                    api3 = Math.max(api3, SdkVersionInfo.getApiByBuildCode((String)name, (boolean)true));
                }
            }
            return api3 == -1 ? null : ApiLevel.atLeast-impl$default(ApiLevel.constructor-impl(api3), 0, 1, null);
        }

        private final ApiConstraint getTargetApiForAnnotated(UAnnotated annotated, Function1<? super String, Boolean> isApiLevelAnnotation) {
            if (annotated == null) {
                return null;
            }
            ApiConstraint constraint = null;
            for (UAnnotation annotation : annotated.getUAnnotations()) {
                ApiConstraint target2 = VersionChecks.Companion.getTargetApiForAnnotation(annotation, isApiLevelAnnotation);
                if (target2 == null) continue;
                constraint = constraint != null ? ApiConstraint.Companion.max(target2, constraint, false) : target2;
            }
            return constraint;
        }

        @NotNull
        public final Location getCatchParametersLocation(@NotNull JavaContext context2, @NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypeReferences();
            if (types.isEmpty()) {
                return Location.NONE;
            }
            Location first = context2.getLocation((UElement)types.get(0));
            if (types.size() < 2) {
                return first;
            }
            Location last = context2.getLocation((UElement)types.get(types.size() - 1));
            File file = first.getFile();
            Position start2 = first.getStart();
            Position end2 = last.getEnd();
            return start2 == null ? Location.Companion.create(file) : Location.Companion.create(file, start2, end2).withSource(types.get(0));
        }

        public final boolean isMultiCatchReflectiveOperationException(@NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypes();
            if (types.size() < 2) {
                return false;
            }
            for (PsiType t : types) {
                if (this.isSubclassOfReflectiveOperationException(t)) continue;
                return false;
            }
            return true;
        }

        private final boolean isSubclassOfReflectiveOperationException(PsiType type) {
            for (PsiType t : type.getSuperTypes()) {
                if (!Intrinsics.areEqual((Object)ApiDetector.REFLECTIVE_OPERATION_EXCEPTION, (Object)t.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, scope, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, evaluator, scope, null, 4, null);
        }

        private static final CharSequence getRemoveReplacementSourceDisplay$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)StringsKt.trim((CharSequence)it)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.XML_REFERENCE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_RETURN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_OVERRIDE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.VARIABLE_REFERENCE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

