/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.SimpleConnectedSocket;
import com.android.ddmlib.TimeoutException;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.AdbInstallerChannel;
import com.android.utils.ILogger;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class AdbInstallerChannelManager {
    private static final HashMap<String, AdbInstallerChannel> channels = new HashMap();

    private AdbInstallerChannelManager() {
    }

    public static AdbInstallerChannel getChannel(AdbClient client, String version2, ILogger logger, AdbInstaller.Mode mode) throws IOException {
        AdbInstallerChannel channel;
        String deviceId = client.getSerial();
        if (channels.containsKey(deviceId) && (channel = channels.get(deviceId)).isClosed()) {
            channels.remove(deviceId);
        }
        if (!channels.containsKey(deviceId)) {
            logger.info("Created SocketChannel to '" + deviceId + "'", new Object[0]);
            channel = AdbInstallerChannelManager.createChannel(client, version2, logger, mode);
            channels.put(deviceId, channel);
        }
        return channels.get(deviceId);
    }

    private static AdbInstallerChannel createChannel(AdbClient client, String version2, ILogger logger, AdbInstaller.Mode mode) throws IOException {
        Closeable channel = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add("-version=" + version2);
        if (mode == AdbInstaller.Mode.DAEMON) {
            parameters.add("-daemon");
        }
        try {
            channel = client.rawExec(AdbInstaller.INSTALLER_PATH, parameters.toArray(new String[0]));
        }
        catch (AdbCommandRejectedException | TimeoutException e) {
            Closeable c = channel;
            if (c != null) {
                c.close();
            }
            throw new IOException(e);
        }
        return new AdbInstallerChannel((SimpleConnectedSocket)channel, logger);
    }

    public static void reset(AdbClient client, ILogger logger) throws IOException {
        String serial = client.getSerial();
        logger.info("Reset SocketChannel to '" + serial + "'", new Object[0]);
        try (AdbInstallerChannel c = channels.get(serial);){
            channels.remove(serial);
        }
    }
}

