/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import org.jetbrains.annotations.NotNull;

public abstract class SigUtils {
    public static String getSimpleName(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1);
    }

    public static String methodName(final String className, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception ignored) {
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s) {
        return new SigReader(s).getSignature();
    }

    @NotNull
    public static String typeToSignature(@NotNull String fqcn) {
        StringBuilder sb = new StringBuilder(fqcn.length() + 2);
        while (fqcn.endsWith("[]")) {
            fqcn = fqcn.substring(0, fqcn.length() - "[]".length());
            sb.append('[');
        }
        if ("boolean".equals(fqcn)) {
            sb.append('Z');
        } else if ("byte".equals(fqcn)) {
            sb.append('B');
        } else if ("char".equals(fqcn)) {
            sb.append('C');
        } else if ("short".equals(fqcn)) {
            sb.append('S');
        } else if ("int".equals(fqcn)) {
            sb.append('I');
        } else if ("long".equals(fqcn)) {
            sb.append('J');
        } else if ("float".equals(fqcn)) {
            sb.append('F');
        } else if ("double".equals(fqcn)) {
            sb.append('D');
        } else if ("void".equals(fqcn)) {
            sb.append('V');
        } else {
            sb.append('L');
            sb.append(fqcn.replace('.', '/'));
            sb.append(';');
        }
        return sb.toString();
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s) {
            this.buffer = s;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start2 = this.pos;
                    this.pos = this.buffer.indexOf(59, start2) + 1;
                    return this.buffer.substring(start2, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder result2 = new StringBuilder("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result2.append(separator);
                        result2.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result2.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result2;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

