/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.ide.common.pagealign.PageAlignUtilsKt;
import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ZipRepo;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;

public class GzipSizeCalculator
implements ApkSizeCalculator {
    private static final long OFFSET_4K = 4096L;
    private static final long OFFSET_16K = 16384L;
    private static final String BUNDLE_METADATA = "BUNDLE-METADATA/";
    private static final String PROFILES_METADATA = "BUNDLE-METADATA/com.android.tools.build.profiles/";
    private static final String APP_METADATA = "BUNDLE-METADATA/com.android.tools.build.gradle/app-metadata.properties";

    private static void verify(@NotNull Path apk) {
        block2: {
            try {
                ZipRepo zip = new ZipRepo(apk);
                zip.close();
            }
            catch (IOException e) {
                if (!Files.exists(apk, new LinkOption[0])) break block2;
                throw new IllegalArgumentException("Cannot open apk: ", e);
            }
        }
    }

    @Override
    public long getFullApkDownloadSize(@NotNull Path apk) {
        long l;
        GzipSizeCalculator.verify(apk);
        MaxGzipCountingOutputStream zos = new MaxGzipCountingOutputStream();
        try {
            Files.copy(apk, zos);
            l = zos.getSize();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        zos.close();
        return l;
    }

    @Override
    public long getFullApkRawSize(@NotNull Path apk) {
        GzipSizeCalculator.verify(apk);
        try {
            return Files.size(apk);
        }
        catch (IOException e) {
            Logger.getLogger(GzipSizeCalculator.class.getName()).severe("Error obtaining size of the APK: " + e);
            return -1L;
        }
    }

    @Override
    @NotNull
    public Map<String, Long> getDownloadSizePerFile(@NotNull Path apk) {
        ImmutableMap immutableMap;
        GzipSizeCalculator.verify(apk);
        ZipRepo zipRepo = new ZipRepo(apk);
        try {
            ImmutableMap.Builder sizes = new ImmutableMap.Builder();
            for (Entry entry : zipRepo.getEntries().values()) {
                String name;
                if (entry.isDirectory() || (name = entry.getName()).startsWith(BUNDLE_METADATA) && !name.startsWith(PROFILES_METADATA) && !name.equals(APP_METADATA)) continue;
                InputStream zip = zipRepo.getInputStream(name);
                try (MaxGzipCountingOutputStream gzip = new MaxGzipCountingOutputStream();){
                    ByteStreams.copy((InputStream)zip, (OutputStream)gzip);
                    sizes.put((Object)("/" + name), (Object)gzip.getSize());
                }
                finally {
                    if (zip == null) continue;
                    zip.close();
                }
            }
            immutableMap = sizes.build();
        }
        catch (Throwable sizes) {
            try {
                try {
                    zipRepo.close();
                }
                catch (Throwable throwable) {
                    sizes.addSuppressed(throwable);
                }
                throw sizes;
            }
            catch (IOException e) {
                String msg = "Error while re-compressing apk to determine file by file download sizes: " + e;
                Logger.getLogger(GzipSizeCalculator.class.getName()).severe(msg);
                return ImmutableMap.of();
            }
        }
        zipRepo.close();
        return immutableMap;
    }

    @Override
    @NotNull
    public Map<String, ZipEntryInfo> getInfoPerFile(@NotNull Path apk) {
        GzipSizeCalculator.verify(apk);
        ImmutableMap.Builder sizes = new ImmutableMap.Builder();
        try (ZipRepo zip = new ZipRepo(apk);){
            Collection<Entry> entries = zip.getEntries().values();
            for (Entry entry : entries) {
                if (entry.isDirectory()) continue;
                long size = entry.getCompressedSize();
                boolean isCompressed = entry.isCompressed();
                long location = entry.getPayloadLocation().first;
                ZipEntryInfo.Alignment alignment = location % 16384L == 0L ? ZipEntryInfo.Alignment.ALIGNMENT_16K : (location % 4096L == 0L ? ZipEntryInfo.Alignment.ALIGNMENT_4K : ZipEntryInfo.Alignment.ALIGNMENT_NONE);
                long loadAlignment = -1L;
                boolean isElf = false;
                try (InputStream stream = zip.getInputStream(entry.getName());){
                    if (PageAlignUtilsKt.hasElfMagicNumber((InputStream)stream)) {
                        isElf = true;
                        loadAlignment = PageAlignUtilsKt.readElfMinimumLoadSectionAlignment((InputStream)stream);
                    }
                }
                sizes.put((Object)("/" + entry.getName()), (Object)new ZipEntryInfo(size, alignment, isCompressed, isElf, loadAlignment));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sizes.build();
    }

    private static final class MaxGzipCountingOutputStream
    extends GZIPOutputStream {
        public MaxGzipCountingOutputStream() throws IOException {
            super((OutputStream)new CountingOutputStream(ByteStreams.nullOutputStream()));
            this.def.setLevel(9);
        }

        public long getSize() throws IOException {
            this.close();
            return ((CountingOutputStream)this.out).getCount();
        }
    }
}

