/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.dex.tree.DexReferencesNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedField;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedTypeReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.util.ReferenceUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageTreeCreator {
    public static final String PARAMS_DELIMITER = ",";
    @Nullable
    private final ProguardMap proguardMap;
    @Nullable
    private final ProguardUsagesMap usagesMap;
    private final boolean addReferencesNode;

    public PackageTreeCreator(@Nullable ProguardMappings proguardMappings, boolean deobfuscateNames) {
        this(proguardMappings, deobfuscateNames, true);
    }

    public PackageTreeCreator(@Nullable ProguardMappings proguardMappings, boolean deobfuscateNames, boolean addReferencesNode) {
        this.proguardMap = deobfuscateNames && proguardMappings != null ? proguardMappings.map : null;
        this.usagesMap = proguardMappings == null ? null : proguardMappings.usage;
        this.addReferencesNode = addReferencesNode;
    }

    @NotNull
    private static Multimap<String, MethodReference> getAllMethodReferencesByClassName(@NotNull DexBackedDexFile dexFile) {
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        return methodsByClass;
    }

    @NotNull
    private static Multimap<String, FieldReference> getAllFieldReferencesByClassName(@NotNull DexBackedDexFile dexFile) {
        ArrayListMultimap fieldsByClass = ArrayListMultimap.create();
        int m = dexFile.getFieldSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedFieldReference fieldRef = new DexBackedFieldReference(dexFile, i);
            fieldsByClass.put((Object)fieldRef.getDefiningClass(), (Object)fieldRef);
        }
        return fieldsByClass;
    }

    @NotNull
    private static Map<String, TypeReference> getAllTypeReferencesByClassName(@NotNull DexBackedDexFile dexFile) {
        HashMap<String, TypeReference> typesByName = new HashMap<String, TypeReference>();
        int m = dexFile.getTypeSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedTypeReference typeRef = new DexBackedTypeReference(dexFile, i);
            typesByName.put(typeRef.getType(), (TypeReference)typeRef);
        }
        return typesByName;
    }

    @NotNull
    public DexPackageNode constructPackageTree(@NotNull Map<Path, DexBackedDexFile> dexFiles) {
        DexPackageNode root2 = new DexPackageNode("root", null);
        for (Map.Entry<Path, DexBackedDexFile> dexFile : dexFiles.entrySet()) {
            this.constructPackageTree(root2, dexFile.getKey(), dexFile.getValue());
        }
        return root2;
    }

    @NotNull
    public DexPackageNode constructPackageTree(@NotNull DexBackedDexFile dexFile) {
        DexPackageNode root2 = new DexPackageNode("root", null);
        this.constructPackageTree(root2, null, dexFile);
        return root2;
    }

    public void constructPackageTree(@NotNull DexPackageNode root2, @Nullable Path dexFilePath, @NotNull DexBackedDexFile dexFile) {
        String cleanClassName;
        Object classNode;
        TypeReference typeRef;
        Multimap<String, MethodReference> methodRefsByClassName = PackageTreeCreator.getAllMethodReferencesByClassName(dexFile);
        Multimap<String, FieldReference> fieldRefsByClassName = PackageTreeCreator.getAllFieldReferencesByClassName(dexFile);
        Map<String, TypeReference> typeRefsByName = PackageTreeCreator.getAllTypeReferencesByClassName(dexFile);
        for (DexBackedClassDef classDef : dexFile.getClasses()) {
            for (DexBackedMethod method : classDef.getMethods()) {
                methodRefsByClassName.remove((Object)classDef.getType(), (Object)method);
            }
            for (DexBackedField field : classDef.getFields()) {
                fieldRefsByClassName.remove((Object)classDef.getType(), (Object)field);
            }
        }
        for (DexBackedClassDef classDef : dexFile.getClasses()) {
            typeRef = typeRefsByName.get(classDef.getType());
            String className = PackageTreeCreator.decodeClassName(classDef.getType(), this.proguardMap);
            classNode = root2.getOrCreateClass("", className, typeRef);
            ((DefaultMutableTreeNode)classNode).setUserObject(dexFilePath);
            ((DexElementNode)classNode).setDefined(true);
            ((DexClassNode)classNode).setSize(((DexClassNode)classNode).getSize() + (long)classDef.getSize());
            this.addMethods((DexClassNode)classNode, classDef.getMethods(), dexFilePath);
            this.addFields((DexClassNode)classNode, classDef.getFields(), dexFilePath);
        }
        for (Object className : methodRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(className);
            cleanClassName = PackageTreeCreator.decodeClassName((String)className, this.proguardMap);
            classNode = root2.getOrCreateClass("", cleanClassName, typeRef);
            this.addMethods((DexClassNode)classNode, methodRefsByClassName.get(className), dexFilePath);
        }
        for (Object className : fieldRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(className);
            cleanClassName = PackageTreeCreator.decodeClassName((String)className, this.proguardMap);
            classNode = root2.getOrCreateClass("", cleanClassName, typeRef);
            this.addFields((DexClassNode)classNode, fieldRefsByClassName.get(className), dexFilePath);
        }
        if (this.usagesMap != null) {
            for (Object className : this.usagesMap.getClasses()) {
                DexClassNode classNode2 = root2.getOrCreateClass("", (String)className, null);
                classNode2.setDefined(false);
                classNode2.setRemoved(true);
            }
            Multimap removedMethodsByClass = this.usagesMap.getMethodsByClass();
            for (String className : removedMethodsByClass.keySet()) {
                DexClassNode classNode3 = root2.getOrCreateClass("", className, null);
                for (String removedMethodName : removedMethodsByClass.get((Object)className)) {
                    DexMethodNode methodNode = new DexMethodNode(removedMethodName, null);
                    methodNode.setDefined(false);
                    methodNode.setRemoved(true);
                    classNode3.add(methodNode);
                }
            }
            Multimap removedFieldsByClass = this.usagesMap.getFieldsByClass();
            for (String className : removedFieldsByClass.keySet()) {
                classNode = root2.getOrCreateClass("", className, null);
                for (String removedFieldName : removedFieldsByClass.get((Object)className)) {
                    DexFieldNode fieldNode = new DexFieldNode(removedFieldName, null);
                    fieldNode.setDefined(false);
                    fieldNode.setRemoved(true);
                    ((DefaultMutableTreeNode)classNode).add(fieldNode);
                }
            }
        }
        root2.update();
        root2.sort(Comparator.comparing(DexElementNode::getMethodReferencesCount).reversed());
    }

    private void addMethods(@NotNull DexClassNode classNode, @NotNull Iterable<? extends MethodReference> methodRefs, Path dexFilePath) {
        for (MethodReference methodReference2 : methodRefs) {
            DexMethodNode methodNode;
            String params;
            String methodName = PackageTreeCreator.decodeMethodName(methodReference2, this.proguardMap);
            String returnType = PackageTreeCreator.decodeClassName(methodReference2.getReturnType(), this.proguardMap);
            String methodSig = returnType + " " + methodName + (params = PackageTreeCreator.decodeMethodParams(methodReference2, this.proguardMap));
            if (methodSig.startsWith("void <init>") || methodSig.startsWith("void <clinit>")) {
                methodSig = methodName + params;
            }
            if (methodReference2 instanceof DexBackedMethod) {
                methodNode = this.getOrAddMethod(classNode, methodSig, methodReference2);
                methodNode.setDefined(true);
                methodNode.setUserObject(dexFilePath);
                methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethod)methodReference2).getSize());
                continue;
            }
            if (!(methodReference2 instanceof DexBackedMethodReference)) continue;
            if (this.addReferencesNode) {
                DexReferencesNode referencesNode = PackageTreeCreator.getOrCreateReferencesNode(classNode);
                methodNode = this.getOrAddMethod(referencesNode, methodSig, methodReference2);
            } else {
                methodNode = this.getOrAddMethod(classNode, methodSig, methodReference2);
            }
            methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethodReference)methodReference2).getSize());
        }
    }

    private void addFields(@NotNull DexClassNode classNode, @NotNull Iterable<? extends FieldReference> fieldRefs, Path dexFilePath) {
        for (FieldReference fieldReference : fieldRefs) {
            DexFieldNode fieldNode;
            String fieldName = PackageTreeCreator.decodeFieldName(fieldReference, this.proguardMap);
            String fieldType = PackageTreeCreator.decodeClassName(fieldReference.getType(), this.proguardMap);
            String fieldSig = fieldType + " " + fieldName;
            if (fieldReference instanceof DexBackedField) {
                fieldNode = this.getOrAddField(classNode, fieldSig, fieldReference);
                fieldNode.setDefined(true);
                fieldNode.setUserObject(dexFilePath);
                fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedField)fieldReference).getSize());
                continue;
            }
            if (!(fieldReference instanceof DexBackedFieldReference)) continue;
            if (this.addReferencesNode) {
                DexReferencesNode referencesNode = PackageTreeCreator.getOrCreateReferencesNode(classNode);
                fieldNode = this.getOrAddField(referencesNode, fieldSig, fieldReference);
            } else {
                fieldNode = this.getOrAddField(classNode, fieldSig, fieldReference);
            }
            fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedFieldReference)fieldReference).getSize());
        }
    }

    public static String decodeFieldName(@NotNull FieldReference fieldRef, @Nullable ProguardMap proguardMap) {
        String fieldName = fieldRef.getName();
        if (proguardMap != null) {
            String className = PackageTreeCreator.decodeClassName(fieldRef.getDefiningClass(), proguardMap);
            fieldName = proguardMap.getFieldName(className, fieldName);
        }
        return fieldName;
    }

    public static String decodeMethodParams(@NotNull MethodReference methodRef, @Nullable ProguardMap proguardMap) {
        Stream<String> params = methodRef.getParameterTypes().stream().map(String::valueOf).map(SigUtils::signatureToName);
        if (proguardMap != null) {
            params = params.map(arg_0 -> ((ProguardMap)proguardMap).getClassName(arg_0));
        }
        return "(" + params.collect(Collectors.joining(PARAMS_DELIMITER)) + ")";
    }

    public static String decodeMethodName(@NotNull MethodReference methodRef, @Nullable ProguardMap proguardMap) {
        if (proguardMap != null) {
            String className = proguardMap.getClassName(SigUtils.signatureToName(methodRef.getDefiningClass()));
            String methodName = methodRef.getName();
            String sigWithoutName = ReferenceUtil.getMethodDescriptor((MethodReference)methodRef, (boolean)true).substring(methodName.length());
            ProguardMap.Frame frame = proguardMap.getFrame(className, methodName, sigWithoutName, null, -1);
            return frame.methodName;
        }
        return methodRef.getName();
    }

    public static String decodeClassName(@NotNull String className, @Nullable ProguardMap proguardMap) {
        className = SigUtils.signatureToName(className);
        if (proguardMap != null) {
            className = proguardMap.getClassName(className);
        }
        return className;
    }

    private static DexReferencesNode getOrCreateReferencesNode(DexClassNode classNode) {
        DexReferencesNode references2 = classNode.getChildByType("References", DexReferencesNode.class);
        if (references2 == null) {
            references2 = new DexReferencesNode();
            classNode.insert(references2, 0);
        }
        return references2;
    }

    private DexMethodNode getOrAddMethod(DexElementNode parent, String sig, MethodReference ref) {
        DexMethodNode node = parent.getChildByType(sig, DexMethodNode.class);
        if (node == null) {
            node = new DexMethodNode(sig, ImmutableMethodReference.of((MethodReference)ref));
            parent.add(node);
        }
        return node;
    }

    private DexFieldNode getOrAddField(DexElementNode parent, String sig, FieldReference ref) {
        DexFieldNode node = parent.getChildByType(sig, DexFieldNode.class);
        if (node == null) {
            node = new DexFieldNode(sig, ImmutableFieldReference.of((FieldReference)ref));
            parent.add(node);
        }
        return node;
    }
}

